
#ifndef _CONST_H_
#define _CONST_H_

c This file contains a number of physical constants and conversion
c factors.  Physical constants are all stored in a variable named
c CONST_name where 'name' is the name of the physical constant.
c 
c Conversion factors are stored in variables named CONV_unit1_unit2
c where 'unit1' and 'unit2' are the names of two physical units.  To
c get from unit1 to unit2, multiply by this factor.
c 
c Example: To convert 20.4 meters/s to miles/hour in a perl script,
c          include the following line at the top of the script:
c              require "Constants.pl";
c          and then, at the point in the script where the conversion
c          is required, the following returns the desired value:
c              20.4 * $CONV_m_mile / $CONV_s_hr
c 
c          To do the same thing in either a C or Fortran program, include
c          the file "Constants.h" or "Constants.f" as appropriate and
c          at the point where the conversion is required, the following
c          returns the desired value:
c              20.4 * CONV_m_mile / CONV_s_hr
c 
c This file was generated automatically on 6/4/96.
c 
c Do not edit this file.  If you wish to add or change a conversion
c factor or constant, edit the file GenerateConstants.pl and rerun it.





c Physical Constants
c ====================
c 
c e       = e
c pi      = pi
c c       = speed of light in a vacuum     m s-1
c g       = gravitational acceleration     m s-2
c G       = gravitational constant         N m+2 kg-2
c me      = mass of an electron            kg
c mn      = mass of a neutron              kg
c mp      = mass of a proton               kg
c mmu     = mass of a mu particle          kg
c u       = atomic mass unit               kg
c ec      = elementary charge              C
c h       = planck's' constant              J s
c hbar    = h/2 pi                         J s
c k       = boltmann's' constant            J K-1
c u0      = permeability of vacuum         N A-2
c e0      = permittivity of vacuum         C+2 N-1 m-2
c re      = classical electron radius      m
c alpha   = fine structure constant   
c a0      = bohr radius                    m
c RH      = quantum hole resistance        ohm
c Rh      = Rydberg constant               m-1
c phi0    = magnetic flux quantum (h/2 ec) m+2 kg s-2 A-1
c uB      = Bohr magneton                  m+2 A
c ue      = electron magnetic moment       m+2 A
c un      = neutron magnetic moment        m+2 A
c uN      = nuclear magneton               m+2 A
c up      = proton magnetic moment         m+2 A
c umu     = mu particle magnetic moment    m+2 A
c lambdac = compton electron wavelength    m
c lambdacp= compton proton wavelength      m
c sigma   = Stefan-Boltmann constant       W m-2 K-4
c NA      = avogadro's' number              mole-1
c Vm      = ideal gas volume at STP        m+3 mole-1
c R       = gas constant                   J K-1 mole-1
c F       = faradays constant              C mole-1
c ea      = atomic unit of energy          J


#define CONST_e	2.71828182845905d0
#define CONST_pi	3.14159265358979d0
#define CONST_c	299792458d0
#define CONST_g	9.80665d0
#define CONST_G	6.67259d-11
#define CONST_me	9.1093897d-31
#define CONST_mn	1.6749543d-27
#define CONST_mp	1.6726485d-27
#define CONST_mmu	1.8835327d-28
#define CONST_u	1.6605402d-27
#define CONST_ec	1.60217733d-19
#define CONST_h	6.6260755d-34
#define CONST_hbar	1.0545726691251d-34
#define CONST_k	1.380658d-23
#define CONST_u0	1.256637061d-06
#define CONST_e0	8.85418782d-12
#define CONST_re	2.81794092d-15
#define CONST_alpha	0.00729735301d0
#define CONST_a0	5.29177257649136d-11
#define CONST_RH	25812.8056d0
#define CONST_Rh	1.09737313d0
#define CONST_phi0	2.06783461977957d-15
#define CONST_uB	9.27401549d-24
#define CONST_ue	9.2847701d-24
#define CONST_un	9.6623707d-27
#define CONST_uN	5.05078647d-27
#define CONST_up	1.41060761d-26
#define CONST_umu	4.4904514d-26
#define CONST_lambdac	2.42631058d-12
#define CONST_lambdacp	1.32141002d-15
#define CONST_sigma	5.67050853850544d-08
#define CONST_NA	6.0221367d+23
#define CONST_Vm	0.0224141d0
#define CONST_R	8.31451d0
#define CONST_F	96485.309d0
#define CONST_ea	4.35974812134962d-18






c TIME (s)
c ====================
c 
c s      = second
c min    = minute
c hr     = hour
c day    = day
c week   = week
c yr     = calendar year (365 days)
c yrleap = calendar year (leap year)
c 
c yrave  = average year (calendar year averaged over 4 years)
c yrside = year (sidereal)
c yrtrop = year (tropical)
c monave = month (averaged over 4 calendar years)
c daysid = sidereal day
c 
c shake  = shake



#define CONV_s_min	0.0166666666666667d0
#define CONV_s_hr	0.000277777777777778d0
#define CONV_s_day	1.15740740740741d-05
#define CONV_s_week	1.65343915343915d-06
#define CONV_s_yr	3.17097919837646d-08
#define CONV_s_yrleap	3.16231532078527d-08
#define CONV_s_yrave	3.16880878140289d-08
#define CONV_s_yrside	3.16875360474875d-08
#define CONV_s_yrtrop	3.16887645350786d-08
#define CONV_s_monave	3.80257053768347d-07
#define CONV_s_daysid	1.16057629112081d-05
#define CONV_s_shake	100000000d0
#define CONV_min_s	60d0
#define CONV_min_hr	0.0166666666666667d0
#define CONV_min_day	0.000694444444444444d0
#define CONV_min_week	9.92063492063492d-05
#define CONV_min_yr	1.90258751902588d-06
#define CONV_min_yrleap	1.89738919247116d-06
#define CONV_min_yrave	1.90128526884174d-06
#define CONV_min_yrside	1.90125216284925d-06
#define CONV_min_yrtrop	1.90132587210471d-06
#define CONV_min_monave	2.28154232261008d-05
#define CONV_min_daysid	0.000696345774672488d0
#define CONV_min_shake	6000000000d0
#define CONV_hr_s	3600d0
#define CONV_hr_min	60d0
#define CONV_hr_day	0.0416666666666667d0
#define CONV_hr_week	0.00595238095238095d0
#define CONV_hr_yr	0.000114155251141553d0
#define CONV_hr_yrleap	0.00011384335154827d0
#define CONV_hr_yrave	0.000114077116130504d0
#define CONV_hr_yrside	0.000114075129770955d0
#define CONV_hr_yrtrop	0.000114079552326283d0
#define CONV_hr_monave	0.00136892539356605d0
#define CONV_hr_daysid	0.0417807464803493d0
#define CONV_hr_shake	360000000000d0
#define CONV_day_s	86400d0
#define CONV_day_min	1440d0
#define CONV_day_hr	24d0
#define CONV_day_week	0.142857142857143d0
#define CONV_day_yr	0.00273972602739726d0
#define CONV_day_yrleap	0.00273224043715847d0
#define CONV_day_yrave	0.0027378507871321d0
#define CONV_day_yrside	0.00273780311450292d0
#define CONV_day_yrtrop	0.00273790925583079d0
#define CONV_day_monave	0.0328542094455852d0
#define CONV_day_daysid	1.00273791552838d0
#define CONV_day_shake	8640000000000d0
#define CONV_week_s	604800d0
#define CONV_week_min	10080d0
#define CONV_week_hr	168d0
#define CONV_week_day	7d0
#define CONV_week_yr	0.0191780821917808d0
#define CONV_week_yrleap	0.0191256830601093d0
#define CONV_week_yrave	0.0191649555099247d0
#define CONV_week_yrside	0.0191646218015204d0
#define CONV_week_yrtrop	0.0191653647908155d0
#define CONV_week_monave	0.229979466119097d0
#define CONV_week_daysid	7.01916540869868d0
#define CONV_week_shake	60480000000000d0
#define CONV_yr_s	31536000d0
#define CONV_yr_min	525600d0
#define CONV_yr_hr	8760d0
#define CONV_yr_day	365d0
#define CONV_yr_week	52.1428571428571d0
#define CONV_yr_yrleap	0.997267759562841d0
#define CONV_yr_yrave	0.999315537303217d0
#define CONV_yr_yrside	0.999298136793566d0
#define CONV_yr_yrtrop	0.999336878378238d0
#define CONV_yr_monave	11.9917864476386d0
#define CONV_yr_daysid	365.99933916786d0
#define CONV_yr_shake	3.1536d+15
#define CONV_yrleap_s	31622400d0
#define CONV_yrleap_min	527040d0
#define CONV_yrleap_hr	8784d0
#define CONV_yrleap_day	366d0
#define CONV_yrleap_week	52.2857142857143d0
#define CONV_yrleap_yr	1.0027397260274d0
#define CONV_yrleap_yrave	1.00205338809035d0
#define CONV_yrleap_yrside	1.00203593990807d0
#define CONV_yrleap_yrtrop	1.00207478763407d0
#define CONV_yrleap_monave	12.0246406570842d0
#define CONV_yrleap_daysid	367.002077083388d0
#define CONV_yrleap_shake	3.16224d+15
#define CONV_yrave_s	31557600d0
#define CONV_yrave_min	525960d0
#define CONV_yrave_hr	8766d0
#define CONV_yrave_day	365.25d0
#define CONV_yrave_week	52.1785714285714d0
#define CONV_yrave_yr	1.00068493150685d0
#define CONV_yrave_yrleap	0.997950819672131d0
#define CONV_yrave_yrside	0.999982587572192d0
#define CONV_yrave_yrtrop	1.0000213556922d0
#define CONV_yrave_monave	12d0
#define CONV_yrave_daysid	366.250023646742d0
#define CONV_yrave_shake	3.15576d+15
#define CONV_yrside_s	31558149.504d0
#define CONV_yrside_min	525969.1584d0
#define CONV_yrside_hr	8766.15264d0
#define CONV_yrside_day	365.25636d0
#define CONV_yrside_week	52.17948d0
#define CONV_yrside_yr	1.00070235616438d0
#define CONV_yrside_yrleap	0.997968196721312d0
#define CONV_yrside_yrave	1.00001741273101d0
#define CONV_yrside_yrtrop	1.00003876879506d0
#define CONV_yrside_monave	12.0002089527721d0
#define CONV_yrside_daysid	366.256401059885d0
#define CONV_yrside_shake	3.1558149504d+15
#define CONV_yrtrop_s	31556926.08d0
#define CONV_yrtrop_min	525948.768d0
#define CONV_yrtrop_hr	8765.8128d0
#define CONV_yrtrop_day	365.2422d0
#define CONV_yrtrop_week	52.1774571428571d0
#define CONV_yrtrop_yr	1.00066356164384d0
#define CONV_yrtrop_yrleap	0.997929508196721d0
#define CONV_yrtrop_yrave	0.99997864476386d0
#define CONV_yrtrop_yrside	0.999961232707899d0
#define CONV_yrtrop_monave	11.9997437371663d0
#define CONV_yrtrop_daysid	366.242202291001d0
#define CONV_yrtrop_shake	3.155692608d+15
#define CONV_monave_s	2629800d0
#define CONV_monave_min	43830d0
#define CONV_monave_hr	730.5d0
#define CONV_monave_day	30.4375d0
#define CONV_monave_week	4.34821428571429d0
#define CONV_monave_yr	0.0833904109589041d0
#define CONV_monave_yrleap	0.0831625683060109d0
#define CONV_monave_yrave	0.0833333333333333d0
#define CONV_monave_yrside	0.0833318822976826d0
#define CONV_monave_yrtrop	0.0833351129743496d0
#define CONV_monave_daysid	30.5208353038952d0
#define CONV_monave_shake	262980000000000d0
#define CONV_daysid_s	86164.09d0
#define CONV_daysid_min	1436.06816666667d0
#define CONV_daysid_hr	23.9344694444444d0
#define CONV_daysid_day	0.997269560185185d0
#define CONV_daysid_week	0.142467080026455d0
#define CONV_daysid_yr	0.00273224537037037d0
#define CONV_daysid_yrleap	0.00272478021908521d0
#define CONV_daysid_yrave	0.00273037525033589d0
#define CONV_daysid_yrside	0.00273032770787396d0
#define CONV_daysid_yrtrop	0.00273043355938932d0
#define CONV_daysid_monave	0.0327645030040307d0
#define CONV_daysid_shake	8616409000000d0
#define CONV_shake_s	1d-08
#define CONV_shake_min	1.66666666666667d-10
#define CONV_shake_hr	2.77777777777778d-12
#define CONV_shake_day	1.15740740740741d-13
#define CONV_shake_week	1.65343915343915d-14
#define CONV_shake_yr	3.17097919837646d-16
#define CONV_shake_yrleap	3.16231532078527d-16
#define CONV_shake_yrave	3.16880878140289d-16
#define CONV_shake_yrside	3.16875360474875d-16
#define CONV_shake_yrtrop	3.16887645350786d-16
#define CONV_shake_monave	3.80257053768347d-15
#define CONV_shake_daysid	1.16057629112081d-13



c LENGTH (m)
c ====================
c 
c METRIC
c km     = kilometer
c m      = meter (SI)
c cm     = cm
c mm     = mm
c um     = micrometer
c nm     = nanometer
c pm     = picometer
c micron = micron
c mmicr  = millimicron
c fermi  = fermi
c 
c ATOMIC
c a      = angstrom
c a0     = bohr radius
c 
c AMERICAN/BRITISH
c hand   = hand
c ell    = ell
c in     = inch
c ft     = foot
c yd     = yard
c mile   = mile
c mileu  = mile (US survey)
c mil    = mil
c rod    = rod
c fur    = furlong
c chaing = chain (Gunter's')
c chainr = chain (Ramsden's')
c leag   = league
c cable  = cable length (U.S.)
c calib  = caliber
c cubit  = cubit
c ftu    = foot (US survey)
c barley = barleycorn (Brit)
c x      = x-unit
c span   = span
c nail   = nail (Brit)
c 
c NAUTICAL
c milen  = mile (nautical)
c leagn  = league (nautical)
c fathom = fathom
c degn   = nautical degree
c circn  = nautical circle
c cablen = cable length (international)
c 
c ASTRONOMICAL
c ly     = light year
c au     = astronomical unit
c pc     = parsec
c ls     = light second
c lm     = light minute
c 
c MISC
c bolt   = bolt (of cloth)



#define CONV_km_m	1000d0
#define CONV_km_cm	100000d0
#define CONV_km_mm	1000000d0
#define CONV_km_um	1000000000d0
#define CONV_km_nm	1000000000000d0
#define CONV_km_pm	1d+15
#define CONV_km_micron	1000000000d0
#define CONV_km_mmicr	1000000000000d0
#define CONV_km_fermi	1d+18
#define CONV_km_a	10000000000000d0
#define CONV_km_a0	18897259576923d0
#define CONV_km_hand	9842.51968503937d0
#define CONV_km_ell	874.890638670166d0
#define CONV_km_in	39370.0787401575d0
#define CONV_km_ft	3280.83989501312d0
#define CONV_km_yd	1093.61329833771d0
#define CONV_km_mile	0.621371192237334d0
#define CONV_km_mileu	0.621369949492802d0
#define CONV_km_mil	39370078.7401575d0
#define CONV_km_rod	198.838781515947d0
#define CONV_km_fur	4.97096953789867d0
#define CONV_km_chaing	49.7096953789867d0
#define CONV_km_chainr	32.8083989501312d0
#define CONV_km_leag	0.207123730745778d0
#define CONV_km_cable	4.55672207640712d0
#define CONV_km_calib	3937007.87401575d0
#define CONV_km_cubit	2187.22659667542d0
#define CONV_km_ftu	3280.83333334646d0
#define CONV_km_barley	118110.236220472d0
#define CONV_km_x	9.97984072174208d+15
#define CONV_km_span	4374.45319335083d0
#define CONV_km_nail	17497.8127734033d0
#define CONV_km_milen	0.539956803455723d0
#define CONV_km_leagn	0.179985601151908d0
#define CONV_km_fathom	546.806649168854d0
#define CONV_km_degn	0.00899928005759539d0
#define CONV_km_circn	2.49980001599872d-05
#define CONV_km_cablen	5.39956803455723d0
#define CONV_km_ly	1.05702323231362d-13
#define CONV_km_au	6.68458321045438d-09
#define CONV_km_pc	3.24078037911195d-14
#define CONV_km_ls	3.33571163560604d-06
#define CONV_km_lm	5.55951939267673d-08
#define CONV_km_bolt	27.3403324584427d0
#define CONV_m_km	0.001d0
#define CONV_m_cm	100d0
#define CONV_m_mm	1000d0
#define CONV_m_um	1000000d0
#define CONV_m_nm	1000000000d0
#define CONV_m_pm	1000000000000d0
#define CONV_m_micron	1000000d0
#define CONV_m_mmicr	1000000000d0
#define CONV_m_fermi	1d+15
#define CONV_m_a	10000000000d0
#define CONV_m_a0	18897259576.923d0
#define CONV_m_hand	9.84251968503937d0
#define CONV_m_ell	0.874890638670166d0
#define CONV_m_in	39.3700787401575d0
#define CONV_m_ft	3.28083989501312d0
#define CONV_m_yd	1.09361329833771d0
#define CONV_m_mile	0.000621371192237334d0
#define CONV_m_mileu	0.000621369949492802d0
#define CONV_m_mil	39370.0787401575d0
#define CONV_m_rod	0.198838781515947d0
#define CONV_m_fur	0.00497096953789867d0
#define CONV_m_chaing	0.0497096953789867d0
#define CONV_m_chainr	0.0328083989501312d0
#define CONV_m_leag	0.000207123730745778d0
#define CONV_m_cable	0.00455672207640712d0
#define CONV_m_calib	3937.00787401575d0
#define CONV_m_cubit	2.18722659667542d0
#define CONV_m_ftu	3.28083333334646d0
#define CONV_m_barley	118.110236220472d0
#define CONV_m_x	9979840721742.08d0
#define CONV_m_span	4.37445319335083d0
#define CONV_m_nail	17.4978127734033d0
#define CONV_m_milen	0.000539956803455723d0
#define CONV_m_leagn	0.000179985601151908d0
#define CONV_m_fathom	0.546806649168854d0
#define CONV_m_degn	8.99928005759539d-06
#define CONV_m_circn	2.49980001599872d-08
#define CONV_m_cablen	0.00539956803455724d0
#define CONV_m_ly	1.05702323231362d-16
#define CONV_m_au	6.68458321045438d-12
#define CONV_m_pc	3.24078037911195d-17
#define CONV_m_ls	3.33571163560604d-09
#define CONV_m_lm	5.55951939267673d-11
#define CONV_m_bolt	0.0273403324584427d0
#define CONV_cm_km	1d-05
#define CONV_cm_m	0.01d0
#define CONV_cm_mm	10d0
#define CONV_cm_um	10000d0
#define CONV_cm_nm	10000000d0
#define CONV_cm_pm	10000000000d0
#define CONV_cm_micron	10000d0
#define CONV_cm_mmicr	10000000d0
#define CONV_cm_fermi	10000000000000d0
#define CONV_cm_a	100000000d0
#define CONV_cm_a0	188972595.76923d0
#define CONV_cm_hand	0.0984251968503937d0
#define CONV_cm_ell	0.00874890638670166d0
#define CONV_cm_in	0.393700787401575d0
#define CONV_cm_ft	0.0328083989501312d0
#define CONV_cm_yd	0.0109361329833771d0
#define CONV_cm_mile	6.21371192237334d-06
#define CONV_cm_mileu	6.21369949492802d-06
#define CONV_cm_mil	393.700787401575d0
#define CONV_cm_rod	0.00198838781515947d0
#define CONV_cm_fur	4.97096953789867d-05
#define CONV_cm_chaing	0.000497096953789867d0
#define CONV_cm_chainr	0.000328083989501312d0
#define CONV_cm_leag	2.07123730745778d-06
#define CONV_cm_cable	4.55672207640712d-05
#define CONV_cm_calib	39.3700787401575d0
#define CONV_cm_cubit	0.0218722659667542d0
#define CONV_cm_ftu	0.0328083333334646d0
#define CONV_cm_barley	1.18110236220472d0
#define CONV_cm_x	99798407217.4208d0
#define CONV_cm_span	0.0437445319335083d0
#define CONV_cm_nail	0.174978127734033d0
#define CONV_cm_milen	5.39956803455724d-06
#define CONV_cm_leagn	1.79985601151908d-06
#define CONV_cm_fathom	0.00546806649168854d0
#define CONV_cm_degn	8.99928005759539d-08
#define CONV_cm_circn	2.49980001599872d-10
#define CONV_cm_cablen	5.39956803455724d-05
#define CONV_cm_ly	1.05702323231362d-18
#define CONV_cm_au	6.68458321045438d-14
#define CONV_cm_pc	3.24078037911195d-19
#define CONV_cm_ls	3.33571163560604d-11
#define CONV_cm_lm	5.55951939267673d-13
#define CONV_cm_bolt	0.000273403324584427d0
#define CONV_mm_km	1d-06
#define CONV_mm_m	0.001d0
#define CONV_mm_cm	0.1d0
#define CONV_mm_um	1000d0
#define CONV_mm_nm	1000000d0
#define CONV_mm_pm	1000000000d0
#define CONV_mm_micron	1000d0
#define CONV_mm_mmicr	1000000d0
#define CONV_mm_fermi	1000000000000d0
#define CONV_mm_a	10000000d0
#define CONV_mm_a0	18897259.576923d0
#define CONV_mm_hand	0.00984251968503937d0
#define CONV_mm_ell	0.000874890638670166d0
#define CONV_mm_in	0.0393700787401575d0
#define CONV_mm_ft	0.00328083989501312d0
#define CONV_mm_yd	0.00109361329833771d0
#define CONV_mm_mile	6.21371192237334d-07
#define CONV_mm_mileu	6.21369949492802d-07
#define CONV_mm_mil	39.3700787401575d0
#define CONV_mm_rod	0.000198838781515947d0
#define CONV_mm_fur	4.97096953789867d-06
#define CONV_mm_chaing	4.97096953789867d-05
#define CONV_mm_chainr	3.28083989501312d-05
#define CONV_mm_leag	2.07123730745778d-07
#define CONV_mm_cable	4.55672207640712d-06
#define CONV_mm_calib	3.93700787401575d0
#define CONV_mm_cubit	0.00218722659667542d0
#define CONV_mm_ftu	0.00328083333334646d0
#define CONV_mm_barley	0.118110236220472d0
#define CONV_mm_x	9979840721.74208d0
#define CONV_mm_span	0.00437445319335083d0
#define CONV_mm_nail	0.0174978127734033d0
#define CONV_mm_milen	5.39956803455723d-07
#define CONV_mm_leagn	1.79985601151908d-07
#define CONV_mm_fathom	0.000546806649168854d0
#define CONV_mm_degn	8.99928005759539d-09
#define CONV_mm_circn	2.49980001599872d-11
#define CONV_mm_cablen	5.39956803455723d-06
#define CONV_mm_ly	1.05702323231362d-19
#define CONV_mm_au	6.68458321045438d-15
#define CONV_mm_pc	3.24078037911195d-20
#define CONV_mm_ls	3.33571163560604d-12
#define CONV_mm_lm	5.55951939267673d-14
#define CONV_mm_bolt	2.73403324584427d-05
#define CONV_um_km	1d-09
#define CONV_um_m	1d-06
#define CONV_um_cm	0.0001d0
#define CONV_um_mm	0.001d0
#define CONV_um_nm	1000d0
#define CONV_um_pm	1000000d0
#define CONV_um_micron	1d0
#define CONV_um_mmicr	1000d0
#define CONV_um_fermi	1000000000d0
#define CONV_um_a	10000d0
#define CONV_um_a0	18897.259576923d0
#define CONV_um_hand	9.84251968503937d-06
#define CONV_um_ell	8.74890638670166d-07
#define CONV_um_in	3.93700787401575d-05
#define CONV_um_ft	3.28083989501312d-06
#define CONV_um_yd	1.09361329833771d-06
#define CONV_um_mile	6.21371192237334d-10
#define CONV_um_mileu	6.21369949492802d-10
#define CONV_um_mil	0.0393700787401575d0
#define CONV_um_rod	1.98838781515947d-07
#define CONV_um_fur	4.97096953789867d-09
#define CONV_um_chaing	4.97096953789867d-08
#define CONV_um_chainr	3.28083989501312d-08
#define CONV_um_leag	2.07123730745778d-10
#define CONV_um_cable	4.55672207640712d-09
#define CONV_um_calib	0.00393700787401575d0
#define CONV_um_cubit	2.18722659667542d-06
#define CONV_um_ftu	3.28083333334646d-06
#define CONV_um_barley	0.000118110236220472d0
#define CONV_um_x	9979840.72174208d0
#define CONV_um_span	4.37445319335083d-06
#define CONV_um_nail	1.74978127734033d-05
#define CONV_um_milen	5.39956803455723d-10
#define CONV_um_leagn	1.79985601151908d-10
#define CONV_um_fathom	5.46806649168854d-07
#define CONV_um_degn	8.99928005759539d-12
#define CONV_um_circn	2.49980001599872d-14
#define CONV_um_cablen	5.39956803455724d-09
#define CONV_um_ly	1.05702323231362d-22
#define CONV_um_au	6.68458321045438d-18
#define CONV_um_pc	3.24078037911195d-23
#define CONV_um_ls	3.33571163560604d-15
#define CONV_um_lm	5.55951939267673d-17
#define CONV_um_bolt	2.73403324584427d-08
#define CONV_nm_km	1d-12
#define CONV_nm_m	1d-09
#define CONV_nm_cm	1d-07
#define CONV_nm_mm	1d-06
#define CONV_nm_um	0.001d0
#define CONV_nm_pm	1000d0
#define CONV_nm_micron	0.001d0
#define CONV_nm_mmicr	1d0
#define CONV_nm_fermi	1000000d0
#define CONV_nm_a	10d0
#define CONV_nm_a0	18.897259576923d0
#define CONV_nm_hand	9.84251968503937d-09
#define CONV_nm_ell	8.74890638670166d-10
#define CONV_nm_in	3.93700787401575d-08
#define CONV_nm_ft	3.28083989501312d-09
#define CONV_nm_yd	1.09361329833771d-09
#define CONV_nm_mile	6.21371192237334d-13
#define CONV_nm_mileu	6.21369949492802d-13
#define CONV_nm_mil	3.93700787401575d-05
#define CONV_nm_rod	1.98838781515947d-10
#define CONV_nm_fur	4.97096953789867d-12
#define CONV_nm_chaing	4.97096953789867d-11
#define CONV_nm_chainr	3.28083989501312d-11
#define CONV_nm_leag	2.07123730745778d-13
#define CONV_nm_cable	4.55672207640712d-12
#define CONV_nm_calib	3.93700787401575d-06
#define CONV_nm_cubit	2.18722659667542d-09
#define CONV_nm_ftu	3.28083333334646d-09
#define CONV_nm_barley	1.18110236220472d-07
#define CONV_nm_x	9979.84072174208d0
#define CONV_nm_span	4.37445319335083d-09
#define CONV_nm_nail	1.74978127734033d-08
#define CONV_nm_milen	5.39956803455724d-13
#define CONV_nm_leagn	1.79985601151908d-13
#define CONV_nm_fathom	5.46806649168854d-10
#define CONV_nm_degn	8.99928005759539d-15
#define CONV_nm_circn	2.49980001599872d-17
#define CONV_nm_cablen	5.39956803455723d-12
#define CONV_nm_ly	1.05702323231362d-25
#define CONV_nm_au	6.68458321045438d-21
#define CONV_nm_pc	3.24078037911195d-26
#define CONV_nm_ls	3.33571163560604d-18
#define CONV_nm_lm	5.55951939267673d-20
#define CONV_nm_bolt	2.73403324584427d-11
#define CONV_pm_km	1d-15
#define CONV_pm_m	1d-12
#define CONV_pm_cm	1d-10
#define CONV_pm_mm	1d-09
#define CONV_pm_um	1d-06
#define CONV_pm_nm	0.001d0
#define CONV_pm_micron	1d-06
#define CONV_pm_mmicr	0.001d0
#define CONV_pm_fermi	1000d0
#define CONV_pm_a	0.01d0
#define CONV_pm_a0	0.018897259576923d0
#define CONV_pm_hand	9.84251968503937d-12
#define CONV_pm_ell	8.74890638670166d-13
#define CONV_pm_in	3.93700787401575d-11
#define CONV_pm_ft	3.28083989501312d-12
#define CONV_pm_yd	1.09361329833771d-12
#define CONV_pm_mile	6.21371192237334d-16
#define CONV_pm_mileu	6.21369949492802d-16
#define CONV_pm_mil	3.93700787401575d-08
#define CONV_pm_rod	1.98838781515947d-13
#define CONV_pm_fur	4.97096953789867d-15
#define CONV_pm_chaing	4.97096953789867d-14
#define CONV_pm_chainr	3.28083989501312d-14
#define CONV_pm_leag	2.07123730745778d-16
#define CONV_pm_cable	4.55672207640712d-15
#define CONV_pm_calib	3.93700787401575d-09
#define CONV_pm_cubit	2.18722659667542d-12
#define CONV_pm_ftu	3.28083333334646d-12
#define CONV_pm_barley	1.18110236220472d-10
#define CONV_pm_x	9.97984072174208d0
#define CONV_pm_span	4.37445319335083d-12
#define CONV_pm_nail	1.74978127734033d-11
#define CONV_pm_milen	5.39956803455724d-16
#define CONV_pm_leagn	1.79985601151908d-16
#define CONV_pm_fathom	5.46806649168854d-13
#define CONV_pm_degn	8.99928005759539d-18
#define CONV_pm_circn	2.49980001599872d-20
#define CONV_pm_cablen	5.39956803455724d-15
#define CONV_pm_ly	1.05702323231362d-28
#define CONV_pm_au	6.68458321045438d-24
#define CONV_pm_pc	3.24078037911195d-29
#define CONV_pm_ls	3.33571163560604d-21
#define CONV_pm_lm	5.55951939267673d-23
#define CONV_pm_bolt	2.73403324584427d-14
#define CONV_micron_km	1d-09
#define CONV_micron_m	1d-06
#define CONV_micron_cm	0.0001d0
#define CONV_micron_mm	0.001d0
#define CONV_micron_um	1d0
#define CONV_micron_nm	1000d0
#define CONV_micron_pm	1000000d0
#define CONV_micron_mmicr	1000d0
#define CONV_micron_fermi	1000000000d0
#define CONV_micron_a	10000d0
#define CONV_micron_a0	18897.259576923d0
#define CONV_micron_hand	9.84251968503937d-06
#define CONV_micron_ell	8.74890638670166d-07
#define CONV_micron_in	3.93700787401575d-05
#define CONV_micron_ft	3.28083989501312d-06
#define CONV_micron_yd	1.09361329833771d-06
#define CONV_micron_mile	6.21371192237334d-10
#define CONV_micron_mileu	6.21369949492802d-10
#define CONV_micron_mil	0.0393700787401575d0
#define CONV_micron_rod	1.98838781515947d-07
#define CONV_micron_fur	4.97096953789867d-09
#define CONV_micron_chaing	4.97096953789867d-08
#define CONV_micron_chainr	3.28083989501312d-08
#define CONV_micron_leag	2.07123730745778d-10
#define CONV_micron_cable	4.55672207640712d-09
#define CONV_micron_calib	0.00393700787401575d0
#define CONV_micron_cubit	2.18722659667542d-06
#define CONV_micron_ftu	3.28083333334646d-06
#define CONV_micron_barley	0.000118110236220472d0
#define CONV_micron_x	9979840.72174208d0
#define CONV_micron_span	4.37445319335083d-06
#define CONV_micron_nail	1.74978127734033d-05
#define CONV_micron_milen	5.39956803455723d-10
#define CONV_micron_leagn	1.79985601151908d-10
#define CONV_micron_fathom	5.46806649168854d-07
#define CONV_micron_degn	8.99928005759539d-12
#define CONV_micron_circn	2.49980001599872d-14
#define CONV_micron_cablen	5.39956803455724d-09
#define CONV_micron_ly	1.05702323231362d-22
#define CONV_micron_au	6.68458321045438d-18
#define CONV_micron_pc	3.24078037911195d-23
#define CONV_micron_ls	3.33571163560604d-15
#define CONV_micron_lm	5.55951939267673d-17
#define CONV_micron_bolt	2.73403324584427d-08
#define CONV_mmicr_km	1d-12
#define CONV_mmicr_m	1d-09
#define CONV_mmicr_cm	1d-07
#define CONV_mmicr_mm	1d-06
#define CONV_mmicr_um	0.001d0
#define CONV_mmicr_nm	1d0
#define CONV_mmicr_pm	1000d0
#define CONV_mmicr_micron	0.001d0
#define CONV_mmicr_fermi	1000000d0
#define CONV_mmicr_a	10d0
#define CONV_mmicr_a0	18.897259576923d0
#define CONV_mmicr_hand	9.84251968503937d-09
#define CONV_mmicr_ell	8.74890638670166d-10
#define CONV_mmicr_in	3.93700787401575d-08
#define CONV_mmicr_ft	3.28083989501312d-09
#define CONV_mmicr_yd	1.09361329833771d-09
#define CONV_mmicr_mile	6.21371192237334d-13
#define CONV_mmicr_mileu	6.21369949492802d-13
#define CONV_mmicr_mil	3.93700787401575d-05
#define CONV_mmicr_rod	1.98838781515947d-10
#define CONV_mmicr_fur	4.97096953789867d-12
#define CONV_mmicr_chaing	4.97096953789867d-11
#define CONV_mmicr_chainr	3.28083989501312d-11
#define CONV_mmicr_leag	2.07123730745778d-13
#define CONV_mmicr_cable	4.55672207640712d-12
#define CONV_mmicr_calib	3.93700787401575d-06
#define CONV_mmicr_cubit	2.18722659667542d-09
#define CONV_mmicr_ftu	3.28083333334646d-09
#define CONV_mmicr_barley	1.18110236220472d-07
#define CONV_mmicr_x	9979.84072174208d0
#define CONV_mmicr_span	4.37445319335083d-09
#define CONV_mmicr_nail	1.74978127734033d-08
#define CONV_mmicr_milen	5.39956803455724d-13
#define CONV_mmicr_leagn	1.79985601151908d-13
#define CONV_mmicr_fathom	5.46806649168854d-10
#define CONV_mmicr_degn	8.99928005759539d-15
#define CONV_mmicr_circn	2.49980001599872d-17
#define CONV_mmicr_cablen	5.39956803455723d-12
#define CONV_mmicr_ly	1.05702323231362d-25
#define CONV_mmicr_au	6.68458321045438d-21
#define CONV_mmicr_pc	3.24078037911195d-26
#define CONV_mmicr_ls	3.33571163560604d-18
#define CONV_mmicr_lm	5.55951939267673d-20
#define CONV_mmicr_bolt	2.73403324584427d-11
#define CONV_fermi_km	1d-18
#define CONV_fermi_m	1d-15
#define CONV_fermi_cm	1d-13
#define CONV_fermi_mm	1d-12
#define CONV_fermi_um	1d-09
#define CONV_fermi_nm	1d-06
#define CONV_fermi_pm	0.001d0
#define CONV_fermi_micron	1d-09
#define CONV_fermi_mmicr	1d-06
#define CONV_fermi_a	1d-05
#define CONV_fermi_a0	1.8897259576923d-05
#define CONV_fermi_hand	9.84251968503937d-15
#define CONV_fermi_ell	8.74890638670166d-16
#define CONV_fermi_in	3.93700787401575d-14
#define CONV_fermi_ft	3.28083989501312d-15
#define CONV_fermi_yd	1.09361329833771d-15
#define CONV_fermi_mile	6.21371192237334d-19
#define CONV_fermi_mileu	6.21369949492802d-19
#define CONV_fermi_mil	3.93700787401575d-11
#define CONV_fermi_rod	1.98838781515947d-16
#define CONV_fermi_fur	4.97096953789867d-18
#define CONV_fermi_chaing	4.97096953789867d-17
#define CONV_fermi_chainr	3.28083989501312d-17
#define CONV_fermi_leag	2.07123730745778d-19
#define CONV_fermi_cable	4.55672207640712d-18
#define CONV_fermi_calib	3.93700787401575d-12
#define CONV_fermi_cubit	2.18722659667542d-15
#define CONV_fermi_ftu	3.28083333334646d-15
#define CONV_fermi_barley	1.18110236220472d-13
#define CONV_fermi_x	0.00997984072174208d0
#define CONV_fermi_span	4.37445319335083d-15
#define CONV_fermi_nail	1.74978127734033d-14
#define CONV_fermi_milen	5.39956803455724d-19
#define CONV_fermi_leagn	1.79985601151908d-19
#define CONV_fermi_fathom	5.46806649168854d-16
#define CONV_fermi_degn	8.99928005759539d-21
#define CONV_fermi_circn	2.49980001599872d-23
#define CONV_fermi_cablen	5.39956803455723d-18
#define CONV_fermi_ly	1.05702323231362d-31
#define CONV_fermi_au	6.68458321045438d-27
#define CONV_fermi_pc	3.24078037911195d-32
#define CONV_fermi_ls	3.33571163560604d-24
#define CONV_fermi_lm	5.55951939267673d-26
#define CONV_fermi_bolt	2.73403324584427d-17
#define CONV_a_km	1d-13
#define CONV_a_m	1d-10
#define CONV_a_cm	1d-08
#define CONV_a_mm	1d-07
#define CONV_a_um	0.0001d0
#define CONV_a_nm	0.1d0
#define CONV_a_pm	100d0
#define CONV_a_micron	0.0001d0
#define CONV_a_mmicr	0.1d0
#define CONV_a_fermi	100000d0
#define CONV_a_a0	1.8897259576923d0
#define CONV_a_hand	9.84251968503937d-10
#define CONV_a_ell	8.74890638670166d-11
#define CONV_a_in	3.93700787401575d-09
#define CONV_a_ft	3.28083989501312d-10
#define CONV_a_yd	1.09361329833771d-10
#define CONV_a_mile	6.21371192237334d-14
#define CONV_a_mileu	6.21369949492802d-14
#define CONV_a_mil	3.93700787401575d-06
#define CONV_a_rod	1.98838781515947d-11
#define CONV_a_fur	4.97096953789867d-13
#define CONV_a_chaing	4.97096953789867d-12
#define CONV_a_chainr	3.28083989501312d-12
#define CONV_a_leag	2.07123730745778d-14
#define CONV_a_cable	4.55672207640712d-13
#define CONV_a_calib	3.93700787401575d-07
#define CONV_a_cubit	2.18722659667542d-10
#define CONV_a_ftu	3.28083333334646d-10
#define CONV_a_barley	1.18110236220472d-08
#define CONV_a_x	997.984072174208d0
#define CONV_a_span	4.37445319335083d-10
#define CONV_a_nail	1.74978127734033d-09
#define CONV_a_milen	5.39956803455724d-14
#define CONV_a_leagn	1.79985601151908d-14
#define CONV_a_fathom	5.46806649168854d-11
#define CONV_a_degn	8.99928005759539d-16
#define CONV_a_circn	2.49980001599872d-18
#define CONV_a_cablen	5.39956803455724d-13
#define CONV_a_ly	1.05702323231362d-26
#define CONV_a_au	6.68458321045438d-22
#define CONV_a_pc	3.24078037911195d-27
#define CONV_a_ls	3.33571163560604d-19
#define CONV_a_lm	5.55951939267673d-21
#define CONV_a_bolt	2.73403324584427d-12
#define CONV_a0_km	5.29177257649136d-14
#define CONV_a0_m	5.29177257649136d-11
#define CONV_a0_cm	5.29177257649136d-09
#define CONV_a0_mm	5.29177257649136d-08
#define CONV_a0_um	5.29177257649136d-05
#define CONV_a0_nm	0.0529177257649136d0
#define CONV_a0_pm	52.9177257649136d0
#define CONV_a0_micron	5.29177257649136d-05
#define CONV_a0_mmicr	0.0529177257649136d0
#define CONV_a0_fermi	52917.7257649136d0
#define CONV_a0_a	0.529177257649136d0
#define CONV_a0_hand	5.20843757528677d-10
#define CONV_a0_ell	4.62972228914379d-11
#define CONV_a0_in	2.08337503011471d-09
#define CONV_a0_ft	1.73614585842892d-10
#define CONV_a0_yd	5.78715286142974d-11
#define CONV_a0_mile	3.28815503490326d-14
#define CONV_a0_mileu	3.28814845858183d-14
#define CONV_a0_mil	2.08337503011471d-06
#define CONV_a0_rod	1.05220961116904d-11
#define CONV_a0_fur	2.63052402792261d-13
#define CONV_a0_chaing	2.63052402792261d-12
#define CONV_a0_chainr	1.73614585842892d-12
#define CONV_a0_leag	1.09605167830109d-14
#define CONV_a0_cable	2.41131369226239d-13
#define CONV_a0_calib	2.08337503011471d-07
#define CONV_a0_cubit	1.15743057228595d-10
#define CONV_a0_ftu	1.73614238614415d-10
#define CONV_a0_barley	6.25012509034412d-09
#define CONV_a0_x	528.110474490665d0
#define CONV_a0_span	2.3148611445719d-10
#define CONV_a0_nail	9.25944457828759d-10
#define CONV_a0_milen	2.85732860501693d-14
#define CONV_a0_leagn	9.52442868338977d-15
#define CONV_a0_fathom	2.89357643071487d-11
#define CONV_a0_degn	4.76221434169489d-16
#define CONV_a0_circn	1.32283731713747d-18
#define CONV_a0_cablen	2.85732860501693d-13
#define CONV_a0_ly	5.59352655347148d-27
#define CONV_a0_au	3.53732941183571d-22
#define CONV_a0_pc	1.71494727366159d-27
#define CONV_a0_ls	1.76518273563832d-19
#define CONV_a0_lm	2.94197122606386d-21
#define CONV_a0_bolt	1.44678821535744d-12
#define CONV_hand_km	0.0001016d0
#define CONV_hand_m	0.1016d0
#define CONV_hand_cm	10.16d0
#define CONV_hand_mm	101.6d0
#define CONV_hand_um	101600d0
#define CONV_hand_nm	101600000d0
#define CONV_hand_pm	101600000000d0
#define CONV_hand_micron	101600d0
#define CONV_hand_mmicr	101600000d0
#define CONV_hand_fermi	101600000000000d0
#define CONV_hand_a	1016000000d0
#define CONV_hand_a0	1919961573.01538d0
#define CONV_hand_ell	0.0888888888888889d0
#define CONV_hand_in	4d0
#define CONV_hand_ft	0.333333333333333d0
#define CONV_hand_yd	0.111111111111111d0
#define CONV_hand_mile	6.31313131313131d-05
#define CONV_hand_mileu	6.31311868684687d-05
#define CONV_hand_mil	4000d0
#define CONV_hand_rod	0.0202020202020202d0
#define CONV_hand_fur	0.000505050505050505d0
#define CONV_hand_chaing	0.00505050505050505d0
#define CONV_hand_chainr	0.00333333333333333d0
#define CONV_hand_leag	2.1043771043771d-05
#define CONV_hand_cable	0.000462962962962963d0
#define CONV_hand_calib	400d0
#define CONV_hand_cubit	0.222222222222222d0
#define CONV_hand_ftu	0.333332666668d0
#define CONV_hand_barley	12d0
#define CONV_hand_x	1013951817329d0
#define CONV_hand_span	0.444444444444444d0
#define CONV_hand_nail	1.77777777777778d0
#define CONV_hand_milen	5.48596112311015d-05
#define CONV_hand_leagn	1.82865370770338d-05
#define CONV_hand_fathom	0.0555555555555556d0
#define CONV_hand_degn	9.14326853851692d-07
#define CONV_hand_circn	2.5397968162547d-09
#define CONV_hand_cablen	0.000548596112311015d0
#define CONV_hand_ly	1.07393560403064d-17
#define CONV_hand_au	6.79153654182165d-13
#define CONV_hand_pc	3.29263286517774d-18
#define CONV_hand_ls	3.38908302177574d-10
#define CONV_hand_lm	5.64847170295956d-12
#define CONV_hand_bolt	0.00277777777777778d0
#define CONV_ell_km	0.001143d0
#define CONV_ell_m	1.143d0
#define CONV_ell_cm	114.3d0
#define CONV_ell_mm	1143d0
#define CONV_ell_um	1143000d0
#define CONV_ell_nm	1143000000d0
#define CONV_ell_pm	1143000000000d0
#define CONV_ell_micron	1143000d0
#define CONV_ell_mmicr	1143000000d0
#define CONV_ell_fermi	1.143d+15
#define CONV_ell_a	11430000000d0
#define CONV_ell_a0	21599567696.423d0
#define CONV_ell_hand	11.25d0
#define CONV_ell_in	45d0
#define CONV_ell_ft	3.75d0
#define CONV_ell_yd	1.25d0
#define CONV_ell_mile	0.000710227272727273d0
#define CONV_ell_mileu	0.000710225852270273d0
#define CONV_ell_mil	45000d0
#define CONV_ell_rod	0.227272727272727d0
#define CONV_ell_fur	0.00568181818181818d0
#define CONV_ell_chaing	0.0568181818181818d0
#define CONV_ell_chainr	0.0375d0
#define CONV_ell_leag	0.000236742424242424d0
#define CONV_ell_cable	0.00520833333333333d0
#define CONV_ell_calib	4500d0
#define CONV_ell_cubit	2.5d0
#define CONV_ell_ftu	3.749992500015d0
#define CONV_ell_barley	135d0
#define CONV_ell_x	11406957944951.2d0
#define CONV_ell_span	5d0
#define CONV_ell_nail	20d0
#define CONV_ell_milen	0.000617170626349892d0
#define CONV_ell_leagn	0.000205723542116631d0
#define CONV_ell_fathom	0.625d0
#define CONV_ell_degn	1.02861771058315d-05
#define CONV_ell_circn	2.85727141828654d-08
#define CONV_ell_cablen	0.00617170626349892d0
#define CONV_ell_ly	1.20817755453447d-16
#define CONV_ell_au	7.64047860954936d-12
#define CONV_ell_pc	3.70421197332496d-17
#define CONV_ell_ls	3.8127183994977d-09
#define CONV_ell_lm	6.35453066582951d-11
#define CONV_ell_bolt	0.03125d0
#define CONV_in_km	2.54d-05
#define CONV_in_m	0.0254d0
#define CONV_in_cm	2.54d0
#define CONV_in_mm	25.4d0
#define CONV_in_um	25400d0
#define CONV_in_nm	25400000d0
#define CONV_in_pm	25400000000d0
#define CONV_in_micron	25400d0
#define CONV_in_mmicr	25400000d0
#define CONV_in_fermi	25400000000000d0
#define CONV_in_a	254000000d0
#define CONV_in_a0	479990393.253845d0
#define CONV_in_hand	0.25d0
#define CONV_in_ell	0.0222222222222222d0
#define CONV_in_ft	0.0833333333333333d0
#define CONV_in_yd	0.0277777777777778d0
#define CONV_in_mile	1.57828282828283d-05
#define CONV_in_mileu	1.57827967171172d-05
#define CONV_in_mil	1000d0
#define CONV_in_rod	0.00505050505050505d0
#define CONV_in_fur	0.000126262626262626d0
#define CONV_in_chaing	0.00126262626262626d0
#define CONV_in_chainr	0.000833333333333333d0
#define CONV_in_leag	5.26094276094276d-06
#define CONV_in_cable	0.000115740740740741d0
#define CONV_in_calib	100d0
#define CONV_in_cubit	0.0555555555555556d0
#define CONV_in_ftu	0.083333166667d0
#define CONV_in_barley	3d0
#define CONV_in_x	253487954332.249d0
#define CONV_in_span	0.111111111111111d0
#define CONV_in_nail	0.444444444444444d0
#define CONV_in_milen	1.37149028077754d-05
#define CONV_in_leagn	4.57163426925846d-06
#define CONV_in_fathom	0.0138888888888889d0
#define CONV_in_degn	2.28581713462923d-07
#define CONV_in_circn	6.34949204063675d-10
#define CONV_in_cablen	0.000137149028077754d0
#define CONV_in_ly	2.6848390100766d-18
#define CONV_in_au	1.69788413545541d-13
#define CONV_in_pc	8.23158216294436d-19
#define CONV_in_ls	8.47270755443934d-11
#define CONV_in_lm	1.41211792573989d-12
#define CONV_in_bolt	0.000694444444444444d0
#define CONV_ft_km	0.0003048d0
#define CONV_ft_m	0.3048d0
#define CONV_ft_cm	30.48d0
#define CONV_ft_mm	304.8d0
#define CONV_ft_um	304800d0
#define CONV_ft_nm	304800000d0
#define CONV_ft_pm	304800000000d0
#define CONV_ft_micron	304800d0
#define CONV_ft_mmicr	304800000d0
#define CONV_ft_fermi	304800000000000d0
#define CONV_ft_a	3048000000d0
#define CONV_ft_a0	5759884719.04614d0
#define CONV_ft_hand	3d0
#define CONV_ft_ell	0.266666666666667d0
#define CONV_ft_in	12d0
#define CONV_ft_yd	0.333333333333333d0
#define CONV_ft_mile	0.000189393939393939d0
#define CONV_ft_mileu	0.000189393560605406d0
#define CONV_ft_mil	12000d0
#define CONV_ft_rod	0.0606060606060606d0
#define CONV_ft_fur	0.00151515151515152d0
#define CONV_ft_chaing	0.0151515151515152d0
#define CONV_ft_chainr	0.01d0
#define CONV_ft_leag	6.31313131313131d-05
#define CONV_ft_cable	0.00138888888888889d0
#define CONV_ft_calib	1200d0
#define CONV_ft_cubit	0.666666666666667d0
#define CONV_ft_ftu	0.999998000004d0
#define CONV_ft_barley	36d0
#define CONV_ft_x	3041855451986.99d0
#define CONV_ft_span	1.33333333333333d0
#define CONV_ft_nail	5.33333333333333d0
#define CONV_ft_milen	0.000164578833693305d0
#define CONV_ft_leagn	5.48596112311015d-05
#define CONV_ft_fathom	0.166666666666667d0
#define CONV_ft_degn	2.74298056155508d-06
#define CONV_ft_circn	7.6193904487641d-09
#define CONV_ft_cablen	0.00164578833693305d0
#define CONV_ft_ly	3.22180681209192d-17
#define CONV_ft_au	2.0374609625465d-12
#define CONV_ft_pc	9.87789859553323d-18
#define CONV_ft_ls	1.01672490653272d-09
#define CONV_ft_lm	1.69454151088787d-11
#define CONV_ft_bolt	0.00833333333333333d0
#define CONV_yd_km	0.0009144d0
#define CONV_yd_m	0.9144d0
#define CONV_yd_cm	91.44d0
#define CONV_yd_mm	914.4d0
#define CONV_yd_um	914400d0
#define CONV_yd_nm	914400000d0
#define CONV_yd_pm	914400000000d0
#define CONV_yd_micron	914400d0
#define CONV_yd_mmicr	914400000d0
#define CONV_yd_fermi	914400000000000d0
#define CONV_yd_a	9144000000d0
#define CONV_yd_a0	17279654157.1384d0
#define CONV_yd_hand	9d0
#define CONV_yd_ell	0.8d0
#define CONV_yd_in	36d0
#define CONV_yd_ft	3d0
#define CONV_yd_mile	0.000568181818181818d0
#define CONV_yd_mileu	0.000568180681816218d0
#define CONV_yd_mil	36000d0
#define CONV_yd_rod	0.181818181818182d0
#define CONV_yd_fur	0.00454545454545455d0
#define CONV_yd_chaing	0.0454545454545455d0
#define CONV_yd_chainr	0.03d0
#define CONV_yd_leag	0.000189393939393939d0
#define CONV_yd_cable	0.00416666666666667d0
#define CONV_yd_calib	3600d0
#define CONV_yd_cubit	2d0
#define CONV_yd_ftu	2.999994000012d0
#define CONV_yd_barley	108d0
#define CONV_yd_x	9125566355960.96d0
#define CONV_yd_span	4d0
#define CONV_yd_nail	16d0
#define CONV_yd_milen	0.000493736501079914d0
#define CONV_yd_leagn	0.000164578833693305d0
#define CONV_yd_fathom	0.5d0
#define CONV_yd_degn	8.22894168466523d-06
#define CONV_yd_circn	2.28581713462923d-08
#define CONV_yd_cablen	0.00493736501079914d0
#define CONV_yd_ly	9.66542043627577d-17
#define CONV_yd_au	6.11238288763949d-12
#define CONV_yd_pc	2.96336957865997d-17
#define CONV_yd_ls	3.05017471959816d-09
#define CONV_yd_lm	5.0836245326636d-11
#define CONV_yd_bolt	0.025d0
#define CONV_mile_km	1.609344d0
#define CONV_mile_m	1609.344d0
#define CONV_mile_cm	160934.4d0
#define CONV_mile_mm	1609344d0
#define CONV_mile_um	1609344000d0
#define CONV_mile_nm	1609344000000d0
#define CONV_mile_pm	1.609344d+15
#define CONV_mile_micron	1609344000d0
#define CONV_mile_mmicr	1609344000000d0
#define CONV_mile_fermi	1.609344d+18
#define CONV_mile_a	16093440000000d0
#define CONV_mile_a0	30412191316563.6d0
#define CONV_mile_hand	15840d0
#define CONV_mile_ell	1408d0
#define CONV_mile_in	63360d0
#define CONV_mile_ft	5280d0
#define CONV_mile_yd	1760d0
#define CONV_mile_mileu	0.999997999996544d0
#define CONV_mile_mil	63360000d0
#define CONV_mile_rod	320d0
#define CONV_mile_fur	8d0
#define CONV_mile_chaing	80d0
#define CONV_mile_chainr	52.8d0
#define CONV_mile_leag	0.333333333333333d0
#define CONV_mile_cable	7.33333333333333d0
#define CONV_mile_calib	6336000d0
#define CONV_mile_cubit	3520d0
#define CONV_mile_ftu	5279.98944002112d0
#define CONV_mile_barley	190080d0
#define CONV_mile_x	1.60609967864913d+16
#define CONV_mile_span	7040d0
#define CONV_mile_nail	28160d0
#define CONV_mile_milen	0.868976241900648d0
#define CONV_mile_leagn	0.289658747300216d0
#define CONV_mile_fathom	880d0
#define CONV_mile_degn	0.0144829373650108d0
#define CONV_mile_circn	4.02303815694744d-05
#define CONV_mile_cablen	8.68976241900648d0
#define CONV_mile_ly	1.70111399678454d-13
#define CONV_mile_au	1.07577938822455d-08
#define CONV_mile_pc	5.21553045844155d-14
#define CONV_mile_ls	5.36830750649277d-06
#define CONV_mile_lm	8.94717917748794d-08
#define CONV_mile_bolt	44d0
#define CONV_mileu_km	1.6093472187d0
#define CONV_mileu_m	1609.3472187d0
#define CONV_mileu_cm	160934.72187d0
#define CONV_mileu_mm	1609347.2187d0
#define CONV_mileu_um	1609347218.7d0
#define CONV_mileu_nm	1609347218700d0
#define CONV_mileu_pm	1.6093472187d+15
#define CONV_mileu_micron	1609347218.7d0
#define CONV_mileu_mmicr	1609347218700d0
#define CONV_mileu_fermi	1.6093472187d+18
#define CONV_mileu_a	16093472187000d0
#define CONV_mileu_a0	30412252141173d0
#define CONV_mileu_hand	15840.0316801181d0
#define CONV_mileu_ell	1408.0028160105d0
#define CONV_mileu_in	63360.1267204724d0
#define CONV_mileu_ft	5280.01056003937d0
#define CONV_mileu_yd	1760.00352001312d0
#define CONV_mileu_mile	1.00000200000746d0
#define CONV_mileu_mil	63360126.7204724d0
#define CONV_mileu_rod	320.000640002386d0
#define CONV_mileu_fur	8.00001600005965d0
#define CONV_mileu_chaing	80.0001600005965d0
#define CONV_mileu_chainr	52.8001056003937d0
#define CONV_mileu_leag	0.333334000002485d0
#define CONV_mileu_cable	7.33334800005468d0
#define CONV_mileu_calib	6336012.67204724d0
#define CONV_mileu_cubit	3520.00704002625d0
#define CONV_mileu_ftu	5280.00000003937d0
#define CONV_mileu_barley	190080.380161417d0
#define CONV_mileu_x	1.60610289086046d+16
#define CONV_mileu_span	7040.01408005249d0
#define CONV_mileu_nail	28160.05632021d0
#define CONV_mileu_milen	0.868977979859611d0
#define CONV_mileu_leagn	0.28965932661987d0
#define CONV_mileu_fathom	880.001760006562d0
#define CONV_mileu_degn	0.0144829663309935d0
#define CONV_mileu_circn	4.02304620305375d-05
#define CONV_mileu_cablen	8.68977979859611d0
#define CONV_mileu_ly	1.70111739902521d-13
#define CONV_mileu_au	1.07578153979135d-08
#define CONV_mileu_pc	5.21554088954135d-14
#define CONV_mileu_ls	5.36831824314781d-06
#define CONV_mileu_lm	8.94719707191301d-08
#define CONV_mileu_bolt	44.0000880003281d0
#define CONV_mil_km	2.54d-08
#define CONV_mil_m	2.54d-05
#define CONV_mil_cm	0.00254d0
#define CONV_mil_mm	0.0254d0
#define CONV_mil_um	25.4d0
#define CONV_mil_nm	25400d0
#define CONV_mil_pm	25400000d0
#define CONV_mil_micron	25.4d0
#define CONV_mil_mmicr	25400d0
#define CONV_mil_fermi	25400000000d0
#define CONV_mil_a	254000d0
#define CONV_mil_a0	479990.393253845d0
#define CONV_mil_hand	0.00025d0
#define CONV_mil_ell	2.22222222222222d-05
#define CONV_mil_in	0.001d0
#define CONV_mil_ft	8.33333333333333d-05
#define CONV_mil_yd	2.77777777777778d-05
#define CONV_mil_mile	1.57828282828283d-08
#define CONV_mil_mileu	1.57827967171172d-08
#define CONV_mil_rod	5.05050505050505d-06
#define CONV_mil_fur	1.26262626262626d-07
#define CONV_mil_chaing	1.26262626262626d-06
#define CONV_mil_chainr	8.33333333333333d-07
#define CONV_mil_leag	5.26094276094276d-09
#define CONV_mil_cable	1.15740740740741d-07
#define CONV_mil_calib	0.1d0
#define CONV_mil_cubit	5.55555555555556d-05
#define CONV_mil_ftu	8.3333166667d-05
#define CONV_mil_barley	0.003d0
#define CONV_mil_x	253487954.332249d0
#define CONV_mil_span	0.000111111111111111d0
#define CONV_mil_nail	0.000444444444444444d0
#define CONV_mil_milen	1.37149028077754d-08
#define CONV_mil_leagn	4.57163426925846d-09
#define CONV_mil_fathom	1.38888888888889d-05
#define CONV_mil_degn	2.28581713462923d-10
#define CONV_mil_circn	6.34949204063675d-13
#define CONV_mil_cablen	1.37149028077754d-07
#define CONV_mil_ly	2.6848390100766d-21
#define CONV_mil_au	1.69788413545541d-16
#define CONV_mil_pc	8.23158216294436d-22
#define CONV_mil_ls	8.47270755443934d-14
#define CONV_mil_lm	1.41211792573989d-15
#define CONV_mil_bolt	6.94444444444444d-07
#define CONV_rod_km	0.0050292d0
#define CONV_rod_m	5.0292d0
#define CONV_rod_cm	502.92d0
#define CONV_rod_mm	5029.2d0
#define CONV_rod_um	5029200d0
#define CONV_rod_nm	5029200000d0
#define CONV_rod_pm	5029200000000d0
#define CONV_rod_micron	5029200d0
#define CONV_rod_mmicr	5029200000d0
#define CONV_rod_fermi	5.0292d+15
#define CONV_rod_a	50292000000d0
#define CONV_rod_a0	95038097864.2614d0
#define CONV_rod_hand	49.5d0
#define CONV_rod_ell	4.4d0
#define CONV_rod_in	198d0
#define CONV_rod_ft	16.5d0
#define CONV_rod_yd	5.5d0
#define CONV_rod_mile	0.003125d0
#define CONV_rod_mileu	0.0031249937499892d0
#define CONV_rod_mil	198000d0
#define CONV_rod_fur	0.025d0
#define CONV_rod_chaing	0.25d0
#define CONV_rod_chainr	0.165d0
#define CONV_rod_leag	0.00104166666666667d0
#define CONV_rod_cable	0.0229166666666667d0
#define CONV_rod_calib	19800d0
#define CONV_rod_cubit	11d0
#define CONV_rod_ftu	16.499967000066d0
#define CONV_rod_barley	594d0
#define CONV_rod_x	50190614957785.3d0
#define CONV_rod_span	22d0
#define CONV_rod_nail	88d0
#define CONV_rod_milen	0.00271555075593952d0
#define CONV_rod_leagn	0.000905183585313175d0
#define CONV_rod_fathom	2.75d0
#define CONV_rod_degn	4.52591792656587d-05
#define CONV_rod_circn	1.25719942404608d-07
#define CONV_rod_cablen	0.0271555075593952d0
#define CONV_rod_ly	5.31598123995167d-16
#define CONV_rod_au	3.36181058820172d-11
#define CONV_rod_pc	1.62985326826298d-16
#define CONV_rod_ls	1.67759609577899d-08
#define CONV_rod_lm	2.79599349296498d-10
#define CONV_rod_bolt	0.1375d0
#define CONV_fur_km	0.201168d0
#define CONV_fur_m	201.168d0
#define CONV_fur_cm	20116.8d0
#define CONV_fur_mm	201168d0
#define CONV_fur_um	201168000d0
#define CONV_fur_nm	201168000000d0
#define CONV_fur_pm	201168000000000d0
#define CONV_fur_micron	201168000d0
#define CONV_fur_mmicr	201168000000d0
#define CONV_fur_fermi	2.01168d+17
#define CONV_fur_a	2011680000000d0
#define CONV_fur_a0	3801523914570.45d0
#define CONV_fur_hand	1980d0
#define CONV_fur_ell	176d0
#define CONV_fur_in	7920d0
#define CONV_fur_ft	660d0
#define CONV_fur_yd	220d0
#define CONV_fur_mile	0.125d0
#define CONV_fur_mileu	0.124999749999568d0
#define CONV_fur_mil	7920000d0
#define CONV_fur_rod	40d0
#define CONV_fur_chaing	10d0
#define CONV_fur_chainr	6.6d0
#define CONV_fur_leag	0.0416666666666667d0
#define CONV_fur_cable	0.916666666666667d0
#define CONV_fur_calib	792000d0
#define CONV_fur_cubit	440d0
#define CONV_fur_ftu	659.99868000264d0
#define CONV_fur_barley	23760d0
#define CONV_fur_x	2.00762459831141d+15
#define CONV_fur_span	880d0
#define CONV_fur_nail	3520d0
#define CONV_fur_milen	0.108622030237581d0
#define CONV_fur_leagn	0.036207343412527d0
#define CONV_fur_fathom	110d0
#define CONV_fur_degn	0.00181036717062635d0
#define CONV_fur_circn	5.02879769618431d-06
#define CONV_fur_cablen	1.08622030237581d0
#define CONV_fur_ly	2.12639249598067d-14
#define CONV_fur_au	1.34472423528069d-09
#define CONV_fur_pc	6.51941307305193d-15
#define CONV_fur_ls	6.71038438311596d-07
#define CONV_fur_lm	1.11839739718599d-08
#define CONV_fur_bolt	5.5d0
#define CONV_chaing_km	0.0201168d0
#define CONV_chaing_m	20.1168d0
#define CONV_chaing_cm	2011.68d0
#define CONV_chaing_mm	20116.8d0
#define CONV_chaing_um	20116800d0
#define CONV_chaing_nm	20116800000d0
#define CONV_chaing_pm	20116800000000d0
#define CONV_chaing_micron	20116800d0
#define CONV_chaing_mmicr	20116800000d0
#define CONV_chaing_fermi	2.01168d+16
#define CONV_chaing_a	201168000000d0
#define CONV_chaing_a0	380152391457.045d0
#define CONV_chaing_hand	198d0
#define CONV_chaing_ell	17.6d0
#define CONV_chaing_in	792d0
#define CONV_chaing_ft	66d0
#define CONV_chaing_yd	22d0
#define CONV_chaing_mile	0.0125d0
#define CONV_chaing_mileu	0.0124999749999568d0
#define CONV_chaing_mil	792000d0
#define CONV_chaing_rod	4d0
#define CONV_chaing_fur	0.1d0
#define CONV_chaing_chainr	0.66d0
#define CONV_chaing_leag	0.00416666666666667d0
#define CONV_chaing_cable	0.0916666666666667d0
#define CONV_chaing_calib	79200d0
#define CONV_chaing_cubit	44d0
#define CONV_chaing_ftu	65.999868000264d0
#define CONV_chaing_barley	2376d0
#define CONV_chaing_x	200762459831141d0
#define CONV_chaing_span	88d0
#define CONV_chaing_nail	352d0
#define CONV_chaing_milen	0.0108622030237581d0
#define CONV_chaing_leagn	0.0036207343412527d0
#define CONV_chaing_fathom	11d0
#define CONV_chaing_degn	0.000181036717062635d0
#define CONV_chaing_circn	5.0287976961843d-07
#define CONV_chaing_cablen	0.108622030237581d0
#define CONV_chaing_ly	2.12639249598067d-15
#define CONV_chaing_au	1.34472423528069d-10
#define CONV_chaing_pc	6.51941307305193d-16
#define CONV_chaing_ls	6.71038438311596d-08
#define CONV_chaing_lm	1.11839739718599d-09
#define CONV_chaing_bolt	0.55d0
#define CONV_chainr_km	0.03048d0
#define CONV_chainr_m	30.48d0
#define CONV_chainr_cm	3048d0
#define CONV_chainr_mm	30480d0
#define CONV_chainr_um	30480000d0
#define CONV_chainr_nm	30480000000d0
#define CONV_chainr_pm	30480000000000d0
#define CONV_chainr_micron	30480000d0
#define CONV_chainr_mmicr	30480000000d0
#define CONV_chainr_fermi	3.048d+16
#define CONV_chainr_a	304800000000d0
#define CONV_chainr_a0	575988471904.614d0
#define CONV_chainr_hand	300d0
#define CONV_chainr_ell	26.6666666666667d0
#define CONV_chainr_in	1200d0
#define CONV_chainr_ft	100d0
#define CONV_chainr_yd	33.3333333333333d0
#define CONV_chainr_mile	0.0189393939393939d0
#define CONV_chainr_mileu	0.0189393560605406d0
#define CONV_chainr_mil	1200000d0
#define CONV_chainr_rod	6.06060606060606d0
#define CONV_chainr_fur	0.151515151515152d0
#define CONV_chainr_chaing	1.51515151515152d0
#define CONV_chainr_leag	0.00631313131313131d0
#define CONV_chainr_cable	0.138888888888889d0
#define CONV_chainr_calib	120000d0
#define CONV_chainr_cubit	66.6666666666667d0
#define CONV_chainr_ftu	99.9998000004d0
#define CONV_chainr_barley	3600d0
#define CONV_chainr_x	304185545198699d0
#define CONV_chainr_span	133.333333333333d0
#define CONV_chainr_nail	533.333333333333d0
#define CONV_chainr_milen	0.0164578833693305d0
#define CONV_chainr_leagn	0.00548596112311015d0
#define CONV_chainr_fathom	16.6666666666667d0
#define CONV_chainr_degn	0.000274298056155508d0
#define CONV_chainr_circn	7.6193904487641d-07
#define CONV_chainr_cablen	0.164578833693305d0
#define CONV_chainr_ly	3.22180681209192d-15
#define CONV_chainr_au	2.0374609625465d-10
#define CONV_chainr_pc	9.87789859553323d-16
#define CONV_chainr_ls	1.01672490653272d-07
#define CONV_chainr_lm	1.69454151088787d-09
#define CONV_chainr_bolt	0.833333333333333d0
#define CONV_leag_km	4.828032d0
#define CONV_leag_m	4828.032d0
#define CONV_leag_cm	482803.2d0
#define CONV_leag_mm	4828032d0
#define CONV_leag_um	4828032000d0
#define CONV_leag_nm	4828032000000d0
#define CONV_leag_pm	4.828032d+15
#define CONV_leag_micron	4828032000d0
#define CONV_leag_mmicr	4828032000000d0
#define CONV_leag_fermi	4.828032d+18
#define CONV_leag_a	48280320000000d0
#define CONV_leag_a0	91236573949690.9d0
#define CONV_leag_hand	47520d0
#define CONV_leag_ell	4224d0
#define CONV_leag_in	190080d0
#define CONV_leag_ft	15840d0
#define CONV_leag_yd	5280d0
#define CONV_leag_mile	3d0
#define CONV_leag_mileu	2.99999399998963d0
#define CONV_leag_mil	190080000d0
#define CONV_leag_rod	960d0
#define CONV_leag_fur	24d0
#define CONV_leag_chaing	240d0
#define CONV_leag_chainr	158.4d0
#define CONV_leag_cable	22d0
#define CONV_leag_calib	19008000d0
#define CONV_leag_cubit	10560d0
#define CONV_leag_ftu	15839.9683200634d0
#define CONV_leag_barley	570240d0
#define CONV_leag_x	4.81829903594739d+16
#define CONV_leag_span	21120d0
#define CONV_leag_nail	84480d0
#define CONV_leag_milen	2.60692872570194d0
#define CONV_leag_leagn	0.868976241900648d0
#define CONV_leag_fathom	2640d0
#define CONV_leag_degn	0.0434488120950324d0
#define CONV_leag_circn	0.000120691144708423d0
#define CONV_leag_cablen	26.0692872570194d0
#define CONV_leag_ly	5.10334199035361d-13
#define CONV_leag_au	3.22733816467365d-08
#define CONV_leag_pc	1.56465913753246d-13
#define CONV_leag_ls	1.61049225194783d-05
#define CONV_leag_lm	2.68415375324638d-07
#define CONV_leag_bolt	132d0
#define CONV_cable_km	0.219456d0
#define CONV_cable_m	219.456d0
#define CONV_cable_cm	21945.6d0
#define CONV_cable_mm	219456d0
#define CONV_cable_um	219456000d0
#define CONV_cable_nm	219456000000d0
#define CONV_cable_pm	219456000000000d0
#define CONV_cable_micron	219456000d0
#define CONV_cable_mmicr	219456000000d0
#define CONV_cable_fermi	2.19456d+17
#define CONV_cable_a	2194560000000d0
#define CONV_cable_a0	4147116997713.22d0
#define CONV_cable_hand	2160d0
#define CONV_cable_ell	192d0
#define CONV_cable_in	8640d0
#define CONV_cable_ft	720d0
#define CONV_cable_yd	240d0
#define CONV_cable_mile	0.136363636363636d0
#define CONV_cable_mileu	0.136363363635892d0
#define CONV_cable_mil	8640000d0
#define CONV_cable_rod	43.6363636363636d0
#define CONV_cable_fur	1.09090909090909d0
#define CONV_cable_chaing	10.9090909090909d0
#define CONV_cable_chainr	7.2d0
#define CONV_cable_leag	0.0454545454545454d0
#define CONV_cable_calib	864000d0
#define CONV_cable_cubit	480d0
#define CONV_cable_ftu	719.99856000288d0
#define CONV_cable_barley	25920d0
#define CONV_cable_x	2.19013592543063d+15
#define CONV_cable_span	960d0
#define CONV_cable_nail	3840d0
#define CONV_cable_milen	0.118496760259179d0
#define CONV_cable_leagn	0.0394989200863931d0
#define CONV_cable_fathom	120d0
#define CONV_cable_degn	0.00197494600431965d0
#define CONV_cable_circn	5.48596112311015d-06
#define CONV_cable_cablen	1.18496760259179d0
#define CONV_cable_ly	2.31970090470618d-14
#define CONV_cable_au	1.46697189303348d-09
#define CONV_cable_pc	7.11208698878393d-15
#define CONV_cable_ls	7.32041932703559d-07
#define CONV_cable_lm	1.22006988783926d-08
#define CONV_cable_bolt	6d0
#define CONV_calib_km	2.54d-07
#define CONV_calib_m	0.000254d0
#define CONV_calib_cm	0.0254d0
#define CONV_calib_mm	0.254d0
#define CONV_calib_um	254d0
#define CONV_calib_nm	254000d0
#define CONV_calib_pm	254000000d0
#define CONV_calib_micron	254d0
#define CONV_calib_mmicr	254000d0
#define CONV_calib_fermi	254000000000d0
#define CONV_calib_a	2540000d0
#define CONV_calib_a0	4799903.93253845d0
#define CONV_calib_hand	0.0025d0
#define CONV_calib_ell	0.000222222222222222d0
#define CONV_calib_in	0.01d0
#define CONV_calib_ft	0.000833333333333333d0
#define CONV_calib_yd	0.000277777777777778d0
#define CONV_calib_mile	1.57828282828283d-07
#define CONV_calib_mileu	1.57827967171172d-07
#define CONV_calib_mil	10d0
#define CONV_calib_rod	5.05050505050505d-05
#define CONV_calib_fur	1.26262626262626d-06
#define CONV_calib_chaing	1.26262626262626d-05
#define CONV_calib_chainr	8.33333333333333d-06
#define CONV_calib_leag	5.26094276094276d-08
#define CONV_calib_cable	1.15740740740741d-06
#define CONV_calib_cubit	0.000555555555555556d0
#define CONV_calib_ftu	0.00083333166667d0
#define CONV_calib_barley	0.03d0
#define CONV_calib_x	2534879543.32249d0
#define CONV_calib_span	0.00111111111111111d0
#define CONV_calib_nail	0.00444444444444444d0
#define CONV_calib_milen	1.37149028077754d-07
#define CONV_calib_leagn	4.57163426925846d-08
#define CONV_calib_fathom	0.000138888888888889d0
#define CONV_calib_degn	2.28581713462923d-09
#define CONV_calib_circn	6.34949204063675d-12
#define CONV_calib_cablen	1.37149028077754d-06
#define CONV_calib_ly	2.6848390100766d-20
#define CONV_calib_au	1.69788413545541d-15
#define CONV_calib_pc	8.23158216294436d-21
#define CONV_calib_ls	8.47270755443934d-13
#define CONV_calib_lm	1.41211792573989d-14
#define CONV_calib_bolt	6.94444444444444d-06
#define CONV_cubit_km	0.0004572d0
#define CONV_cubit_m	0.4572d0
#define CONV_cubit_cm	45.72d0
#define CONV_cubit_mm	457.2d0
#define CONV_cubit_um	457200d0
#define CONV_cubit_nm	457200000d0
#define CONV_cubit_pm	457200000000d0
#define CONV_cubit_micron	457200d0
#define CONV_cubit_mmicr	457200000d0
#define CONV_cubit_fermi	457200000000000d0
#define CONV_cubit_a	4572000000d0
#define CONV_cubit_a0	8639827078.56921d0
#define CONV_cubit_hand	4.5d0
#define CONV_cubit_ell	0.4d0
#define CONV_cubit_in	18d0
#define CONV_cubit_ft	1.5d0
#define CONV_cubit_yd	0.5d0
#define CONV_cubit_mile	0.000284090909090909d0
#define CONV_cubit_mileu	0.000284090340908109d0
#define CONV_cubit_mil	18000d0
#define CONV_cubit_rod	0.0909090909090909d0
#define CONV_cubit_fur	0.00227272727272727d0
#define CONV_cubit_chaing	0.0227272727272727d0
#define CONV_cubit_chainr	0.015d0
#define CONV_cubit_leag	9.46969696969697d-05
#define CONV_cubit_cable	0.00208333333333333d0
#define CONV_cubit_calib	1800d0
#define CONV_cubit_ftu	1.499997000006d0
#define CONV_cubit_barley	54d0
#define CONV_cubit_x	4562783177980.48d0
#define CONV_cubit_span	2d0
#define CONV_cubit_nail	8d0
#define CONV_cubit_milen	0.000246868250539957d0
#define CONV_cubit_leagn	8.22894168466523d-05
#define CONV_cubit_fathom	0.25d0
#define CONV_cubit_degn	4.11447084233261d-06
#define CONV_cubit_circn	1.14290856731461d-08
#define CONV_cubit_cablen	0.00246868250539957d0
#define CONV_cubit_ly	4.83271021813789d-17
#define CONV_cubit_au	3.05619144381974d-12
#define CONV_cubit_pc	1.48168478932998d-17
#define CONV_cubit_ls	1.52508735979908d-09
#define CONV_cubit_lm	2.5418122663318d-11
#define CONV_cubit_bolt	0.0125d0
#define CONV_ftu_km	0.0003048006096d0
#define CONV_ftu_m	0.3048006096d0
#define CONV_ftu_cm	30.48006096d0
#define CONV_ftu_mm	304.8006096d0
#define CONV_ftu_um	304800.6096d0
#define CONV_ftu_nm	304800609.6d0
#define CONV_ftu_pm	304800609600d0
#define CONV_ftu_micron	304800.6096d0
#define CONV_ftu_mmicr	304800609.6d0
#define CONV_ftu_fermi	304800609600000d0
#define CONV_ftu_a	3048006096d0
#define CONV_ftu_a0	5759896238.81558d0
#define CONV_ftu_hand	3.000006d0
#define CONV_ftu_ell	0.2666672d0
#define CONV_ftu_in	12.000024d0
#define CONV_ftu_ft	1.000002d0
#define CONV_ftu_yd	0.333334d0
#define CONV_ftu_mile	0.000189394318181818d0
#define CONV_ftu_mileu	0.000189393939392527d0
#define CONV_ftu_mil	12000.024d0
#define CONV_ftu_rod	0.0606061818181818d0
#define CONV_ftu_fur	0.00151515454545455d0
#define CONV_ftu_chaing	0.0151515454545455d0
#define CONV_ftu_chainr	0.01000002d0
#define CONV_ftu_leag	6.31314393939394d-05
#define CONV_ftu_cable	0.00138889166666667d0
#define CONV_ftu_calib	1200.0024d0
#define CONV_ftu_cubit	0.666668d0
#define CONV_ftu_barley	36.000072d0
#define CONV_ftu_x	3041861535697.89d0
#define CONV_ftu_span	1.333336d0
#define CONV_ftu_nail	5.333344d0
#define CONV_ftu_milen	0.000164579162850972d0
#define CONV_ftu_leagn	5.4859720950324d-05
#define CONV_ftu_fathom	0.166667d0
#define CONV_ftu_degn	2.7429860475162d-06
#define CONV_ftu_circn	7.61940568754499d-09
#define CONV_ftu_cablen	0.00164579162850972d0
#define CONV_ftu_ly	3.22181325570555d-17
#define CONV_ftu_au	2.03746503746842d-12
#define CONV_ftu_pc	9.87791835133042d-18
#define CONV_ftu_ls	1.01672693998253d-09
#define CONV_ftu_lm	1.69454489997089d-11
#define CONV_ftu_bolt	0.00833335d0
#define CONV_barley_km	8.46666666666667d-06
#define CONV_barley_m	0.00846666666666667d0
#define CONV_barley_cm	0.846666666666667d0
#define CONV_barley_mm	8.46666666666667d0
#define CONV_barley_um	8466.66666666667d0
#define CONV_barley_nm	8466666.66666667d0
#define CONV_barley_pm	8466666666.66667d0
#define CONV_barley_micron	8466.66666666667d0
#define CONV_barley_mmicr	8466666.66666667d0
#define CONV_barley_fermi	8466666666666.67d0
#define CONV_barley_a	84666666.6666667d0
#define CONV_barley_a0	159996797.751282d0
#define CONV_barley_hand	0.0833333333333333d0
#define CONV_barley_ell	0.00740740740740741d0
#define CONV_barley_in	0.333333333333333d0
#define CONV_barley_ft	0.0277777777777778d0
#define CONV_barley_yd	0.00925925925925926d0
#define CONV_barley_mile	5.26094276094276d-06
#define CONV_barley_mileu	5.26093223903906d-06
#define CONV_barley_mil	333.333333333333d0
#define CONV_barley_rod	0.00168350168350168d0
#define CONV_barley_fur	4.20875420875421d-05
#define CONV_barley_chaing	0.000420875420875421d0
#define CONV_barley_chainr	0.000277777777777778d0
#define CONV_barley_leag	1.75364758698092d-06
#define CONV_barley_cable	3.85802469135803d-05
#define CONV_barley_calib	33.3333333333333d0
#define CONV_barley_cubit	0.0185185185185185d0
#define CONV_barley_ftu	0.0277777222223333d0
#define CONV_barley_x	84495984777.4163d0
#define CONV_barley_span	0.037037037037037d0
#define CONV_barley_nail	0.148148148148148d0
#define CONV_barley_milen	4.57163426925846d-06
#define CONV_barley_leagn	1.52387808975282d-06
#define CONV_barley_fathom	0.00462962962962963d0
#define CONV_barley_degn	7.6193904487641d-08
#define CONV_barley_circn	2.11649734687892d-10
#define CONV_barley_cablen	4.57163426925846d-05
#define CONV_barley_ly	8.94946336692201d-19
#define CONV_barley_au	5.65961378485138d-14
#define CONV_barley_pc	2.74386072098145d-19
#define CONV_barley_ls	2.82423585147978d-11
#define CONV_barley_lm	4.7070597524663d-13
#define CONV_barley_bolt	0.000231481481481481d0
#define CONV_x_km	1.00202d-16
#define CONV_x_m	1.00202d-13
#define CONV_x_cm	1.00202d-11
#define CONV_x_mm	1.00202d-10
#define CONV_x_um	1.00202d-07
#define CONV_x_nm	0.000100202d0
#define CONV_x_pm	0.100202d0
#define CONV_x_micron	1.00202d-07
#define CONV_x_mmicr	0.000100202d0
#define CONV_x_fermi	100.202d0
#define CONV_x_a	0.00100202d0
#define CONV_x_a0	0.00189354320412684d0
#define CONV_x_hand	9.86240157480315d-13
#define CONV_x_ell	8.7665791776028d-14
#define CONV_x_in	3.94496062992126d-12
#define CONV_x_ft	3.28746719160105d-13
#define CONV_x_yd	1.09582239720035d-13
#define CONV_x_mile	6.22626362045653d-17
#define CONV_x_mileu	6.22625116790777d-17
#define CONV_x_mil	3.94496062992126d-09
#define CONV_x_rod	1.99240435854609d-14
#define CONV_x_fur	4.98101089636523d-16
#define CONV_x_chaing	4.98101089636523d-15
#define CONV_x_chainr	3.28746719160105d-15
#define CONV_x_leag	2.07542120681884d-17
#define CONV_x_cable	4.56592665500146d-16
#define CONV_x_calib	3.94496062992126d-10
#define CONV_x_cubit	2.1916447944007d-13
#define CONV_x_ftu	3.28746061667982d-13
#define CONV_x_barley	1.18348818897638d-11
#define CONV_x_span	4.3832895888014d-13
#define CONV_x_nail	1.75331583552056d-12
#define CONV_x_milen	5.41047516198704d-17
#define CONV_x_leagn	1.80349172066235d-17
#define CONV_x_fathom	5.47911198600175d-14
#define CONV_x_degn	9.01745860331173d-19
#define CONV_x_circn	2.50484961203104d-21
#define CONV_x_cablen	5.41047516198704d-16
#define CONV_x_ly	1.0591584192429d-29
#define CONV_x_au	6.6980860685395d-25
#define CONV_x_pc	3.24732675547776d-30
#define CONV_x_ls	3.34244977310996d-22
#define CONV_x_lm	5.57074962184994d-24
#define CONV_x_bolt	2.73955599300087d-15
#define CONV_span_km	0.0002286d0
#define CONV_span_m	0.2286d0
#define CONV_span_cm	22.86d0
#define CONV_span_mm	228.6d0
#define CONV_span_um	228600d0
#define CONV_span_nm	228600000d0
#define CONV_span_pm	228600000000d0
#define CONV_span_micron	228600d0
#define CONV_span_mmicr	228600000d0
#define CONV_span_fermi	228600000000000d0
#define CONV_span_a	2286000000d0
#define CONV_span_a0	4319913539.28461d0
#define CONV_span_hand	2.25d0
#define CONV_span_ell	0.2d0
#define CONV_span_in	9d0
#define CONV_span_ft	0.75d0
#define CONV_span_yd	0.25d0
#define CONV_span_mile	0.000142045454545455d0
#define CONV_span_mileu	0.000142045170454055d0
#define CONV_span_mil	9000d0
#define CONV_span_rod	0.0454545454545455d0
#define CONV_span_fur	0.00113636363636364d0
#define CONV_span_chaing	0.0113636363636364d0
#define CONV_span_chainr	0.0075d0
#define CONV_span_leag	4.73484848484848d-05
#define CONV_span_cable	0.00104166666666667d0
#define CONV_span_calib	900d0
#define CONV_span_cubit	0.5d0
#define CONV_span_ftu	0.749998500003d0
#define CONV_span_barley	27d0
#define CONV_span_x	2281391588990.24d0
#define CONV_span_nail	4d0
#define CONV_span_milen	0.000123434125269978d0
#define CONV_span_leagn	4.11447084233261d-05
#define CONV_span_fathom	0.125d0
#define CONV_span_degn	2.05723542116631d-06
#define CONV_span_circn	5.71454283657307d-09
#define CONV_span_cablen	0.00123434125269978d0
#define CONV_span_ly	2.41635510906894d-17
#define CONV_span_au	1.52809572190987d-12
#define CONV_span_pc	7.40842394664992d-18
#define CONV_span_ls	7.62543679899541d-10
#define CONV_span_lm	1.2709061331659d-11
#define CONV_span_bolt	0.00625d0
#define CONV_nail_km	5.715d-05
#define CONV_nail_m	0.05715d0
#define CONV_nail_cm	5.715d0
#define CONV_nail_mm	57.15d0
#define CONV_nail_um	57150d0
#define CONV_nail_nm	57150000d0
#define CONV_nail_pm	57150000000d0
#define CONV_nail_micron	57150d0
#define CONV_nail_mmicr	57150000d0
#define CONV_nail_fermi	57150000000000d0
#define CONV_nail_a	571500000d0
#define CONV_nail_a0	1079978384.82115d0
#define CONV_nail_hand	0.5625d0
#define CONV_nail_ell	0.05d0
#define CONV_nail_in	2.25d0
#define CONV_nail_ft	0.1875d0
#define CONV_nail_yd	0.0625d0
#define CONV_nail_mile	3.55113636363636d-05
#define CONV_nail_mileu	3.55112926135136d-05
#define CONV_nail_mil	2250d0
#define CONV_nail_rod	0.0113636363636364d0
#define CONV_nail_fur	0.000284090909090909d0
#define CONV_nail_chaing	0.00284090909090909d0
#define CONV_nail_chainr	0.001875d0
#define CONV_nail_leag	1.18371212121212d-05
#define CONV_nail_cable	0.000260416666666667d0
#define CONV_nail_calib	225d0
#define CONV_nail_cubit	0.125d0
#define CONV_nail_ftu	0.18749962500075d0
#define CONV_nail_barley	6.75d0
#define CONV_nail_x	570347897247.56d0
#define CONV_nail_span	0.25d0
#define CONV_nail_milen	3.08585313174946d-05
#define CONV_nail_leagn	1.02861771058315d-05
#define CONV_nail_fathom	0.03125d0
#define CONV_nail_degn	5.14308855291577d-07
#define CONV_nail_circn	1.42863570914327d-09
#define CONV_nail_cablen	0.000308585313174946d0
#define CONV_nail_ly	6.04088777267236d-18
#define CONV_nail_au	3.82023930477468d-13
#define CONV_nail_pc	1.85210598666248d-18
#define CONV_nail_ls	1.90635919974885d-10
#define CONV_nail_lm	3.17726533291475d-12
#define CONV_nail_bolt	0.0015625d0
#define CONV_milen_km	1.852d0
#define CONV_milen_m	1852d0
#define CONV_milen_cm	185200d0
#define CONV_milen_mm	1852000d0
#define CONV_milen_um	1852000000d0
#define CONV_milen_nm	1852000000000d0
#define CONV_milen_pm	1.852d+15
#define CONV_milen_micron	1852000000d0
#define CONV_milen_mmicr	1852000000000d0
#define CONV_milen_fermi	1.852d+18
#define CONV_milen_a	18520000000000d0
#define CONV_milen_a0	34997724736461.5d0
#define CONV_milen_hand	18228.3464566929d0
#define CONV_milen_ell	1620.29746281715d0
#define CONV_milen_in	72913.3858267717d0
#define CONV_milen_ft	6076.1154855643d0
#define CONV_milen_yd	2025.37182852143d0
#define CONV_milen_mile	1.15077944802354d0
#define CONV_milen_mileu	1.15077714646067d0
#define CONV_milen_mil	72913385.8267716d0
#define CONV_milen_rod	368.249423367534d0
#define CONV_milen_fur	9.20623558418834d0
#define CONV_milen_chaing	92.0623558418834d0
#define CONV_milen_chainr	60.761154855643d0
#define CONV_milen_leag	0.383593149341181d0
#define CONV_milen_cable	8.43904928550598d0
#define CONV_milen_calib	7291338.58267717d0
#define CONV_milen_cubit	4050.74365704287d0
#define CONV_milen_ftu	6076.10333335764d0
#define CONV_milen_barley	218740.157480315d0
#define CONV_milen_x	1.84826650166663d+16
#define CONV_milen_span	8101.48731408574d0
#define CONV_milen_nail	32405.949256343d0
#define CONV_milen_leagn	0.333333333333333d0
#define CONV_milen_fathom	1012.68591426072d0
#define CONV_milen_degn	0.0166666666666667d0
#define CONV_milen_circn	4.62962962962963d-05
#define CONV_milen_cablen	10d0
#define CONV_milen_ly	1.95760702624483d-13
#define CONV_milen_au	1.23798481057615d-08
#define CONV_milen_pc	6.00192526211534d-14
#define CONV_milen_ls	6.17773794914239d-06
#define CONV_milen_lm	1.02962299152373d-07
#define CONV_milen_bolt	50.6342957130359d0
#define CONV_leagn_km	5.556d0
#define CONV_leagn_m	5556d0
#define CONV_leagn_cm	555600d0
#define CONV_leagn_mm	5556000d0
#define CONV_leagn_um	5556000000d0
#define CONV_leagn_nm	5556000000000d0
#define CONV_leagn_pm	5.556d+15
#define CONV_leagn_micron	5556000000d0
#define CONV_leagn_mmicr	5556000000000d0
#define CONV_leagn_fermi	5.556d+18
#define CONV_leagn_a	55560000000000d0
#define CONV_leagn_a0	104993174209384d0
#define CONV_leagn_hand	54685.0393700787d0
#define CONV_leagn_ell	4860.89238845144d0
#define CONV_leagn_in	218740.157480315d0
#define CONV_leagn_ft	18228.3464566929d0
#define CONV_leagn_yd	6076.11548556431d0
#define CONV_leagn_mile	3.45233834407063d0
#define CONV_leagn_mileu	3.45233143938201d0
#define CONV_leagn_mil	218740157.480315d0
#define CONV_leagn_rod	1104.7482701026d0
#define CONV_leagn_fur	27.618706752565d0
#define CONV_leagn_chaing	276.18706752565d0
#define CONV_leagn_chainr	182.283464566929d0
#define CONV_leagn_leag	1.15077944802354d0
#define CONV_leagn_cable	25.3171478565179d0
#define CONV_leagn_calib	21874015.7480315d0
#define CONV_leagn_cubit	12152.2309711286d0
#define CONV_leagn_ftu	18228.3100000729d0
#define CONV_leagn_barley	656220.472440945d0
#define CONV_leagn_x	5.5447995049999d+16
#define CONV_leagn_span	24304.4619422572d0
#define CONV_leagn_nail	97217.8477690289d0
#define CONV_leagn_milen	3d0
#define CONV_leagn_fathom	3038.05774278215d0
#define CONV_leagn_degn	0.05d0
#define CONV_leagn_circn	0.000138888888888889d0
#define CONV_leagn_cablen	30d0
#define CONV_leagn_ly	5.87282107873449d-13
#define CONV_leagn_au	3.71395443172846d-08
#define CONV_leagn_pc	1.8005775786346d-13
#define CONV_leagn_ls	1.85332138474272d-05
#define CONV_leagn_lm	3.08886897457119d-07
#define CONV_leagn_bolt	151.902887139108d0
#define CONV_fathom_km	0.0018288d0
#define CONV_fathom_m	1.8288d0
#define CONV_fathom_cm	182.88d0
#define CONV_fathom_mm	1828.8d0
#define CONV_fathom_um	1828800d0
#define CONV_fathom_nm	1828800000d0
#define CONV_fathom_pm	1828800000000d0
#define CONV_fathom_micron	1828800d0
#define CONV_fathom_mmicr	1828800000d0
#define CONV_fathom_fermi	1.8288d+15
#define CONV_fathom_a	18288000000d0
#define CONV_fathom_a0	34559308314.2769d0
#define CONV_fathom_hand	18d0
#define CONV_fathom_ell	1.6d0
#define CONV_fathom_in	72d0
#define CONV_fathom_ft	6d0
#define CONV_fathom_yd	2d0
#define CONV_fathom_mile	0.00113636363636364d0
#define CONV_fathom_mileu	0.00113636136363244d0
#define CONV_fathom_mil	72000d0
#define CONV_fathom_rod	0.363636363636364d0
#define CONV_fathom_fur	0.00909090909090909d0
#define CONV_fathom_chaing	0.0909090909090909d0
#define CONV_fathom_chainr	0.06d0
#define CONV_fathom_leag	0.000378787878787879d0
#define CONV_fathom_cable	0.00833333333333333d0
#define CONV_fathom_calib	7200d0
#define CONV_fathom_cubit	4d0
#define CONV_fathom_ftu	5.999988000024d0
#define CONV_fathom_barley	216d0
#define CONV_fathom_x	18251132711921.9d0
#define CONV_fathom_span	8d0
#define CONV_fathom_nail	32d0
#define CONV_fathom_milen	0.000987473002159827d0
#define CONV_fathom_leagn	0.000329157667386609d0
#define CONV_fathom_degn	1.64578833693305d-05
#define CONV_fathom_circn	4.57163426925846d-08
#define CONV_fathom_cablen	0.00987473002159827d0
#define CONV_fathom_ly	1.93308408725515d-16
#define CONV_fathom_au	1.2224765775279d-11
#define CONV_fathom_pc	5.92673915731994d-17
#define CONV_fathom_ls	6.10034943919633d-09
#define CONV_fathom_lm	1.01672490653272d-10
#define CONV_fathom_bolt	0.05d0
#define CONV_degn_km	111.12d0
#define CONV_degn_m	111120d0
#define CONV_degn_cm	11112000d0
#define CONV_degn_mm	111120000d0
#define CONV_degn_um	111120000000d0
#define CONV_degn_nm	111120000000000d0
#define CONV_degn_pm	1.1112d+17
#define CONV_degn_micron	111120000000d0
#define CONV_degn_mmicr	111120000000000d0
#define CONV_degn_fermi	1.1112d+20
#define CONV_degn_a	1.1112d+15
#define CONV_degn_a0	2.09986348418769d+15
#define CONV_degn_hand	1093700.78740157d0
#define CONV_degn_ell	97217.8477690289d0
#define CONV_degn_in	4374803.1496063d0
#define CONV_degn_ft	364566.929133858d0
#define CONV_degn_yd	121522.309711286d0
#define CONV_degn_mile	69.0467668814126d0
#define CONV_degn_mileu	69.0466287876401d0
#define CONV_degn_mil	4374803149.6063d0
#define CONV_degn_rod	22094.965402052d0
#define CONV_degn_fur	552.3741350513d0
#define CONV_degn_chaing	5523.741350513d0
#define CONV_degn_chainr	3645.66929133858d0
#define CONV_degn_leag	23.0155889604709d0
#define CONV_degn_cable	506.342957130359d0
#define CONV_degn_calib	437480314.96063d0
#define CONV_degn_cubit	243044.619422572d0
#define CONV_degn_ftu	364566.200001458d0
#define CONV_degn_barley	13124409.4488189d0
#define CONV_degn_x	1.10895990099998d+18
#define CONV_degn_span	486089.238845144d0
#define CONV_degn_nail	1944356.95538058d0
#define CONV_degn_milen	60d0
#define CONV_degn_leagn	20d0
#define CONV_degn_fathom	60761.154855643d0
#define CONV_degn_circn	0.00277777777777778d0
#define CONV_degn_cablen	600d0
#define CONV_degn_ly	1.1745642157469d-11
#define CONV_degn_au	7.42790886345691d-07
#define CONV_degn_pc	3.6011551572692d-12
#define CONV_degn_ls	0.000370664276948543d0
#define CONV_degn_lm	6.17773794914239d-06
#define CONV_degn_bolt	3038.05774278215d0
#define CONV_circn_km	40003.2d0
#define CONV_circn_m	40003200d0
#define CONV_circn_cm	4000320000d0
#define CONV_circn_mm	40003200000d0
#define CONV_circn_um	40003200000000d0
#define CONV_circn_nm	4.00032d+16
#define CONV_circn_pm	4.00032d+19
#define CONV_circn_micron	40003200000000d0
#define CONV_circn_mmicr	4.00032d+16
#define CONV_circn_fermi	4.00032d+22
#define CONV_circn_a	4.00032d+17
#define CONV_circn_a0	7.55950854307568d+17
#define CONV_circn_hand	393732283.464567d0
#define CONV_circn_ell	34998425.1968504d0
#define CONV_circn_in	1574929133.85827d0
#define CONV_circn_ft	131244094.488189d0
#define CONV_circn_yd	43748031.496063d0
#define CONV_circn_mile	24856.8360773085d0
#define CONV_circn_mileu	24856.7863635505d0
#define CONV_circn_mil	1574929133858.27d0
#define CONV_circn_rod	7954187.54473873d0
#define CONV_circn_fur	198854.688618468d0
#define CONV_circn_chaing	1988546.88618468d0
#define CONV_circn_chainr	1312440.94488189d0
#define CONV_circn_leag	8285.61202576951d0
#define CONV_circn_cable	182283.464566929d0
#define CONV_circn_calib	157492913385.827d0
#define CONV_circn_cubit	87496062.992126d0
#define CONV_circn_ftu	131243832.000525d0
#define CONV_circn_barley	4724787401.5748d0
#define CONV_circn_x	3.99225564359993d+20
#define CONV_circn_span	174992125.984252d0
#define CONV_circn_nail	699968503.937008d0
#define CONV_circn_milen	21600d0
#define CONV_circn_leagn	7200d0
#define CONV_circn_fathom	21874015.7480315d0
#define CONV_circn_degn	360d0
#define CONV_circn_cablen	216000d0
#define CONV_circn_ly	4.22843117668883d-09
#define CONV_circn_au	0.000267404719084449d0
#define CONV_circn_pc	1.29641585661691d-09
#define CONV_circn_ls	0.133439139701476d0
#define CONV_circn_lm	0.00222398566169126d0
#define CONV_circn_bolt	1093700.78740157d0
#define CONV_cablen_km	0.1852d0
#define CONV_cablen_m	185.2d0
#define CONV_cablen_cm	18520d0
#define CONV_cablen_mm	185200d0
#define CONV_cablen_um	185200000d0
#define CONV_cablen_nm	185200000000d0
#define CONV_cablen_pm	185200000000000d0
#define CONV_cablen_micron	185200000d0
#define CONV_cablen_mmicr	185200000000d0
#define CONV_cablen_fermi	1.852d+17
#define CONV_cablen_a	1852000000000d0
#define CONV_cablen_a0	3499772473646.15d0
#define CONV_cablen_hand	1822.83464566929d0
#define CONV_cablen_ell	162.029746281715d0
#define CONV_cablen_in	7291.33858267717d0
#define CONV_cablen_ft	607.61154855643d0
#define CONV_cablen_yd	202.537182852144d0
#define CONV_cablen_mile	0.115077944802354d0
#define CONV_cablen_mileu	0.115077714646067d0
#define CONV_cablen_mil	7291338.58267717d0
#define CONV_cablen_rod	36.8249423367534d0
#define CONV_cablen_fur	0.920623558418834d0
#define CONV_cablen_chaing	9.20623558418834d0
#define CONV_cablen_chainr	6.0761154855643d0
#define CONV_cablen_leag	0.0383593149341181d0
#define CONV_cablen_cable	0.843904928550598d0
#define CONV_cablen_calib	729133.858267717d0
#define CONV_cablen_cubit	405.074365704287d0
#define CONV_cablen_ftu	607.610333335764d0
#define CONV_cablen_barley	21874.0157480315d0
#define CONV_cablen_x	1.84826650166663d+15
#define CONV_cablen_span	810.148731408574d0
#define CONV_cablen_nail	3240.5949256343d0
#define CONV_cablen_milen	0.1d0
#define CONV_cablen_leagn	0.0333333333333333d0
#define CONV_cablen_fathom	101.268591426072d0
#define CONV_cablen_degn	0.00166666666666667d0
#define CONV_cablen_circn	4.62962962962963d-06
#define CONV_cablen_ly	1.95760702624483d-14
#define CONV_cablen_au	1.23798481057615d-09
#define CONV_cablen_pc	6.00192526211534d-15
#define CONV_cablen_ls	6.17773794914239d-07
#define CONV_cablen_lm	1.02962299152373d-08
#define CONV_cablen_bolt	5.06342957130359d0
#define CONV_ly_km	9460530000000d0
#define CONV_ly_m	9.46053d+15
#define CONV_ly_cm	9.46053d+17
#define CONV_ly_mm	9.46053d+18
#define CONV_ly_um	9.46053d+21
#define CONV_ly_nm	9.46053d+24
#define CONV_ly_pm	9.46053d+27
#define CONV_ly_micron	9.46053d+21
#define CONV_ly_mmicr	9.46053d+24
#define CONV_ly_fermi	9.46053d+30
#define CONV_ly_a	9.46053d+25
#define CONV_ly_a0	1.78778091145268d+26
#define CONV_ly_hand	9.31154527559055d+16
#define CONV_ly_ell	8.27692913385827d+15
#define CONV_ly_in	3.72461811023622d+17
#define CONV_ly_ft	3.10384842519685d+16
#define CONV_ly_yd	1.03461614173228d+16
#define CONV_ly_mile	5878500805297.06d0
#define CONV_ly_mileu	5878489048275.14d0
#define CONV_ly_mil	3.72461811023622d+20
#define CONV_ly_rod	1.88112025769506d+15
#define CONV_ly_fur	47028006442376.5d0
#define CONV_ly_chaing	470280064423765d0
#define CONV_ly_chainr	310384842519685d0
#define CONV_ly_leag	1959500268432.35d0
#define CONV_ly_cable	43109005905511.8d0
#define CONV_ly_calib	3.72461811023622d+19
#define CONV_ly_cubit	2.06923228346457d+16
#define CONV_ly_ftu	3.10384221751242d+16
#define CONV_ly_barley	1.11738543307087d+18
#define CONV_ly_x	9.44145825432626d+28
#define CONV_ly_span	4.13846456692913d+16
#define CONV_ly_nail	1.65538582677165d+17
#define CONV_ly_milen	5108277537796.98d0
#define CONV_ly_leagn	1702759179265.66d0
#define CONV_ly_fathom	5.17308070866142d+15
#define CONV_ly_degn	85137958963.2829d0
#define CONV_ly_circn	236494330.453564d0
#define CONV_ly_cablen	51082775377969.8d0
#define CONV_ly_au	63239.7d0
#define CONV_ly_pc	0.306595d0
#define CONV_ly_ls	31557600d0
#define CONV_ly_lm	525960d0
#define CONV_ly_bolt	258654035433071d0
#define CONV_au_km	149597958.244584d0
#define CONV_au_m	149597958244.584d0
#define CONV_au_cm	14959795824458.4d0
#define CONV_au_mm	149597958244584d0
#define CONV_au_um	1.49597958244584d+17
#define CONV_au_nm	1.49597958244584d+20
#define CONV_au_pm	1.49597958244584d+23
#define CONV_au_micron	1.49597958244584d+17
#define CONV_au_mmicr	1.49597958244584d+20
#define CONV_au_fermi	1.49597958244584d+26
#define CONV_au_a	1.49597958244584d+21
#define CONV_au_a0	2.82699144912559d+21
#define CONV_au_hand	1472420848864.01d0
#define CONV_au_ell	130881853232.357d0
#define CONV_au_in	5889683395456.05d0
#define CONV_au_ft	490806949621.338d0
#define CONV_au_yd	163602316540.446d0
#define CONV_au_mile	92955861.6707079d0
#define CONV_au_mileu	92955675.7586633d0
#define CONV_au_mil	5.88968339545605d+15
#define CONV_au_rod	29745875734.6265d0
#define CONV_au_fur	743646893.365663d0
#define CONV_au_chaing	7436468933.65663d0
#define CONV_au_chainr	4908069496.21338d0
#define CONV_au_leag	30985287.2235693d0
#define CONV_au_cable	681676318.918525d0
#define CONV_au_calib	588968339545605d0
#define CONV_au_cubit	327204633080.892d0
#define CONV_au_ftu	490805968009.402d0
#define CONV_au_barley	17669050186368.2d0
#define CONV_au_x	1.49296379557877d+24
#define CONV_au_span	654409266161.783d0
#define CONV_au_nail	2617637064647.13d0
#define CONV_au_milen	80776435.3372482d0
#define CONV_au_leagn	26925478.4457494d0
#define CONV_au_fathom	81801158270.2229d0
#define CONV_au_degn	1346273.92228747d0
#define CONV_au_circn	3739.64978413186d0
#define CONV_au_cablen	807764353.372482d0
#define CONV_au_ly	1.58128517371208d-05
#define CONV_au_pc	4.84814127834256d-06
#define CONV_au_ls	499.015649979364d0
#define CONV_au_lm	8.31692749965607d0
#define CONV_au_bolt	4090057913.51115d0
#define CONV_pc_km	30856765439749.5d0
#define CONV_pc_m	3.08567654397495d+16
#define CONV_pc_cm	3.08567654397495d+18
#define CONV_pc_mm	3.08567654397495d+19
#define CONV_pc_um	3.08567654397495d+22
#define CONV_pc_nm	3.08567654397495d+25
#define CONV_pc_pm	3.08567654397495d+28
#define CONV_pc_micron	3.08567654397495d+22
#define CONV_pc_mmicr	3.08567654397495d+25
#define CONV_pc_fermi	3.08567654397495d+31
#define CONV_pc_a	3.08567654397495d+26
#define CONV_pc_a0	5.83108306219174d+26
#define CONV_pc_hand	3.03708321257377d+17
#define CONV_pc_ell	2.6996295222878d+16
#define CONV_pc_in	1.21483328502951d+18
#define CONV_pc_ft	1.01236107085792d+17
#define CONV_pc_yd	3.37453690285974d+16
#define CONV_pc_mile	19173505129884.9d0
#define CONV_pc_mileu	19173466782808.4d0
#define CONV_pc_mil	1.21483328502951d+21
#define CONV_pc_rod	6.13552164156317d+15
#define CONV_pc_fur	153388041039079d0
#define CONV_pc_chaing	1.53388041039079d+15
#define CONV_pc_chainr	1.01236107085792d+15
#define CONV_pc_leag	6391168376628.3d0
#define CONV_pc_cable	140605704285823d0
#define CONV_pc_calib	1.21483328502951d+20
#define CONV_pc_cubit	6.74907380571949d+16
#define CONV_pc_ftu	1.01235904613983d+17
#define CONV_pc_barley	3.64449985508852d+18
#define CONV_pc_x	3.07945604276856d+29
#define CONV_pc_span	1.3498147611439d+17
#define CONV_pc_nail	5.39925904457559d+17
#define CONV_pc_milen	16661320431830.2d0
#define CONV_pc_leagn	5553773477276.73d0
#define CONV_pc_fathom	1.68726845142987d+16
#define CONV_pc_degn	277688673863.836d0
#define CONV_pc_circn	771357427.399546d0
#define CONV_pc_cablen	166613204318302d0
#define CONV_pc_ly	3.26163179438673d0
#define CONV_pc_au	206264.616187479d0
#define CONV_pc_ls	102929271.514539d0
#define CONV_pc_lm	1715487.85857565d0
#define CONV_pc_bolt	843634225714936d0
#define CONV_ls_km	299786.105407255d0
#define CONV_ls_m	299786105.407255d0
#define CONV_ls_cm	29978610540.7255d0
#define CONV_ls_mm	299786105407.255d0
#define CONV_ls_um	299786105407255d0
#define CONV_ls_nm	2.99786105407255d+17
#define CONV_ls_pm	2.99786105407255d+20
#define CONV_ls_micron	299786105407255d0
#define CONV_ls_mmicr	2.99786105407255d+17
#define CONV_ls_fermi	2.99786105407255d+23
#define CONV_ls_a	2.99786105407255d+18
#define CONV_ls_a0	5.66513585143571d+18
#define CONV_ls_hand	2950650643.7722d0
#define CONV_ls_ell	262280057.224195d0
#define CONV_ls_in	11802602575.0888d0
#define CONV_ls_ft	983550214.590732d0
#define CONV_ls_yd	327850071.530244d0
#define CONV_ls_mile	186278.449733093d0
#define CONV_ls_mileu	186278.07717555d0
#define CONV_ls_mil	11802602575088.8d0
#define CONV_ls_rod	59609103.9145898d0
#define CONV_ls_fur	1490227.59786475d0
#define CONV_ls_chaing	14902275.9786475d0
#define CONV_ls_chainr	9835502.14590732d0
#define CONV_ls_leag	62092.8165776978d0
#define CONV_ls_cable	1366041.96470935d0
#define CONV_ls_calib	1180260257508.88d0
#define CONV_ls_cubit	655700143.060488d0
#define CONV_ls_ftu	983548247.494237d0
#define CONV_ls_barley	35407807725.2664d0
#define CONV_ls_x	2.99181758255579d+21
#define CONV_ls_span	1311400286.12098d0
#define CONV_ls_nail	5245601144.48391d0
#define CONV_ls_milen	161871.547196142d0
#define CONV_ls_leagn	53957.182398714d0
#define CONV_ls_fathom	163925035.765122d0
#define CONV_ls_degn	2697.8591199357d0
#define CONV_ls_circn	7.49405311093251d0
#define CONV_ls_cablen	1618715.47196142d0
#define CONV_ls_ly	3.16880878140289d-08
#define CONV_ls_au	0.00200394516693285d0
#define CONV_ls_pc	9.7154092833422d-09
#define CONV_ls_lm	0.0166666666666667d0
#define CONV_ls_bolt	8196251.7882561d0
#define CONV_lm_km	17987166.3244353d0
#define CONV_lm_m	17987166324.4353d0
#define CONV_lm_cm	1798716632443.53d0
#define CONV_lm_mm	17987166324435.3d0
#define CONV_lm_um	1.79871663244353d+16
#define CONV_lm_nm	1.79871663244353d+19
#define CONV_lm_pm	1.79871663244353d+22
#define CONV_lm_micron	1.79871663244353d+16
#define CONV_lm_mmicr	1.79871663244353d+19
#define CONV_lm_fermi	1.79871663244353d+25
#define CONV_lm_a	1.79871663244353d+20
#define CONV_lm_a0	3.39908151086143d+20
#define CONV_lm_hand	177039038626.332d0
#define CONV_lm_ell	15736803433.4517d0
#define CONV_lm_in	708156154505.327d0
#define CONV_lm_ft	59013012875.4439d0
#define CONV_lm_yd	19671004291.8146d0
#define CONV_lm_mile	11176706.9839856d0
#define CONV_lm_mileu	11176684.630533d0
#define CONV_lm_mil	708156154505327d0
#define CONV_lm_rod	3576546234.87539d0
#define CONV_lm_fur	89413655.8718848d0
#define CONV_lm_chaing	894136558.718848d0
#define CONV_lm_chainr	590130128.754439d0
#define CONV_lm_leag	3725568.99466187d0
#define CONV_lm_cable	81962517.882561d0
#define CONV_lm_calib	70815615450532.7d0
#define CONV_lm_cubit	39342008583.6293d0
#define CONV_lm_ftu	59012894849.6542d0
#define CONV_lm_barley	2124468463515.98d0
#define CONV_lm_x	1.79509054953347d+23
#define CONV_lm_span	78684017167.2586d0
#define CONV_lm_nail	314736068669.034d0
#define CONV_lm_milen	9712292.83176853d0
#define CONV_lm_leagn	3237430.94392284d0
#define CONV_lm_fathom	9835502145.90732d0
#define CONV_lm_degn	161871.547196142d0
#define CONV_lm_circn	449.64318665595d0
#define CONV_lm_cablen	97122928.3176853d0
#define CONV_lm_ly	1.90128526884174d-06
#define CONV_lm_au	0.120236710015971d0
#define CONV_lm_pc	5.82924557000532d-07
#define CONV_lm_ls	60d0
#define CONV_lm_bolt	491775107.295366d0
#define CONV_bolt_km	0.036576d0
#define CONV_bolt_m	36.576d0
#define CONV_bolt_cm	3657.6d0
#define CONV_bolt_mm	36576d0
#define CONV_bolt_um	36576000d0
#define CONV_bolt_nm	36576000000d0
#define CONV_bolt_pm	36576000000000d0
#define CONV_bolt_micron	36576000d0
#define CONV_bolt_mmicr	36576000000d0
#define CONV_bolt_fermi	3.6576d+16
#define CONV_bolt_a	365760000000d0
#define CONV_bolt_a0	691186166285.537d0
#define CONV_bolt_hand	360d0
#define CONV_bolt_ell	32d0
#define CONV_bolt_in	1440d0
#define CONV_bolt_ft	120d0
#define CONV_bolt_yd	40d0
#define CONV_bolt_mile	0.0227272727272727d0
#define CONV_bolt_mileu	0.0227272272726487d0
#define CONV_bolt_mil	1440000d0
#define CONV_bolt_rod	7.27272727272727d0
#define CONV_bolt_fur	0.181818181818182d0
#define CONV_bolt_chaing	1.81818181818182d0
#define CONV_bolt_chainr	1.2d0
#define CONV_bolt_leag	0.00757575757575758d0
#define CONV_bolt_cable	0.166666666666667d0
#define CONV_bolt_calib	144000d0
#define CONV_bolt_cubit	80d0
#define CONV_bolt_ftu	119.99976000048d0
#define CONV_bolt_barley	4320d0
#define CONV_bolt_x	365022654238438d0
#define CONV_bolt_span	160d0
#define CONV_bolt_nail	640d0
#define CONV_bolt_milen	0.0197494600431965d0
#define CONV_bolt_leagn	0.00658315334773218d0
#define CONV_bolt_fathom	20d0
#define CONV_bolt_degn	0.000329157667386609d0
#define CONV_bolt_circn	9.14326853851692d-07
#define CONV_bolt_cablen	0.197494600431965d0
#define CONV_bolt_ly	3.86616817451031d-15
#define CONV_bolt_au	2.44495315505579d-10
#define CONV_bolt_pc	1.18534783146399d-15
#define CONV_bolt_ls	1.22006988783927d-07
#define CONV_bolt_lm	2.03344981306544d-09



c MASS (kg)
c ====================
c 
c METRIC
c g      = gram
c kg     = kilogram (SI unit of mass)
c ktonm  = kiloton (metric)
c tonne  = tonne
c tonm   = ton (metric)
c 100wtm = hundredweight (metric)
c caratm = carat (metric)
c ng     = nanogram
c pg     = picogram
c mg     = milligram
c ug     = microgram
c 
c ATOMIC
c amu    = atomic mass units
c 
c AVOIRDUPOIS (US)
c 100wt  = hundredweight (short)
c 100wtl = hundredweight (long)
c cental = cental
c dram   = dram (solid)
c geelb  = geepound
c lb     = pound
c oz     = ounce (avoirdupois)
c slug   = slug
c stone  = stone
c ton    = ton (short)
c tonl   = ton (long)
c 
c TROY
c ozt    = ounce (Troy or apothecary)
c penny  = pennyweight
c scruple= scruple
c grain  = grain
c lbt    = pound (Troy)
c dramt  = dram (Troy or apothecary)



#define CONV_g_kg	0.001d0
#define CONV_g_ktonm	1d-09
#define CONV_g_tonne	1d-06
#define CONV_g_tonm	1d-06
#define CONV_g_100wtm	1d-05
#define CONV_g_caratm	5d0
#define CONV_g_ng	1000000000d0
#define CONV_g_pg	1000000000000d0
#define CONV_g_mg	1000d0
#define CONV_g_ug	1000000d0
#define CONV_g_amu	6.02213665167516d+23
#define CONV_g_100wt	2.2046226d-05
#define CONV_g_100wtl	1.96841303571429d-05
#define CONV_g_cental	2.2046226d-05
#define CONV_g_dram	0.5643833856d0
#define CONV_g_geelb	6.85218685895444d-05
#define CONV_g_lb	0.0022046226d0
#define CONV_g_oz	0.0352739616d0
#define CONV_g_slug	6.85218685895444d-05
#define CONV_g_stone	0.000157473042857143d0
#define CONV_g_ton	1.1023113d-06
#define CONV_g_tonl	9.84206517857143d-07
#define CONV_g_ozt	0.03215074625d0
#define CONV_g_penny	0.643014925d0
#define CONV_g_scruple	0.77161791d0
#define CONV_g_grain	15.4323582d0
#define CONV_g_lbt	0.00267922885416667d0
#define CONV_g_dramt	0.25720597d0
#define CONV_kg_g	1000d0
#define CONV_kg_ktonm	1d-06
#define CONV_kg_tonne	0.001d0
#define CONV_kg_tonm	0.001d0
#define CONV_kg_100wtm	0.01d0
#define CONV_kg_caratm	5000d0
#define CONV_kg_ng	1000000000000d0
#define CONV_kg_pg	1d+15
#define CONV_kg_mg	1000000d0
#define CONV_kg_ug	1000000000d0
#define CONV_kg_amu	6.02213665167516d+26
#define CONV_kg_100wt	0.022046226d0
#define CONV_kg_100wtl	0.0196841303571429d0
#define CONV_kg_cental	0.022046226d0
#define CONV_kg_dram	564.3833856d0
#define CONV_kg_geelb	0.0685218685895444d0
#define CONV_kg_lb	2.2046226d0
#define CONV_kg_oz	35.2739616d0
#define CONV_kg_slug	0.0685218685895444d0
#define CONV_kg_stone	0.157473042857143d0
#define CONV_kg_ton	0.0011023113d0
#define CONV_kg_tonl	0.000984206517857143d0
#define CONV_kg_ozt	32.15074625d0
#define CONV_kg_penny	643.014925d0
#define CONV_kg_scruple	771.61791d0
#define CONV_kg_grain	15432.3582d0
#define CONV_kg_lbt	2.67922885416667d0
#define CONV_kg_dramt	257.20597d0
#define CONV_ktonm_g	1000000000d0
#define CONV_ktonm_kg	1000000d0
#define CONV_ktonm_tonne	1000d0
#define CONV_ktonm_tonm	1000d0
#define CONV_ktonm_100wtm	10000d0
#define CONV_ktonm_caratm	5000000000d0
#define CONV_ktonm_ng	1d+18
#define CONV_ktonm_pg	1d+21
#define CONV_ktonm_mg	1000000000000d0
#define CONV_ktonm_ug	1d+15
#define CONV_ktonm_amu	6.02213665167516d+32
#define CONV_ktonm_100wt	22046.226d0
#define CONV_ktonm_100wtl	19684.1303571429d0
#define CONV_ktonm_cental	22046.226d0
#define CONV_ktonm_dram	564383385.6d0
#define CONV_ktonm_geelb	68521.8685895443d0
#define CONV_ktonm_lb	2204622.6d0
#define CONV_ktonm_oz	35273961.6d0
#define CONV_ktonm_slug	68521.8685895443d0
#define CONV_ktonm_stone	157473.042857143d0
#define CONV_ktonm_ton	1102.3113d0
#define CONV_ktonm_tonl	984.206517857143d0
#define CONV_ktonm_ozt	32150746.25d0
#define CONV_ktonm_penny	643014925d0
#define CONV_ktonm_scruple	771617910d0
#define CONV_ktonm_grain	15432358200d0
#define CONV_ktonm_lbt	2679228.85416667d0
#define CONV_ktonm_dramt	257205970d0
#define CONV_tonne_g	1000000d0
#define CONV_tonne_kg	1000d0
#define CONV_tonne_ktonm	0.001d0
#define CONV_tonne_tonm	1d0
#define CONV_tonne_100wtm	10d0
#define CONV_tonne_caratm	5000000d0
#define CONV_tonne_ng	1d+15
#define CONV_tonne_pg	1d+18
#define CONV_tonne_mg	1000000000d0
#define CONV_tonne_ug	1000000000000d0
#define CONV_tonne_amu	6.02213665167516d+29
#define CONV_tonne_100wt	22.046226d0
#define CONV_tonne_100wtl	19.6841303571429d0
#define CONV_tonne_cental	22.046226d0
#define CONV_tonne_dram	564383.3856d0
#define CONV_tonne_geelb	68.5218685895444d0
#define CONV_tonne_lb	2204.6226d0
#define CONV_tonne_oz	35273.9616d0
#define CONV_tonne_slug	68.5218685895444d0
#define CONV_tonne_stone	157.473042857143d0
#define CONV_tonne_ton	1.1023113d0
#define CONV_tonne_tonl	0.984206517857143d0
#define CONV_tonne_ozt	32150.74625d0
#define CONV_tonne_penny	643014.925d0
#define CONV_tonne_scruple	771617.91d0
#define CONV_tonne_grain	15432358.2d0
#define CONV_tonne_lbt	2679.22885416667d0
#define CONV_tonne_dramt	257205.97d0
#define CONV_tonm_g	1000000d0
#define CONV_tonm_kg	1000d0
#define CONV_tonm_ktonm	0.001d0
#define CONV_tonm_tonne	1d0
#define CONV_tonm_100wtm	10d0
#define CONV_tonm_caratm	5000000d0
#define CONV_tonm_ng	1d+15
#define CONV_tonm_pg	1d+18
#define CONV_tonm_mg	1000000000d0
#define CONV_tonm_ug	1000000000000d0
#define CONV_tonm_amu	6.02213665167516d+29
#define CONV_tonm_100wt	22.046226d0
#define CONV_tonm_100wtl	19.6841303571429d0
#define CONV_tonm_cental	22.046226d0
#define CONV_tonm_dram	564383.3856d0
#define CONV_tonm_geelb	68.5218685895444d0
#define CONV_tonm_lb	2204.6226d0
#define CONV_tonm_oz	35273.9616d0
#define CONV_tonm_slug	68.5218685895444d0
#define CONV_tonm_stone	157.473042857143d0
#define CONV_tonm_ton	1.1023113d0
#define CONV_tonm_tonl	0.984206517857143d0
#define CONV_tonm_ozt	32150.74625d0
#define CONV_tonm_penny	643014.925d0
#define CONV_tonm_scruple	771617.91d0
#define CONV_tonm_grain	15432358.2d0
#define CONV_tonm_lbt	2679.22885416667d0
#define CONV_tonm_dramt	257205.97d0
#define CONV_100wtm_g	100000d0
#define CONV_100wtm_kg	100d0
#define CONV_100wtm_ktonm	0.0001d0
#define CONV_100wtm_tonne	0.1d0
#define CONV_100wtm_tonm	0.1d0
#define CONV_100wtm_caratm	500000d0
#define CONV_100wtm_ng	100000000000000d0
#define CONV_100wtm_pg	1d+17
#define CONV_100wtm_mg	100000000d0
#define CONV_100wtm_ug	100000000000d0
#define CONV_100wtm_amu	6.02213665167516d+28
#define CONV_100wtm_100wt	2.2046226d0
#define CONV_100wtm_100wtl	1.96841303571429d0
#define CONV_100wtm_cental	2.2046226d0
#define CONV_100wtm_dram	56438.33856d0
#define CONV_100wtm_geelb	6.85218685895444d0
#define CONV_100wtm_lb	220.46226d0
#define CONV_100wtm_oz	3527.39616d0
#define CONV_100wtm_slug	6.85218685895444d0
#define CONV_100wtm_stone	15.7473042857143d0
#define CONV_100wtm_ton	0.11023113d0
#define CONV_100wtm_tonl	0.0984206517857143d0
#define CONV_100wtm_ozt	3215.074625d0
#define CONV_100wtm_penny	64301.4925d0
#define CONV_100wtm_scruple	77161.791d0
#define CONV_100wtm_grain	1543235.82d0
#define CONV_100wtm_lbt	267.922885416667d0
#define CONV_100wtm_dramt	25720.597d0
#define CONV_caratm_g	0.2d0
#define CONV_caratm_kg	0.0002d0
#define CONV_caratm_ktonm	2d-10
#define CONV_caratm_tonne	2d-07
#define CONV_caratm_tonm	2d-07
#define CONV_caratm_100wtm	2d-06
#define CONV_caratm_ng	200000000d0
#define CONV_caratm_pg	200000000000d0
#define CONV_caratm_mg	200d0
#define CONV_caratm_ug	200000d0
#define CONV_caratm_amu	1.20442733033503d+23
#define CONV_caratm_100wt	4.4092452d-06
#define CONV_caratm_100wtl	3.93682607142857d-06
#define CONV_caratm_cental	4.4092452d-06
#define CONV_caratm_dram	0.11287667712d0
#define CONV_caratm_geelb	1.37043737179089d-05
#define CONV_caratm_lb	0.00044092452d0
#define CONV_caratm_oz	0.00705479232d0
#define CONV_caratm_slug	1.37043737179089d-05
#define CONV_caratm_stone	3.14946085714286d-05
#define CONV_caratm_ton	2.2046226d-07
#define CONV_caratm_tonl	1.96841303571429d-07
#define CONV_caratm_ozt	0.00643014925d0
#define CONV_caratm_penny	0.128602985d0
#define CONV_caratm_scruple	0.154323582d0
#define CONV_caratm_grain	3.08647164d0
#define CONV_caratm_lbt	0.000535845770833333d0
#define CONV_caratm_dramt	0.051441194d0
#define CONV_ng_g	1d-09
#define CONV_ng_kg	1d-12
#define CONV_ng_ktonm	1d-18
#define CONV_ng_tonne	1d-15
#define CONV_ng_tonm	1d-15
#define CONV_ng_100wtm	1d-14
#define CONV_ng_caratm	5d-09
#define CONV_ng_pg	1000d0
#define CONV_ng_mg	1d-06
#define CONV_ng_ug	0.001d0
#define CONV_ng_amu	602213665167516d0
#define CONV_ng_100wt	2.2046226d-14
#define CONV_ng_100wtl	1.96841303571429d-14
#define CONV_ng_cental	2.2046226d-14
#define CONV_ng_dram	5.643833856d-10
#define CONV_ng_geelb	6.85218685895444d-14
#define CONV_ng_lb	2.2046226d-12
#define CONV_ng_oz	3.52739616d-11
#define CONV_ng_slug	6.85218685895444d-14
#define CONV_ng_stone	1.57473042857143d-13
#define CONV_ng_ton	1.1023113d-15
#define CONV_ng_tonl	9.84206517857143d-16
#define CONV_ng_ozt	3.215074625d-11
#define CONV_ng_penny	6.43014925d-10
#define CONV_ng_scruple	7.7161791d-10
#define CONV_ng_grain	1.54323582d-08
#define CONV_ng_lbt	2.67922885416667d-12
#define CONV_ng_dramt	2.5720597d-10
#define CONV_pg_g	1d-12
#define CONV_pg_kg	1d-15
#define CONV_pg_ktonm	1d-21
#define CONV_pg_tonne	1d-18
#define CONV_pg_tonm	1d-18
#define CONV_pg_100wtm	1d-17
#define CONV_pg_caratm	5d-12
#define CONV_pg_ng	0.001d0
#define CONV_pg_mg	1d-09
#define CONV_pg_ug	1d-06
#define CONV_pg_amu	602213665167.516d0
#define CONV_pg_100wt	2.2046226d-17
#define CONV_pg_100wtl	1.96841303571429d-17
#define CONV_pg_cental	2.2046226d-17
#define CONV_pg_dram	5.643833856d-13
#define CONV_pg_geelb	6.85218685895444d-17
#define CONV_pg_lb	2.2046226d-15
#define CONV_pg_oz	3.52739616d-14
#define CONV_pg_slug	6.85218685895444d-17
#define CONV_pg_stone	1.57473042857143d-16
#define CONV_pg_ton	1.1023113d-18
#define CONV_pg_tonl	9.84206517857143d-19
#define CONV_pg_ozt	3.215074625d-14
#define CONV_pg_penny	6.43014925d-13
#define CONV_pg_scruple	7.7161791d-13
#define CONV_pg_grain	1.54323582d-11
#define CONV_pg_lbt	2.67922885416667d-15
#define CONV_pg_dramt	2.5720597d-13
#define CONV_mg_g	0.001d0
#define CONV_mg_kg	1d-06
#define CONV_mg_ktonm	1d-12
#define CONV_mg_tonne	1d-09
#define CONV_mg_tonm	1d-09
#define CONV_mg_100wtm	1d-08
#define CONV_mg_caratm	0.005d0
#define CONV_mg_ng	1000000d0
#define CONV_mg_pg	1000000000d0
#define CONV_mg_ug	1000d0
#define CONV_mg_amu	6.02213665167516d+20
#define CONV_mg_100wt	2.2046226d-08
#define CONV_mg_100wtl	1.96841303571429d-08
#define CONV_mg_cental	2.2046226d-08
#define CONV_mg_dram	0.0005643833856d0
#define CONV_mg_geelb	6.85218685895444d-08
#define CONV_mg_lb	2.2046226d-06
#define CONV_mg_oz	3.52739616d-05
#define CONV_mg_slug	6.85218685895444d-08
#define CONV_mg_stone	1.57473042857143d-07
#define CONV_mg_ton	1.1023113d-09
#define CONV_mg_tonl	9.84206517857143d-10
#define CONV_mg_ozt	3.215074625d-05
#define CONV_mg_penny	0.000643014925d0
#define CONV_mg_scruple	0.00077161791d0
#define CONV_mg_grain	0.0154323582d0
#define CONV_mg_lbt	2.67922885416667d-06
#define CONV_mg_dramt	0.00025720597d0
#define CONV_ug_g	1d-06
#define CONV_ug_kg	1d-09
#define CONV_ug_ktonm	1d-15
#define CONV_ug_tonne	1d-12
#define CONV_ug_tonm	1d-12
#define CONV_ug_100wtm	1d-11
#define CONV_ug_caratm	5d-06
#define CONV_ug_ng	1000d0
#define CONV_ug_pg	1000000d0
#define CONV_ug_mg	0.001d0
#define CONV_ug_amu	6.02213665167516d+17
#define CONV_ug_100wt	2.2046226d-11
#define CONV_ug_100wtl	1.96841303571429d-11
#define CONV_ug_cental	2.2046226d-11
#define CONV_ug_dram	5.643833856d-07
#define CONV_ug_geelb	6.85218685895443d-11
#define CONV_ug_lb	2.2046226d-09
#define CONV_ug_oz	3.52739616d-08
#define CONV_ug_slug	6.85218685895443d-11
#define CONV_ug_stone	1.57473042857143d-10
#define CONV_ug_ton	1.1023113d-12
#define CONV_ug_tonl	9.84206517857143d-13
#define CONV_ug_ozt	3.215074625d-08
#define CONV_ug_penny	6.43014925d-07
#define CONV_ug_scruple	7.7161791d-07
#define CONV_ug_grain	1.54323582d-05
#define CONV_ug_lbt	2.67922885416667d-09
#define CONV_ug_dramt	2.5720597d-07
#define CONV_amu_g	1.6605402d-24
#define CONV_amu_kg	1.6605402d-27
#define CONV_amu_ktonm	1.6605402d-33
#define CONV_amu_tonne	1.6605402d-30
#define CONV_amu_tonm	1.6605402d-30
#define CONV_amu_100wtm	1.6605402d-29
#define CONV_amu_caratm	8.302701d-24
#define CONV_amu_ng	1.6605402d-15
#define CONV_amu_pg	1.6605402d-12
#define CONV_amu_mg	1.6605402d-21
#define CONV_amu_ug	1.6605402d-18
#define CONV_amu_100wt	3.66086445312852d-29
#define CONV_amu_100wtl	3.26862897600761d-29
#define CONV_amu_cental	3.66086445312852d-29
#define CONV_amu_dram	9.37181300000901d-25
#define CONV_amu_geelb	1.13783317372056d-28
#define CONV_amu_lb	3.66086445312852d-27
#define CONV_amu_oz	5.85738312500563d-26
#define CONV_amu_slug	1.13783317372056d-28
#define CONV_amu_stone	2.61490318080609d-28
#define CONV_amu_ton	1.83043222656426d-30
#define CONV_amu_tonl	1.6343144880038d-30
#define CONV_amu_ozt	5.33876066081242d-26
#define CONV_amu_penny	1.06775213216248d-24
#define CONV_amu_scruple	1.28130255859498d-24
#define CONV_amu_grain	2.56260511718996d-23
#define CONV_amu_lbt	4.44896721734369d-27
#define CONV_amu_dramt	4.27100852864994d-25
#define CONV_100wt_g	45359.2374495299d0
#define CONV_100wt_kg	45.3592374495299d0
#define CONV_100wt_ktonm	4.53592374495299d-05
#define CONV_100wt_tonne	0.0453592374495299d0
#define CONV_100wt_tonm	0.0453592374495299d0
#define CONV_100wt_100wtm	0.453592374495299d0
#define CONV_100wt_caratm	226796.187247649d0
#define CONV_100wt_ng	45359237449529.9d0
#define CONV_100wt_pg	4.53592374495299d+16
#define CONV_100wt_mg	45359237.4495299d0
#define CONV_100wt_ug	45359237449.5299d0
#define CONV_100wt_amu	2.73159526336851d+28
#define CONV_100wt_100wtl	0.892857142857143d0
#define CONV_100wt_cental	1d0
#define CONV_100wt_dram	25600d0
#define CONV_100wt_geelb	3.10809970783863d0
#define CONV_100wt_lb	100d0
#define CONV_100wt_oz	1600d0
#define CONV_100wt_slug	3.10809970783863d0
#define CONV_100wt_stone	7.14285714285714d0
#define CONV_100wt_ton	0.05d0
#define CONV_100wt_tonl	0.0446428571428571d0
#define CONV_100wt_ozt	1458.33333333333d0
#define CONV_100wt_penny	29166.6666666667d0
#define CONV_100wt_scruple	35000d0
#define CONV_100wt_grain	700000d0
#define CONV_100wt_lbt	121.527777777778d0
#define CONV_100wt_dramt	11666.6666666667d0
#define CONV_100wtl_g	50802.3459434735d0
#define CONV_100wtl_kg	50.8023459434735d0
#define CONV_100wtl_ktonm	5.08023459434735d-05
#define CONV_100wtl_tonne	0.0508023459434735d0
#define CONV_100wtl_tonm	0.0508023459434735d0
#define CONV_100wtl_100wtm	0.508023459434735d0
#define CONV_100wtl_caratm	254011.729717368d0
#define CONV_100wtl_ng	50802345943473.5d0
#define CONV_100wtl_pg	5.08023459434735d+16
#define CONV_100wtl_mg	50802345.9434735d0
#define CONV_100wtl_ug	50802345943.4735d0
#define CONV_100wtl_amu	3.05938669497273d+28
#define CONV_100wtl_100wt	1.12d0
#define CONV_100wtl_cental	1.12d0
#define CONV_100wtl_dram	28672d0
#define CONV_100wtl_geelb	3.48107167277926d0
#define CONV_100wtl_lb	112d0
#define CONV_100wtl_oz	1792d0
#define CONV_100wtl_slug	3.48107167277926d0
#define CONV_100wtl_stone	8d0
#define CONV_100wtl_ton	0.056d0
#define CONV_100wtl_tonl	0.05d0
#define CONV_100wtl_ozt	1633.33333333333d0
#define CONV_100wtl_penny	32666.6666666667d0
#define CONV_100wtl_scruple	39200d0
#define CONV_100wtl_grain	784000d0
#define CONV_100wtl_lbt	136.111111111111d0
#define CONV_100wtl_dramt	13066.6666666667d0
#define CONV_cental_g	45359.2374495299d0
#define CONV_cental_kg	45.3592374495299d0
#define CONV_cental_ktonm	4.53592374495299d-05
#define CONV_cental_tonne	0.0453592374495299d0
#define CONV_cental_tonm	0.0453592374495299d0
#define CONV_cental_100wtm	0.453592374495299d0
#define CONV_cental_caratm	226796.18724765d0
#define CONV_cental_ng	45359237449529.9d0
#define CONV_cental_pg	4.53592374495299d+16
#define CONV_cental_mg	45359237.4495299d0
#define CONV_cental_ug	45359237449.5299d0
#define CONV_cental_amu	2.73159526336851d+28
#define CONV_cental_100wt	1d0
#define CONV_cental_100wtl	0.892857142857143d0
#define CONV_cental_dram	25600d0
#define CONV_cental_geelb	3.10809970783863d0
#define CONV_cental_lb	100d0
#define CONV_cental_oz	1600d0
#define CONV_cental_slug	3.10809970783863d0
#define CONV_cental_stone	7.14285714285714d0
#define CONV_cental_ton	0.05d0
#define CONV_cental_tonl	0.0446428571428571d0
#define CONV_cental_ozt	1458.33333333333d0
#define CONV_cental_penny	29166.6666666667d0
#define CONV_cental_scruple	35000d0
#define CONV_cental_grain	700000d0
#define CONV_cental_lbt	121.527777777778d0
#define CONV_cental_dramt	11666.6666666667d0
#define CONV_dram_g	1.77184521287226d0
#define CONV_dram_kg	0.00177184521287226d0
#define CONV_dram_ktonm	1.77184521287226d-09
#define CONV_dram_tonne	1.77184521287226d-06
#define CONV_dram_tonm	1.77184521287226d-06
#define CONV_dram_100wtm	1.77184521287226d-05
#define CONV_dram_caratm	8.85922606436131d0
#define CONV_dram_ng	1771845212.87226d0
#define CONV_dram_pg	1771845212872.26d0
#define CONV_dram_mg	1771.84521287226d0
#define CONV_dram_ug	1771845.21287226d0
#define CONV_dram_amu	1.06702939975332d+24
#define CONV_dram_100wt	3.90625d-05
#define CONV_dram_100wtl	3.48772321428571d-05
#define CONV_dram_cental	3.90625d-05
#define CONV_dram_geelb	0.000121410144837446d0
#define CONV_dram_lb	0.00390625d0
#define CONV_dram_oz	0.0625d0
#define CONV_dram_slug	0.000121410144837446d0
#define CONV_dram_stone	0.000279017857142857d0
#define CONV_dram_ton	1.953125d-06
#define CONV_dram_tonl	1.74386160714286d-06
#define CONV_dram_ozt	0.0569661458333333d0
#define CONV_dram_penny	1.13932291666667d0
#define CONV_dram_scruple	1.3671875d0
#define CONV_dram_grain	27.34375d0
#define CONV_dram_lbt	0.00474717881944444d0
#define CONV_dram_dramt	0.455729166666667d0
#define CONV_geelb_g	14593.8810570118d0
#define CONV_geelb_kg	14.5938810570118d0
#define CONV_geelb_ktonm	1.45938810570118d-05
#define CONV_geelb_tonne	0.0145938810570118d0
#define CONV_geelb_tonm	0.0145938810570118d0
#define CONV_geelb_100wtm	0.145938810570118d0
#define CONV_geelb_caratm	72969.4052850588d0
#define CONV_geelb_ng	14593881057011.8d0
#define CONV_geelb_pg	1.45938810570118d+16
#define CONV_geelb_mg	14593881.0570118d0
#define CONV_geelb_ug	14593881057.0118d0
#define CONV_geelb_amu	8.78863460036183d+27
#define CONV_geelb_100wt	0.32174d0
#define CONV_geelb_100wtl	0.287267857142857d0
#define CONV_geelb_cental	0.32174d0
#define CONV_geelb_dram	8236.544d0
#define CONV_geelb_lb	32.174d0
#define CONV_geelb_oz	514.784d0
#define CONV_geelb_slug	1d0
#define CONV_geelb_stone	2.29814285714286d0
#define CONV_geelb_ton	0.016087d0
#define CONV_geelb_tonl	0.0143633928571429d0
#define CONV_geelb_ozt	469.204166666667d0
#define CONV_geelb_penny	9384.08333333333d0
#define CONV_geelb_scruple	11260.9d0
#define CONV_geelb_grain	225218d0
#define CONV_geelb_lbt	39.1003472222222d0
#define CONV_geelb_dramt	3753.63333333333d0
#define CONV_lb_g	453.592374495299d0
#define CONV_lb_kg	0.453592374495299d0
#define CONV_lb_ktonm	4.53592374495299d-07
#define CONV_lb_tonne	0.000453592374495299d0
#define CONV_lb_tonm	0.000453592374495299d0
#define CONV_lb_100wtm	0.00453592374495299d0
#define CONV_lb_caratm	2267.9618724765d0
#define CONV_lb_ng	453592374495.299d0
#define CONV_lb_pg	453592374495299d0
#define CONV_lb_mg	453592.374495299d0
#define CONV_lb_ug	453592374.495299d0
#define CONV_lb_amu	2.73159526336851d+26
#define CONV_lb_100wt	0.01d0
#define CONV_lb_100wtl	0.00892857142857143d0
#define CONV_lb_cental	0.01d0
#define CONV_lb_dram	256d0
#define CONV_lb_geelb	0.0310809970783863d0
#define CONV_lb_oz	16d0
#define CONV_lb_slug	0.0310809970783863d0
#define CONV_lb_stone	0.0714285714285714d0
#define CONV_lb_ton	0.0005d0
#define CONV_lb_tonl	0.000446428571428571d0
#define CONV_lb_ozt	14.5833333333333d0
#define CONV_lb_penny	291.666666666667d0
#define CONV_lb_scruple	350d0
#define CONV_lb_grain	7000d0
#define CONV_lb_lbt	1.21527777777778d0
#define CONV_lb_dramt	116.666666666667d0
#define CONV_oz_g	28.3495234059562d0
#define CONV_oz_kg	0.0283495234059562d0
#define CONV_oz_ktonm	2.83495234059562d-08
#define CONV_oz_tonne	2.83495234059562d-05
#define CONV_oz_tonm	2.83495234059562d-05
#define CONV_oz_100wtm	0.000283495234059562d0
#define CONV_oz_caratm	141.747617029781d0
#define CONV_oz_ng	28349523405.9562d0
#define CONV_oz_pg	28349523405956.2d0
#define CONV_oz_mg	28349.5234059562d0
#define CONV_oz_ug	28349523.4059562d0
#define CONV_oz_amu	1.70724703960532d+25
#define CONV_oz_100wt	0.000625d0
#define CONV_oz_100wtl	0.000558035714285714d0
#define CONV_oz_cental	0.000625d0
#define CONV_oz_dram	16d0
#define CONV_oz_geelb	0.00194256231739914d0
#define CONV_oz_lb	0.0625d0
#define CONV_oz_slug	0.00194256231739914d0
#define CONV_oz_stone	0.00446428571428571d0
#define CONV_oz_ton	3.125d-05
#define CONV_oz_tonl	2.79017857142857d-05
#define CONV_oz_ozt	0.911458333333333d0
#define CONV_oz_penny	18.2291666666667d0
#define CONV_oz_scruple	21.875d0
#define CONV_oz_grain	437.5d0
#define CONV_oz_lbt	0.0759548611111111d0
#define CONV_oz_dramt	7.29166666666667d0
#define CONV_slug_g	14593.8810570118d0
#define CONV_slug_kg	14.5938810570118d0
#define CONV_slug_ktonm	1.45938810570118d-05
#define CONV_slug_tonne	0.0145938810570118d0
#define CONV_slug_tonm	0.0145938810570118d0
#define CONV_slug_100wtm	0.145938810570118d0
#define CONV_slug_caratm	72969.4052850588d0
#define CONV_slug_ng	14593881057011.8d0
#define CONV_slug_pg	1.45938810570118d+16
#define CONV_slug_mg	14593881.0570118d0
#define CONV_slug_ug	14593881057.0118d0
#define CONV_slug_amu	8.78863460036183d+27
#define CONV_slug_100wt	0.32174d0
#define CONV_slug_100wtl	0.287267857142857d0
#define CONV_slug_cental	0.32174d0
#define CONV_slug_dram	8236.544d0
#define CONV_slug_geelb	1d0
#define CONV_slug_lb	32.174d0
#define CONV_slug_oz	514.784d0
#define CONV_slug_stone	2.29814285714286d0
#define CONV_slug_ton	0.016087d0
#define CONV_slug_tonl	0.0143633928571429d0
#define CONV_slug_ozt	469.204166666667d0
#define CONV_slug_penny	9384.08333333333d0
#define CONV_slug_scruple	11260.9d0
#define CONV_slug_grain	225218d0
#define CONV_slug_lbt	39.1003472222222d0
#define CONV_slug_dramt	3753.63333333333d0
#define CONV_stone_g	6350.29324293419d0
#define CONV_stone_kg	6.35029324293419d0
#define CONV_stone_ktonm	6.35029324293419d-06
#define CONV_stone_tonne	0.00635029324293419d0
#define CONV_stone_tonm	0.00635029324293419d0
#define CONV_stone_100wtm	0.0635029324293419d0
#define CONV_stone_caratm	31751.4662146709d0
#define CONV_stone_ng	6350293242934.19d0
#define CONV_stone_pg	6.35029324293419d+15
#define CONV_stone_mg	6350293.24293419d0
#define CONV_stone_ug	6350293242.93419d0
#define CONV_stone_amu	3.82423336871591d+27
#define CONV_stone_100wt	0.14d0
#define CONV_stone_100wtl	0.125d0
#define CONV_stone_cental	0.14d0
#define CONV_stone_dram	3584d0
#define CONV_stone_geelb	0.435133959097408d0
#define CONV_stone_lb	14d0
#define CONV_stone_oz	224d0
#define CONV_stone_slug	0.435133959097408d0
#define CONV_stone_ton	0.007d0
#define CONV_stone_tonl	0.00625d0
#define CONV_stone_ozt	204.166666666667d0
#define CONV_stone_penny	4083.33333333333d0
#define CONV_stone_scruple	4900d0
#define CONV_stone_grain	98000d0
#define CONV_stone_lbt	17.0138888888889d0
#define CONV_stone_dramt	1633.33333333333d0
#define CONV_ton_g	907184.748990598d0
#define CONV_ton_kg	907.184748990598d0
#define CONV_ton_ktonm	0.000907184748990598d0
#define CONV_ton_tonne	0.907184748990598d0
#define CONV_ton_tonm	0.907184748990598d0
#define CONV_ton_100wtm	9.07184748990598d0
#define CONV_ton_caratm	4535923.74495299d0
#define CONV_ton_ng	907184748990598d0
#define CONV_ton_pg	9.07184748990598d+17
#define CONV_ton_mg	907184748.990598d0
#define CONV_ton_ug	907184748990.598d0
#define CONV_ton_amu	5.46319052673701d+29
#define CONV_ton_100wt	20d0
#define CONV_ton_100wtl	17.8571428571429d0
#define CONV_ton_cental	20d0
#define CONV_ton_dram	512000d0
#define CONV_ton_geelb	62.1619941567726d0
#define CONV_ton_lb	2000d0
#define CONV_ton_oz	32000d0
#define CONV_ton_slug	62.1619941567726d0
#define CONV_ton_stone	142.857142857143d0
#define CONV_ton_tonl	0.892857142857143d0
#define CONV_ton_ozt	29166.6666666667d0
#define CONV_ton_penny	583333.333333333d0
#define CONV_ton_scruple	700000d0
#define CONV_ton_grain	14000000d0
#define CONV_ton_lbt	2430.55555555556d0
#define CONV_ton_dramt	233333.333333333d0
#define CONV_tonl_g	1016046.91886947d0
#define CONV_tonl_kg	1016.04691886947d0
#define CONV_tonl_ktonm	0.00101604691886947d0
#define CONV_tonl_tonne	1.01604691886947d0
#define CONV_tonl_tonm	1.01604691886947d0
#define CONV_tonl_100wtm	10.1604691886947d0
#define CONV_tonl_caratm	5080234.59434735d0
#define CONV_tonl_ng	1.01604691886947d+15
#define CONV_tonl_pg	1.01604691886947d+18
#define CONV_tonl_mg	1016046918.86947d0
#define CONV_tonl_ug	1016046918869.47d0
#define CONV_tonl_amu	6.11877338994545d+29
#define CONV_tonl_100wt	22.4d0
#define CONV_tonl_100wtl	20d0
#define CONV_tonl_cental	22.4d0
#define CONV_tonl_dram	573440d0
#define CONV_tonl_geelb	69.6214334555853d0
#define CONV_tonl_lb	2240d0
#define CONV_tonl_oz	35840d0
#define CONV_tonl_slug	69.6214334555853d0
#define CONV_tonl_stone	160d0
#define CONV_tonl_ton	1.12d0
#define CONV_tonl_ozt	32666.6666666667d0
#define CONV_tonl_penny	653333.333333333d0
#define CONV_tonl_scruple	784000d0
#define CONV_tonl_grain	15680000d0
#define CONV_tonl_lbt	2722.22222222222d0
#define CONV_tonl_dramt	261333.333333333d0
#define CONV_ozt_g	31.1034771082491d0
#define CONV_ozt_kg	0.0311034771082491d0
#define CONV_ozt_ktonm	3.11034771082491d-08
#define CONV_ozt_tonne	3.11034771082491d-05
#define CONV_ozt_tonm	3.11034771082491d-05
#define CONV_ozt_100wtm	0.000311034771082491d0
#define CONV_ozt_caratm	155.517385541245d0
#define CONV_ozt_ng	31103477108.2491d0
#define CONV_ozt_pg	31103477108249.1d0
#define CONV_ozt_mg	31103.4771082491d0
#define CONV_ozt_ug	31103477.1082491d0
#define CONV_ozt_amu	1.87309389488126d+25
#define CONV_ozt_100wt	0.000685714285714286d0
#define CONV_ozt_100wtl	0.000612244897959184d0
#define CONV_ozt_cental	0.000685714285714286d0
#define CONV_ozt_dram	17.5542857142857d0
#define CONV_ozt_geelb	0.00213126837108934d0
#define CONV_ozt_lb	0.0685714285714286d0
#define CONV_ozt_oz	1.09714285714286d0
#define CONV_ozt_slug	0.00213126837108934d0
#define CONV_ozt_stone	0.00489795918367347d0
#define CONV_ozt_ton	3.42857142857143d-05
#define CONV_ozt_tonl	3.06122448979592d-05
#define CONV_ozt_penny	20d0
#define CONV_ozt_scruple	24d0
#define CONV_ozt_grain	480d0
#define CONV_ozt_lbt	0.0833333333333333d0
#define CONV_ozt_dramt	8d0
#define CONV_penny_g	1.55517385541245d0
#define CONV_penny_kg	0.00155517385541245d0
#define CONV_penny_ktonm	1.55517385541245d-09
#define CONV_penny_tonne	1.55517385541245d-06
#define CONV_penny_tonm	1.55517385541245d-06
#define CONV_penny_100wtm	1.55517385541245d-05
#define CONV_penny_caratm	7.77586927706227d0
#define CONV_penny_ng	1555173855.41245d0
#define CONV_penny_pg	1555173855412.45d0
#define CONV_penny_mg	1555.17385541245d0
#define CONV_penny_ug	1555173.85541245d0
#define CONV_penny_amu	9.36546947440631d+23
#define CONV_penny_100wt	3.42857142857143d-05
#define CONV_penny_100wtl	3.06122448979592d-05
#define CONV_penny_cental	3.42857142857143d-05
#define CONV_penny_dram	0.877714285714286d0
#define CONV_penny_geelb	0.000106563418554467d0
#define CONV_penny_lb	0.00342857142857143d0
#define CONV_penny_oz	0.0548571428571429d0
#define CONV_penny_slug	0.000106563418554467d0
#define CONV_penny_stone	0.000244897959183673d0
#define CONV_penny_ton	1.71428571428571d-06
#define CONV_penny_tonl	1.53061224489796d-06
#define CONV_penny_ozt	0.05d0
#define CONV_penny_scruple	1.2d0
#define CONV_penny_grain	24d0
#define CONV_penny_lbt	0.00416666666666667d0
#define CONV_penny_dramt	0.4d0
#define CONV_scruple_g	1.29597821284371d0
#define CONV_scruple_kg	0.00129597821284371d0
#define CONV_scruple_ktonm	1.29597821284371d-09
#define CONV_scruple_tonne	1.29597821284371d-06
#define CONV_scruple_tonm	1.29597821284371d-06
#define CONV_scruple_100wtm	1.29597821284371d-05
#define CONV_scruple_caratm	6.47989106421856d0
#define CONV_scruple_ng	1295978212.84371d0
#define CONV_scruple_pg	1295978212843.71d0
#define CONV_scruple_mg	1295.97821284371d0
#define CONV_scruple_ug	1295978.21284371d0
#define CONV_scruple_amu	7.80455789533859d+23
#define CONV_scruple_100wt	2.85714285714286d-05
#define CONV_scruple_100wtl	2.55102040816326d-05
#define CONV_scruple_cental	2.85714285714286d-05
#define CONV_scruple_dram	0.731428571428571d0
#define CONV_scruple_geelb	8.88028487953894d-05
#define CONV_scruple_lb	0.00285714285714286d0
#define CONV_scruple_oz	0.0457142857142857d0
#define CONV_scruple_slug	8.88028487953894d-05
#define CONV_scruple_stone	0.000204081632653061d0
#define CONV_scruple_ton	1.42857142857143d-06
#define CONV_scruple_tonl	1.27551020408163d-06
#define CONV_scruple_ozt	0.0416666666666667d0
#define CONV_scruple_penny	0.833333333333333d0
#define CONV_scruple_grain	20d0
#define CONV_scruple_lbt	0.00347222222222222d0
#define CONV_scruple_dramt	0.333333333333333d0
#define CONV_grain_g	0.0647989106421856d0
#define CONV_grain_kg	6.47989106421856d-05
#define CONV_grain_ktonm	6.47989106421856d-11
#define CONV_grain_tonne	6.47989106421856d-08
#define CONV_grain_tonm	6.47989106421856d-08
#define CONV_grain_100wtm	6.47989106421856d-07
#define CONV_grain_caratm	0.323994553210928d0
#define CONV_grain_ng	64798910.6421856d0
#define CONV_grain_pg	64798910642.1856d0
#define CONV_grain_mg	64.7989106421856d0
#define CONV_grain_ug	64798.9106421856d0
#define CONV_grain_amu	3.90227894766929d+22
#define CONV_grain_100wt	1.42857142857143d-06
#define CONV_grain_100wtl	1.27551020408163d-06
#define CONV_grain_cental	1.42857142857143d-06
#define CONV_grain_dram	0.0365714285714286d0
#define CONV_grain_geelb	4.44014243976947d-06
#define CONV_grain_lb	0.000142857142857143d0
#define CONV_grain_oz	0.00228571428571429d0
#define CONV_grain_slug	4.44014243976947d-06
#define CONV_grain_stone	1.02040816326531d-05
#define CONV_grain_ton	7.14285714285714d-08
#define CONV_grain_tonl	6.37755102040816d-08
#define CONV_grain_ozt	0.00208333333333333d0
#define CONV_grain_penny	0.0416666666666667d0
#define CONV_grain_scruple	0.05d0
#define CONV_grain_lbt	0.000173611111111111d0
#define CONV_grain_dramt	0.0166666666666667d0
#define CONV_lbt_g	373.241725298989d0
#define CONV_lbt_kg	0.373241725298989d0
#define CONV_lbt_ktonm	3.73241725298989d-07
#define CONV_lbt_tonne	0.000373241725298989d0
#define CONV_lbt_tonm	0.000373241725298989d0
#define CONV_lbt_100wtm	0.00373241725298989d0
#define CONV_lbt_caratm	1866.20862649494d0
#define CONV_lbt_ng	373241725298.989d0
#define CONV_lbt_pg	373241725298989d0
#define CONV_lbt_mg	373241.725298989d0
#define CONV_lbt_ug	373241725.298989d0
#define CONV_lbt_amu	2.24771267385751d+26
#define CONV_lbt_100wt	0.00822857142857143d0
#define CONV_lbt_100wtl	0.0073469387755102d0
#define CONV_lbt_cental	0.00822857142857143d0
#define CONV_lbt_dram	210.651428571429d0
#define CONV_lbt_geelb	0.0255752204530721d0
#define CONV_lbt_lb	0.822857142857143d0
#define CONV_lbt_oz	13.1657142857143d0
#define CONV_lbt_slug	0.0255752204530721d0
#define CONV_lbt_stone	0.0587755102040816d0
#define CONV_lbt_ton	0.000411428571428571d0
#define CONV_lbt_tonl	0.00036734693877551d0
#define CONV_lbt_ozt	12d0
#define CONV_lbt_penny	240d0
#define CONV_lbt_scruple	288d0
#define CONV_lbt_grain	5760d0
#define CONV_lbt_dramt	96d0
#define CONV_dramt_g	3.88793463853114d0
#define CONV_dramt_kg	0.00388793463853114d0
#define CONV_dramt_ktonm	3.88793463853114d-09
#define CONV_dramt_tonne	3.88793463853114d-06
#define CONV_dramt_tonm	3.88793463853114d-06
#define CONV_dramt_100wtm	3.88793463853113d-05
#define CONV_dramt_caratm	19.4396731926557d0
#define CONV_dramt_ng	3887934638.53114d0
#define CONV_dramt_pg	3887934638531.13d0
#define CONV_dramt_mg	3887.93463853114d0
#define CONV_dramt_ug	3887934.63853113d0
#define CONV_dramt_amu	2.34136736860158d+24
#define CONV_dramt_100wt	8.57142857142857d-05
#define CONV_dramt_100wtl	7.65306122448979d-05
#define CONV_dramt_cental	8.57142857142857d-05
#define CONV_dramt_dram	2.19428571428571d0
#define CONV_dramt_geelb	0.000266408546386168d0
#define CONV_dramt_lb	0.00857142857142857d0
#define CONV_dramt_oz	0.137142857142857d0
#define CONV_dramt_slug	0.000266408546386168d0
#define CONV_dramt_stone	0.000612244897959184d0
#define CONV_dramt_ton	4.28571428571429d-06
#define CONV_dramt_tonl	3.8265306122449d-06
#define CONV_dramt_ozt	0.125d0
#define CONV_dramt_penny	2.5d0
#define CONV_dramt_scruple	3d0
#define CONV_dramt_grain	60d0
#define CONV_dramt_lbt	0.0104166666666667d0



c ELECTRIC CURRENT (A)
c ====================
c 
c abA    = abampere
c A      = ampere
c Aint   = ampere (international)
c Aus    = ampere (U.S.)
c biot   = biot
c gilb   = gilbert



#define CONV_abA_A	10d0
#define CONV_abA_Aint	10.0015002250338d0
#define CONV_abA_Aus	10.0016502722949d0
#define CONV_abA_biot	1d0
#define CONV_abA_gilb	12.5663708584854d0
#define CONV_A_abA	0.1d0
#define CONV_A_Aint	1.00015002250338d0
#define CONV_A_Aus	1.00016502722949d0
#define CONV_A_biot	0.1d0
#define CONV_A_gilb	1.25663708584854d0
#define CONV_Aint_abA	0.099985d0
#define CONV_Aint_A	0.99985d0
#define CONV_Aint_Aus	1.00001500247541d0
#define CONV_Aint_biot	0.099985d0
#define CONV_Aint_gilb	1.25644859028567d0
#define CONV_Aus_abA	0.0999835d0
#define CONV_Aus_A	0.999835d0
#define CONV_Aus_Aint	0.999984997749662d0
#define CONV_Aus_biot	0.0999835d0
#define CONV_Aus_gilb	1.25642974072938d0
#define CONV_biot_abA	1d0
#define CONV_biot_A	10d0
#define CONV_biot_Aint	10.0015002250338d0
#define CONV_biot_Aus	10.0016502722949d0
#define CONV_biot_gilb	12.5663708584854d0
#define CONV_gilb_abA	0.07957747d0
#define CONV_gilb_A	0.7957747d0
#define CONV_gilb_Aint	0.795894084112617d0
#define CONV_gilb_Aus	0.795906024494041d0
#define CONV_gilb_biot	0.07957747d0



c TEMPERATURE INTERVAL (K)
c ====================
c 
c degc   = celcius degree
c degf   = farenheit degree
c degr   = rankine degree
c K      = kelvin degree



#define CONV_degc_degf	1.8d0
#define CONV_degc_degr	1.8d0
#define CONV_degc_K	1d0
#define CONV_degf_degc	0.555555555555556d0
#define CONV_degf_degr	1d0
#define CONV_degf_K	0.555555555555556d0
#define CONV_degr_degc	0.555555555555556d0
#define CONV_degr_degf	1d0
#define CONV_degr_K	0.555555555555556d0
#define CONV_K_degc	1d0
#define CONV_K_degf	1.8d0
#define CONV_K_degr	1.8d0



c LUMINOUS INTENSITY
c ====================
c 
c cd     = candela
c hef    = hefner unit
c lumPsr = lumen per steradian



#define CONV_cd_hef	1.11d0
#define CONV_cd_lumPsr	1d0
#define CONV_hef_cd	0.900900900900901d0
#define CONV_hef_lumPsr	0.900900900900901d0
#define CONV_lumPsr_cd	1d0
#define CONV_lumPsr_hef	1.11d0



c ANGLES (rad)
c ====================
c 
c amin   = minutes of an angle
c as     = seconds of an angle
c circum = circumference
c deg    = degrees
c gon    = gon (grade)
c quad   = quadrant
c rad    = radians
c rev    = revolution



#define CONV_amin_as	60d0
#define CONV_amin_circum	4.62962962962963d-05
#define CONV_amin_deg	0.0166666666666667d0
#define CONV_amin_gon	0.0185185185185185d0
#define CONV_amin_quad	0.000185185185185185d0
#define CONV_amin_rad	0.000290888208665722d0
#define CONV_amin_rev	4.62962962962963d-05
#define CONV_as_amin	0.0166666666666667d0
#define CONV_as_circum	7.71604938271605d-07
#define CONV_as_deg	0.000277777777777778d0
#define CONV_as_gon	0.000308641975308642d0
#define CONV_as_quad	3.08641975308642d-06
#define CONV_as_rad	4.84813681109536d-06
#define CONV_as_rev	7.71604938271605d-07
#define CONV_circum_amin	21600d0
#define CONV_circum_as	1296000d0
#define CONV_circum_deg	360d0
#define CONV_circum_gon	400d0
#define CONV_circum_quad	4d0
#define CONV_circum_rad	6.28318530717959d0
#define CONV_circum_rev	1d0
#define CONV_deg_amin	60d0
#define CONV_deg_as	3600d0
#define CONV_deg_circum	0.00277777777777778d0
#define CONV_deg_gon	1.11111111111111d0
#define CONV_deg_quad	0.0111111111111111d0
#define CONV_deg_rad	0.0174532925199433d0
#define CONV_deg_rev	0.00277777777777778d0
#define CONV_gon_amin	54d0
#define CONV_gon_as	3240d0
#define CONV_gon_circum	0.0025d0
#define CONV_gon_deg	0.9d0
#define CONV_gon_quad	0.01d0
#define CONV_gon_rad	0.015707963267949d0
#define CONV_gon_rev	0.0025d0
#define CONV_quad_amin	5400d0
#define CONV_quad_as	324000d0
#define CONV_quad_circum	0.25d0
#define CONV_quad_deg	90d0
#define CONV_quad_gon	100d0
#define CONV_quad_rad	1.5707963267949d0
#define CONV_quad_rev	0.25d0
#define CONV_rad_amin	3437.74677078494d0
#define CONV_rad_as	206264.806247096d0
#define CONV_rad_circum	0.159154943091895d0
#define CONV_rad_deg	57.2957795130823d0
#define CONV_rad_gon	63.6619772367581d0
#define CONV_rad_quad	0.636619772367581d0
#define CONV_rad_rev	0.159154943091895d0
#define CONV_rev_amin	21600d0
#define CONV_rev_as	1296000d0
#define CONV_rev_circum	1d0
#define CONV_rev_deg	360d0
#define CONV_rev_gon	400d0
#define CONV_rev_quad	4d0
#define CONV_rev_rad	6.28318530717959d0



c SOLID ANGLES (sr)
c ====================
c 
c sphere = sphere
c sr     = steradians
c sqdeg  = square degree
c sphra  = spherical right angle



#define CONV_sphere_sr	12.5663706143592d0
#define CONV_sphere_sqdeg	41252.956851042d0
#define CONV_sphere_sphra	8d0
#define CONV_sr_sphere	0.0795774715459477d0
#define CONV_sr_sqdeg	3282.806d0
#define CONV_sr_sphra	0.636619772367581d0
#define CONV_sqdeg_sphere	2.42406866400109d-05
#define CONV_sqdeg_sr	0.000304617452264922d0
#define CONV_sqdeg_sphra	0.000193925493120087d0
#define CONV_sphra_sphere	0.125d0
#define CONV_sphra_sr	1.5707963267949d0
#define CONV_sphra_sqdeg	5156.61960638025d0



c AREA (m2)
c ====================
c 
c METRIC
c cm2    = square cm
c km2    = square kilometer
c m2     = square meter
c are    = are
c circmm = circular millimeter
c hect   = hectare
c mm2    = square millimeter
c barn   = barn
c 
c US
c acre   = acre
c ft2    = square ft
c in2    = square inch
c mile2  = square mile
c yd2    = square yd
c acreus = acre (US survey)
c chaig2 = square chain (Gunter's')
c chair2 = square chain (Ramsden's')
c chaiu2 = square chain (US survey)
c circin = circular inch
c circmil= circular mil
c ftu2   = square foot (US survey)
c linkg2 = square link (Gunter's')
c linkr2 = square link (Ramsden's')
c mil2   = square mil
c mileu2 = square mile (US survey)
c rod2   = square rod
c town   = township (US)
c darcy  = darcy



#define CONV_cm2_km2	1d-10
#define CONV_cm2_m2	0.0001d0
#define CONV_cm2_are	1d-06
#define CONV_cm2_circmm	127.324d0
#define CONV_cm2_hect	1d-08
#define CONV_cm2_mm2	100d0
#define CONV_cm2_barn	1d+24
#define CONV_cm2_acre	2.47105381467165d-08
#define CONV_cm2_ft2	0.00107639104167097d0
#define CONV_cm2_in2	0.15500031000062d0
#define CONV_cm2_mile2	3.86102158542446d-11
#define CONV_cm2_yd2	0.000119599004630108d0
#define CONV_cm2_acreus	2.4710439303895d-08
#define CONV_cm2_chaig2	2.47105381467165d-07
#define CONV_cm2_chair2	1.07639104167097d-07
#define CONV_cm2_chaiu2	2.4710439303895d-07
#define CONV_cm2_circin	0.1973525d0
#define CONV_cm2_circmil	197352.5d0
#define CONV_cm2_ftu2	0.00107638673163048d0
#define CONV_cm2_linkg2	0.00247105381467165d0
#define CONV_cm2_linkr2	0.00107639104167097d0
#define CONV_cm2_mil2	155000.31000062d0
#define CONV_cm2_mileu2	3.86100614182988d-11
#define CONV_cm2_rod2	3.95368610347464d-06
#define CONV_cm2_town	1.07250599595124d-12
#define CONV_cm2_darcy	101324996.582814d0
#define CONV_km2_cm2	10000000000d0
#define CONV_km2_m2	1000000d0
#define CONV_km2_are	10000d0
#define CONV_km2_circmm	1273240000000d0
#define CONV_km2_hect	100d0
#define CONV_km2_mm2	1000000000000d0
#define CONV_km2_barn	1d+34
#define CONV_km2_acre	247.105381467165d0
#define CONV_km2_ft2	10763910.4167097d0
#define CONV_km2_in2	1550003100.0062d0
#define CONV_km2_mile2	0.386102158542446d0
#define CONV_km2_yd2	1195990.04630108d0
#define CONV_km2_acreus	247.10439303895d0
#define CONV_km2_chaig2	2471.05381467165d0
#define CONV_km2_chair2	1076.39104167097d0
#define CONV_km2_chaiu2	2471.0439303895d0
#define CONV_km2_circin	1973525000d0
#define CONV_km2_circmil	1.973525d+15
#define CONV_km2_ftu2	10763867.3163048d0
#define CONV_km2_linkg2	24710538.1467165d0
#define CONV_km2_linkr2	10763910.4167097d0
#define CONV_km2_mil2	1.5500031000062d+15
#define CONV_km2_mileu2	0.386100614182988d0
#define CONV_km2_rod2	39536.8610347465d0
#define CONV_km2_town	0.0107250599595124d0
#define CONV_km2_darcy	1.01324996582815d+18
#define CONV_m2_cm2	10000d0
#define CONV_m2_km2	1d-06
#define CONV_m2_are	0.01d0
#define CONV_m2_circmm	1273240d0
#define CONV_m2_hect	0.0001d0
#define CONV_m2_mm2	1000000d0
#define CONV_m2_barn	1d+28
#define CONV_m2_acre	0.000247105381467165d0
#define CONV_m2_ft2	10.7639104167097d0
#define CONV_m2_in2	1550.0031000062d0
#define CONV_m2_mile2	3.86102158542446d-07
#define CONV_m2_yd2	1.19599004630108d0
#define CONV_m2_acreus	0.00024710439303895d0
#define CONV_m2_chaig2	0.00247105381467165d0
#define CONV_m2_chair2	0.00107639104167097d0
#define CONV_m2_chaiu2	0.0024710439303895d0
#define CONV_m2_circin	1973.525d0
#define CONV_m2_circmil	1973525000d0
#define CONV_m2_ftu2	10.7638673163048d0
#define CONV_m2_linkg2	24.7105381467165d0
#define CONV_m2_linkr2	10.7639104167097d0
#define CONV_m2_mil2	1550003100.0062d0
#define CONV_m2_mileu2	3.86100614182988d-07
#define CONV_m2_rod2	0.0395368610347464d0
#define CONV_m2_town	1.07250599595124d-08
#define CONV_m2_darcy	1013249965828.14d0
#define CONV_are_cm2	1000000d0
#define CONV_are_km2	0.0001d0
#define CONV_are_m2	100d0
#define CONV_are_circmm	127324000d0
#define CONV_are_hect	0.01d0
#define CONV_are_mm2	100000000d0
#define CONV_are_barn	1d+30
#define CONV_are_acre	0.0247105381467165d0
#define CONV_are_ft2	1076.39104167097d0
#define CONV_are_in2	155000.31000062d0
#define CONV_are_mile2	3.86102158542446d-05
#define CONV_are_yd2	119.599004630108d0
#define CONV_are_acreus	0.024710439303895d0
#define CONV_are_chaig2	0.247105381467165d0
#define CONV_are_chair2	0.107639104167097d0
#define CONV_are_chaiu2	0.24710439303895d0
#define CONV_are_circin	197352.5d0
#define CONV_are_circmil	197352500000d0
#define CONV_are_ftu2	1076.38673163048d0
#define CONV_are_linkg2	2471.05381467165d0
#define CONV_are_linkr2	1076.39104167097d0
#define CONV_are_mil2	155000310000.62d0
#define CONV_are_mileu2	3.86100614182988d-05
#define CONV_are_rod2	3.95368610347464d0
#define CONV_are_town	1.07250599595124d-06
#define CONV_are_darcy	101324996582814d0
#define CONV_circmm_cm2	0.00785397882567309d0
#define CONV_circmm_km2	7.85397882567309d-13
#define CONV_circmm_m2	7.85397882567309d-07
#define CONV_circmm_are	7.85397882567309d-09
#define CONV_circmm_hect	7.85397882567308d-11
#define CONV_circmm_mm2	0.785397882567309d0
#define CONV_circmm_barn	7.85397882567309d+21
#define CONV_circmm_acre	1.94076043375299d-10
#define CONV_circmm_ft2	8.45395244942801d-06
#define CONV_circmm_in2	0.00121736915271763d0
#define CONV_circmm_mile2	3.03243817773904d-13
#define CONV_circmm_yd2	9.39328049936445d-07
#define CONV_circmm_acreus	1.94075267065871d-10
#define CONV_circmm_chaig2	1.94076043375299d-09
#define CONV_circmm_chair2	8.45395244942801d-10
#define CONV_circmm_chaiu2	1.94075267065871d-09
#define CONV_circmm_circin	0.00155000235619365d0
#define CONV_circmm_circmil	1550.00235619365d0
#define CONV_circmm_ftu2	8.45391859846126d-06
#define CONV_circmm_linkg2	1.94076043375299d-05
#define CONV_circmm_linkr2	8.45395244942801d-06
#define CONV_circmm_mil2	1217.36915271763d0
#define CONV_circmm_mileu2	3.03242604837256d-13
#define CONV_circmm_rod2	3.10521669400478d-08
#define CONV_circmm_town	8.42343938260845d-15
#define CONV_circmm_darcy	795804.377672823d0
#define CONV_hect_cm2	100000000d0
#define CONV_hect_km2	0.01d0
#define CONV_hect_m2	10000d0
#define CONV_hect_are	100d0
#define CONV_hect_circmm	12732400000d0
#define CONV_hect_mm2	10000000000d0
#define CONV_hect_barn	1d+32
#define CONV_hect_acre	2.47105381467165d0
#define CONV_hect_ft2	107639.104167097d0
#define CONV_hect_in2	15500031.000062d0
#define CONV_hect_mile2	0.00386102158542446d0
#define CONV_hect_yd2	11959.9004630108d0
#define CONV_hect_acreus	2.4710439303895d0
#define CONV_hect_chaig2	24.7105381467165d0
#define CONV_hect_chair2	10.7639104167097d0
#define CONV_hect_chaiu2	24.710439303895d0
#define CONV_hect_circin	19735250d0
#define CONV_hect_circmil	19735250000000d0
#define CONV_hect_ftu2	107638.673163048d0
#define CONV_hect_linkg2	247105.381467165d0
#define CONV_hect_linkr2	107639.104167097d0
#define CONV_hect_mil2	15500031000062d0
#define CONV_hect_mileu2	0.00386100614182988d0
#define CONV_hect_rod2	395.368610347465d0
#define CONV_hect_town	0.000107250599595124d0
#define CONV_hect_darcy	1.01324996582815d+16
#define CONV_mm2_cm2	0.01d0
#define CONV_mm2_km2	1d-12
#define CONV_mm2_m2	1d-06
#define CONV_mm2_are	1d-08
#define CONV_mm2_circmm	1.27324d0
#define CONV_mm2_hect	1d-10
#define CONV_mm2_barn	1d+22
#define CONV_mm2_acre	2.47105381467165d-10
#define CONV_mm2_ft2	1.07639104167097d-05
#define CONV_mm2_in2	0.0015500031000062d0
#define CONV_mm2_mile2	3.86102158542446d-13
#define CONV_mm2_yd2	1.19599004630108d-06
#define CONV_mm2_acreus	2.4710439303895d-10
#define CONV_mm2_chaig2	2.47105381467165d-09
#define CONV_mm2_chair2	1.07639104167097d-09
#define CONV_mm2_chaiu2	2.4710439303895d-09
#define CONV_mm2_circin	0.001973525d0
#define CONV_mm2_circmil	1973.525d0
#define CONV_mm2_ftu2	1.07638673163048d-05
#define CONV_mm2_linkg2	2.47105381467165d-05
#define CONV_mm2_linkr2	1.07639104167097d-05
#define CONV_mm2_mil2	1550.0031000062d0
#define CONV_mm2_mileu2	3.86100614182988d-13
#define CONV_mm2_rod2	3.95368610347464d-08
#define CONV_mm2_town	1.07250599595124d-14
#define CONV_mm2_darcy	1013249.96582814d0
#define CONV_barn_cm2	1d-24
#define CONV_barn_km2	1d-34
#define CONV_barn_m2	1d-28
#define CONV_barn_are	1d-30
#define CONV_barn_circmm	1.27324d-22
#define CONV_barn_hect	1d-32
#define CONV_barn_mm2	1d-22
#define CONV_barn_acre	2.47105381467165d-32
#define CONV_barn_ft2	1.07639104167097d-27
#define CONV_barn_in2	1.5500031000062d-25
#define CONV_barn_mile2	3.86102158542446d-35
#define CONV_barn_yd2	1.19599004630108d-28
#define CONV_barn_acreus	2.4710439303895d-32
#define CONV_barn_chaig2	2.47105381467165d-31
#define CONV_barn_chair2	1.07639104167097d-31
#define CONV_barn_chaiu2	2.4710439303895d-31
#define CONV_barn_circin	1.973525d-25
#define CONV_barn_circmil	1.973525d-19
#define CONV_barn_ftu2	1.07638673163048d-27
#define CONV_barn_linkg2	2.47105381467165d-27
#define CONV_barn_linkr2	1.07639104167097d-27
#define CONV_barn_mil2	1.5500031000062d-19
#define CONV_barn_mileu2	3.86100614182988d-35
#define CONV_barn_rod2	3.95368610347464d-30
#define CONV_barn_town	1.07250599595124d-36
#define CONV_barn_darcy	1.01324996582814d-16
#define CONV_acre_cm2	40468564.224d0
#define CONV_acre_km2	0.0040468564224d0
#define CONV_acre_m2	4046.8564224d0
#define CONV_acre_are	40.468564224d0
#define CONV_acre_circmm	5152619471.25658d0
#define CONV_acre_hect	0.40468564224d0
#define CONV_acre_mm2	4046856422.4d0
#define CONV_acre_barn	4.0468564224d+31
#define CONV_acre_ft2	43560d0
#define CONV_acre_in2	6272640d0
#define CONV_acre_mile2	0.0015625d0
#define CONV_acre_yd2	4840d0
#define CONV_acre_acreus	0.999995999972928d0
#define CONV_acre_chaig2	10d0
#define CONV_acre_chair2	4.356d0
#define CONV_acre_chaiu2	9.99995999972928d0
#define CONV_acre_circin	7986572.32101696d0
#define CONV_acre_circmil	7986572321016.96d0
#define CONV_acre_ftu2	43559.8255788496d0
#define CONV_acre_linkg2	100000d0
#define CONV_acre_linkr2	43560d0
#define CONV_acre_mil2	6272640000000d0
#define CONV_acre_mileu2	0.00156249375019901d0
#define CONV_acre_rod2	160d0
#define CONV_acre_town	4.34027777777778d-05
#define CONV_acre_darcy	4.10047713170821d+15
#define CONV_ft2_cm2	929.0304d0
#define CONV_ft2_km2	9.290304d-08
#define CONV_ft2_m2	0.09290304d0
#define CONV_ft2_are	0.000929030400000001d0
#define CONV_ft2_circmm	118287.8666496d0
#define CONV_ft2_hect	9.290304d-06
#define CONV_ft2_mm2	92903.04d0
#define CONV_ft2_barn	9.290304d+26
#define CONV_ft2_acre	2.29568411386593d-05
#define CONV_ft2_in2	144d0
#define CONV_ft2_mile2	3.58700642791552d-08
#define CONV_ft2_yd2	0.111111111111111d0
#define CONV_ft2_acreus	2.29567493106733d-05
#define CONV_ft2_chaig2	0.000229568411386593d0
#define CONV_ft2_chair2	0.0001d0
#define CONV_ft2_chaiu2	0.000229567493106733d0
#define CONV_ft2_circin	183.346472016d0
#define CONV_ft2_circmil	183346472.016d0
#define CONV_ft2_ftu2	0.999995995841359d0
#define CONV_ft2_linkg2	2.29568411386593d0
#define CONV_ft2_linkr2	1d0
#define CONV_ft2_mil2	144000000d0
#define CONV_ft2_mileu2	3.58699208034667d-08
#define CONV_ft2_rod2	0.00367309458218549d0
#define CONV_ft2_town	9.96390674420977d-10
#define CONV_ft2_darcy	94134002105.3308d0
#define CONV_in2_cm2	6.4516d0
#define CONV_in2_km2	6.4516d-10
#define CONV_in2_m2	0.00064516d0
#define CONV_in2_are	6.4516d-06
#define CONV_in2_circmm	821.4435184d0
#define CONV_in2_hect	6.4516d-08
#define CONV_in2_mm2	645.16d0
#define CONV_in2_barn	6.4516d+24
#define CONV_in2_acre	1.59422507907356d-07
#define CONV_in2_ft2	0.00694444444444444d0
#define CONV_in2_mile2	2.49097668605244d-10
#define CONV_in2_yd2	0.000771604938271605d0
#define CONV_in2_acreus	1.59421870213009d-07
#define CONV_in2_chaig2	1.59422507907356d-06
#define CONV_in2_chair2	6.94444444444444d-07
#define CONV_in2_chaiu2	1.59421870213009d-06
#define CONV_in2_circin	1.273239389d0
#define CONV_in2_circmil	1273239.389d0
#define CONV_in2_ftu2	0.00694441663778721d0
#define CONV_in2_linkg2	0.0159422507907356d0
#define CONV_in2_linkr2	0.00694444444444444d0
#define CONV_in2_mil2	1000000d0
#define CONV_in2_mileu2	2.49096672246297d-10
#define CONV_in2_rod2	2.5507601265177d-05
#define CONV_in2_town	6.91937968347901d-12
#define CONV_in2_darcy	653708347.953686d0
#define CONV_mile2_cm2	25899881103.36d0
#define CONV_mile2_km2	2.589988110336d0
#define CONV_mile2_m2	2589988.110336d0
#define CONV_mile2_are	25899.88110336d0
#define CONV_mile2_circmm	3297676461604.21d0
#define CONV_mile2_hect	258.9988110336d0
#define CONV_mile2_mm2	2589988110336d0
#define CONV_mile2_barn	2.589988110336d+34
#define CONV_mile2_acre	640d0
#define CONV_mile2_ft2	27878400d0
#define CONV_mile2_in2	4014489600d0
#define CONV_mile2_yd2	3097600d0
#define CONV_mile2_acreus	639.997439982674d0
#define CONV_mile2_chaig2	6400d0
#define CONV_mile2_chair2	2787.84d0
#define CONV_mile2_chaiu2	6399.97439982674d0
#define CONV_mile2_circin	5111406285.45086d0
#define CONV_mile2_circmil	5.11140628545086d+15
#define CONV_mile2_ftu2	27878288.3704637d0
#define CONV_mile2_linkg2	64000000d0
#define CONV_mile2_linkr2	27878400d0
#define CONV_mile2_mil2	4.0144896d+15
#define CONV_mile2_mileu2	0.999996000127367d0
#define CONV_mile2_rod2	102400d0
#define CONV_mile2_town	0.0277777777777778d0
#define CONV_mile2_darcy	2.62430536429325d+18
#define CONV_yd2_cm2	8361.2736d0
#define CONV_yd2_km2	8.3612736d-07
#define CONV_yd2_m2	0.83612736d0
#define CONV_yd2_are	0.00836127360000001d0
#define CONV_yd2_circmm	1064590.7998464d0
#define CONV_yd2_hect	8.3612736d-05
#define CONV_yd2_mm2	836127.36d0
#define CONV_yd2_barn	8.3612736d+27
#define CONV_yd2_acre	0.000206611570247934d0
#define CONV_yd2_ft2	9d0
#define CONV_yd2_in2	1296d0
#define CONV_yd2_mile2	3.22830578512397d-07
#define CONV_yd2_acreus	0.000206610743796059d0
#define CONV_yd2_chaig2	0.00206611570247934d0
#define CONV_yd2_chair2	0.0009d0
#define CONV_yd2_chaiu2	0.00206610743796059d0
#define CONV_yd2_circin	1650.118248144d0
#define CONV_yd2_circmil	1650118248.144d0
#define CONV_yd2_ftu2	8.99996396257223d0
#define CONV_yd2_linkg2	20.6611570247934d0
#define CONV_yd2_linkr2	9d0
#define CONV_yd2_mil2	1296000000d0
#define CONV_yd2_mileu2	3.22829287231201d-07
#define CONV_yd2_rod2	0.0330578512396694d0
#define CONV_yd2_town	8.9675160697888d-09
#define CONV_yd2_darcy	847206018947.977d0
#define CONV_acreus_cm2	40468726.1d0
#define CONV_acreus_km2	0.00404687261d0
#define CONV_acreus_m2	4046.87261d0
#define CONV_acreus_are	40.4687261d0
#define CONV_acreus_circmm	5152640081.9564d0
#define CONV_acreus_hect	0.404687261d0
#define CONV_acreus_mm2	4046872610d0
#define CONV_acreus_barn	4.04687261d+31
#define CONV_acreus_acre	1.00000400004307d0
#define CONV_acreus_ft2	43560.1742418762d0
#define CONV_acreus_in2	6272665.09083018d0
#define CONV_acreus_mile2	0.0015625062500673d0
#define CONV_acreus_yd2	4840.01936020847d0
#define CONV_acreus_chaig2	10.0000400004307d0
#define CONV_acreus_chair2	4.35601742418763d0
#define CONV_acreus_chaiu2	10d0
#define CONV_acreus_circin	7986604.26765025d0
#define CONV_acreus_circmil	7986604267650.25d0
#define CONV_acreus_ftu2	43559.9998200281d0
#define CONV_acreus_linkg2	100000.400004307d0
#define CONV_acreus_linkr2	43560.1742418762d0
#define CONV_acreus_mil2	6272665090830.18d0
#define CONV_acreus_mileu2	0.00156250000024131d0
#define CONV_acreus_rod2	160.000640006892d0
#define CONV_acreus_town	4.34029513907584d-05
#define CONV_acreus_darcy	4.10049353379336d+15
#define CONV_chaig2_cm2	4046856.4224d0
#define CONV_chaig2_km2	0.00040468564224d0
#define CONV_chaig2_m2	404.68564224d0
#define CONV_chaig2_are	4.0468564224d0
#define CONV_chaig2_circmm	515261947.125658d0
#define CONV_chaig2_hect	0.040468564224d0
#define CONV_chaig2_mm2	404685642.24d0
#define CONV_chaig2_barn	4.0468564224d+30
#define CONV_chaig2_acre	0.1d0
#define CONV_chaig2_ft2	4356d0
#define CONV_chaig2_in2	627264d0
#define CONV_chaig2_mile2	0.00015625d0
#define CONV_chaig2_yd2	484d0
#define CONV_chaig2_acreus	0.0999995999972928d0
#define CONV_chaig2_chair2	0.4356d0
#define CONV_chaig2_chaiu2	0.999995999972928d0
#define CONV_chaig2_circin	798657.232101696d0
#define CONV_chaig2_circmil	798657232101.696d0
#define CONV_chaig2_ftu2	4355.98255788496d0
#define CONV_chaig2_linkg2	10000d0
#define CONV_chaig2_linkr2	4356d0
#define CONV_chaig2_mil2	627264000000d0
#define CONV_chaig2_mileu2	0.000156249375019901d0
#define CONV_chaig2_rod2	16d0
#define CONV_chaig2_town	4.34027777777778d-06
#define CONV_chaig2_darcy	410047713170821d0
#define CONV_chair2_cm2	9290304d0
#define CONV_chair2_km2	0.0009290304d0
#define CONV_chair2_m2	929.0304d0
#define CONV_chair2_are	9.290304d0
#define CONV_chair2_circmm	1182878666.496d0
#define CONV_chair2_hect	0.09290304d0
#define CONV_chair2_mm2	929030400d0
#define CONV_chair2_barn	9.290304d+30
#define CONV_chair2_acre	0.229568411386593d0
#define CONV_chair2_ft2	10000d0
#define CONV_chair2_in2	1440000d0
#define CONV_chair2_mile2	0.000358700642791552d0
#define CONV_chair2_yd2	1111.11111111111d0
#define CONV_chair2_acreus	0.229567493106733d0
#define CONV_chair2_chaig2	2.29568411386593d0
#define CONV_chair2_chaiu2	2.29567493106733d0
#define CONV_chair2_circin	1833464.72016d0
#define CONV_chair2_circmil	1833464720160d0
#define CONV_chair2_ftu2	9999.95995841359d0
#define CONV_chair2_linkg2	22956.8411386593d0
#define CONV_chair2_linkr2	10000d0
#define CONV_chair2_mil2	1440000000000d0
#define CONV_chair2_mileu2	0.000358699208034667d0
#define CONV_chair2_rod2	36.7309458218549d0
#define CONV_chair2_town	9.96390674420977d-06
#define CONV_chair2_darcy	941340021053308d0
#define CONV_chaiu2_cm2	4046872.61d0
#define CONV_chaiu2_km2	0.000404687261d0
#define CONV_chaiu2_m2	404.687261d0
#define CONV_chaiu2_are	4.04687261d0
#define CONV_chaiu2_circmm	515264008.19564d0
#define CONV_chaiu2_hect	0.0404687261d0
#define CONV_chaiu2_mm2	404687261d0
#define CONV_chaiu2_barn	4.04687261d+30
#define CONV_chaiu2_acre	0.100000400004307d0
#define CONV_chaiu2_ft2	4356.01742418762d0
#define CONV_chaiu2_in2	627266.509083018d0
#define CONV_chaiu2_mile2	0.00015625062500673d0
#define CONV_chaiu2_yd2	484.001936020847d0
#define CONV_chaiu2_acreus	0.1d0
#define CONV_chaiu2_chaig2	1.00000400004307d0
#define CONV_chaiu2_chair2	0.435601742418762d0
#define CONV_chaiu2_circin	798660.426765025d0
#define CONV_chaiu2_circmil	798660426765.025d0
#define CONV_chaiu2_ftu2	4355.99998200281d0
#define CONV_chaiu2_linkg2	10000.0400004307d0
#define CONV_chaiu2_linkr2	4356.01742418762d0
#define CONV_chaiu2_mil2	627266509083.018d0
#define CONV_chaiu2_mileu2	0.000156250000024131d0
#define CONV_chaiu2_rod2	16.0000640006892d0
#define CONV_chaiu2_town	4.34029513907584d-06
#define CONV_chaiu2_darcy	410049353379336d0
#define CONV_circin_cm2	5.0670754107498d0
#define CONV_circin_km2	5.0670754107498d-10
#define CONV_circin_m2	0.00050670754107498d0
#define CONV_circin_are	5.0670754107498d-06
#define CONV_circin_circmm	645.160309598308d0
#define CONV_circin_hect	5.0670754107498d-08
#define CONV_circin_mm2	506.70754107498d0
#define CONV_circin_barn	5.0670754107498d+24
#define CONV_circin_acre	1.25210160229622d-07
#define CONV_circin_ft2	0.00545415457960234d0
#define CONV_circin_in2	0.785398259462738d0
#define CONV_circin_mile2	1.95640875358785d-10
#define CONV_circin_yd2	0.000606017175511372d0
#define CONV_circin_acreus	1.25209659385592d-07
#define CONV_circin_chaig2	1.25210160229622d-06
#define CONV_circin_chair2	5.45415457960234d-07
#define CONV_circin_chaiu2	1.25209659385592d-06
#define CONV_circin_circmil	1000000d0
#define CONV_circin_ftu2	0.00545413274030216d0
#define CONV_circin_linkg2	0.0125210160229622d0
#define CONV_circin_linkr2	0.00545415457960234d0
#define CONV_circin_mil2	785398.259462738d0
#define CONV_circin_mileu2	1.95640092820201d-10
#define CONV_circin_rod2	2.00336256367396d-05
#define CONV_circin_town	5.43446875996624d-12
#define CONV_circin_darcy	513421398.679087d0
#define CONV_circmil_cm2	5.0670754107498d-06
#define CONV_circmil_km2	5.0670754107498d-16
#define CONV_circmil_m2	5.0670754107498d-10
#define CONV_circmil_are	5.0670754107498d-12
#define CONV_circmil_circmm	0.000645160309598308d0
#define CONV_circmil_hect	5.0670754107498d-14
#define CONV_circmil_mm2	0.00050670754107498d0
#define CONV_circmil_barn	5.0670754107498d+18
#define CONV_circmil_acre	1.25210160229622d-13
#define CONV_circmil_ft2	5.45415457960234d-09
#define CONV_circmil_in2	7.85398259462738d-07
#define CONV_circmil_mile2	1.95640875358785d-16
#define CONV_circmil_yd2	6.06017175511372d-10
#define CONV_circmil_acreus	1.25209659385592d-13
#define CONV_circmil_chaig2	1.25210160229622d-12
#define CONV_circmil_chair2	5.45415457960234d-13
#define CONV_circmil_chaiu2	1.25209659385592d-12
#define CONV_circmil_circin	1d-06
#define CONV_circmil_ftu2	5.45413274030215d-09
#define CONV_circmil_linkg2	1.25210160229622d-08
#define CONV_circmil_linkr2	5.45415457960234d-09
#define CONV_circmil_mil2	0.785398259462738d0
#define CONV_circmil_mileu2	1.95640092820201d-16
#define CONV_circmil_rod2	2.00336256367396d-11
#define CONV_circmil_town	5.43446875996624d-18
#define CONV_circmil_darcy	513.421398679087d0
#define CONV_ftu2_cm2	929.03412d0
#define CONV_ftu2_km2	9.2903412d-08
#define CONV_ftu2_m2	0.092903412d0
#define CONV_ftu2_are	0.00092903412d0
#define CONV_ftu2_circmm	118288.34029488d0
#define CONV_ftu2_hect	9.2903412d-06
#define CONV_ftu2_mm2	92903.412d0
#define CONV_ftu2_barn	9.2903412d+26
#define CONV_ftu2_acre	2.29569330618612d-05
#define CONV_ftu2_ft2	1.00000400417467d0
#define CONV_ftu2_in2	144.000576601153d0
#define CONV_ftu2_mile2	3.58702079091581d-08
#define CONV_ftu2_yd2	0.111111556019408d0
#define CONV_ftu2_acreus	2.29568412335075d-05
#define CONV_ftu2_chaig2	0.000229569330618612d0
#define CONV_ftu2_chair2	0.000100000400417467d0
#define CONV_ftu2_chaiu2	0.000229568412335075d0
#define CONV_ftu2_circin	183.3472061673d0
#define CONV_ftu2_circmil	183347206.1673d0
#define CONV_ftu2_linkg2	2.29569330618612d0
#define CONV_ftu2_linkr2	1.00000400417467d0
#define CONV_ftu2_mil2	144000576.601153d0
#define CONV_ftu2_mileu2	3.58700644328952d-08
#define CONV_ftu2_rod2	0.00367310928989779d0
#define CONV_ftu2_town	9.96394664143282d-10
#define CONV_ftu2_darcy	94134379034.3181d0
#define CONV_linkg2_cm2	404.68564224d0
#define CONV_linkg2_km2	4.0468564224d-08
#define CONV_linkg2_m2	0.040468564224d0
#define CONV_linkg2_are	0.00040468564224d0
#define CONV_linkg2_circmm	51526.1947125658d0
#define CONV_linkg2_hect	4.0468564224d-06
#define CONV_linkg2_mm2	40468.564224d0
#define CONV_linkg2_barn	4.0468564224d+26
#define CONV_linkg2_acre	1d-05
#define CONV_linkg2_ft2	0.4356d0
#define CONV_linkg2_in2	62.7264d0
#define CONV_linkg2_mile2	1.5625d-08
#define CONV_linkg2_yd2	0.0484d0
#define CONV_linkg2_acreus	9.99995999972928d-06
#define CONV_linkg2_chaig2	0.0001d0
#define CONV_linkg2_chair2	4.356d-05
#define CONV_linkg2_chaiu2	9.99995999972928d-05
#define CONV_linkg2_circin	79.8657232101696d0
#define CONV_linkg2_circmil	79865723.2101696d0
#define CONV_linkg2_ftu2	0.435598255788496d0
#define CONV_linkg2_linkr2	0.4356d0
#define CONV_linkg2_mil2	62726400d0
#define CONV_linkg2_mileu2	1.56249375019901d-08
#define CONV_linkg2_rod2	0.0016d0
#define CONV_linkg2_town	4.34027777777778d-10
#define CONV_linkg2_darcy	41004771317.0821d0
#define CONV_linkr2_cm2	929.0304d0
#define CONV_linkr2_km2	9.290304d-08
#define CONV_linkr2_m2	0.09290304d0
#define CONV_linkr2_are	0.000929030400000001d0
#define CONV_linkr2_circmm	118287.8666496d0
#define CONV_linkr2_hect	9.290304d-06
#define CONV_linkr2_mm2	92903.04d0
#define CONV_linkr2_barn	9.290304d+26
#define CONV_linkr2_acre	2.29568411386593d-05
#define CONV_linkr2_ft2	1d0
#define CONV_linkr2_in2	144d0
#define CONV_linkr2_mile2	3.58700642791552d-08
#define CONV_linkr2_yd2	0.111111111111111d0
#define CONV_linkr2_acreus	2.29567493106733d-05
#define CONV_linkr2_chaig2	0.000229568411386593d0
#define CONV_linkr2_chair2	0.0001d0
#define CONV_linkr2_chaiu2	0.000229567493106733d0
#define CONV_linkr2_circin	183.346472016d0
#define CONV_linkr2_circmil	183346472.016d0
#define CONV_linkr2_ftu2	0.999995995841359d0
#define CONV_linkr2_linkg2	2.29568411386593d0
#define CONV_linkr2_mil2	144000000d0
#define CONV_linkr2_mileu2	3.58699208034667d-08
#define CONV_linkr2_rod2	0.00367309458218549d0
#define CONV_linkr2_town	9.96390674420977d-10
#define CONV_linkr2_darcy	94134002105.3308d0
#define CONV_mil2_cm2	6.4516d-06
#define CONV_mil2_km2	6.4516d-16
#define CONV_mil2_m2	6.4516d-10
#define CONV_mil2_are	6.4516d-12
#define CONV_mil2_circmm	0.0008214435184d0
#define CONV_mil2_hect	6.4516d-14
#define CONV_mil2_mm2	0.00064516d0
#define CONV_mil2_barn	6.4516d+18
#define CONV_mil2_acre	1.59422507907356d-13
#define CONV_mil2_ft2	6.94444444444444d-09
#define CONV_mil2_in2	1d-06
#define CONV_mil2_mile2	2.49097668605244d-16
#define CONV_mil2_yd2	7.71604938271605d-10
#define CONV_mil2_acreus	1.59421870213009d-13
#define CONV_mil2_chaig2	1.59422507907356d-12
#define CONV_mil2_chair2	6.94444444444444d-13
#define CONV_mil2_chaiu2	1.59421870213009d-12
#define CONV_mil2_circin	1.273239389d-06
#define CONV_mil2_circmil	1.273239389d0
#define CONV_mil2_ftu2	6.94441663778721d-09
#define CONV_mil2_linkg2	1.59422507907356d-08
#define CONV_mil2_linkr2	6.94444444444444d-09
#define CONV_mil2_mileu2	2.49096672246297d-16
#define CONV_mil2_rod2	2.5507601265177d-11
#define CONV_mil2_town	6.91937968347901d-18
#define CONV_mil2_darcy	653.708347953686d0
#define CONV_mileu2_cm2	25899984700d0
#define CONV_mileu2_km2	2.58999847d0
#define CONV_mileu2_m2	2589998.47d0
#define CONV_mileu2_are	25899.9847d0
#define CONV_mileu2_circmm	3297689651942.8d0
#define CONV_mileu2_hect	258.999847d0
#define CONV_mileu2_mm2	2589998470000d0
#define CONV_mileu2_barn	2.58999847d+34
#define CONV_mileu2_acre	640.002559928725d0
#define CONV_mileu2_ft2	27878511.5104952d0
#define CONV_mileu2_in2	4014505657.51131d0
#define CONV_mileu2_mile2	1.00000399988863d0
#define CONV_mileu2_yd2	3097612.39005503d0
#define CONV_mileu2_acreus	639.999999901159d0
#define CONV_mileu2_chaig2	6400.02559928724d0
#define CONV_mileu2_chair2	2787.85115104952d0
#define CONV_mileu2_chaiu2	6399.99999901158d0
#define CONV_mileu2_circin	5111426730.50675d0
#define CONV_mileu2_circmil	5.11142673050675d+15
#define CONV_mileu2_ftu2	27878399.8805125d0
#define CONV_mileu2_linkg2	64000255.9928725d0
#define CONV_mileu2_linkr2	27878511.5104952d0
#define CONV_mileu2_mil2	4.01450565751131d+15
#define CONV_mileu2_rod2	102400.409588596d0
#define CONV_mileu2_town	0.0277778888857953d0
#define CONV_mileu2_darcy	2.62431586122245d+18
#define CONV_rod2_cm2	252928.5264d0
#define CONV_rod2_km2	2.529285264d-05
#define CONV_rod2_m2	25.29285264d0
#define CONV_rod2_are	0.2529285264d0
#define CONV_rod2_circmm	32203871.6953536d0
#define CONV_rod2_hect	0.002529285264d0
#define CONV_rod2_mm2	25292852.64d0
#define CONV_rod2_barn	2.529285264d+29
#define CONV_rod2_acre	0.00625d0
#define CONV_rod2_ft2	272.25d0
#define CONV_rod2_in2	39204d0
#define CONV_rod2_mile2	9.765625d-06
#define CONV_rod2_yd2	30.25d0
#define CONV_rod2_acreus	0.0062499749998308d0
#define CONV_rod2_chaig2	0.0625d0
#define CONV_rod2_chair2	0.027225d0
#define CONV_rod2_chaiu2	0.062499749998308d0
#define CONV_rod2_circin	49916.077006356d0
#define CONV_rod2_circmil	49916077006.356d0
#define CONV_rod2_ftu2	272.24890986781d0
#define CONV_rod2_linkg2	625d0
#define CONV_rod2_linkr2	272.25d0
#define CONV_rod2_mil2	39204000000d0
#define CONV_rod2_mileu2	9.76558593874382d-06
#define CONV_rod2_town	2.71267361111111d-07
#define CONV_rod2_darcy	25627982073176.3d0
#define CONV_town_cm2	932395719720.961d0
#define CONV_town_km2	93.239571972096d0
#define CONV_town_m2	93239571.972096d0
#define CONV_town_are	932395.719720961d0
#define CONV_town_circmm	118716352617752d0
#define CONV_town_hect	9323.9571972096d0
#define CONV_town_mm2	93239571972096d0
#define CONV_town_barn	9.3239571972096d+35
#define CONV_town_acre	23040d0
#define CONV_town_ft2	1003622400d0
#define CONV_town_in2	144521625600d0
#define CONV_town_mile2	36d0
#define CONV_town_yd2	111513600d0
#define CONV_town_acreus	23039.9078393763d0
#define CONV_town_chaig2	230400d0
#define CONV_town_chair2	100362.24d0
#define CONV_town_chaiu2	230399.078393763d0
#define CONV_town_circin	184010626276.231d0
#define CONV_town_circmil	1.84010626276231d+17
#define CONV_town_ftu2	1003618381.33669d0
#define CONV_town_linkg2	2304000000d0
#define CONV_town_linkr2	1003622400d0
#define CONV_town_mil2	1.445216256d+17
#define CONV_town_mileu2	35.9998560045852d0
#define CONV_town_rod2	3686400d0
#define CONV_town_darcy	9.44749931145572d+19
#define CONV_darcy_cm2	9.869233d-09
#define CONV_darcy_km2	9.869233d-19
#define CONV_darcy_m2	9.869233d-13
#define CONV_darcy_are	9.869233d-15
#define CONV_darcy_circmm	1.256590222492d-06
#define CONV_darcy_hect	9.869233d-17
#define CONV_darcy_mm2	9.869233d-07
#define CONV_darcy_barn	9.869233d+15
#define CONV_darcy_acre	2.43874058525334d-16
#define CONV_darcy_ft2	1.06231539893635d-11
#define CONV_darcy_in2	1.52973417446835d-09
#define CONV_darcy_mile2	3.81053216445834d-19
#define CONV_darcy_yd2	1.18035044326261d-12
#define CONV_darcy_acreus	2.43873083022497d-16
#define CONV_darcy_chaig2	2.43874058525334d-15
#define CONV_darcy_chair2	1.06231539893635d-15
#define CONV_darcy_chaiu2	2.43873083022497d-15
#define CONV_darcy_circin	1.9477178056325d-09
#define CONV_darcy_circmil	0.0019477178056325d0
#define CONV_darcy_ftu2	1.06231114525697d-11
#define CONV_darcy_linkg2	2.43874058525334d-11
#define CONV_darcy_linkr2	1.06231539893635d-11
#define CONV_darcy_mil2	0.00152973417446835d0
#define CONV_darcy_mileu2	3.81051692281501d-19
#define CONV_darcy_rod2	3.90198493640534d-14
#define CONV_darcy_town	1.05848115679398d-20



c VOLUME (l)
c ====================
c 
c METRIC
c cc     = cubic centimeter
c cl     = centiliter
c cm3    = cubic centimeter
c cupm   = cup (metric)
c dm3    = cubic decimeter
c km3    = cubic kilometer
c l      = liter
c litero = old (1901-1964) value of liter
c m3     = cubic meter
c ml     = milliliter
c mm3    = cubic millimeter
c 
c US/British
c acreft = acre-foot
c acrein = acre-inch
c bag    = bag (Brit)
c bbl    = barrel (petroleum)
c bblbb  = barrel (Brit, beer)
c bblbw  = barrel (Brit, wine)
c bbluc  = barrel (US, cranb)
c bblud  = barrel (US, dry)
c bblul  = barrel (US, liquid)
c board  = board foot
c boardf = board foot
c bu     = bushel (US)
c bub    = bushel (Brit)
c buck   = bucket (Brit)
c cord   = cord
c cordft = cord-foot
c cup    = cup
c dra    = dram (US, liquid)
c drach  = drachm (Brit, liquid)
c firkb  = firkin (Brit)
c firku  = firkin (US)
c floz   = ounce (US, liquid)
c ft3    = cubic foot
c gal    = gallon (US, liquid)
c galb   = gallon (Brit)
c gald   = gallon (US, dry)
c gill   = gill (US)
c gillb  = gill (Brit)
c in3    = cubic inch
c mile3  = cubic mile
c minim  = minim (US)
c minimb = minim (Brit)
c ozbf   = ounce (Brit, liquid)
c peck   = peck (US)
c peckb  = peck (Brit)
c pt     = pint (US, liquid)
c ptb    = pint (Brit)
c ptd    = pint (US, dry)
c qt     = quart (US, liquid)
c qtb    = quart (Brit)
c qtd    = quart (US, dry)
c regton = register ton
c scrup  = scruple (Brit, liquid)
c seam   = seam (Brit)
c yd3    = cubic yard



#define CONV_cc_cl	0.1d0
#define CONV_cc_cm3	1d0
#define CONV_cc_cupm	0.005d0
#define CONV_cc_dm3	0.001d0
#define CONV_cc_km3	1d-15
#define CONV_cc_l	0.001d0
#define CONV_cc_litero	0.000999972000783978d0
#define CONV_cc_m3	1d-06
#define CONV_cc_ml	1d0
#define CONV_cc_mm3	1000d0
#define CONV_cc_acreft	8.10713193789912d-10
#define CONV_cc_acrein	9.72855832547895d-09
#define CONV_cc_bag	9.16538534579532d-06
#define CONV_cc_bbl	6.2898107704321d-06
#define CONV_cc_bblbb	6.11025689719688d-06
#define CONV_cc_bblbw	6.98315073965358d-06
#define CONV_cc_bbluc	1.04743810667237d-05
#define CONV_cc_bblud	8.64848980934414d-06
#define CONV_cc_bblul	8.38641436057614d-06
#define CONV_cc_board	0.000423776000657863d0
#define CONV_cc_boardf	0.000423776000657863d0
#define CONV_cc_bu	2.83775932584017d-05
#define CONV_cc_bub	2.7496156037386d-05
#define CONV_cc_buck	5.49923120747719d-05
#define CONV_cc_cord	2.7589583376163d-07
#define CONV_cc_cordft	2.20716667009304d-06
#define CONV_cc_cup	0.00762796801184153d0
#define CONV_cc_dra	0.270512181614744d0
#define CONV_cc_drach	0.281560637822832d0
#define CONV_cc_firkb	2.44410275887875d-05
#define CONV_cc_firku	2.93524502620165d-05
#define CONV_cc_floz	0.0610237440947323d0
#define CONV_cc_ft3	3.53146667214886d-05
#define CONV_cc_gal	0.000264172052358148d0
#define CONV_cc_galb	0.000219969248299088d0
#define CONV_cc_gald	0.000227020746067214d0
#define CONV_cc_gill	0.00845350567546074d0
#define CONV_cc_gillb	0.00703901594557081d0
#define CONV_cc_in3	0.0610237440947323d0
#define CONV_cc_mile3	2.39912758578928d-16
#define CONV_cc_minim	16.2307308968846d0
#define CONV_cc_minimb	16.8936382693699d0
#define CONV_cc_ozbf	0.035195079727854d0
#define CONV_cc_peck	0.000113510373033607d0
#define CONV_cc_peckb	0.000109984624149544d0
#define CONV_cc_pt	0.00211337641886519d0
#define CONV_cc_ptb	0.0017597539863927d0
#define CONV_cc_ptd	0.00181616596853771d0
#define CONV_cc_qt	0.00105668820943259d0
#define CONV_cc_qtb	0.000879876993196351d0
#define CONV_cc_qtd	0.000908082984268856d0
#define CONV_cc_regton	3.53146667214886d-07
#define CONV_cc_scrup	0.844681913468497d0
#define CONV_cc_seam	3.43701950467325d-06
#define CONV_cc_yd3	1.30795061931439d-06
#define CONV_cl_cc	10d0
#define CONV_cl_cm3	10d0
#define CONV_cl_cupm	0.05d0
#define CONV_cl_dm3	0.01d0
#define CONV_cl_km3	1d-14
#define CONV_cl_l	0.01d0
#define CONV_cl_litero	0.00999972000783978d0
#define CONV_cl_m3	1d-05
#define CONV_cl_ml	10d0
#define CONV_cl_mm3	10000d0
#define CONV_cl_acreft	8.10713193789912d-09
#define CONV_cl_acrein	9.72855832547895d-08
#define CONV_cl_bag	9.16538534579532d-05
#define CONV_cl_bbl	6.2898107704321d-05
#define CONV_cl_bblbb	6.11025689719688d-05
#define CONV_cl_bblbw	6.98315073965358d-05
#define CONV_cl_bbluc	0.000104743810667237d0
#define CONV_cl_bblud	8.64848980934414d-05
#define CONV_cl_bblul	8.38641436057614d-05
#define CONV_cl_board	0.00423776000657863d0
#define CONV_cl_boardf	0.00423776000657863d0
#define CONV_cl_bu	0.000283775932584017d0
#define CONV_cl_bub	0.00027496156037386d0
#define CONV_cl_buck	0.000549923120747719d0
#define CONV_cl_cord	2.7589583376163d-06
#define CONV_cl_cordft	2.20716667009304d-05
#define CONV_cl_cup	0.0762796801184153d0
#define CONV_cl_dra	2.70512181614744d0
#define CONV_cl_drach	2.81560637822832d0
#define CONV_cl_firkb	0.000244410275887875d0
#define CONV_cl_firku	0.000293524502620165d0
#define CONV_cl_floz	0.610237440947323d0
#define CONV_cl_ft3	0.000353146667214886d0
#define CONV_cl_gal	0.00264172052358148d0
#define CONV_cl_galb	0.00219969248299088d0
#define CONV_cl_gald	0.00227020746067214d0
#define CONV_cl_gill	0.0845350567546075d0
#define CONV_cl_gillb	0.0703901594557081d0
#define CONV_cl_in3	0.610237440947323d0
#define CONV_cl_mile3	2.39912758578928d-15
#define CONV_cl_minim	162.307308968846d0
#define CONV_cl_minimb	168.936382693699d0
#define CONV_cl_ozbf	0.35195079727854d0
#define CONV_cl_peck	0.00113510373033607d0
#define CONV_cl_peckb	0.00109984624149544d0
#define CONV_cl_pt	0.0211337641886519d0
#define CONV_cl_ptb	0.017597539863927d0
#define CONV_cl_ptd	0.0181616596853771d0
#define CONV_cl_qt	0.0105668820943259d0
#define CONV_cl_qtb	0.00879876993196351d0
#define CONV_cl_qtd	0.00908082984268856d0
#define CONV_cl_regton	3.53146667214886d-06
#define CONV_cl_scrup	8.44681913468497d0
#define CONV_cl_seam	3.43701950467325d-05
#define CONV_cl_yd3	1.30795061931439d-05
#define CONV_cm3_cc	1d0
#define CONV_cm3_cl	0.1d0
#define CONV_cm3_cupm	0.005d0
#define CONV_cm3_dm3	0.001d0
#define CONV_cm3_km3	1d-15
#define CONV_cm3_l	0.001d0
#define CONV_cm3_litero	0.000999972000783978d0
#define CONV_cm3_m3	1d-06
#define CONV_cm3_ml	1d0
#define CONV_cm3_mm3	1000d0
#define CONV_cm3_acreft	8.10713193789912d-10
#define CONV_cm3_acrein	9.72855832547895d-09
#define CONV_cm3_bag	9.16538534579532d-06
#define CONV_cm3_bbl	6.2898107704321d-06
#define CONV_cm3_bblbb	6.11025689719688d-06
#define CONV_cm3_bblbw	6.98315073965358d-06
#define CONV_cm3_bbluc	1.04743810667237d-05
#define CONV_cm3_bblud	8.64848980934414d-06
#define CONV_cm3_bblul	8.38641436057614d-06
#define CONV_cm3_board	0.000423776000657863d0
#define CONV_cm3_boardf	0.000423776000657863d0
#define CONV_cm3_bu	2.83775932584017d-05
#define CONV_cm3_bub	2.7496156037386d-05
#define CONV_cm3_buck	5.49923120747719d-05
#define CONV_cm3_cord	2.7589583376163d-07
#define CONV_cm3_cordft	2.20716667009304d-06
#define CONV_cm3_cup	0.00762796801184153d0
#define CONV_cm3_dra	0.270512181614744d0
#define CONV_cm3_drach	0.281560637822832d0
#define CONV_cm3_firkb	2.44410275887875d-05
#define CONV_cm3_firku	2.93524502620165d-05
#define CONV_cm3_floz	0.0610237440947323d0
#define CONV_cm3_ft3	3.53146667214886d-05
#define CONV_cm3_gal	0.000264172052358148d0
#define CONV_cm3_galb	0.000219969248299088d0
#define CONV_cm3_gald	0.000227020746067214d0
#define CONV_cm3_gill	0.00845350567546074d0
#define CONV_cm3_gillb	0.00703901594557081d0
#define CONV_cm3_in3	0.0610237440947323d0
#define CONV_cm3_mile3	2.39912758578928d-16
#define CONV_cm3_minim	16.2307308968846d0
#define CONV_cm3_minimb	16.8936382693699d0
#define CONV_cm3_ozbf	0.035195079727854d0
#define CONV_cm3_peck	0.000113510373033607d0
#define CONV_cm3_peckb	0.000109984624149544d0
#define CONV_cm3_pt	0.00211337641886519d0
#define CONV_cm3_ptb	0.0017597539863927d0
#define CONV_cm3_ptd	0.00181616596853771d0
#define CONV_cm3_qt	0.00105668820943259d0
#define CONV_cm3_qtb	0.000879876993196351d0
#define CONV_cm3_qtd	0.000908082984268856d0
#define CONV_cm3_regton	3.53146667214886d-07
#define CONV_cm3_scrup	0.844681913468497d0
#define CONV_cm3_seam	3.43701950467325d-06
#define CONV_cm3_yd3	1.30795061931439d-06
#define CONV_cupm_cc	200d0
#define CONV_cupm_cl	20d0
#define CONV_cupm_cm3	200d0
#define CONV_cupm_dm3	0.2d0
#define CONV_cupm_km3	2d-13
#define CONV_cupm_l	0.2d0
#define CONV_cupm_litero	0.199994400156796d0
#define CONV_cupm_m3	0.0002d0
#define CONV_cupm_ml	200d0
#define CONV_cupm_mm3	200000d0
#define CONV_cupm_acreft	1.62142638757982d-07
#define CONV_cupm_acrein	1.94571166509579d-06
#define CONV_cupm_bag	0.00183307706915906d0
#define CONV_cupm_bbl	0.00125796215408642d0
#define CONV_cupm_bblbb	0.00122205137943938d0
#define CONV_cupm_bblbw	0.00139663014793072d0
#define CONV_cupm_bbluc	0.00209487621334474d0
#define CONV_cupm_bblud	0.00172969796186883d0
#define CONV_cupm_bblul	0.00167728287211523d0
#define CONV_cupm_board	0.0847552001315726d0
#define CONV_cupm_boardf	0.0847552001315726d0
#define CONV_cupm_bu	0.00567551865168035d0
#define CONV_cupm_bub	0.00549923120747719d0
#define CONV_cupm_buck	0.0109984624149544d0
#define CONV_cupm_cord	5.51791667523259d-05
#define CONV_cupm_cordft	0.000441433334018607d0
#define CONV_cupm_cup	1.52559360236831d0
#define CONV_cupm_dra	54.1024363229488d0
#define CONV_cupm_drach	56.3121275645665d0
#define CONV_cupm_firkb	0.0048882055177575d0
#define CONV_cupm_firku	0.0058704900524033d0
#define CONV_cupm_floz	12.2047488189465d0
#define CONV_cupm_ft3	0.00706293334429772d0
#define CONV_cupm_gal	0.0528344104716297d0
#define CONV_cupm_galb	0.0439938496598175d0
#define CONV_cupm_gald	0.0454041492134428d0
#define CONV_cupm_gill	1.69070113509215d0
#define CONV_cupm_gillb	1.40780318911416d0
#define CONV_cupm_in3	12.2047488189465d0
#define CONV_cupm_mile3	4.79825517157855d-14
#define CONV_cupm_minim	3246.14617937693d0
#define CONV_cupm_minimb	3378.72765387399d0
#define CONV_cupm_ozbf	7.03901594557081d0
#define CONV_cupm_peck	0.0227020746067214d0
#define CONV_cupm_peckb	0.0219969248299088d0
#define CONV_cupm_pt	0.422675283773037d0
#define CONV_cupm_ptb	0.35195079727854d0
#define CONV_cupm_ptd	0.363233193707542d0
#define CONV_cupm_qt	0.211337641886519d0
#define CONV_cupm_qtb	0.17597539863927d0
#define CONV_cupm_qtd	0.181616596853771d0
#define CONV_cupm_regton	7.06293334429772d-05
#define CONV_cupm_scrup	168.936382693699d0
#define CONV_cupm_seam	0.000687403900934649d0
#define CONV_cupm_yd3	0.000261590123862878d0
#define CONV_dm3_cc	1000d0
#define CONV_dm3_cl	100d0
#define CONV_dm3_cm3	1000d0
#define CONV_dm3_cupm	5d0
#define CONV_dm3_km3	1d-12
#define CONV_dm3_l	1d0
#define CONV_dm3_litero	0.999972000783978d0
#define CONV_dm3_m3	0.001d0
#define CONV_dm3_ml	1000d0
#define CONV_dm3_mm3	1000000d0
#define CONV_dm3_acreft	8.10713193789912d-07
#define CONV_dm3_acrein	9.72855832547895d-06
#define CONV_dm3_bag	0.00916538534579532d0
#define CONV_dm3_bbl	0.0062898107704321d0
#define CONV_dm3_bblbb	0.00611025689719688d0
#define CONV_dm3_bblbw	0.00698315073965358d0
#define CONV_dm3_bbluc	0.0104743810667237d0
#define CONV_dm3_bblud	0.00864848980934414d0
#define CONV_dm3_bblul	0.00838641436057614d0
#define CONV_dm3_board	0.423776000657863d0
#define CONV_dm3_boardf	0.423776000657863d0
#define CONV_dm3_bu	0.0283775932584017d0
#define CONV_dm3_bub	0.027496156037386d0
#define CONV_dm3_buck	0.0549923120747719d0
#define CONV_dm3_cord	0.00027589583376163d0
#define CONV_dm3_cordft	0.00220716667009304d0
#define CONV_dm3_cup	7.62796801184153d0
#define CONV_dm3_dra	270.512181614744d0
#define CONV_dm3_drach	281.560637822832d0
#define CONV_dm3_firkb	0.0244410275887875d0
#define CONV_dm3_firku	0.0293524502620165d0
#define CONV_dm3_floz	61.0237440947323d0
#define CONV_dm3_ft3	0.0353146667214886d0
#define CONV_dm3_gal	0.264172052358148d0
#define CONV_dm3_galb	0.219969248299088d0
#define CONV_dm3_gald	0.227020746067214d0
#define CONV_dm3_gill	8.45350567546074d0
#define CONV_dm3_gillb	7.03901594557081d0
#define CONV_dm3_in3	61.0237440947323d0
#define CONV_dm3_mile3	2.39912758578928d-13
#define CONV_dm3_minim	16230.7308968846d0
#define CONV_dm3_minimb	16893.6382693699d0
#define CONV_dm3_ozbf	35.195079727854d0
#define CONV_dm3_peck	0.113510373033607d0
#define CONV_dm3_peckb	0.109984624149544d0
#define CONV_dm3_pt	2.11337641886519d0
#define CONV_dm3_ptb	1.7597539863927d0
#define CONV_dm3_ptd	1.81616596853771d0
#define CONV_dm3_qt	1.05668820943259d0
#define CONV_dm3_qtb	0.879876993196351d0
#define CONV_dm3_qtd	0.908082984268856d0
#define CONV_dm3_regton	0.000353146667214886d0
#define CONV_dm3_scrup	844.681913468497d0
#define CONV_dm3_seam	0.00343701950467325d0
#define CONV_dm3_yd3	0.00130795061931439d0
#define CONV_km3_cc	1d+15
#define CONV_km3_cl	100000000000000d0
#define CONV_km3_cm3	1d+15
#define CONV_km3_cupm	5000000000000d0
#define CONV_km3_dm3	1000000000000d0
#define CONV_km3_l	1000000000000d0
#define CONV_km3_litero	999972000783.978d0
#define CONV_km3_m3	1000000000d0
#define CONV_km3_ml	1d+15
#define CONV_km3_mm3	1d+18
#define CONV_km3_acreft	810713.193789912d0
#define CONV_km3_acrein	9728558.32547895d0
#define CONV_km3_bag	9165385345.79532d0
#define CONV_km3_bbl	6289810770.4321d0
#define CONV_km3_bblbb	6110256897.19688d0
#define CONV_km3_bblbw	6983150739.65358d0
#define CONV_km3_bbluc	10474381066.7237d0
#define CONV_km3_bblud	8648489809.34414d0
#define CONV_km3_bblul	8386414360.57614d0
#define CONV_km3_board	423776000657.863d0
#define CONV_km3_boardf	423776000657.863d0
#define CONV_km3_bu	28377593258.4017d0
#define CONV_km3_bub	27496156037.386d0
#define CONV_km3_buck	54992312074.7719d0
#define CONV_km3_cord	275895833.76163d0
#define CONV_km3_cordft	2207166670.09304d0
#define CONV_km3_cup	7627968011841.53d0
#define CONV_km3_dra	270512181614744d0
#define CONV_km3_drach	281560637822832d0
#define CONV_km3_firkb	24441027588.7875d0
#define CONV_km3_firku	29352450262.0165d0
#define CONV_km3_floz	61023744094732.3d0
#define CONV_km3_ft3	35314666721.4886d0
#define CONV_km3_gal	264172052358.148d0
#define CONV_km3_galb	219969248299.088d0
#define CONV_km3_gald	227020746067.214d0
#define CONV_km3_gill	8453505675460.75d0
#define CONV_km3_gillb	7039015945570.81d0
#define CONV_km3_in3	61023744094732.3d0
#define CONV_km3_mile3	0.239912758578928d0
#define CONV_km3_minim	1.62307308968846d+16
#define CONV_km3_minimb	1.68936382693699d+16
#define CONV_km3_ozbf	35195079727854d0
#define CONV_km3_peck	113510373033.607d0
#define CONV_km3_peckb	109984624149.544d0
#define CONV_km3_pt	2113376418865.19d0
#define CONV_km3_ptb	1759753986392.7d0
#define CONV_km3_ptd	1816165968537.71d0
#define CONV_km3_qt	1056688209432.59d0
#define CONV_km3_qtb	879876993196.351d0
#define CONV_km3_qtd	908082984268.856d0
#define CONV_km3_regton	353146667.214886d0
#define CONV_km3_scrup	844681913468497d0
#define CONV_km3_seam	3437019504.67325d0
#define CONV_km3_yd3	1307950619.31439d0
#define CONV_l_cc	1000d0
#define CONV_l_cl	100d0
#define CONV_l_cm3	1000d0
#define CONV_l_cupm	5d0
#define CONV_l_dm3	1d0
#define CONV_l_km3	1d-12
#define CONV_l_litero	0.999972000783978d0
#define CONV_l_m3	0.001d0
#define CONV_l_ml	1000d0
#define CONV_l_mm3	1000000d0
#define CONV_l_acreft	8.10713193789912d-07
#define CONV_l_acrein	9.72855832547895d-06
#define CONV_l_bag	0.00916538534579532d0
#define CONV_l_bbl	0.0062898107704321d0
#define CONV_l_bblbb	0.00611025689719688d0
#define CONV_l_bblbw	0.00698315073965358d0
#define CONV_l_bbluc	0.0104743810667237d0
#define CONV_l_bblud	0.00864848980934414d0
#define CONV_l_bblul	0.00838641436057614d0
#define CONV_l_board	0.423776000657863d0
#define CONV_l_boardf	0.423776000657863d0
#define CONV_l_bu	0.0283775932584017d0
#define CONV_l_bub	0.027496156037386d0
#define CONV_l_buck	0.0549923120747719d0
#define CONV_l_cord	0.00027589583376163d0
#define CONV_l_cordft	0.00220716667009304d0
#define CONV_l_cup	7.62796801184153d0
#define CONV_l_dra	270.512181614744d0
#define CONV_l_drach	281.560637822832d0
#define CONV_l_firkb	0.0244410275887875d0
#define CONV_l_firku	0.0293524502620165d0
#define CONV_l_floz	61.0237440947323d0
#define CONV_l_ft3	0.0353146667214886d0
#define CONV_l_gal	0.264172052358148d0
#define CONV_l_galb	0.219969248299088d0
#define CONV_l_gald	0.227020746067214d0
#define CONV_l_gill	8.45350567546074d0
#define CONV_l_gillb	7.03901594557081d0
#define CONV_l_in3	61.0237440947323d0
#define CONV_l_mile3	2.39912758578928d-13
#define CONV_l_minim	16230.7308968846d0
#define CONV_l_minimb	16893.6382693699d0
#define CONV_l_ozbf	35.195079727854d0
#define CONV_l_peck	0.113510373033607d0
#define CONV_l_peckb	0.109984624149544d0
#define CONV_l_pt	2.11337641886519d0
#define CONV_l_ptb	1.7597539863927d0
#define CONV_l_ptd	1.81616596853771d0
#define CONV_l_qt	1.05668820943259d0
#define CONV_l_qtb	0.879876993196351d0
#define CONV_l_qtd	0.908082984268856d0
#define CONV_l_regton	0.000353146667214886d0
#define CONV_l_scrup	844.681913468497d0
#define CONV_l_seam	0.00343701950467325d0
#define CONV_l_yd3	0.00130795061931439d0
#define CONV_litero_cc	1000.028d0
#define CONV_litero_cl	100.0028d0
#define CONV_litero_cm3	1000.028d0
#define CONV_litero_cupm	5.00014d0
#define CONV_litero_dm3	1.000028d0
#define CONV_litero_km3	1.000028d-12
#define CONV_litero_l	1.000028d0
#define CONV_litero_m3	0.001000028d0
#define CONV_litero_ml	1000.028d0
#define CONV_litero_mm3	1000028d0
#define CONV_litero_acreft	8.10735893759338d-07
#define CONV_litero_acrein	9.72883072511206d-06
#define CONV_litero_bag	0.009165641976585d0
#define CONV_litero_bbl	0.00628998688513367d0
#define CONV_litero_bblbb	0.00611042798439d0
#define CONV_litero_bblbw	0.00698334626787429d0
#define CONV_litero_bbluc	0.0104746743493936d0
#define CONV_litero_bblud	0.0086487319670588d0
#define CONV_litero_bblul	0.00838664918017823d0
#define CONV_litero_board	0.423787866385881d0
#define CONV_litero_boardf	0.423787866385881d0
#define CONV_litero_bu	0.028378387831013d0
#define CONV_litero_bub	0.027496925929755d0
#define CONV_litero_buck	0.05499385185951d0
#define CONV_litero_cord	0.000275903558844975d0
#define CONV_litero_cordft	0.0022072284707598d0
#define CONV_litero_cup	7.62818159494586d0
#define CONV_litero_dra	270.519755955829d0
#define CONV_litero_drach	281.568521520691d0
#define CONV_litero_firkb	0.02444171193756d0
#define CONV_litero_firku	0.0293532721306238d0
#define CONV_litero_floz	61.0254527595669d0
#define CONV_litero_ft3	0.0353156555321568d0
#define CONV_litero_gal	0.264179449175614d0
#define CONV_litero_galb	0.21997540743804d0
#define CONV_litero_gald	0.227027102648104d0
#define CONV_litero_gill	8.45374237361966d0
#define CONV_litero_gillb	7.03921303801728d0
#define CONV_litero_in3	61.0254527595669d0
#define CONV_litero_mile3	2.39919476136168d-13
#define CONV_litero_minim	16231.1853573497d0
#define CONV_litero_minimb	16894.1112912415d0
#define CONV_litero_ozbf	35.1960651900864d0
#define CONV_litero_peck	0.113513551324052d0
#define CONV_litero_peckb	0.10998770371902d0
#define CONV_litero_pt	2.11343559340491d0
#define CONV_litero_ptb	1.75980325950432d0
#define CONV_litero_ptd	1.81621682118483d0
#define CONV_litero_qt	1.05671779670246d0
#define CONV_litero_qtb	0.87990162975216d0
#define CONV_litero_qtd	0.908108410592415d0
#define CONV_litero_regton	0.000353156555321568d0
#define CONV_litero_scrup	844.705564562074d0
#define CONV_litero_seam	0.00343711574121938d0
#define CONV_litero_yd3	0.00130798724193173d0
#define CONV_m3_cc	1000000d0
#define CONV_m3_cl	100000d0
#define CONV_m3_cm3	1000000d0
#define CONV_m3_cupm	5000d0
#define CONV_m3_dm3	1000d0
#define CONV_m3_km3	1d-09
#define CONV_m3_l	1000d0
#define CONV_m3_litero	999.972000783978d0
#define CONV_m3_ml	1000000d0
#define CONV_m3_mm3	1000000000d0
#define CONV_m3_acreft	0.000810713193789912d0
#define CONV_m3_acrein	0.00972855832547895d0
#define CONV_m3_bag	9.16538534579532d0
#define CONV_m3_bbl	6.2898107704321d0
#define CONV_m3_bblbb	6.11025689719688d0
#define CONV_m3_bblbw	6.98315073965358d0
#define CONV_m3_bbluc	10.4743810667237d0
#define CONV_m3_bblud	8.64848980934414d0
#define CONV_m3_bblul	8.38641436057614d0
#define CONV_m3_board	423.776000657863d0
#define CONV_m3_boardf	423.776000657863d0
#define CONV_m3_bu	28.3775932584017d0
#define CONV_m3_bub	27.496156037386d0
#define CONV_m3_buck	54.9923120747719d0
#define CONV_m3_cord	0.27589583376163d0
#define CONV_m3_cordft	2.20716667009304d0
#define CONV_m3_cup	7627.96801184153d0
#define CONV_m3_dra	270512.181614744d0
#define CONV_m3_drach	281560.637822832d0
#define CONV_m3_firkb	24.4410275887875d0
#define CONV_m3_firku	29.3524502620165d0
#define CONV_m3_floz	61023.7440947323d0
#define CONV_m3_ft3	35.3146667214886d0
#define CONV_m3_gal	264.172052358148d0
#define CONV_m3_galb	219.969248299088d0
#define CONV_m3_gald	227.020746067214d0
#define CONV_m3_gill	8453.50567546075d0
#define CONV_m3_gillb	7039.01594557081d0
#define CONV_m3_in3	61023.7440947323d0
#define CONV_m3_mile3	2.39912758578928d-10
#define CONV_m3_minim	16230730.8968846d0
#define CONV_m3_minimb	16893638.2693699d0
#define CONV_m3_ozbf	35195.079727854d0
#define CONV_m3_peck	113.510373033607d0
#define CONV_m3_peckb	109.984624149544d0
#define CONV_m3_pt	2113.37641886519d0
#define CONV_m3_ptb	1759.7539863927d0
#define CONV_m3_ptd	1816.16596853771d0
#define CONV_m3_qt	1056.68820943259d0
#define CONV_m3_qtb	879.876993196351d0
#define CONV_m3_qtd	908.082984268856d0
#define CONV_m3_regton	0.353146667214886d0
#define CONV_m3_scrup	844681.913468497d0
#define CONV_m3_seam	3.43701950467325d0
#define CONV_m3_yd3	1.30795061931439d0
#define CONV_ml_cc	1d0
#define CONV_ml_cl	0.1d0
#define CONV_ml_cm3	1d0
#define CONV_ml_cupm	0.005d0
#define CONV_ml_dm3	0.001d0
#define CONV_ml_km3	1d-15
#define CONV_ml_l	0.001d0
#define CONV_ml_litero	0.000999972000783978d0
#define CONV_ml_m3	1d-06
#define CONV_ml_mm3	1000d0
#define CONV_ml_acreft	8.10713193789912d-10
#define CONV_ml_acrein	9.72855832547895d-09
#define CONV_ml_bag	9.16538534579532d-06
#define CONV_ml_bbl	6.2898107704321d-06
#define CONV_ml_bblbb	6.11025689719688d-06
#define CONV_ml_bblbw	6.98315073965358d-06
#define CONV_ml_bbluc	1.04743810667237d-05
#define CONV_ml_bblud	8.64848980934414d-06
#define CONV_ml_bblul	8.38641436057614d-06
#define CONV_ml_board	0.000423776000657863d0
#define CONV_ml_boardf	0.000423776000657863d0
#define CONV_ml_bu	2.83775932584017d-05
#define CONV_ml_bub	2.7496156037386d-05
#define CONV_ml_buck	5.49923120747719d-05
#define CONV_ml_cord	2.7589583376163d-07
#define CONV_ml_cordft	2.20716667009304d-06
#define CONV_ml_cup	0.00762796801184153d0
#define CONV_ml_dra	0.270512181614744d0
#define CONV_ml_drach	0.281560637822832d0
#define CONV_ml_firkb	2.44410275887875d-05
#define CONV_ml_firku	2.93524502620165d-05
#define CONV_ml_floz	0.0610237440947323d0
#define CONV_ml_ft3	3.53146667214886d-05
#define CONV_ml_gal	0.000264172052358148d0
#define CONV_ml_galb	0.000219969248299088d0
#define CONV_ml_gald	0.000227020746067214d0
#define CONV_ml_gill	0.00845350567546074d0
#define CONV_ml_gillb	0.00703901594557081d0
#define CONV_ml_in3	0.0610237440947323d0
#define CONV_ml_mile3	2.39912758578928d-16
#define CONV_ml_minim	16.2307308968846d0
#define CONV_ml_minimb	16.8936382693699d0
#define CONV_ml_ozbf	0.035195079727854d0
#define CONV_ml_peck	0.000113510373033607d0
#define CONV_ml_peckb	0.000109984624149544d0
#define CONV_ml_pt	0.00211337641886519d0
#define CONV_ml_ptb	0.0017597539863927d0
#define CONV_ml_ptd	0.00181616596853771d0
#define CONV_ml_qt	0.00105668820943259d0
#define CONV_ml_qtb	0.000879876993196351d0
#define CONV_ml_qtd	0.000908082984268856d0
#define CONV_ml_regton	3.53146667214886d-07
#define CONV_ml_scrup	0.844681913468497d0
#define CONV_ml_seam	3.43701950467325d-06
#define CONV_ml_yd3	1.30795061931439d-06
#define CONV_mm3_cc	0.001d0
#define CONV_mm3_cl	0.0001d0
#define CONV_mm3_cm3	0.001d0
#define CONV_mm3_cupm	5d-06
#define CONV_mm3_dm3	1d-06
#define CONV_mm3_km3	1d-18
#define CONV_mm3_l	1d-06
#define CONV_mm3_litero	9.99972000783978d-07
#define CONV_mm3_m3	1d-09
#define CONV_mm3_ml	0.001d0
#define CONV_mm3_acreft	8.10713193789912d-13
#define CONV_mm3_acrein	9.72855832547895d-12
#define CONV_mm3_bag	9.16538534579532d-09
#define CONV_mm3_bbl	6.2898107704321d-09
#define CONV_mm3_bblbb	6.11025689719688d-09
#define CONV_mm3_bblbw	6.98315073965358d-09
#define CONV_mm3_bbluc	1.04743810667237d-08
#define CONV_mm3_bblud	8.64848980934414d-09
#define CONV_mm3_bblul	8.38641436057614d-09
#define CONV_mm3_board	4.23776000657863d-07
#define CONV_mm3_boardf	4.23776000657863d-07
#define CONV_mm3_bu	2.83775932584017d-08
#define CONV_mm3_bub	2.7496156037386d-08
#define CONV_mm3_buck	5.49923120747719d-08
#define CONV_mm3_cord	2.7589583376163d-10
#define CONV_mm3_cordft	2.20716667009304d-09
#define CONV_mm3_cup	7.62796801184153d-06
#define CONV_mm3_dra	0.000270512181614744d0
#define CONV_mm3_drach	0.000281560637822832d0
#define CONV_mm3_firkb	2.44410275887875d-08
#define CONV_mm3_firku	2.93524502620165d-08
#define CONV_mm3_floz	6.10237440947323d-05
#define CONV_mm3_ft3	3.53146667214886d-08
#define CONV_mm3_gal	2.64172052358148d-07
#define CONV_mm3_galb	2.19969248299088d-07
#define CONV_mm3_gald	2.27020746067214d-07
#define CONV_mm3_gill	8.45350567546075d-06
#define CONV_mm3_gillb	7.03901594557081d-06
#define CONV_mm3_in3	6.10237440947323d-05
#define CONV_mm3_mile3	2.39912758578928d-19
#define CONV_mm3_minim	0.0162307308968846d0
#define CONV_mm3_minimb	0.0168936382693699d0
#define CONV_mm3_ozbf	3.5195079727854d-05
#define CONV_mm3_peck	1.13510373033607d-07
#define CONV_mm3_peckb	1.09984624149544d-07
#define CONV_mm3_pt	2.11337641886519d-06
#define CONV_mm3_ptb	1.7597539863927d-06
#define CONV_mm3_ptd	1.81616596853771d-06
#define CONV_mm3_qt	1.05668820943259d-06
#define CONV_mm3_qtb	8.79876993196351d-07
#define CONV_mm3_qtd	9.08082984268856d-07
#define CONV_mm3_regton	3.53146667214886d-10
#define CONV_mm3_scrup	0.000844681913468497d0
#define CONV_mm3_seam	3.43701950467325d-09
#define CONV_mm3_yd3	1.30795061931439d-09
#define CONV_acreft_cc	1233481837.54752d0
#define CONV_acreft_cl	123348183.754752d0
#define CONV_acreft_cm3	1233481837.54752d0
#define CONV_acreft_cupm	6167409.1877376d0
#define CONV_acreft_dm3	1233481.83754752d0
#define CONV_acreft_km3	1.23348183754752d-06
#define CONV_acreft_l	1233481.83754752d0
#define CONV_acreft_litero	1233447.30102309d0
#define CONV_acreft_m3	1233.48183754752d0
#define CONV_acreft_ml	1233481837.54752d0
#define CONV_acreft_mm3	1233481837547.52d0
#define CONV_acreft_acrein	12d0
#define CONV_acreft_bag	11305.3363581627d0
#define CONV_acreft_bbl	7758.36734693877d0
#define CONV_acreft_bblbb	7536.89090544182d0
#define CONV_acreft_bblbw	8613.58960621922d0
#define CONV_acreft_bbluc	12919.9588053553d0
#define CONV_acreft_bblud	10667.7551020408d0
#define CONV_acreft_bblul	10344.4897959184d0
#define CONV_acreft_board	522720d0
#define CONV_acreft_boardf	522720d0
#define CONV_acreft_bu	35003.2458775495d0
#define CONV_acreft_bub	33916.0090744882d0
#define CONV_acreft_buck	67832.0181489764d0
#define CONV_acreft_cord	340.3125d0
#define CONV_acreft_cordft	2722.5d0
#define CONV_acreft_cup	9408960d0
#define CONV_acreft_dra	333671862.857143d0
#define CONV_acreft_drach	347299932.922759d0
#define CONV_acreft_firkb	30147.5636217673d0
#define CONV_acreft_firku	36205.7142857143d0
#define CONV_acreft_floz	75271680d0
#define CONV_acreft_ft3	43560d0
#define CONV_acreft_gal	325851.428571429d0
#define CONV_acreft_galb	271328.072595906d0
#define CONV_acreft_gald	280025.967020396d0
#define CONV_acreft_gill	10427245.7142857d0
#define CONV_acreft_gillb	8682498.32306898d0
#define CONV_acreft_in3	75271680d0
#define CONV_acreft_mile3	2.9592803030303d-07
#define CONV_acreft_minim	20020311771.4286d0
#define CONV_acreft_minimb	20837995975.3655d0
#define CONV_acreft_ozbf	43412491.6153449d0
#define CONV_acreft_peck	140012.983510198d0
#define CONV_acreft_peckb	135664.036297953d0
#define CONV_acreft_pt	2606811.42857143d0
#define CONV_acreft_ptb	2170624.58076724d0
#define CONV_acreft_ptd	2240207.73616317d0
#define CONV_acreft_qt	1303405.71428571d0
#define CONV_acreft_qtb	1085312.29038362d0
#define CONV_acreft_qtd	1120103.86808158d0
#define CONV_acreft_regton	435.6d0
#define CONV_acreft_scrup	1041899798.76828d0
#define CONV_acreft_seam	4239.50113431102d0
#define CONV_acreft_yd3	1613.33333333333d0
#define CONV_acrein_cc	102790153.12896d0
#define CONV_acrein_cl	10279015.312896d0
#define CONV_acrein_cm3	102790153.12896d0
#define CONV_acrein_cupm	513950.7656448d0
#define CONV_acrein_dm3	102790.15312896d0
#define CONV_acrein_km3	1.0279015312896d-07
#define CONV_acrein_l	102790.15312896d0
#define CONV_acrein_litero	102787.275085258d0
#define CONV_acrein_m3	102.79015312896d0
#define CONV_acrein_ml	102790153.12896d0
#define CONV_acrein_mm3	102790153128.96d0
#define CONV_acrein_acreft	0.0833333333333333d0
#define CONV_acrein_bag	942.111363180228d0
#define CONV_acrein_bbl	646.530612244898d0
#define CONV_acrein_bblbb	628.074242120152d0
#define CONV_acrein_bblbw	717.799133851602d0
#define CONV_acrein_bbluc	1076.66323377961d0
#define CONV_acrein_bblud	888.979591836735d0
#define CONV_acrein_bblul	862.040816326531d0
#define CONV_acrein_board	43560d0
#define CONV_acrein_boardf	43560d0
#define CONV_acrein_bu	2916.93715646246d0
#define CONV_acrein_bub	2826.33408954068d0
#define CONV_acrein_buck	5652.66817908137d0
#define CONV_acrein_cord	28.359375d0
#define CONV_acrein_cordft	226.875d0
#define CONV_acrein_cup	784080d0
#define CONV_acrein_dra	27805988.5714286d0
#define CONV_acrein_drach	28941661.0768966d0
#define CONV_acrein_firkb	2512.29696848061d0
#define CONV_acrein_firku	3017.14285714286d0
#define CONV_acrein_floz	6272640d0
#define CONV_acrein_ft3	3630d0
#define CONV_acrein_gal	27154.2857142857d0
#define CONV_acrein_galb	22610.6727163255d0
#define CONV_acrein_gald	23335.4972516997d0
#define CONV_acrein_gill	868937.142857143d0
#define CONV_acrein_gillb	723541.526922415d0
#define CONV_acrein_in3	6272640d0
#define CONV_acrein_mile3	2.46606691919192d-08
#define CONV_acrein_minim	1668359314.28571d0
#define CONV_acrein_minimb	1736499664.6138d0
#define CONV_acrein_ozbf	3617707.63461207d0
#define CONV_acrein_peck	11667.7486258498d0
#define CONV_acrein_peckb	11305.3363581627d0
#define CONV_acrein_pt	217234.285714286d0
#define CONV_acrein_ptb	180885.381730604d0
#define CONV_acrein_ptd	186683.978013597d0
#define CONV_acrein_qt	108617.142857143d0
#define CONV_acrein_qtb	90442.6908653018d0
#define CONV_acrein_qtd	93341.9890067987d0
#define CONV_acrein_regton	36.3d0
#define CONV_acrein_scrup	86824983.2306898d0
#define CONV_acrein_seam	353.291761192585d0
#define CONV_acrein_yd3	134.444444444444d0
#define CONV_bag_cc	109106.16d0
#define CONV_bag_cl	10910.616d0
#define CONV_bag_cm3	109106.16d0
#define CONV_bag_cupm	545.5308d0
#define CONV_bag_dm3	109.10616d0
#define CONV_bag_km3	1.0910616d-10
#define CONV_bag_l	109.10616d0
#define CONV_bag_litero	109.103105113057d0
#define CONV_bag_m3	0.10910616d0
#define CONV_bag_ml	109106.16d0
#define CONV_bag_mm3	109106160d0
#define CONV_bag_acreft	8.84538034357532d-05
#define CONV_bag_acrein	0.00106144564122904d0
#define CONV_bag_bbl	0.686257100288488d0
#define CONV_bag_bblbb	0.666666666666667d0
#define CONV_bag_bblbw	0.761904761904762d0
#define CONV_bag_bbluc	1.14281949656693d0
#define CONV_bag_bblud	0.943603512896672d0
#define CONV_bag_bblul	0.915009467051318d0
#define CONV_bag_board	46.2365721319369d0
#define CONV_bag_boardf	46.2365721319369d0
#define CONV_bag_bu	3.0961702304661d0
#define CONV_bag_bub	3d0
#define CONV_bag_buck	6d0
#define CONV_bag_cord	0.0301019349817298d0
#define CONV_bag_cordft	0.240815479853838d0
#define CONV_bag_cup	832.258298374864d0
#define CONV_bag_dra	29514.5453692073d0
#define CONV_bag_drach	30720d0
#define CONV_bag_firkb	2.66666666666667d0
#define CONV_bag_firku	3.20253313467961d0
#define CONV_bag_floz	6658.06638699891d0
#define CONV_bag_ft3	3.85304767766141d0
#define CONV_bag_gal	28.8227982121165d0
#define CONV_bag_galb	24d0
#define CONV_bag_gald	24.7693618437288d0
#define CONV_bag_gill	922.329542787728d0
#define CONV_bag_gillb	768d0
#define CONV_bag_in3	6658.06638699891d0
#define CONV_bag_mile3	2.61759598235538d-11
#define CONV_bag_minim	1770872.72215244d0
#define CONV_bag_minimb	1843200d0
#define CONV_bag_ozbf	3840d0
#define CONV_bag_peck	12.3846809218644d0
#define CONV_bag_peckb	12d0
#define CONV_bag_pt	230.582385696932d0
#define CONV_bag_ptb	192d0
#define CONV_bag_ptd	198.15489474983d0
#define CONV_bag_qt	115.291192848466d0
#define CONV_bag_qtb	96d0
#define CONV_bag_qtd	99.0774473749152d0
#define CONV_bag_regton	0.0385304767766141d0
#define CONV_bag_scrup	92160d0
#define CONV_bag_seam	0.375d0
#define CONV_bag_yd3	0.142705469543015d0
#define CONV_bbl_cc	158987.294928d0
#define CONV_bbl_cl	15898.7294928d0
#define CONV_bbl_cm3	158987.294928d0
#define CONV_bbl_cupm	794.93647464d0
#define CONV_bbl_dm3	158.987294928d0
#define CONV_bbl_km3	1.58987294928d-10
#define CONV_bbl_l	158.987294928d0
#define CONV_bbl_litero	158.982843408385d0
#define CONV_bbl_m3	0.158987294928d0
#define CONV_bbl_ml	158987.294928d0
#define CONV_bbl_mm3	158987294.928d0
#define CONV_bbl_acreft	0.000128893097643098d0
#define CONV_bbl_acrein	0.00154671717171717d0
#define CONV_bbl_bag	1.45717982310073d0
#define CONV_bbl_bblbb	0.971453215400487d0
#define CONV_bbl_bblbw	1.11023224617199d0
#define CONV_bbl_bbluc	1.66529351184346d0
#define CONV_bbl_bblud	1.375d0
#define CONV_bbl_bblul	1.33333333333333d0
#define CONV_bbl_board	67.375d0
#define CONV_bbl_boardf	67.375d0
#define CONV_bbl_bu	4.51167678872034d0
#define CONV_bbl_bub	4.37153946930219d0
#define CONV_bbl_buck	8.74307893860439d0
#define CONV_bbl_cord	0.0438639322916667d0
#define CONV_bbl_cordft	0.350911458333333d0
#define CONV_bbl_cup	1212.75d0
#define CONV_bbl_dra	43008d0
#define CONV_bbl_drach	44764.5641656545d0
#define CONV_bbl_firkb	3.88581286160195d0
#define CONV_bbl_firku	4.66666666666667d0
#define CONV_bbl_floz	9702d0
#define CONV_bbl_ft3	5.61458333333333d0
#define CONV_bbl_gal	42d0
#define CONV_bbl_galb	34.9723157544175d0
#define CONV_bbl_gald	36.0934143097627d0
#define CONV_bbl_gill	1344d0
#define CONV_bbl_gillb	1119.11410414136d0
#define CONV_bbl_in3	9702d0
#define CONV_bbl_mile3	3.8143080505178d-11
#define CONV_bbl_minim	2580480d0
#define CONV_bbl_minimb	2685873.84993927d0
#define CONV_bbl_ozbf	5595.57052070681d0
#define CONV_bbl_peck	18.0467071548814d0
#define CONV_bbl_peckb	17.4861578772088d0
#define CONV_bbl_pt	336d0
#define CONV_bbl_ptb	279.77852603534d0
#define CONV_bbl_ptd	288.747314478102d0
#define CONV_bbl_qt	168d0
#define CONV_bbl_qtb	139.88926301767d0
#define CONV_bbl_qtd	144.373657239051d0
#define CONV_bbl_regton	0.0561458333333333d0
#define CONV_bbl_scrup	134293.692496963d0
#define CONV_bbl_seam	0.546442433662774d0
#define CONV_bbl_yd3	0.207947530864197d0
#define CONV_bblbb_cc	163659.24d0
#define CONV_bblbb_cl	16365.924d0
#define CONV_bblbb_cm3	163659.24d0
#define CONV_bblbb_cupm	818.2962d0
#define CONV_bblbb_dm3	163.65924d0
#define CONV_bblbb_km3	1.6365924d-10
#define CONV_bblbb_l	163.65924d0
#define CONV_bblbb_litero	163.654657669585d0
#define CONV_bblbb_m3	0.16365924d0
#define CONV_bblbb_ml	163659.24d0
#define CONV_bblbb_mm3	163659240d0
#define CONV_bblbb_acreft	0.00013268070515363d0
#define CONV_bblbb_acrein	0.00159216846184356d0
#define CONV_bblbb_bag	1.5d0
#define CONV_bblbb_bbl	1.02938565043273d0
#define CONV_bblbb_bblbw	1.14285714285714d0
#define CONV_bblbb_bbluc	1.71422924485039d0
#define CONV_bblbb_bblud	1.41540526934501d0
#define CONV_bblbb_bblul	1.37251420057698d0
#define CONV_bblbb_board	69.3548581979053d0
#define CONV_bblbb_boardf	69.3548581979053d0
#define CONV_bblbb_bu	4.64425534569915d0
#define CONV_bblbb_bub	4.5d0
#define CONV_bblbb_buck	9d0
#define CONV_bblbb_cord	0.0451529024725946d0
#define CONV_bblbb_cordft	0.361223219780757d0
#define CONV_bblbb_cup	1248.3874475623d0
#define CONV_bblbb_dra	44271.818053811d0
#define CONV_bblbb_drach	46080d0
#define CONV_bblbb_firkb	4d0
#define CONV_bblbb_firku	4.80379970201942d0
#define CONV_bblbb_floz	9987.09958049837d0
#define CONV_bblbb_ft3	5.77957151649211d0
#define CONV_bblbb_gal	43.2341973181748d0
#define CONV_bblbb_galb	36d0
#define CONV_bblbb_gald	37.1540427655932d0
#define CONV_bblbb_gill	1383.49431418159d0
#define CONV_bblbb_gillb	1152d0
#define CONV_bblbb_in3	9987.09958049837d0
#define CONV_bblbb_mile3	3.92639397353308d-11
#define CONV_bblbb_minim	2656309.08322866d0
#define CONV_bblbb_minimb	2764800d0
#define CONV_bblbb_ozbf	5760d0
#define CONV_bblbb_peck	18.5770213827966d0
#define CONV_bblbb_peckb	18d0
#define CONV_bblbb_pt	345.873578545398d0
#define CONV_bblbb_ptb	288d0
#define CONV_bblbb_ptd	297.232342124746d0
#define CONV_bblbb_qt	172.936789272699d0
#define CONV_bblbb_qtb	144d0
#define CONV_bblbb_qtd	148.616171062373d0
#define CONV_bblbb_regton	0.0577957151649211d0
#define CONV_bblbb_scrup	138240d0
#define CONV_bblbb_seam	0.5625d0
#define CONV_bblbb_yd3	0.214058204314523d0
#define CONV_bblbw_cc	143201.835d0
#define CONV_bblbw_cl	14320.1835d0
#define CONV_bblbw_cm3	143201.835d0
#define CONV_bblbw_cupm	716.009175d0
#define CONV_bblbw_dm3	143.201835d0
#define CONV_bblbw_km3	1.43201835d-10
#define CONV_bblbw_l	143.201835d0
#define CONV_bblbw_litero	143.197825460887d0
#define CONV_bblbw_m3	0.143201835d0
#define CONV_bblbw_ml	143201.835d0
#define CONV_bblbw_mm3	143201835d0
#define CONV_bblbw_acreft	0.000116095617009426d0
#define CONV_bblbw_acrein	0.00139314740411311d0
#define CONV_bblbw_bag	1.3125d0
#define CONV_bblbw_bbl	0.900712444128641d0
#define CONV_bblbw_bblbb	0.875d0
#define CONV_bblbw_bbluc	1.49995058924409d0
#define CONV_bblbw_bblud	1.23847961067688d0
#define CONV_bblbw_bblul	1.20094992550485d0
#define CONV_bblbw_board	60.6855009231672d0
#define CONV_bblbw_boardf	60.6855009231672d0
#define CONV_bblbw_bu	4.06372342748676d0
#define CONV_bblbw_bub	3.9375d0
#define CONV_bblbw_buck	7.875d0
#define CONV_bblbw_cord	0.0395087896635203d0
#define CONV_bblbw_cordft	0.316070317308162d0
#define CONV_bblbw_cup	1092.33901661701d0
#define CONV_bblbw_dra	38737.8407970846d0
#define CONV_bblbw_drach	40320d0
#define CONV_bblbw_firkb	3.5d0
#define CONV_bblbw_firku	4.20332473926699d0
#define CONV_bblbw_floz	8738.71213293607d0
#define CONV_bblbw_ft3	5.0571250769306d0
#define CONV_bblbw_gal	37.8299226534029d0
#define CONV_bblbw_galb	31.5d0
#define CONV_bblbw_gald	32.5097874198941d0
#define CONV_bblbw_gill	1210.55752490889d0
#define CONV_bblbw_gillb	1008d0
#define CONV_bblbw_in3	8738.71213293607d0
#define CONV_bblbw_mile3	3.43559472684144d-11
#define CONV_bblbw_minim	2324270.44782508d0
#define CONV_bblbw_minimb	2419200d0
#define CONV_bblbw_ozbf	5040d0
#define CONV_bblbw_peck	16.254893709947d0
#define CONV_bblbw_peckb	15.75d0
#define CONV_bblbw_pt	302.639381227223d0
#define CONV_bblbw_ptb	252d0
#define CONV_bblbw_ptd	260.078299359152d0
#define CONV_bblbw_qt	151.319690613612d0
#define CONV_bblbw_qtb	126d0
#define CONV_bblbw_qtd	130.039149679576d0
#define CONV_bblbw_regton	0.050571250769306d0
#define CONV_bblbw_scrup	120960d0
#define CONV_bblbw_seam	0.4921875d0
#define CONV_bblbw_yd3	0.187300928775207d0
#define CONV_bbluc_cc	95471.034864d0
#define CONV_bbluc_cl	9547.1034864d0
#define CONV_bbluc_cm3	95471.034864d0
#define CONV_bbluc_cupm	477.35517432d0
#define CONV_bbluc_dm3	95.471034864d0
#define CONV_bbluc_km3	9.5471034864d-11
#define CONV_bbluc_l	95.471034864d0
#define CONV_bbluc_litero	95.468361749871d0
#define CONV_bbluc_m3	0.095471034864d0
#define CONV_bbluc_ml	95471.034864d0
#define CONV_bbluc_mm3	95471034.864d0
#define CONV_bbluc_acreft	7.73996275890215d-05
#define CONV_bbluc_acrein	0.000928795531068258d0
#define CONV_bbluc_bag	0.87502882389042d0
#define CONV_bbluc_bbl	0.600494743351886d0
#define CONV_bbluc_bblbb	0.58335254926028d0
#define CONV_bbluc_bblbw	0.666688627726035d0
#define CONV_bbluc_bblud	0.825680272108844d0
#define CONV_bbluc_bblul	0.800659657802515d0
#define CONV_bbluc_board	40.4583333333333d0
#define CONV_bbluc_boardf	40.4583333333333d0
#define CONV_bbluc_bu	2.70923819532928d0
#define CONV_bbluc_bub	2.62508647167126d0
#define CONV_bbluc_buck	5.25017294334252d0
#define CONV_bbluc_cord	0.0263400607638889d0
#define CONV_bbluc_cordft	0.210720486111111d0
#define CONV_bbluc_cup	728.25d0
#define CONV_bbluc_dra	25826.0779220779d0
#define CONV_bbluc_drach	26880.8854699137d0
#define CONV_bbluc_firkb	2.33341019704112d0
#define CONV_bbluc_firku	2.8023088023088d0
#define CONV_bbluc_floz	5826d0
#define CONV_bbluc_ft3	3.37152777777778d0
#define CONV_bbluc_gal	25.2207792207792d0
#define CONV_bbluc_galb	21.0006917733701d0
#define CONV_bbluc_gald	21.6739055626343d0
#define CONV_bbluc_gill	807.064935064935d0
#define CONV_bbluc_gillb	672.022136747843d0
#define CONV_bbluc_in3	5826d0
#define CONV_bbluc_mile3	2.29047193386072d-11
#define CONV_bbluc_minim	1549564.67532468d0
#define CONV_bbluc_minimb	1612853.12819482d0
#define CONV_bbluc_ozbf	3360.11068373921d0
#define CONV_bbluc_peck	10.8369527813171d0
#define CONV_bbluc_peckb	10.500345886685d0
#define CONV_bbluc_pt	201.766233766234d0
#define CONV_bbluc_ptb	168.005534186961d0
#define CONV_bbluc_ptd	173.391244501074d0
#define CONV_bbluc_qt	100.883116883117d0
#define CONV_bbluc_qtb	84.0027670934803d0
#define CONV_bbluc_qtd	86.6956222505371d0
#define CONV_bbluc_regton	0.0337152777777778d0
#define CONV_bbluc_scrup	80642.6564097411d0
#define CONV_bbluc_seam	0.328135808958908d0
#define CONV_bbluc_yd3	0.124871399176955d0
#define CONV_bblud_cc	115627.123584d0
#define CONV_bblud_cl	11562.7123584d0
#define CONV_bblud_cm3	115627.123584d0
#define CONV_bblud_cupm	578.13561792d0
#define CONV_bblud_dm3	115.627123584d0
#define CONV_bblud_km3	1.15627123584d-10
#define CONV_bblud_l	115.627123584d0
#define CONV_bblud_litero	115.623886115189d0
#define CONV_bblud_m3	0.115627123584d0
#define CONV_bblud_ml	115627.123584d0
#define CONV_bblud_mm3	115627123.584d0
#define CONV_bblud_acreft	9.37404346495256d-05
#define CONV_bblud_acrein	0.00112488521579431d0
#define CONV_bblud_bag	1.05976714407326d0
#define CONV_bblud_bbl	0.727272727272727d0
#define CONV_bblud_bblbb	0.706511429382173d0
#define CONV_bblud_bblbw	0.807441633579626d0
#define CONV_bblud_bbluc	1.21112255406797d0
#define CONV_bblud_bblul	0.96969696969697d0
#define CONV_bblud_board	49d0
#define CONV_bblud_boardf	49d0
#define CONV_bblud_bu	3.2812194827057d0
#define CONV_bblud_bub	3.17930143221978d0
#define CONV_bblud_buck	6.35860286443955d0
#define CONV_bblud_cord	0.0319010416666667d0
#define CONV_bblud_cordft	0.255208333333333d0
#define CONV_bblud_cup	882d0
#define CONV_bblud_dra	31278.5454545455d0
#define CONV_bblud_drach	32556.0466659305d0
#define CONV_bblud_firkb	2.82604571752869d0
#define CONV_bblud_firku	3.39393939393939d0
#define CONV_bblud_floz	7056d0
#define CONV_bblud_ft3	4.08333333333333d0
#define CONV_bblud_gal	30.5454545454545d0
#define CONV_bblud_galb	25.4344114577582d0
#define CONV_bblud_gald	26.2497558616456d0
#define CONV_bblud_gill	977.454545454545d0
#define CONV_bblud_gillb	813.901166648263d0
#define CONV_bblud_in3	7056d0
#define CONV_bblud_mile3	2.7740422185584d-11
#define CONV_bblud_minim	1876712.72727273d0
#define CONV_bblud_minimb	1953362.79995583d0
#define CONV_bblud_ozbf	4069.50583324131d0
#define CONV_bblud_peck	13.1248779308228d0
#define CONV_bblud_peckb	12.7172057288791d0
#define CONV_bblud_pt	244.363636363636d0
#define CONV_bblud_ptb	203.475291662066d0
#define CONV_bblud_ptd	209.998046893165d0
#define CONV_bblud_qt	122.181818181818d0
#define CONV_bblud_qtb	101.737645831033d0
#define CONV_bblud_qtd	104.999023446583d0
#define CONV_bblud_regton	0.0408333333333333d0
#define CONV_bblud_scrup	97668.1399977915d0
#define CONV_bblud_seam	0.397412679027472d0
#define CONV_bblud_yd3	0.151234567901235d0
#define CONV_bblul_cc	119240.471196d0
#define CONV_bblul_cl	11924.0471196d0
#define CONV_bblul_cm3	119240.471196d0
#define CONV_bblul_cupm	596.20235598d0
#define CONV_bblul_dm3	119.240471196d0
#define CONV_bblul_km3	1.19240471196d-10
#define CONV_bblul_l	119.240471196d0
#define CONV_bblul_litero	119.237132556288d0
#define CONV_bblul_m3	0.119240471196d0
#define CONV_bblul_ml	119240.471196d0
#define CONV_bblul_mm3	119240471.196d0
#define CONV_bblul_acreft	9.66698232323232d-05
#define CONV_bblul_acrein	0.00116003787878788d0
#define CONV_bblul_bag	1.09288486732555d0
#define CONV_bblul_bbl	0.75d0
#define CONV_bblul_bblbb	0.728589911550366d0
#define CONV_bblul_bblbw	0.832674184628989d0
#define CONV_bblul_bbluc	1.2489701338826d0
#define CONV_bblul_bblud	1.03125d0
#define CONV_bblul_board	50.53125d0
#define CONV_bblul_boardf	50.53125d0
#define CONV_bblul_bu	3.38375759154026d0
#define CONV_bblul_bub	3.27865460197664d0
#define CONV_bblul_buck	6.55730920395329d0
#define CONV_bblul_cord	0.03289794921875d0
#define CONV_bblul_cordft	0.26318359375d0
#define CONV_bblul_cup	909.5625d0
#define CONV_bblul_dra	32256d0
#define CONV_bblul_drach	33573.4231242408d0
#define CONV_bblul_firkb	2.91435964620146d0
#define CONV_bblul_firku	3.5d0
#define CONV_bblul_floz	7276.5d0
#define CONV_bblul_ft3	4.2109375d0
#define CONV_bblul_gal	31.5d0
#define CONV_bblul_galb	26.2292368158132d0
#define CONV_bblul_gald	27.0700607323221d0
#define CONV_bblul_gill	1008d0
#define CONV_bblul_gillb	839.335578106021d0
#define CONV_bblul_in3	7276.5d0
#define CONV_bblul_mile3	2.86073103788835d-11
#define CONV_bblul_minim	1935360d0
#define CONV_bblul_minimb	2014405.38745445d0
#define CONV_bblul_ozbf	4196.67789053011d0
#define CONV_bblul_peck	13.535030366161d0
#define CONV_bblul_peckb	13.1146184079066d0
#define CONV_bblul_pt	252d0
#define CONV_bblul_ptb	209.833894526505d0
#define CONV_bblul_ptd	216.560485858576d0
#define CONV_bblul_qt	126d0
#define CONV_bblul_qtb	104.916947263253d0
#define CONV_bblul_qtd	108.280242929288d0
#define CONV_bblul_regton	0.042109375d0
#define CONV_bblul_scrup	100720.269372723d0
#define CONV_bblul_seam	0.409831825247081d0
#define CONV_bblul_yd3	0.155960648148148d0
#define CONV_board_cc	2359.737216d0
#define CONV_board_cl	235.9737216d0
#define CONV_board_cm3	2359.737216d0
#define CONV_board_cupm	11.79868608d0
#define CONV_board_dm3	2.359737216d0
#define CONV_board_km3	2.359737216d-12
#define CONV_board_l	2.359737216d0
#define CONV_board_litero	2.35967114520794d0
#define CONV_board_m3	0.002359737216d0
#define CONV_board_ml	2359.737216d0
#define CONV_board_mm3	2359737.216d0
#define CONV_board_acreft	1.91307009488828d-06
#define CONV_board_acrein	2.29568411386593d-05
#define CONV_board_bag	0.0216279008994543d0
#define CONV_board_bbl	0.0148423005565863d0
#define CONV_board_bblbb	0.0144186005996362d0
#define CONV_board_bblbw	0.0164784006852985d0
#define CONV_board_bbluc	0.0247167868177137d0
#define CONV_board_bblud	0.0204081632653061d0
#define CONV_board_bblul	0.0197897340754484d0
#define CONV_board_boardf	1d0
#define CONV_board_bu	0.0669636629123613d0
#define CONV_board_bub	0.0648837026983628d0
#define CONV_board_buck	0.129767405396726d0
#define CONV_board_cord	0.000651041666666667d0
#define CONV_board_cordft	0.00520833333333333d0
#define CONV_board_cup	18d0
#define CONV_board_dra	638.337662337662d0
#define CONV_board_drach	664.409115631235d0
#define CONV_board_firkb	0.0576744023985447d0
#define CONV_board_firku	0.0692640692640692d0
#define CONV_board_floz	144d0
#define CONV_board_ft3	0.0833333333333333d0
#define CONV_board_gal	0.623376623376623d0
#define CONV_board_galb	0.519069621586902d0
#define CONV_board_gald	0.53570930329889d0
#define CONV_board_gill	19.9480519480519d0
#define CONV_board_gillb	16.6102278907809d0
#define CONV_board_in3	144d0
#define CONV_board_mile3	5.66131065011919d-13
#define CONV_board_minim	38300.2597402597d0
#define CONV_board_minimb	39864.5469378741d0
#define CONV_board_ozbf	83.0511394539044d0
#define CONV_board_peck	0.267854651649445d0
#define CONV_board_peckb	0.259534810793451d0
#define CONV_board_pt	4.98701298701299d0
#define CONV_board_ptb	4.15255697269522d0
#define CONV_board_ptd	4.28567442639112d0
#define CONV_board_qt	2.49350649350649d0
#define CONV_board_qtb	2.07627848634761d0
#define CONV_board_qtd	2.14283721319556d0
#define CONV_board_regton	0.000833333333333333d0
#define CONV_board_scrup	1993.2273468937d0
#define CONV_board_seam	0.00811046283729535d0
#define CONV_board_yd3	0.00308641975308642d0
#define CONV_boardf_cc	2359.737216d0
#define CONV_boardf_cl	235.9737216d0
#define CONV_boardf_cm3	2359.737216d0
#define CONV_boardf_cupm	11.79868608d0
#define CONV_boardf_dm3	2.359737216d0
#define CONV_boardf_km3	2.359737216d-12
#define CONV_boardf_l	2.359737216d0
#define CONV_boardf_litero	2.35967114520794d0
#define CONV_boardf_m3	0.002359737216d0
#define CONV_boardf_ml	2359.737216d0
#define CONV_boardf_mm3	2359737.216d0
#define CONV_boardf_acreft	1.91307009488828d-06
#define CONV_boardf_acrein	2.29568411386593d-05
#define CONV_boardf_bag	0.0216279008994543d0
#define CONV_boardf_bbl	0.0148423005565863d0
#define CONV_boardf_bblbb	0.0144186005996362d0
#define CONV_boardf_bblbw	0.0164784006852985d0
#define CONV_boardf_bbluc	0.0247167868177137d0
#define CONV_boardf_bblud	0.0204081632653061d0
#define CONV_boardf_bblul	0.0197897340754484d0
#define CONV_boardf_board	1d0
#define CONV_boardf_bu	0.0669636629123613d0
#define CONV_boardf_bub	0.0648837026983628d0
#define CONV_boardf_buck	0.129767405396726d0
#define CONV_boardf_cord	0.000651041666666667d0
#define CONV_boardf_cordft	0.00520833333333333d0
#define CONV_boardf_cup	18d0
#define CONV_boardf_dra	638.337662337662d0
#define CONV_boardf_drach	664.409115631235d0
#define CONV_boardf_firkb	0.0576744023985447d0
#define CONV_boardf_firku	0.0692640692640692d0
#define CONV_boardf_floz	144d0
#define CONV_boardf_ft3	0.0833333333333333d0
#define CONV_boardf_gal	0.623376623376623d0
#define CONV_boardf_galb	0.519069621586902d0
#define CONV_boardf_gald	0.53570930329889d0
#define CONV_boardf_gill	19.9480519480519d0
#define CONV_boardf_gillb	16.6102278907809d0
#define CONV_boardf_in3	144d0
#define CONV_boardf_mile3	5.66131065011919d-13
#define CONV_boardf_minim	38300.2597402597d0
#define CONV_boardf_minimb	39864.5469378741d0
#define CONV_boardf_ozbf	83.0511394539044d0
#define CONV_boardf_peck	0.267854651649445d0
#define CONV_boardf_peckb	0.259534810793451d0
#define CONV_boardf_pt	4.98701298701299d0
#define CONV_boardf_ptb	4.15255697269522d0
#define CONV_boardf_ptd	4.28567442639112d0
#define CONV_boardf_qt	2.49350649350649d0
#define CONV_boardf_qtb	2.07627848634761d0
#define CONV_boardf_qtd	2.14283721319556d0
#define CONV_boardf_regton	0.000833333333333333d0
#define CONV_boardf_scrup	1993.2273468937d0
#define CONV_boardf_seam	0.00811046283729535d0
#define CONV_boardf_yd3	0.00308641975308642d0
#define CONV_bu_cc	35239.07016688d0
#define CONV_bu_cl	3523.907016688d0
#define CONV_bu_cm3	35239.07016688d0
#define CONV_bu_cupm	176.1953508344d0
#define CONV_bu_dm3	35.23907016688d0
#define CONV_bu_km3	3.523907016688d-11
#define CONV_bu_l	35.23907016688d0
#define CONV_bu_litero	35.238083500542d0
#define CONV_bu_m3	0.03523907016688d0
#define CONV_bu_ml	35239.07016688d0
#define CONV_bu_mm3	35239070.16688d0
#define CONV_bu_acreft	2.85687791211781d-05
#define CONV_bu_acrein	0.000342825349454137d0
#define CONV_bu_bag	0.322979657306975d0
#define CONV_bu_bbl	0.221647083075655d0
#define CONV_bu_bblbb	0.215319771537984d0
#define CONV_bu_bblbw	0.246079738900553d0
#define CONV_bu_bbluc	0.369107449364916d0
#define CONV_bu_bblud	0.304764739229025d0
#define CONV_bu_bblul	0.295529444100873d0
#define CONV_bu_board	14.9334722222222d0
#define CONV_bu_boardf	14.9334722222222d0
#define CONV_bu_bub	0.968938971920926d0
#define CONV_bu_buck	1.93787794384185d0
#define CONV_bu_cord	0.00972231264467593d0
#define CONV_bu_cordft	0.0777785011574074d0
#define CONV_bu_cup	268.8025d0
#define CONV_bu_dra	9532.59774891775d0
#define CONV_bu_drach	9921.93507247028d0
#define CONV_bu_firkb	0.861279086151934d0
#define CONV_bu_firku	1.03435305435305d0
#define CONV_bu_floz	2150.42d0
#define CONV_bu_ft3	1.24445601851852d0
#define CONV_bu_gal	9.30917748917749d0
#define CONV_bu_galb	7.75151177536741d0
#define CONV_bu_gald	8d0
#define CONV_bu_gill	297.89367965368d0
#define CONV_bu_gillb	248.048376811757d0
#define CONV_bu_in3	2150.42d0
#define CONV_bu_mile3	8.45430253349258d-12
#define CONV_bu_minim	571955.864935065d0
#define CONV_bu_minimb	595316.104348217d0
#define CONV_bu_ozbf	1240.24188405878d0
#define CONV_bu_peck	4d0
#define CONV_bu_peckb	3.8757558876837d0
#define CONV_bu_pt	74.4734199134199d0
#define CONV_bu_ptb	62.0120942029392d0
#define CONV_bu_ptd	64d0
#define CONV_bu_qt	37.23670995671d0
#define CONV_bu_qtb	31.0060471014696d0
#define CONV_bu_qtd	32d0
#define CONV_bu_regton	0.0124445601851852d0
#define CONV_bu_scrup	29765.8052174108d0
#define CONV_bu_seam	0.121117371490116d0
#define CONV_bu_yd3	0.046090963648834d0
#define CONV_bub_cc	36368.72d0
#define CONV_bub_cl	3636.872d0
#define CONV_bub_cm3	36368.72d0
#define CONV_bub_cupm	181.8436d0
#define CONV_bub_dm3	36.36872d0
#define CONV_bub_km3	3.636872d-11
#define CONV_bub_l	36.36872d0
#define CONV_bub_litero	36.3677017043523d0
#define CONV_bub_m3	0.03636872d0
#define CONV_bub_ml	36368.72d0
#define CONV_bub_mm3	36368720d0
#define CONV_bub_acreft	2.94846011452511d-05
#define CONV_bub_acrein	0.000353815213743013d0
#define CONV_bub_bag	0.333333333333333d0
#define CONV_bub_bbl	0.228752366762829d0
#define CONV_bub_bblbb	0.222222222222222d0
#define CONV_bub_bblbw	0.253968253968254d0
#define CONV_bub_bbluc	0.380939832188976d0
#define CONV_bub_bblud	0.314534504298891d0
#define CONV_bub_bblul	0.305003155683773d0
#define CONV_bub_board	15.4121907106456d0
#define CONV_bub_boardf	15.4121907106456d0
#define CONV_bub_bu	1.0320567434887d0
#define CONV_bub_buck	2d0
#define CONV_bub_cord	0.0100339783272433d0
#define CONV_bub_cordft	0.080271826617946d0
#define CONV_bub_cup	277.419432791621d0
#define CONV_bub_dra	9838.18178973577d0
#define CONV_bub_drach	10240d0
#define CONV_bub_firkb	0.888888888888889d0
#define CONV_bub_firku	1.0675110448932d0
#define CONV_bub_floz	2219.35546233297d0
#define CONV_bub_ft3	1.28434922588714d0
#define CONV_bub_gal	9.60759940403884d0
#define CONV_bub_galb	8d0
#define CONV_bub_gald	8.2564539479096d0
#define CONV_bub_gill	307.443180929243d0
#define CONV_bub_gillb	256d0
#define CONV_bub_in3	2219.35546233297d0
#define CONV_bub_mile3	8.72531994118462d-12
#define CONV_bub_minim	590290.907384146d0
#define CONV_bub_minimb	614400d0
#define CONV_bub_ozbf	1280d0
#define CONV_bub_peck	4.1282269739548d0
#define CONV_bub_peckb	4d0
#define CONV_bub_pt	76.8607952323107d0
#define CONV_bub_ptb	64d0
#define CONV_bub_ptd	66.0516315832768d0
#define CONV_bub_qt	38.4303976161553d0
#define CONV_bub_qtb	32d0
#define CONV_bub_qtd	33.0258157916384d0
#define CONV_bub_regton	0.0128434922588714d0
#define CONV_bub_scrup	30720d0
#define CONV_bub_seam	0.125d0
#define CONV_bub_yd3	0.0475684898476717d0
#define CONV_buck_cc	18184.36d0
#define CONV_buck_cl	1818.436d0
#define CONV_buck_cm3	18184.36d0
#define CONV_buck_cupm	90.9218d0
#define CONV_buck_dm3	18.18436d0
#define CONV_buck_km3	1.818436d-11
#define CONV_buck_l	18.18436d0
#define CONV_buck_litero	18.1838508521761d0
#define CONV_buck_m3	0.01818436d0
#define CONV_buck_ml	18184.36d0
#define CONV_buck_mm3	18184360d0
#define CONV_buck_acreft	1.47423005726255d-05
#define CONV_buck_acrein	0.000176907606871506d0
#define CONV_buck_bag	0.166666666666667d0
#define CONV_buck_bbl	0.114376183381415d0
#define CONV_buck_bblbb	0.111111111111111d0
#define CONV_buck_bblbw	0.126984126984127d0
#define CONV_buck_bbluc	0.190469916094488d0
#define CONV_buck_bblud	0.157267252149445d0
#define CONV_buck_bblul	0.152501577841886d0
#define CONV_buck_board	7.70609535532282d0
#define CONV_buck_boardf	7.70609535532282d0
#define CONV_buck_bu	0.51602837174435d0
#define CONV_buck_bub	0.5d0
#define CONV_buck_cord	0.00501698916362163d0
#define CONV_buck_cordft	0.040135913308973d0
#define CONV_buck_cup	138.709716395811d0
#define CONV_buck_dra	4919.09089486788d0
#define CONV_buck_drach	5120d0
#define CONV_buck_firkb	0.444444444444444d0
#define CONV_buck_firku	0.533755522446602d0
#define CONV_buck_floz	1109.67773116649d0
#define CONV_buck_ft3	0.642174612943568d0
#define CONV_buck_gal	4.80379970201942d0
#define CONV_buck_galb	4d0
#define CONV_buck_gald	4.1282269739548d0
#define CONV_buck_gill	153.721590464621d0
#define CONV_buck_gillb	128d0
#define CONV_buck_in3	1109.67773116649d0
#define CONV_buck_mile3	4.36265997059231d-12
#define CONV_buck_minim	295145.453692073d0
#define CONV_buck_minimb	307200d0
#define CONV_buck_ozbf	640d0
#define CONV_buck_peck	2.0641134869774d0
#define CONV_buck_peckb	2d0
#define CONV_buck_pt	38.4303976161553d0
#define CONV_buck_ptb	32d0
#define CONV_buck_ptd	33.0258157916384d0
#define CONV_buck_qt	19.2151988080777d0
#define CONV_buck_qtb	16d0
#define CONV_buck_qtd	16.5129078958192d0
#define CONV_buck_regton	0.00642174612943568d0
#define CONV_buck_scrup	15360d0
#define CONV_buck_seam	0.0625d0
#define CONV_buck_yd3	0.0237842449238359d0
#define CONV_cord_cc	3624556.363776d0
#define CONV_cord_cl	362455.6363776d0
#define CONV_cord_cm3	3624556.363776d0
#define CONV_cord_cupm	18122.78181888d0
#define CONV_cord_dm3	3624.556363776d0
#define CONV_cord_km3	3.624556363776d-09
#define CONV_cord_l	3624.556363776d0
#define CONV_cord_litero	3624.45487903939d0
#define CONV_cord_m3	3.624556363776d0
#define CONV_cord_ml	3624556.363776d0
#define CONV_cord_mm3	3624556363.776d0
#define CONV_cord_acreft	0.00293847566574839d0
#define CONV_cord_acrein	0.0352617079889807d0
#define CONV_cord_bag	33.2204557815617d0
#define CONV_cord_bbl	22.7977736549165d0
#define CONV_cord_bblbb	22.1469705210412d0
#define CONV_cord_bblbw	25.3108234526185d0
#define CONV_cord_bbluc	37.9649845520082d0
#define CONV_cord_bblud	31.3469387755102d0
#define CONV_cord_bblul	30.3970315398887d0
#define CONV_cord_board	1536d0
#define CONV_cord_boardf	1536d0
#define CONV_cord_bu	102.856186233387d0
#define CONV_cord_bub	99.6613673446852d0
#define CONV_cord_buck	199.32273468937d0
#define CONV_cord_cordft	8d0
#define CONV_cord_cup	27648d0
#define CONV_cord_dra	980486.649350649d0
#define CONV_cord_drach	1020532.40160958d0
#define CONV_cord_firkb	88.5878820841646d0
#define CONV_cord_firku	106.38961038961d0
#define CONV_cord_floz	221184d0
#define CONV_cord_ft3	128d0
#define CONV_cord_gal	957.506493506493d0
#define CONV_cord_galb	797.290938757482d0
#define CONV_cord_gald	822.849489867096d0
#define CONV_cord_gill	30640.2077922078d0
#define CONV_cord_gillb	25513.3100402394d0
#define CONV_cord_in3	221184d0
#define CONV_cord_mile3	8.69577315858308d-10
#define CONV_cord_minim	58829198.9610389d0
#define CONV_cord_minimb	61231944.0965746d0
#define CONV_cord_ozbf	127566.550201197d0
#define CONV_cord_peck	411.424744933548d0
#define CONV_cord_peckb	398.645469378741d0
#define CONV_cord_pt	7660.05194805195d0
#define CONV_cord_ptb	6378.32751005985d0
#define CONV_cord_ptd	6582.79591893676d0
#define CONV_cord_qt	3830.02597402597d0
#define CONV_cord_qtb	3189.16375502993d0
#define CONV_cord_qtd	3291.39795946838d0
#define CONV_cord_regton	1.28d0
#define CONV_cord_scrup	3061597.20482873d0
#define CONV_cord_seam	12.4576709180857d0
#define CONV_cord_yd3	4.74074074074074d0
#define CONV_cordft_cc	453069.545472d0
#define CONV_cordft_cl	45306.9545472d0
#define CONV_cordft_cm3	453069.545472d0
#define CONV_cordft_cupm	2265.34772736d0
#define CONV_cordft_dm3	453.069545472d0
#define CONV_cordft_km3	4.53069545472d-10
#define CONV_cordft_l	453.069545472d0
#define CONV_cordft_litero	453.056859879924d0
#define CONV_cordft_m3	0.453069545472d0
#define CONV_cordft_ml	453069.545472d0
#define CONV_cordft_mm3	453069545.472d0
#define CONV_cordft_acreft	0.000367309458218549d0
#define CONV_cordft_acrein	0.00440771349862259d0
#define CONV_cordft_bag	4.15255697269522d0
#define CONV_cordft_bbl	2.84972170686456d0
#define CONV_cordft_bblbb	2.76837131513015d0
#define CONV_cordft_bblbw	3.16385293157731d0
#define CONV_cordft_bbluc	4.74562306900103d0
#define CONV_cordft_bblud	3.91836734693878d0
#define CONV_cordft_bblul	3.79962894248609d0
#define CONV_cordft_board	192d0
#define CONV_cordft_boardf	192d0
#define CONV_cordft_bu	12.8570232791734d0
#define CONV_cordft_bub	12.4576709180857d0
#define CONV_cordft_buck	24.9153418361713d0
#define CONV_cordft_cord	0.125d0
#define CONV_cordft_cup	3456d0
#define CONV_cordft_dra	122560.831168831d0
#define CONV_cordft_drach	127566.550201197d0
#define CONV_cordft_firkb	11.0734852605206d0
#define CONV_cordft_firku	13.2987012987013d0
#define CONV_cordft_floz	27648d0
#define CONV_cordft_ft3	16d0
#define CONV_cordft_gal	119.688311688312d0
#define CONV_cordft_galb	99.6613673446852d0
#define CONV_cordft_gald	102.856186233387d0
#define CONV_cordft_gill	3830.02597402597d0
#define CONV_cordft_gillb	3189.16375502993d0
#define CONV_cordft_in3	27648d0
#define CONV_cordft_mile3	1.08697164482288d-10
#define CONV_cordft_minim	7353649.87012987d0
#define CONV_cordft_minimb	7653993.01207183d0
#define CONV_cordft_ozbf	15945.8187751496d0
#define CONV_cordft_peck	51.4280931166935d0
#define CONV_cordft_peckb	49.8306836723426d0
#define CONV_cordft_pt	957.506493506493d0
#define CONV_cordft_ptb	797.290938757482d0
#define CONV_cordft_ptd	822.849489867096d0
#define CONV_cordft_qt	478.753246753247d0
#define CONV_cordft_qtb	398.645469378741d0
#define CONV_cordft_qtd	411.424744933548d0
#define CONV_cordft_regton	0.16d0
#define CONV_cordft_scrup	382699.650603591d0
#define CONV_cordft_seam	1.55720886476071d0
#define CONV_cordft_yd3	0.592592592592592d0
#define CONV_cup_cc	131.096512d0
#define CONV_cup_cl	13.1096512d0
#define CONV_cup_cm3	131.096512d0
#define CONV_cup_cupm	0.65548256d0
#define CONV_cup_dm3	0.131096512d0
#define CONV_cup_km3	1.31096512d-13
#define CONV_cup_l	0.131096512d0
#define CONV_cup_litero	0.131092841400441d0
#define CONV_cup_m3	0.000131096512d0
#define CONV_cup_ml	131.096512d0
#define CONV_cup_mm3	131096.512d0
#define CONV_cup_acreft	1.06281671938238d-07
#define CONV_cup_acrein	1.27538006325885d-06
#define CONV_cup_bag	0.00120155004996968d0
#define CONV_cup_bbl	0.000824572253143682d0
#define CONV_cup_bblbb	0.000801033366646454d0
#define CONV_cup_bblbw	0.000915466704738805d0
#define CONV_cup_bbluc	0.00137315482320632d0
#define CONV_cup_bblud	0.00113378684807256d0
#define CONV_cup_bblul	0.00109942967085824d0
#define CONV_cup_board	0.0555555555555556d0
#define CONV_cup_boardf	0.0555555555555556d0
#define CONV_cup_bu	0.00372020349513118d0
#define CONV_cup_bub	0.00360465014990904d0
#define CONV_cup_buck	0.00720930029981809d0
#define CONV_cup_cord	3.61689814814815d-05
#define CONV_cup_cordft	0.000289351851851852d0
#define CONV_cup_dra	35.4632034632035d0
#define CONV_cup_drach	36.9116175350686d0
#define CONV_cup_firkb	0.00320413346658582d0
#define CONV_cup_firku	0.00384800384800385d0
#define CONV_cup_floz	8d0
#define CONV_cup_ft3	0.00462962962962963d0
#define CONV_cup_gal	0.0346320346320346d0
#define CONV_cup_galb	0.0288372011992723d0
#define CONV_cup_gald	0.0297616279610495d0
#define CONV_cup_gill	1.10822510822511d0
#define CONV_cup_gillb	0.922790438376715d0
#define CONV_cup_in3	8d0
#define CONV_cup_mile3	3.14517258339955d-14
#define CONV_cup_minim	2127.79220779221d0
#define CONV_cup_minimb	2214.69705210412d0
#define CONV_cup_ozbf	4.61395219188358d0
#define CONV_cup_peck	0.0148808139805247d0
#define CONV_cup_peckb	0.0144186005996362d0
#define CONV_cup_pt	0.277056277056277d0
#define CONV_cup_ptb	0.230697609594179d0
#define CONV_cup_ptd	0.238093023688396d0
#define CONV_cup_qt	0.138528138528139d0
#define CONV_cup_qtb	0.115348804797089d0
#define CONV_cup_qtd	0.119046511844198d0
#define CONV_cup_regton	4.62962962962963d-05
#define CONV_cup_scrup	110.734852605206d0
#define CONV_cup_seam	0.00045058126873863d0
#define CONV_cup_yd3	0.000171467764060357d0
#define CONV_dra_cc	3.6966911953125d0
#define CONV_dra_cl	0.36966911953125d0
#define CONV_dra_cm3	3.6966911953125d0
#define CONV_dra_cupm	0.0184834559765625d0
#define CONV_dra_dm3	0.0036966911953125d0
#define CONV_dra_km3	3.6966911953125d-15
#define CONV_dra_l	0.0036966911953125d0
#define CONV_dra_litero	0.00369658769085716d0
#define CONV_dra_m3	3.6966911953125d-06
#define CONV_dra_ml	3.6966911953125d0
#define CONV_dra_mm3	3696.6911953125d0
#define CONV_dra_acreft	2.99695632540685d-09
#define CONV_dra_acrein	3.59634759048822d-08
#define CONV_dra_bag	3.38815993094478d-05
#define CONV_dra_bbl	2.32514880952381d-05
#define CONV_dra_bblbb	2.25877328729652d-05
#define CONV_dra_bblbw	2.58145518548174d-05
#define CONV_dra_bbluc	3.87205522657055d-05
#define CONV_dra_bblud	3.19707961309524d-05
#define CONV_dra_bblul	3.10019841269841d-05
#define CONV_dra_board	0.00156656901041667d0
#define CONV_dra_boardf	0.00156656901041667d0
#define CONV_dra_bu	0.000104903199142493d0
#define CONV_dra_bub	0.000101644797928343d0
#define CONV_dra_buck	0.000203289595856687d0
#define CONV_dra_cord	1.01990169949002d-06
#define CONV_dra_cordft	8.15921359592014d-06
#define CONV_dra_cup	0.0281982421875d0
#define CONV_dra_drach	1.04084273078624d0
#define CONV_dra_firkb	9.03509314918608d-05
#define CONV_dra_firku	0.000108506944444444d0
#define CONV_dra_floz	0.2255859375d0
#define CONV_dra_ft3	0.000130547417534722d0
#define CONV_dra_gal	0.0009765625d0
#define CONV_dra_galb	0.000813158383426747d0
#define CONV_dra_gald	0.000839225593139945d0
#define CONV_dra_gill	0.03125d0
#define CONV_dra_gillb	0.0260210682696559d0
#define CONV_dra_in3	0.2255859375d0
#define CONV_dra_mile3	8.86883382281856d-16
#define CONV_dra_minim	60d0
#define CONV_dra_minimb	62.4505638471742d0
#define CONV_dra_ozbf	0.13010534134828d0
#define CONV_dra_peck	0.000419612796569972d0
#define CONV_dra_peckb	0.000406579191713373d0
#define CONV_dra_pt	0.0078125d0
#define CONV_dra_ptb	0.00650526706741398d0
#define CONV_dra_ptd	0.00671380474511956d0
#define CONV_dra_qt	0.00390625d0
#define CONV_dra_qtb	0.00325263353370699d0
#define CONV_dra_qtd	0.00335690237255978d0
#define CONV_dra_regton	1.30547417534722d-06
#define CONV_dra_scrup	3.12252819235871d0
#define CONV_dra_seam	1.27055997410429d-05
#define CONV_dra_yd3	4.83508953832304d-06
#define CONV_drach_cc	3.5516328125d0
#define CONV_drach_cl	0.35516328125d0
#define CONV_drach_cm3	3.5516328125d0
#define CONV_drach_cupm	0.0177581640625d0
#define CONV_drach_dm3	0.0035516328125d0
#define CONV_drach_km3	3.5516328125d-15
#define CONV_drach_l	0.0035516328125d0
#define CONV_drach_litero	0.00355153336956565d0
#define CONV_drach_m3	3.5516328125d-06
#define CONV_drach_ml	3.5516328125d0
#define CONV_drach_mm3	3551.6328125d0
#define CONV_drach_acreft	2.87935558059092d-09
#define CONV_drach_acrein	3.45522669670911d-08
#define CONV_drach_bag	3.25520833333333d-05
#define CONV_drach_bbl	2.23390983166826d-05
#define CONV_drach_bblbb	2.17013888888889d-05
#define CONV_drach_bblbw	2.48015873015873d-05
#define CONV_drach_bbluc	3.72011554872046d-05
#define CONV_drach_bblud	3.07162601854385d-05
#define CONV_drach_bblul	2.97854644222434d-05
#define CONV_drach_board	0.00150509674908649d0
#define CONV_drach_boardf	0.00150509674908649d0
#define CONV_drach_bu	0.000100786791356318d0
#define CONV_drach_bub	9.765625d-05
#define CONV_drach_buck	0.0001953125d0
#define CONV_drach_cord	9.79880696019849d-07
#define CONV_drach_cordft	7.83904556815879d-06
#define CONV_drach_cup	0.0270917414835568d0
#define CONV_drach_dra	0.960759940403884d0
#define CONV_drach_firkb	8.68055555555556d-05
#define CONV_drach_firku	0.000104249125477852d0
#define CONV_drach_floz	0.216733931868454d0
#define CONV_drach_ft3	0.000125424729090541d0
#define CONV_drach_gal	0.000938242129300668d0
#define CONV_drach_galb	0.00078125d0
#define CONV_drach_gald	0.000806294330850547d0
#define CONV_drach_gill	0.0300237481376214d0
#define CONV_drach_gillb	0.025d0
#define CONV_drach_in3	0.216733931868454d0
#define CONV_drach_mile3	8.5208202550631d-16
#define CONV_drach_minim	57.645596424233d0
#define CONV_drach_minimb	60d0
#define CONV_drach_ozbf	0.125d0
#define CONV_drach_peck	0.000403147165425274d0
#define CONV_drach_peckb	0.000390625d0
#define CONV_drach_pt	0.00750593703440534d0
#define CONV_drach_ptb	0.00625d0
#define CONV_drach_ptd	0.00645035464680438d0
#define CONV_drach_qt	0.00375296851720267d0
#define CONV_drach_qtb	0.003125d0
#define CONV_drach_qtd	0.00322517732340219d0
#define CONV_drach_regton	1.25424729090541d-06
#define CONV_drach_scrup	3d0
#define CONV_drach_seam	1.220703125d-05
#define CONV_drach_yd3	4.64536033668669d-06
#define CONV_firkb_cc	40914.81d0
#define CONV_firkb_cl	4091.481d0
#define CONV_firkb_cm3	40914.81d0
#define CONV_firkb_cupm	204.57405d0
#define CONV_firkb_dm3	40.91481d0
#define CONV_firkb_km3	4.091481d-11
#define CONV_firkb_l	40.91481d0
#define CONV_firkb_litero	40.9136644173963d0
#define CONV_firkb_m3	0.04091481d0
#define CONV_firkb_ml	40914.81d0
#define CONV_firkb_mm3	40914810d0
#define CONV_firkb_acreft	3.31701762884074d-05
#define CONV_firkb_acrein	0.000398042115460889d0
#define CONV_firkb_bag	0.375d0
#define CONV_firkb_bbl	0.257346412608183d0
#define CONV_firkb_bblbb	0.25d0
#define CONV_firkb_bblbw	0.285714285714286d0
#define CONV_firkb_bbluc	0.428557311212597d0
#define CONV_firkb_bblud	0.353851317336252d0
#define CONV_firkb_bblul	0.343128550144244d0
#define CONV_firkb_board	17.3387145494763d0
#define CONV_firkb_boardf	17.3387145494763d0
#define CONV_firkb_bu	1.16106383642479d0
#define CONV_firkb_bub	1.125d0
#define CONV_firkb_buck	2.25d0
#define CONV_firkb_cord	0.0112882256181487d0
#define CONV_firkb_cordft	0.0903058049451893d0
#define CONV_firkb_cup	312.096861890574d0
#define CONV_firkb_dra	11067.9545134527d0
#define CONV_firkb_drach	11520d0
#define CONV_firkb_firku	1.20094992550485d0
#define CONV_firkb_floz	2496.77489512459d0
#define CONV_firkb_ft3	1.44489287912303d0
#define CONV_firkb_gal	10.8085493295437d0
#define CONV_firkb_galb	9d0
#define CONV_firkb_gald	9.2885106913983d0
#define CONV_firkb_gill	345.873578545398d0
#define CONV_firkb_gillb	288d0
#define CONV_firkb_in3	2496.77489512459d0
#define CONV_firkb_mile3	9.81598493383269d-12
#define CONV_firkb_minim	664077.270807164d0
#define CONV_firkb_minimb	691200d0
#define CONV_firkb_ozbf	1440d0
#define CONV_firkb_peck	4.64425534569915d0
#define CONV_firkb_peckb	4.5d0
#define CONV_firkb_pt	86.4683946363495d0
#define CONV_firkb_ptb	72d0
#define CONV_firkb_ptd	74.3080855311864d0
#define CONV_firkb_qt	43.2341973181748d0
#define CONV_firkb_qtb	36d0
#define CONV_firkb_qtd	37.1540427655932d0
#define CONV_firkb_regton	0.0144489287912303d0
#define CONV_firkb_scrup	34560d0
#define CONV_firkb_seam	0.140625d0
#define CONV_firkb_yd3	0.0535145510786307d0
#define CONV_firku_cc	34068.706056d0
#define CONV_firku_cl	3406.8706056d0
#define CONV_firku_cm3	34068.706056d0
#define CONV_firku_cupm	170.34353028d0
#define CONV_firku_dm3	34.068706056d0
#define CONV_firku_km3	3.4068706056d-11
#define CONV_firku_l	34.068706056d0
#define CONV_firku_litero	34.0677521589396d0
#define CONV_firku_m3	0.034068706056d0
#define CONV_firku_ml	34068.706056d0
#define CONV_firku_mm3	34068706.056d0
#define CONV_firku_acreft	2.76199494949495d-05
#define CONV_firku_acrein	0.000331439393939394d0
#define CONV_firku_bag	0.312252819235871d0
#define CONV_firku_bbl	0.214285714285714d0
#define CONV_firku_bblbb	0.208168546157247d0
#define CONV_firku_bblbw	0.237906909893997d0
#define CONV_firku_bbluc	0.356848609680742d0
#define CONV_firku_bblud	0.294642857142857d0
#define CONV_firku_bblul	0.285714285714286d0
#define CONV_firku_board	14.4375d0
#define CONV_firku_boardf	14.4375d0
#define CONV_firku_bu	0.966787883297217d0
#define CONV_firku_bub	0.936758457707613d0
#define CONV_firku_buck	1.87351691541523d0
#define CONV_firku_cord	0.0093994140625d0
#define CONV_firku_cordft	0.0751953125d0
#define CONV_firku_cup	259.875d0
#define CONV_firku_dra	9216d0
#define CONV_firku_drach	9592.40660692596d0
#define CONV_firku_firkb	0.832674184628989d0
#define CONV_firku_floz	2079d0
#define CONV_firku_ft3	1.203125d0
#define CONV_firku_gal	9d0
#define CONV_firku_galb	7.4940676616609d0
#define CONV_firku_gald	7.73430306637773d0
#define CONV_firku_gill	288d0
#define CONV_firku_gillb	239.810165173149d0
#define CONV_firku_in3	2079d0
#define CONV_firku_mile3	8.17351725110958d-12
#define CONV_firku_minim	552960d0
#define CONV_firku_minimb	575544.396415557d0
#define CONV_firku_ozbf	1199.05082586574d0
#define CONV_firku_peck	3.86715153318887d0
#define CONV_firku_peckb	3.74703383083045d0
#define CONV_firku_pt	72d0
#define CONV_firku_ptb	59.9525412932872d0
#define CONV_firku_ptd	61.8744245310218d0
#define CONV_firku_qt	36d0
#define CONV_firku_qtb	29.9762706466436d0
#define CONV_firku_qtd	30.9372122655109d0
#define CONV_firku_regton	0.01203125d0
#define CONV_firku_scrup	28777.2198207779d0
#define CONV_firku_seam	0.117094807213452d0
#define CONV_firku_yd3	0.0445601851851852d0
#define CONV_floz_cc	16.387064d0
#define CONV_floz_cl	1.6387064d0
#define CONV_floz_cm3	16.387064d0
#define CONV_floz_cupm	0.08193532d0
#define CONV_floz_dm3	0.016387064d0
#define CONV_floz_km3	1.6387064d-14
#define CONV_floz_l	0.016387064d0
#define CONV_floz_litero	0.0163866051750551d0
#define CONV_floz_m3	1.6387064d-05
#define CONV_floz_ml	16.387064d0
#define CONV_floz_mm3	16387.064d0
#define CONV_floz_acreft	1.32852089922797d-08
#define CONV_floz_acrein	1.59422507907356d-07
#define CONV_floz_bag	0.00015019375624621d0
#define CONV_floz_bbl	0.00010307153164296d0
#define CONV_floz_bblbb	0.000100129170830807d0
#define CONV_floz_bblbw	0.000114433338092351d0
#define CONV_floz_bbluc	0.00017164435290079d0
#define CONV_floz_bblud	0.00014172335600907d0
#define CONV_floz_bblul	0.00013742870885728d0
#define CONV_floz_board	0.00694444444444445d0
#define CONV_floz_boardf	0.00694444444444445d0
#define CONV_floz_bu	0.000465025436891398d0
#define CONV_floz_bub	0.00045058126873863d0
#define CONV_floz_buck	0.000901162537477261d0
#define CONV_floz_cord	4.52112268518519d-06
#define CONV_floz_cordft	3.61689814814815d-05
#define CONV_floz_cup	0.125d0
#define CONV_floz_dra	4.43290043290043d0
#define CONV_floz_drach	4.61395219188358d0
#define CONV_floz_firkb	0.000400516683323227d0
#define CONV_floz_firku	0.000481000481000481d0
#define CONV_floz_ft3	0.000578703703703704d0
#define CONV_floz_gal	0.00432900432900433d0
#define CONV_floz_galb	0.00360465014990904d0
#define CONV_floz_gald	0.00372020349513118d0
#define CONV_floz_gill	0.138528138528139d0
#define CONV_floz_gillb	0.115348804797089d0
#define CONV_floz_in3	1d0
#define CONV_floz_mile3	3.93146572924944d-15
#define CONV_floz_minim	265.974025974026d0
#define CONV_floz_minimb	276.837131513015d0
#define CONV_floz_ozbf	0.576744023985447d0
#define CONV_floz_peck	0.00186010174756559d0
#define CONV_floz_peckb	0.00180232507495452d0
#define CONV_floz_pt	0.0346320346320346d0
#define CONV_floz_ptb	0.0288372011992723d0
#define CONV_floz_ptd	0.0297616279610495d0
#define CONV_floz_qt	0.0173160173160173d0
#define CONV_floz_qtb	0.0144186005996362d0
#define CONV_floz_qtd	0.0148808139805247d0
#define CONV_floz_regton	5.78703703703704d-06
#define CONV_floz_scrup	13.8418565756507d0
#define CONV_floz_seam	5.63226585923288d-05
#define CONV_floz_yd3	2.14334705075446d-05
#define CONV_ft3_cc	28316.846592d0
#define CONV_ft3_cl	2831.6846592d0
#define CONV_ft3_cm3	28316.846592d0
#define CONV_ft3_cupm	141.58423296d0
#define CONV_ft3_dm3	28.316846592d0
#define CONV_ft3_km3	2.8316846592d-11
#define CONV_ft3_l	28.316846592d0
#define CONV_ft3_litero	28.3160537424952d0
#define CONV_ft3_m3	0.028316846592d0
#define CONV_ft3_ml	28316.846592d0
#define CONV_ft3_mm3	28316846.592d0
#define CONV_ft3_acreft	2.29568411386593d-05
#define CONV_ft3_acrein	0.000275482093663912d0
#define CONV_ft3_bag	0.259534810793451d0
#define CONV_ft3_bbl	0.178107606679035d0
#define CONV_ft3_bblbb	0.173023207195634d0
#define CONV_ft3_bblbw	0.197740808223582d0
#define CONV_ft3_bbluc	0.296601441812564d0
#define CONV_ft3_bblud	0.244897959183673d0
#define CONV_ft3_bblul	0.23747680890538d0
#define CONV_ft3_board	12d0
#define CONV_ft3_boardf	12d0
#define CONV_ft3_bu	0.803563954948336d0
#define CONV_ft3_bub	0.778604432380353d0
#define CONV_ft3_buck	1.55720886476071d0
#define CONV_ft3_cord	0.0078125d0
#define CONV_ft3_cordft	0.0625d0
#define CONV_ft3_cup	216d0
#define CONV_ft3_dra	7660.05194805195d0
#define CONV_ft3_drach	7972.90938757482d0
#define CONV_ft3_firkb	0.692092828782537d0
#define CONV_ft3_firku	0.831168831168831d0
#define CONV_ft3_floz	1728d0
#define CONV_ft3_gal	7.48051948051948d0
#define CONV_ft3_galb	6.22883545904283d0
#define CONV_ft3_gald	6.42851163958669d0
#define CONV_ft3_gill	239.376623376623d0
#define CONV_ft3_gillb	199.32273468937d0
#define CONV_ft3_in3	1728d0
#define CONV_ft3_mile3	6.79357278014303d-12
#define CONV_ft3_minim	459603.116883117d0
#define CONV_ft3_minimb	478374.563254489d0
#define CONV_ft3_ozbf	996.613673446852d0
#define CONV_ft3_peck	3.21425581979334d0
#define CONV_ft3_peckb	3.11441772952141d0
#define CONV_ft3_pt	59.8441558441558d0
#define CONV_ft3_ptb	49.8306836723426d0
#define CONV_ft3_ptd	51.4280931166935d0
#define CONV_ft3_qt	29.9220779220779d0
#define CONV_ft3_qtb	24.9153418361713d0
#define CONV_ft3_qtd	25.7140465583467d0
#define CONV_ft3_regton	0.01d0
#define CONV_ft3_scrup	23918.7281627245d0
#define CONV_ft3_seam	0.0973255540475442d0
#define CONV_ft3_yd3	0.037037037037037d0
#define CONV_gal_cc	3785.411784d0
#define CONV_gal_cl	378.5411784d0
#define CONV_gal_cm3	3785.411784d0
#define CONV_gal_cupm	18.92705892d0
#define CONV_gal_dm3	3.785411784d0
#define CONV_gal_km3	3.785411784d-12
#define CONV_gal_l	3.785411784d0
#define CONV_gal_litero	3.78530579543773d0
#define CONV_gal_m3	0.003785411784d0
#define CONV_gal_ml	3785.411784d0
#define CONV_gal_mm3	3785411.784d0
#define CONV_gal_acreft	3.06888327721661d-06
#define CONV_gal_acrein	3.68265993265993d-05
#define CONV_gal_bag	0.0346947576928745d0
#define CONV_gal_bbl	0.0238095238095238d0
#define CONV_gal_bblbb	0.0231298384619164d0
#define CONV_gal_bblbw	0.026434101099333d0
#define CONV_gal_bbluc	0.0396498455200824d0
#define CONV_gal_bblud	0.0327380952380952d0
#define CONV_gal_bblul	0.0317460317460317d0
#define CONV_gal_board	1.60416666666667d0
#define CONV_gal_boardf	1.60416666666667d0
#define CONV_gal_bu	0.107420875921913d0
#define CONV_gal_bub	0.104084273078624d0
#define CONV_gal_buck	0.208168546157247d0
#define CONV_gal_cord	0.00104437934027778d0
#define CONV_gal_cordft	0.00835503472222222d0
#define CONV_gal_cup	28.875d0
#define CONV_gal_dra	1024d0
#define CONV_gal_drach	1065.82295632511d0
#define CONV_gal_firkb	0.0925193538476655d0
#define CONV_gal_firku	0.111111111111111d0
#define CONV_gal_floz	231d0
#define CONV_gal_ft3	0.133680555555556d0
#define CONV_gal_galb	0.832674184628989d0
#define CONV_gal_gald	0.859367007375303d0
#define CONV_gal_gill	32d0
#define CONV_gal_gillb	26.6455739081276d0
#define CONV_gal_in3	231d0
#define CONV_gal_mile3	9.0816858345662d-13
#define CONV_gal_minim	61440d0
#define CONV_gal_minimb	63949.3773795064d0
#define CONV_gal_ozbf	133.227869540638d0
#define CONV_gal_peck	0.429683503687652d0
#define CONV_gal_peckb	0.416337092314495d0
#define CONV_gal_pt	8d0
#define CONV_gal_ptb	6.66139347703191d0
#define CONV_gal_ptd	6.87493605900243d0
#define CONV_gal_qt	4d0
#define CONV_gal_qtb	3.33069673851596d0
#define CONV_gal_qtd	3.43746802950121d0
#define CONV_gal_regton	0.00133680555555556d0
#define CONV_gal_scrup	3197.46886897532d0
#define CONV_gal_seam	0.013010534134828d0
#define CONV_gal_yd3	0.0049511316872428d0
#define CONV_galb_cc	4546.09d0
#define CONV_galb_cl	454.609d0
#define CONV_galb_cm3	4546.09d0
#define CONV_galb_cupm	22.73045d0
#define CONV_galb_dm3	4.54609d0
#define CONV_galb_km3	4.54609d-12
#define CONV_galb_l	4.54609d0
#define CONV_galb_litero	4.54596271304404d0
#define CONV_galb_m3	0.00454609d0
#define CONV_galb_ml	4546.09d0
#define CONV_galb_mm3	4546090d0
#define CONV_galb_acreft	3.68557514315638d-06
#define CONV_galb_acrein	4.42269017178766d-05
#define CONV_galb_bag	0.0416666666666667d0
#define CONV_galb_bbl	0.0285940458453537d0
#define CONV_galb_bblbb	0.0277777777777778d0
#define CONV_galb_bblbw	0.0317460317460317d0
#define CONV_galb_bbluc	0.0476174790236219d0
#define CONV_galb_bblud	0.0393168130373613d0
#define CONV_galb_bblul	0.0381253944604716d0
#define CONV_galb_board	1.9265238388307d0
#define CONV_galb_boardf	1.9265238388307d0
#define CONV_galb_bu	0.129007092936088d0
#define CONV_galb_bub	0.125d0
#define CONV_galb_buck	0.25d0
#define CONV_galb_cord	0.00125424729090541d0
#define CONV_galb_cordft	0.0100339783272433d0
#define CONV_galb_cup	34.6774290989527d0
#define CONV_galb_dra	1229.77272371697d0
#define CONV_galb_drach	1280d0
#define CONV_galb_firkb	0.111111111111111d0
#define CONV_galb_firku	0.133438880611651d0
#define CONV_galb_floz	277.419432791621d0
#define CONV_galb_ft3	0.160543653235892d0
#define CONV_galb_gal	1.20094992550485d0
#define CONV_galb_gald	1.0320567434887d0
#define CONV_galb_gill	38.4303976161553d0
#define CONV_galb_gillb	32d0
#define CONV_galb_in3	277.419432791621d0
#define CONV_galb_mile3	1.09066499264808d-12
#define CONV_galb_minim	73786.3634230183d0
#define CONV_galb_minimb	76800d0
#define CONV_galb_ozbf	160d0
#define CONV_galb_peck	0.51602837174435d0
#define CONV_galb_peckb	0.5d0
#define CONV_galb_pt	9.60759940403884d0
#define CONV_galb_ptb	8d0
#define CONV_galb_ptd	8.2564539479096d0
#define CONV_galb_qt	4.80379970201942d0
#define CONV_galb_qtb	4d0
#define CONV_galb_qtd	4.1282269739548d0
#define CONV_galb_regton	0.00160543653235892d0
#define CONV_galb_scrup	3840d0
#define CONV_galb_seam	0.015625d0
#define CONV_galb_yd3	0.00594606123095896d0
#define CONV_gald_cc	4404.88377086d0
#define CONV_gald_cl	440.488377086d0
#define CONV_gald_cm3	4404.88377086d0
#define CONV_gald_cupm	22.0244188543d0
#define CONV_gald_dm3	4.40488377086d0
#define CONV_gald_km3	4.40488377086d-12
#define CONV_gald_l	4.40488377086d0
#define CONV_gald_litero	4.40476043756775d0
#define CONV_gald_m3	0.00440488377086d0
#define CONV_gald_ml	4404.88377086d0
#define CONV_gald_mm3	4404883.77086d0
#define CONV_gald_acreft	3.57109739014726d-06
#define CONV_gald_acrein	4.28531686817672d-05
#define CONV_gald_bag	0.0403724571633719d0
#define CONV_gald_bbl	0.0277058853844568d0
#define CONV_gald_bblbb	0.0269149714422479d0
#define CONV_gald_bblbw	0.0307599673625691d0
#define CONV_gald_bbluc	0.0461384311706145d0
#define CONV_gald_bblud	0.0380955924036281d0
#define CONV_gald_bblul	0.0369411805126091d0
#define CONV_gald_board	1.86668402777778d0
#define CONV_gald_boardf	1.86668402777778d0
#define CONV_gald_bu	0.125d0
#define CONV_gald_bub	0.121117371490116d0
#define CONV_gald_buck	0.242234742980231d0
#define CONV_gald_cord	0.00121528908058449d0
#define CONV_gald_cordft	0.00972231264467593d0
#define CONV_gald_cup	33.6003125d0
#define CONV_gald_dra	1191.57471861472d0
#define CONV_gald_drach	1240.24188405878d0
#define CONV_gald_firkb	0.107659885768992d0
#define CONV_gald_firku	0.129294131794132d0
#define CONV_gald_floz	268.8025d0
#define CONV_gald_ft3	0.155557002314815d0
#define CONV_gald_gal	1.16364718614719d0
#define CONV_gald_galb	0.968938971920926d0
#define CONV_gald_gill	37.23670995671d0
#define CONV_gald_gillb	31.0060471014696d0
#define CONV_gald_in3	268.8025d0
#define CONV_gald_mile3	1.05678781668657d-12
#define CONV_gald_minim	71494.4831168831d0
#define CONV_gald_minimb	74414.5130435271d0
#define CONV_gald_ozbf	155.030235507348d0
#define CONV_gald_peck	0.5d0
#define CONV_gald_peckb	0.484469485960463d0
#define CONV_gald_pt	9.30917748917749d0
#define CONV_gald_ptb	7.7515117753674d0
#define CONV_gald_ptd	8d0
#define CONV_gald_qt	4.65458874458874d0
#define CONV_gald_qtb	3.8757558876837d0
#define CONV_gald_qtd	4d0
#define CONV_gald_regton	0.00155557002314815d0
#define CONV_gald_scrup	3720.72565217635d0
#define CONV_gald_seam	0.0151396714362645d0
#define CONV_gald_yd3	0.00576137045610425d0
#define CONV_gill_cc	118.29411825d0
#define CONV_gill_cl	11.829411825d0
#define CONV_gill_cm3	118.29411825d0
#define CONV_gill_cupm	0.59147059125d0
#define CONV_gill_dm3	0.11829411825d0
#define CONV_gill_km3	1.1829411825d-13
#define CONV_gill_l	0.11829411825d0
#define CONV_gill_litero	0.118290806107429d0
#define CONV_gill_m3	0.00011829411825d0
#define CONV_gill_ml	118.29411825d0
#define CONV_gill_mm3	118294.11825d0
#define CONV_gill_acreft	9.59026024130191d-08
#define CONV_gill_acrein	1.15083122895623d-06
#define CONV_gill_bag	0.00108421117790233d0
#define CONV_gill_bbl	0.000744047619047619d0
#define CONV_gill_bblbb	0.000722807451934886d0
#define CONV_gill_bblbw	0.000826065659354156d0
#define CONV_gill_bbluc	0.00123905767250257d0
#define CONV_gill_bblud	0.00102306547619048d0
#define CONV_gill_bblul	0.000992063492063492d0
#define CONV_gill_board	0.0501302083333333d0
#define CONV_gill_boardf	0.0501302083333333d0
#define CONV_gill_bu	0.00335690237255978d0
#define CONV_gill_bub	0.00325263353370699d0
#define CONV_gill_buck	0.00650526706741398d0
#define CONV_gill_cord	3.26368543836806d-05
#define CONV_gill_cordft	0.000261094835069444d0
#define CONV_gill_cup	0.90234375d0
#define CONV_gill_dra	32d0
#define CONV_gill_drach	33.3069673851596d0
#define CONV_gill_firkb	0.00289122980773955d0
#define CONV_gill_firku	0.00347222222222222d0
#define CONV_gill_floz	7.21875d0
#define CONV_gill_ft3	0.00417751736111111d0
#define CONV_gill_gal	0.03125d0
#define CONV_gill_galb	0.0260210682696559d0
#define CONV_gill_gald	0.0268552189804782d0
#define CONV_gill_gillb	0.832674184628989d0
#define CONV_gill_in3	7.21875d0
#define CONV_gill_mile3	2.83802682330194d-14
#define CONV_gill_minim	1920d0
#define CONV_gill_minimb	1998.41804310957d0
#define CONV_gill_ozbf	4.16337092314495d0
#define CONV_gill_peck	0.0134276094902391d0
#define CONV_gill_peckb	0.013010534134828d0
#define CONV_gill_pt	0.25d0
#define CONV_gill_ptb	0.208168546157247d0
#define CONV_gill_ptd	0.214841751843826d0
#define CONV_gill_qt	0.125d0
#define CONV_gill_qtb	0.104084273078624d0
#define CONV_gill_qtd	0.107420875921913d0
#define CONV_gill_regton	4.17751736111111d-05
#define CONV_gill_scrup	99.9209021554787d0
#define CONV_gill_seam	0.000406579191713373d0
#define CONV_gill_yd3	0.000154722865226337d0
#define CONV_gillb_cc	142.0653125d0
#define CONV_gillb_cl	14.20653125d0
#define CONV_gillb_cm3	142.0653125d0
#define CONV_gillb_cupm	0.7103265625d0
#define CONV_gillb_dm3	0.1420653125d0
#define CONV_gillb_km3	1.420653125d-13
#define CONV_gillb_l	0.1420653125d0
#define CONV_gillb_litero	0.142061334782626d0
#define CONV_gillb_m3	0.0001420653125d0
#define CONV_gillb_ml	142.0653125d0
#define CONV_gillb_mm3	142065.3125d0
#define CONV_gillb_acreft	1.15174223223637d-07
#define CONV_gillb_acrein	1.38209067868364d-06
#define CONV_gillb_bag	0.00130208333333333d0
#define CONV_gillb_bbl	0.000893563932667303d0
#define CONV_gillb_bblbb	0.000868055555555556d0
#define CONV_gillb_bblbw	0.000992063492063492d0
#define CONV_gillb_bbluc	0.00148804621948819d0
#define CONV_gillb_bblud	0.00122865040741754d0
#define CONV_gillb_bblul	0.00119141857688974d0
#define CONV_gillb_board	0.0602038699634595d0
#define CONV_gillb_boardf	0.0602038699634595d0
#define CONV_gillb_bu	0.00403147165425274d0
#define CONV_gillb_bub	0.00390625d0
#define CONV_gillb_buck	0.0078125d0
#define CONV_gillb_cord	3.9195227840794d-05
#define CONV_gillb_cordft	0.000313561822726352d0
#define CONV_gillb_cup	1.08366965934227d0
#define CONV_gillb_dra	38.4303976161554d0
#define CONV_gillb_drach	40d0
#define CONV_gillb_firkb	0.00347222222222222d0
#define CONV_gillb_firku	0.00416996501911408d0
#define CONV_gillb_floz	8.66935727473817d0
#define CONV_gillb_ft3	0.00501698916362163d0
#define CONV_gillb_gal	0.0375296851720267d0
#define CONV_gillb_galb	0.03125d0
#define CONV_gillb_gald	0.0322517732340219d0
#define CONV_gillb_gill	1.20094992550485d0
#define CONV_gillb_in3	8.66935727473817d0
#define CONV_gillb_mile3	3.40832810202524d-14
#define CONV_gillb_minim	2305.82385696932d0
#define CONV_gillb_minimb	2400d0
#define CONV_gillb_ozbf	5d0
#define CONV_gillb_peck	0.0161258866170109d0
#define CONV_gillb_peckb	0.015625d0
#define CONV_gillb_pt	0.300237481376214d0
#define CONV_gillb_ptb	0.25d0
#define CONV_gillb_ptd	0.258014185872175d0
#define CONV_gillb_qt	0.150118740688107d0
#define CONV_gillb_qtb	0.125d0
#define CONV_gillb_qtd	0.129007092936088d0
#define CONV_gillb_regton	5.01698916362163d-05
#define CONV_gillb_scrup	120d0
#define CONV_gillb_seam	0.00048828125d0
#define CONV_gillb_yd3	0.000185814413467468d0
#define CONV_in3_cc	16.387064d0
#define CONV_in3_cl	1.6387064d0
#define CONV_in3_cm3	16.387064d0
#define CONV_in3_cupm	0.08193532d0
#define CONV_in3_dm3	0.016387064d0
#define CONV_in3_km3	1.6387064d-14
#define CONV_in3_l	0.016387064d0
#define CONV_in3_litero	0.0163866051750551d0
#define CONV_in3_m3	1.6387064d-05
#define CONV_in3_ml	16.387064d0
#define CONV_in3_mm3	16387.064d0
#define CONV_in3_acreft	1.32852089922797d-08
#define CONV_in3_acrein	1.59422507907356d-07
#define CONV_in3_bag	0.00015019375624621d0
#define CONV_in3_bbl	0.00010307153164296d0
#define CONV_in3_bblbb	0.000100129170830807d0
#define CONV_in3_bblbw	0.000114433338092351d0
#define CONV_in3_bbluc	0.00017164435290079d0
#define CONV_in3_bblud	0.00014172335600907d0
#define CONV_in3_bblul	0.00013742870885728d0
#define CONV_in3_board	0.00694444444444445d0
#define CONV_in3_boardf	0.00694444444444445d0
#define CONV_in3_bu	0.000465025436891398d0
#define CONV_in3_bub	0.00045058126873863d0
#define CONV_in3_buck	0.000901162537477261d0
#define CONV_in3_cord	4.52112268518519d-06
#define CONV_in3_cordft	3.61689814814815d-05
#define CONV_in3_cup	0.125d0
#define CONV_in3_dra	4.43290043290043d0
#define CONV_in3_drach	4.61395219188358d0
#define CONV_in3_firkb	0.000400516683323227d0
#define CONV_in3_firku	0.000481000481000481d0
#define CONV_in3_floz	1d0
#define CONV_in3_ft3	0.000578703703703704d0
#define CONV_in3_gal	0.00432900432900433d0
#define CONV_in3_galb	0.00360465014990904d0
#define CONV_in3_gald	0.00372020349513118d0
#define CONV_in3_gill	0.138528138528139d0
#define CONV_in3_gillb	0.115348804797089d0
#define CONV_in3_mile3	3.93146572924944d-15
#define CONV_in3_minim	265.974025974026d0
#define CONV_in3_minimb	276.837131513015d0
#define CONV_in3_ozbf	0.576744023985447d0
#define CONV_in3_peck	0.00186010174756559d0
#define CONV_in3_peckb	0.00180232507495452d0
#define CONV_in3_pt	0.0346320346320346d0
#define CONV_in3_ptb	0.0288372011992723d0
#define CONV_in3_ptd	0.0297616279610495d0
#define CONV_in3_qt	0.0173160173160173d0
#define CONV_in3_qtb	0.0144186005996362d0
#define CONV_in3_qtd	0.0148808139805247d0
#define CONV_in3_regton	5.78703703703704d-06
#define CONV_in3_scrup	13.8418565756507d0
#define CONV_in3_seam	5.63226585923288d-05
#define CONV_in3_yd3	2.14334705075446d-05
#define CONV_mile3_cc	4.16818182544058d+15
#define CONV_mile3_cl	416818182544058d0
#define CONV_mile3_cm3	4.16818182544058d+15
#define CONV_mile3_cupm	20840909127202.9d0
#define CONV_mile3_dm3	4168181825440.58d0
#define CONV_mile3_km3	4.16818182544058d0
#define CONV_mile3_l	4168181825440.58d0
#define CONV_mile3_litero	4168065119617.23d0
#define CONV_mile3_m3	4168181825.44058d0
#define CONV_mile3_ml	4.16818182544058d+15
#define CONV_mile3_mm3	4.16818182544058d+18
#define CONV_mile3_acreft	3379200d0
#define CONV_mile3_acrein	40550400d0
#define CONV_mile3_bag	38202992621.5035d0
#define CONV_mile3_bbl	26217074938.7755d0
#define CONV_mile3_bblbb	25468661747.669d0
#define CONV_mile3_bblbw	29107041997.336d0
#define CONV_mile3_bbluc	43659124795.0566d0
#define CONV_mile3_bblud	36048478040.8163d0
#define CONV_mile3_bblul	34956099918.3673d0
#define CONV_mile3_board	1766375424000d0
#define CONV_mile3_boardf	1766375424000d0
#define CONV_mile3_bu	118282968469.415d0
#define CONV_mile3_bub	114608977864.511d0
#define CONV_mile3_buck	229217955729.021d0
#define CONV_mile3_cord	1149984000d0
#define CONV_mile3_cordft	9199872000d0
#define CONV_mile3_cup	31794757632000d0
#define CONV_mile3_dra	1.12754395896686d+15
#define CONV_mile3_drach	1.17359593333259d+15
#define CONV_mile3_firkb	101874646990.676d0
#define CONV_mile3_firku	122346349714.286d0
#define CONV_mile3_floz	254358061056000d0
#define CONV_mile3_ft3	147197952000d0
#define CONV_mile3_gal	1101117147428.57d0
#define CONV_mile3_galb	916871822916.084d0
#define CONV_mile3_gald	946263747755.322d0
#define CONV_mile3_gill	35235748717714.3d0
#define CONV_mile3_gillb	29339898333314.7d0
#define CONV_mile3_in3	254358061056000d0
#define CONV_mile3_minim	6.76526375380114d+16
#define CONV_mile3_minimb	7.04157559999553d+16
#define CONV_mile3_ozbf	146699491666573d0
#define CONV_mile3_peck	473131873877.661d0
#define CONV_mile3_peckb	458435911458.042d0
#define CONV_mile3_pt	8808937179428.57d0
#define CONV_mile3_ptb	7334974583328.67d0
#define CONV_mile3_ptd	7570109982042.58d0
#define CONV_mile3_qt	4404468589714.29d0
#define CONV_mile3_qtb	3667487291664.34d0
#define CONV_mile3_qtd	3785054991021.29d0
#define CONV_mile3_regton	1471979520d0
#define CONV_mile3_scrup	3.52078779999776d+15
#define CONV_mile3_seam	14326122233.0638d0
#define CONV_mile3_yd3	5451776000d0
#define CONV_minim_cc	0.061611519921875d0
#define CONV_minim_cl	0.0061611519921875d0
#define CONV_minim_cm3	0.061611519921875d0
#define CONV_minim_cupm	0.000308057599609375d0
#define CONV_minim_dm3	6.1611519921875d-05
#define CONV_minim_km3	6.1611519921875d-17
#define CONV_minim_l	6.1611519921875d-05
#define CONV_minim_litero	6.16097948476193d-05
#define CONV_minim_m3	6.1611519921875d-08
#define CONV_minim_ml	0.061611519921875d0
#define CONV_minim_mm3	61.611519921875d0
#define CONV_minim_acreft	4.99492720901141d-11
#define CONV_minim_acrein	5.99391265081369d-10
#define CONV_minim_bag	5.6469332182413d-07
#define CONV_minim_bbl	3.87524801587302d-07
#define CONV_minim_bblbb	3.7646221454942d-07
#define CONV_minim_bblbw	4.30242530913623d-07
#define CONV_minim_bbluc	6.45342537761758d-07
#define CONV_minim_bblud	5.3284660218254d-07
#define CONV_minim_bblul	5.16699735449735d-07
#define CONV_minim_board	2.61094835069444d-05
#define CONV_minim_boardf	2.61094835069444d-05
#define CONV_minim_bu	1.74838665237488d-06
#define CONV_minim_bub	1.69407996547239d-06
#define CONV_minim_buck	3.38815993094478d-06
#define CONV_minim_cord	1.6998361658167d-08
#define CONV_minim_cordft	1.35986893265336d-07
#define CONV_minim_cup	0.000469970703125d0
#define CONV_minim_dra	0.0166666666666667d0
#define CONV_minim_drach	0.0173473788464373d0
#define CONV_minim_firkb	1.50584885819768d-06
#define CONV_minim_firku	1.80844907407407d-06
#define CONV_minim_floz	0.003759765625d0
#define CONV_minim_ft3	2.17579029224537d-06
#define CONV_minim_gal	1.62760416666667d-05
#define CONV_minim_galb	1.35526397237791d-05
#define CONV_minim_gald	1.39870932189991d-05
#define CONV_minim_gill	0.000520833333333333d0
#define CONV_minim_gillb	0.000433684471160932d0
#define CONV_minim_in3	0.003759765625d0
#define CONV_minim_mile3	1.47813897046976d-17
#define CONV_minim_minimb	1.04084273078624d0
#define CONV_minim_ozbf	0.00216842235580466d0
#define CONV_minim_peck	6.99354660949954d-06
#define CONV_minim_peckb	6.77631986188956d-06
#define CONV_minim_pt	0.000130208333333333d0
#define CONV_minim_ptb	0.000108421117790233d0
#define CONV_minim_ptd	0.000111896745751993d0
#define CONV_minim_qt	6.51041666666667d-05
#define CONV_minim_qtb	5.42105588951165d-05
#define CONV_minim_qtd	5.59483728759963d-05
#define CONV_minim_regton	2.17579029224537d-08
#define CONV_minim_scrup	0.0520421365393118d0
#define CONV_minim_seam	2.11759995684049d-07
#define CONV_minim_yd3	8.05848256387174d-08
#define CONV_minimb_cc	0.0591938802083333d0
#define CONV_minimb_cl	0.00591938802083333d0
#define CONV_minimb_cm3	0.0591938802083333d0
#define CONV_minimb_cupm	0.000295969401041667d0
#define CONV_minimb_dm3	5.91938802083333d-05
#define CONV_minimb_km3	5.91938802083333d-17
#define CONV_minimb_l	5.91938802083333d-05
#define CONV_minimb_litero	5.91922228260942d-05
#define CONV_minimb_m3	5.91938802083333d-08
#define CONV_minimb_ml	0.0591938802083333d0
#define CONV_minimb_mm3	59.1938802083333d0
#define CONV_minimb_acreft	4.79892596765154d-11
#define CONV_minimb_acrein	5.75871116118185d-10
#define CONV_minimb_bag	5.42534722222222d-07
#define CONV_minimb_bbl	3.72318305278043d-07
#define CONV_minimb_bblbb	3.61689814814815d-07
#define CONV_minimb_bblbw	4.13359788359788d-07
#define CONV_minimb_bbluc	6.20019258120077d-07
#define CONV_minimb_bblud	5.11937669757309d-07
#define CONV_minimb_bblul	4.9642440703739d-07
#define CONV_minimb_board	2.50849458181081d-05
#define CONV_minimb_boardf	2.50849458181081d-05
#define CONV_minimb_bu	1.67977985593864d-06
#define CONV_minimb_bub	1.62760416666667d-06
#define CONV_minimb_buck	3.25520833333333d-06
#define CONV_minimb_cord	1.63313449336641d-08
#define CONV_minimb_cordft	1.30650759469313d-07
#define CONV_minimb_cup	0.000451529024725946d0
#define CONV_minimb_dra	0.0160126656733981d0
#define CONV_minimb_drach	0.0166666666666667d0
#define CONV_minimb_firkb	1.44675925925926d-06
#define CONV_minimb_firku	1.73748542463087d-06
#define CONV_minimb_floz	0.00361223219780757d0
#define CONV_minimb_ft3	2.09041215150901d-06
#define CONV_minimb_gal	1.56373688216778d-05
#define CONV_minimb_galb	1.30208333333333d-05
#define CONV_minimb_gald	1.34382388475091d-05
#define CONV_minimb_gill	0.000500395802293689d0
#define CONV_minimb_gillb	0.000416666666666667d0
#define CONV_minimb_in3	0.00361223219780757d0
#define CONV_minimb_mile3	1.42013670917718d-17
#define CONV_minimb_minim	0.960759940403884d0
#define CONV_minimb_ozbf	0.00208333333333333d0
#define CONV_minimb_peck	6.71911942375456d-06
#define CONV_minimb_peckb	6.51041666666667d-06
#define CONV_minimb_pt	0.000125098950573422d0
#define CONV_minimb_ptb	0.000104166666666667d0
#define CONV_minimb_ptd	0.000107505910780073d0
#define CONV_minimb_qt	6.25494752867112d-05
#define CONV_minimb_qtb	5.20833333333333d-05
#define CONV_minimb_qtd	5.37529553900365d-05
#define CONV_minimb_regton	2.09041215150901d-08
#define CONV_minimb_scrup	0.05d0
#define CONV_minimb_seam	2.03450520833333d-07
#define CONV_minimb_yd3	7.74226722781115d-08
#define CONV_ozbf_cc	28.4130625d0
#define CONV_ozbf_cl	2.84130625d0
#define CONV_ozbf_cm3	28.4130625d0
#define CONV_ozbf_cupm	0.1420653125d0
#define CONV_ozbf_dm3	0.0284130625d0
#define CONV_ozbf_km3	2.84130625d-14
#define CONV_ozbf_l	0.0284130625d0
#define CONV_ozbf_litero	0.0284122669565252d0
#define CONV_ozbf_m3	2.84130625d-05
#define CONV_ozbf_ml	28.4130625d0
#define CONV_ozbf_mm3	28413.0625d0
#define CONV_ozbf_acreft	2.30348446447274d-08
#define CONV_ozbf_acrein	2.76418135736729d-07
#define CONV_ozbf_bag	0.000260416666666667d0
#define CONV_ozbf_bbl	0.00017871278653346d0
#define CONV_ozbf_bblbb	0.000173611111111111d0
#define CONV_ozbf_bblbw	0.000198412698412698d0
#define CONV_ozbf_bbluc	0.000297609243897637d0
#define CONV_ozbf_bblud	0.000245730081483508d0
#define CONV_ozbf_bblul	0.000238283715377947d0
#define CONV_ozbf_board	0.0120407739926919d0
#define CONV_ozbf_boardf	0.0120407739926919d0
#define CONV_ozbf_bu	0.000806294330850547d0
#define CONV_ozbf_bub	0.00078125d0
#define CONV_ozbf_buck	0.0015625d0
#define CONV_ozbf_cord	7.83904556815879d-06
#define CONV_ozbf_cordft	6.27123645452703d-05
#define CONV_ozbf_cup	0.216733931868454d0
#define CONV_ozbf_dra	7.68607952323107d0
#define CONV_ozbf_drach	8d0
#define CONV_ozbf_firkb	0.000694444444444445d0
#define CONV_ozbf_firku	0.000833993003822816d0
#define CONV_ozbf_floz	1.73387145494763d0
#define CONV_ozbf_ft3	0.00100339783272433d0
#define CONV_ozbf_gal	0.00750593703440534d0
#define CONV_ozbf_galb	0.00625d0
#define CONV_ozbf_gald	0.00645035464680438d0
#define CONV_ozbf_gill	0.240189985100971d0
#define CONV_ozbf_gillb	0.2d0
#define CONV_ozbf_in3	1.73387145494763d0
#define CONV_ozbf_mile3	6.81665620405048d-15
#define CONV_ozbf_minim	461.164771393864d0
#define CONV_ozbf_minimb	480d0
#define CONV_ozbf_peck	0.00322517732340219d0
#define CONV_ozbf_peckb	0.003125d0
#define CONV_ozbf_pt	0.0600474962752427d0
#define CONV_ozbf_ptb	0.05d0
#define CONV_ozbf_ptd	0.051602837174435d0
#define CONV_ozbf_qt	0.0300237481376214d0
#define CONV_ozbf_qtb	0.025d0
#define CONV_ozbf_qtd	0.0258014185872175d0
#define CONV_ozbf_regton	1.00339783272433d-05
#define CONV_ozbf_scrup	24d0
#define CONV_ozbf_seam	9.765625d-05
#define CONV_ozbf_yd3	3.71628826934935d-05
#define CONV_peck_cc	8809.76754172d0
#define CONV_peck_cl	880.976754172d0
#define CONV_peck_cm3	8809.76754172d0
#define CONV_peck_cupm	44.0488377086d0
#define CONV_peck_dm3	8.80976754172d0
#define CONV_peck_km3	8.80976754172d-12
#define CONV_peck_l	8.80976754172d0
#define CONV_peck_litero	8.8095208751355d0
#define CONV_peck_m3	0.00880976754172d0
#define CONV_peck_ml	8809.76754172d0
#define CONV_peck_mm3	8809767.54172d0
#define CONV_peck_acreft	7.14219478029453d-06
#define CONV_peck_acrein	8.57063373635343d-05
#define CONV_peck_bag	0.0807449143267438d0
#define CONV_peck_bbl	0.0554117707689136d0
#define CONV_peck_bblbb	0.0538299428844959d0
#define CONV_peck_bblbw	0.0615199347251381d0
#define CONV_peck_bbluc	0.092276862341229d0
#define CONV_peck_bblud	0.0761911848072562d0
#define CONV_peck_bblul	0.0738823610252182d0
#define CONV_peck_board	3.73336805555556d0
#define CONV_peck_boardf	3.73336805555556d0
#define CONV_peck_bu	0.25d0
#define CONV_peck_bub	0.242234742980231d0
#define CONV_peck_buck	0.484469485960463d0
#define CONV_peck_cord	0.00243057816116898d0
#define CONV_peck_cordft	0.0194446252893519d0
#define CONV_peck_cup	67.200625d0
#define CONV_peck_dra	2383.14943722944d0
#define CONV_peck_drach	2480.48376811757d0
#define CONV_peck_firkb	0.215319771537984d0
#define CONV_peck_firku	0.258588263588264d0
#define CONV_peck_floz	537.605d0
#define CONV_peck_ft3	0.31111400462963d0
#define CONV_peck_gal	2.32729437229437d0
#define CONV_peck_galb	1.93787794384185d0
#define CONV_peck_gald	2d0
#define CONV_peck_gill	74.4734199134199d0
#define CONV_peck_gillb	62.0120942029392d0
#define CONV_peck_in3	537.605d0
#define CONV_peck_mile3	2.11357563337314d-12
#define CONV_peck_minim	142988.966233766d0
#define CONV_peck_minimb	148829.026087054d0
#define CONV_peck_ozbf	310.060471014696d0
#define CONV_peck_peckb	0.968938971920926d0
#define CONV_peck_pt	18.618354978355d0
#define CONV_peck_ptb	15.5030235507348d0
#define CONV_peck_ptd	16d0
#define CONV_peck_qt	9.30917748917749d0
#define CONV_peck_qtb	7.7515117753674d0
#define CONV_peck_qtd	8d0
#define CONV_peck_regton	0.0031111400462963d0
#define CONV_peck_scrup	7441.45130435271d0
#define CONV_peck_seam	0.0302793428725289d0
#define CONV_peck_yd3	0.0115227409122085d0
#define CONV_peckb_cc	9092.18d0
#define CONV_peckb_cl	909.218d0
#define CONV_peckb_cm3	9092.18d0
#define CONV_peckb_cupm	45.4609d0
#define CONV_peckb_dm3	9.09218d0
#define CONV_peckb_km3	9.09218d-12
#define CONV_peckb_l	9.09218d0
#define CONV_peckb_litero	9.09192542608807d0
#define CONV_peckb_m3	0.00909218d0
#define CONV_peckb_ml	9092.18d0
#define CONV_peckb_mm3	9092180d0
#define CONV_peckb_acreft	7.37115028631276d-06
#define CONV_peckb_acrein	8.84538034357532d-05
#define CONV_peckb_bag	0.0833333333333333d0
#define CONV_peckb_bbl	0.0571880916907074d0
#define CONV_peckb_bblbb	0.0555555555555556d0
#define CONV_peckb_bblbw	0.0634920634920635d0
#define CONV_peckb_bbluc	0.0952349580472439d0
#define CONV_peckb_bblud	0.0786336260747226d0
#define CONV_peckb_bblul	0.0762507889209432d0
#define CONV_peckb_board	3.85304767766141d0
#define CONV_peckb_boardf	3.85304767766141d0
#define CONV_peckb_bu	0.258014185872175d0
#define CONV_peckb_bub	0.25d0
#define CONV_peckb_buck	0.5d0
#define CONV_peckb_cord	0.00250849458181081d0
#define CONV_peckb_cordft	0.0200679566544865d0
#define CONV_peckb_cup	69.3548581979054d0
#define CONV_peckb_dra	2459.54544743394d0
#define CONV_peckb_drach	2560d0
#define CONV_peckb_firkb	0.222222222222222d0
#define CONV_peckb_firku	0.266877761223301d0
#define CONV_peckb_floz	554.838865583243d0
#define CONV_peckb_ft3	0.321087306471784d0
#define CONV_peckb_gal	2.40189985100971d0
#define CONV_peckb_galb	2d0
#define CONV_peckb_gald	2.0641134869774d0
#define CONV_peckb_gill	76.8607952323107d0
#define CONV_peckb_gillb	64d0
#define CONV_peckb_in3	554.838865583243d0
#define CONV_peckb_mile3	2.18132998529615d-12
#define CONV_peckb_minim	147572.726846037d0
#define CONV_peckb_minimb	153600d0
#define CONV_peckb_ozbf	320d0
#define CONV_peckb_peck	1.0320567434887d0
#define CONV_peckb_pt	19.2151988080777d0
#define CONV_peckb_ptb	16d0
#define CONV_peckb_ptd	16.5129078958192d0
#define CONV_peckb_qt	9.60759940403884d0
#define CONV_peckb_qtb	8d0
#define CONV_peckb_qtd	8.25645394790961d0
#define CONV_peckb_regton	0.00321087306471784d0
#define CONV_peckb_scrup	7680d0
#define CONV_peckb_seam	0.03125d0
#define CONV_peckb_yd3	0.0118921224619179d0
#define CONV_pt_cc	473.176473d0
#define CONV_pt_cl	47.3176473d0
#define CONV_pt_cm3	473.176473d0
#define CONV_pt_cupm	2.365882365d0
#define CONV_pt_dm3	0.473176473d0
#define CONV_pt_km3	4.73176473d-13
#define CONV_pt_l	0.473176473d0
#define CONV_pt_litero	0.473163224429716d0
#define CONV_pt_m3	0.000473176473d0
#define CONV_pt_ml	473.176473d0
#define CONV_pt_mm3	473176.473d0
#define CONV_pt_acreft	3.83610409652076d-07
#define CONV_pt_acrein	4.60332491582492d-06
#define CONV_pt_bag	0.00433684471160932d0
#define CONV_pt_bbl	0.00297619047619048d0
#define CONV_pt_bblbb	0.00289122980773955d0
#define CONV_pt_bblbw	0.00330426263741662d0
#define CONV_pt_bbluc	0.0049562306900103d0
#define CONV_pt_bblud	0.0040922619047619d0
#define CONV_pt_bblul	0.00396825396825397d0
#define CONV_pt_board	0.200520833333333d0
#define CONV_pt_boardf	0.200520833333333d0
#define CONV_pt_bu	0.0134276094902391d0
#define CONV_pt_bub	0.013010534134828d0
#define CONV_pt_buck	0.0260210682696559d0
#define CONV_pt_cord	0.000130547417534722d0
#define CONV_pt_cordft	0.00104437934027778d0
#define CONV_pt_cup	3.609375d0
#define CONV_pt_dra	128d0
#define CONV_pt_drach	133.227869540638d0
#define CONV_pt_firkb	0.0115649192309582d0
#define CONV_pt_firku	0.0138888888888889d0
#define CONV_pt_floz	28.875d0
#define CONV_pt_ft3	0.0167100694444444d0
#define CONV_pt_gal	0.125d0
#define CONV_pt_galb	0.104084273078624d0
#define CONV_pt_gald	0.107420875921913d0
#define CONV_pt_gill	4d0
#define CONV_pt_gillb	3.33069673851596d0
#define CONV_pt_in3	28.875d0
#define CONV_pt_mile3	1.13521072932077d-13
#define CONV_pt_minim	7680d0
#define CONV_pt_minimb	7993.6721724383d0
#define CONV_pt_ozbf	16.6534836925798d0
#define CONV_pt_peck	0.0537104379609565d0
#define CONV_pt_peckb	0.0520421365393118d0
#define CONV_pt_ptb	0.832674184628989d0
#define CONV_pt_ptd	0.859367007375303d0
#define CONV_pt_qt	0.5d0
#define CONV_pt_qtb	0.416337092314494d0
#define CONV_pt_qtd	0.429683503687652d0
#define CONV_pt_regton	0.000167100694444444d0
#define CONV_pt_scrup	399.683608621915d0
#define CONV_pt_seam	0.00162631676685349d0
#define CONV_pt_yd3	0.00061889146090535d0
#define CONV_ptb_cc	568.26125d0
#define CONV_ptb_cl	56.826125d0
#define CONV_ptb_cm3	568.26125d0
#define CONV_ptb_cupm	2.84130625d0
#define CONV_ptb_dm3	0.56826125d0
#define CONV_ptb_km3	5.6826125d-13
#define CONV_ptb_l	0.56826125d0
#define CONV_ptb_litero	0.568245339130504d0
#define CONV_ptb_m3	0.00056826125d0
#define CONV_ptb_ml	568.26125d0
#define CONV_ptb_mm3	568261.25d0
#define CONV_ptb_acreft	4.60696892894548d-07
#define CONV_ptb_acrein	5.52836271473457d-06
#define CONV_ptb_bag	0.00520833333333333d0
#define CONV_ptb_bbl	0.00357425573066921d0
#define CONV_ptb_bblbb	0.00347222222222222d0
#define CONV_ptb_bblbw	0.00396825396825397d0
#define CONV_ptb_bbluc	0.00595218487795274d0
#define CONV_ptb_bblud	0.00491460162967016d0
#define CONV_ptb_bblul	0.00476567430755895d0
#define CONV_ptb_board	0.240815479853838d0
#define CONV_ptb_boardf	0.240815479853838d0
#define CONV_ptb_bu	0.0161258866170109d0
#define CONV_ptb_bub	0.015625d0
#define CONV_ptb_buck	0.03125d0
#define CONV_ptb_cord	0.000156780911363176d0
#define CONV_ptb_cordft	0.00125424729090541d0
#define CONV_ptb_cup	4.33467863736908d0
#define CONV_ptb_dra	153.721590464621d0
#define CONV_ptb_drach	160d0
#define CONV_ptb_firkb	0.0138888888888889d0
#define CONV_ptb_firku	0.0166798600764563d0
#define CONV_ptb_floz	34.6774290989527d0
#define CONV_ptb_ft3	0.0200679566544865d0
#define CONV_ptb_gal	0.150118740688107d0
#define CONV_ptb_galb	0.125d0
#define CONV_ptb_gald	0.129007092936088d0
#define CONV_ptb_gill	4.80379970201942d0
#define CONV_ptb_gillb	4d0
#define CONV_ptb_in3	34.6774290989527d0
#define CONV_ptb_mile3	1.3633312408101d-13
#define CONV_ptb_minim	9223.29542787728d0
#define CONV_ptb_minimb	9600d0
#define CONV_ptb_ozbf	20d0
#define CONV_ptb_peck	0.0645035464680438d0
#define CONV_ptb_peckb	0.0625d0
#define CONV_ptb_pt	1.20094992550485d0
#define CONV_ptb_ptd	1.0320567434887d0
#define CONV_ptb_qt	0.600474962752427d0
#define CONV_ptb_qtb	0.5d0
#define CONV_ptb_qtd	0.51602837174435d0
#define CONV_ptb_regton	0.000200679566544865d0
#define CONV_ptb_scrup	480d0
#define CONV_ptb_seam	0.001953125d0
#define CONV_ptb_yd3	0.00074325765386987d0
#define CONV_ptd_cc	550.6104713575d0
#define CONV_ptd_cl	55.06104713575d0
#define CONV_ptd_cm3	550.6104713575d0
#define CONV_ptd_cupm	2.7530523567875d0
#define CONV_ptd_dm3	0.5506104713575d0
#define CONV_ptd_km3	5.506104713575d-13
#define CONV_ptd_l	0.5506104713575d0
#define CONV_ptd_litero	0.550595054695969d0
#define CONV_ptd_m3	0.0005506104713575d0
#define CONV_ptd_ml	550.6104713575d0
#define CONV_ptd_mm3	550610.4713575d0
#define CONV_ptd_acreft	4.46387173768408d-07
#define CONV_ptd_acrein	5.3566460852209d-06
#define CONV_ptd_bag	0.00504655714542149d0
#define CONV_ptd_bbl	0.0034632356730571d0
#define CONV_ptd_bblbb	0.00336437143028099d0
#define CONV_ptd_bblbw	0.00384499592032113d0
#define CONV_ptd_bbluc	0.00576730389632681d0
#define CONV_ptd_bblud	0.00476194905045352d0
#define CONV_ptd_bblul	0.00461764756407614d0
#define CONV_ptd_board	0.233335503472222d0
#define CONV_ptd_boardf	0.233335503472222d0
#define CONV_ptd_bu	0.015625d0
#define CONV_ptd_bub	0.0151396714362645d0
#define CONV_ptd_buck	0.0302793428725289d0
#define CONV_ptd_cord	0.000151911135073061d0
#define CONV_ptd_cordft	0.00121528908058449d0
#define CONV_ptd_cup	4.2000390625d0
#define CONV_ptd_dra	148.94683982684d0
#define CONV_ptd_drach	155.030235507348d0
#define CONV_ptd_firkb	0.013457485721124d0
#define CONV_ptd_firku	0.0161617664742665d0
#define CONV_ptd_floz	33.6003125d0
#define CONV_ptd_ft3	0.0194446252893519d0
#define CONV_ptd_gal	0.145455898268398d0
#define CONV_ptd_galb	0.121117371490116d0
#define CONV_ptd_gald	0.125d0
#define CONV_ptd_gill	4.65458874458874d0
#define CONV_ptd_gillb	3.8757558876837d0
#define CONV_ptd_in3	33.6003125d0
#define CONV_ptd_mile3	1.32098477085822d-13
#define CONV_ptd_minim	8936.81038961039d0
#define CONV_ptd_minimb	9301.81413044089d0
#define CONV_ptd_ozbf	19.3787794384185d0
#define CONV_ptd_peck	0.0625d0
#define CONV_ptd_peckb	0.0605586857450578d0
#define CONV_ptd_pt	1.16364718614719d0
#define CONV_ptd_ptb	0.968938971920925d0
#define CONV_ptd_qt	0.581823593073593d0
#define CONV_ptd_qtb	0.484469485960463d0
#define CONV_ptd_qtd	0.5d0
#define CONV_ptd_regton	0.000194446252893519d0
#define CONV_ptd_scrup	465.090706522044d0
#define CONV_ptd_seam	0.00189245892953306d0
#define CONV_ptd_yd3	0.000720171307013031d0
#define CONV_qt_cc	946.352946000001d0
#define CONV_qt_cl	94.6352946d0
#define CONV_qt_cm3	946.352946000001d0
#define CONV_qt_cupm	4.73176473d0
#define CONV_qt_dm3	0.946352946000001d0
#define CONV_qt_km3	9.46352946d-13
#define CONV_qt_l	0.946352946000001d0
#define CONV_qt_litero	0.946326448859432d0
#define CONV_qt_m3	0.000946352946d0
#define CONV_qt_ml	946.352946000001d0
#define CONV_qt_mm3	946352.946d0
#define CONV_qt_acreft	7.67220819304153d-07
#define CONV_qt_acrein	9.20664983164983d-06
#define CONV_qt_bag	0.00867368942321864d0
#define CONV_qt_bbl	0.00595238095238095d0
#define CONV_qt_bblbb	0.00578245961547909d0
#define CONV_qt_bblbw	0.00660852527483325d0
#define CONV_qt_bbluc	0.0099124613800206d0
#define CONV_qt_bblud	0.00818452380952381d0
#define CONV_qt_bblul	0.00793650793650794d0
#define CONV_qt_board	0.401041666666667d0
#define CONV_qt_boardf	0.401041666666667d0
#define CONV_qt_bu	0.0268552189804782d0
#define CONV_qt_bub	0.0260210682696559d0
#define CONV_qt_buck	0.0520421365393118d0
#define CONV_qt_cord	0.000261094835069444d0
#define CONV_qt_cordft	0.00208875868055556d0
#define CONV_qt_cup	7.21875d0
#define CONV_qt_dra	256d0
#define CONV_qt_drach	266.455739081276d0
#define CONV_qt_firkb	0.0231298384619164d0
#define CONV_qt_firku	0.0277777777777778d0
#define CONV_qt_floz	57.75d0
#define CONV_qt_ft3	0.0334201388888889d0
#define CONV_qt_gal	0.25d0
#define CONV_qt_galb	0.208168546157247d0
#define CONV_qt_gald	0.214841751843826d0
#define CONV_qt_gill	8d0
#define CONV_qt_gillb	6.66139347703191d0
#define CONV_qt_in3	57.75d0
#define CONV_qt_mile3	2.27042145864155d-13
#define CONV_qt_minim	15360d0
#define CONV_qt_minimb	15987.3443448766d0
#define CONV_qt_ozbf	33.3069673851596d0
#define CONV_qt_peck	0.107420875921913d0
#define CONV_qt_peckb	0.104084273078624d0
#define CONV_qt_pt	2d0
#define CONV_qt_ptb	1.66534836925798d0
#define CONV_qt_ptd	1.71873401475061d0
#define CONV_qt_qtb	0.832674184628989d0
#define CONV_qt_qtd	0.859367007375303d0
#define CONV_qt_regton	0.000334201388888889d0
#define CONV_qt_scrup	799.367217243829d0
#define CONV_qt_seam	0.00325263353370699d0
#define CONV_qt_yd3	0.0012377829218107d0
#define CONV_qtb_cc	1136.5225d0
#define CONV_qtb_cl	113.65225d0
#define CONV_qtb_cm3	1136.5225d0
#define CONV_qtb_cupm	5.6826125d0
#define CONV_qtb_dm3	1.1365225d0
#define CONV_qtb_km3	1.1365225d-12
#define CONV_qtb_l	1.1365225d0
#define CONV_qtb_litero	1.13649067826101d0
#define CONV_qtb_m3	0.0011365225d0
#define CONV_qtb_ml	1136.5225d0
#define CONV_qtb_mm3	1136522.5d0
#define CONV_qtb_acreft	9.21393785789096d-07
#define CONV_qtb_acrein	1.10567254294691d-05
#define CONV_qtb_bag	0.0104166666666667d0
#define CONV_qtb_bbl	0.00714851146133842d0
#define CONV_qtb_bblbb	0.00694444444444445d0
#define CONV_qtb_bblbw	0.00793650793650794d0
#define CONV_qtb_bbluc	0.0119043697559055d0
#define CONV_qtb_bblud	0.00982920325934033d0
#define CONV_qtb_bblul	0.00953134861511789d0
#define CONV_qtb_board	0.481630959707676d0
#define CONV_qtb_boardf	0.481630959707676d0
#define CONV_qtb_bu	0.0322517732340219d0
#define CONV_qtb_bub	0.03125d0
#define CONV_qtb_buck	0.0625d0
#define CONV_qtb_cord	0.000313561822726352d0
#define CONV_qtb_cordft	0.00250849458181081d0
#define CONV_qtb_cup	8.66935727473817d0
#define CONV_qtb_dra	307.443180929243d0
#define CONV_qtb_drach	320d0
#define CONV_qtb_firkb	0.0277777777777778d0
#define CONV_qtb_firku	0.0333597201529126d0
#define CONV_qtb_floz	69.3548581979054d0
#define CONV_qtb_ft3	0.040135913308973d0
#define CONV_qtb_gal	0.300237481376214d0
#define CONV_qtb_galb	0.25d0
#define CONV_qtb_gald	0.258014185872175d0
#define CONV_qtb_gill	9.60759940403884d0
#define CONV_qtb_gillb	8d0
#define CONV_qtb_in3	69.3548581979054d0
#define CONV_qtb_mile3	2.72666248162019d-13
#define CONV_qtb_minim	18446.5908557546d0
#define CONV_qtb_minimb	19200d0
#define CONV_qtb_ozbf	40d0
#define CONV_qtb_peck	0.129007092936088d0
#define CONV_qtb_peckb	0.125d0
#define CONV_qtb_pt	2.40189985100971d0
#define CONV_qtb_ptb	2d0
#define CONV_qtb_ptd	2.0641134869774d0
#define CONV_qtb_qt	1.20094992550485d0
#define CONV_qtb_qtd	1.0320567434887d0
#define CONV_qtb_regton	0.00040135913308973d0
#define CONV_qtb_scrup	960d0
#define CONV_qtb_seam	0.00390625d0
#define CONV_qtb_yd3	0.00148651530773974d0
#define CONV_qtd_cc	1101.220942715d0
#define CONV_qtd_cl	110.1220942715d0
#define CONV_qtd_cm3	1101.220942715d0
#define CONV_qtd_cupm	5.506104713575d0
#define CONV_qtd_dm3	1.101220942715d0
#define CONV_qtd_km3	1.101220942715d-12
#define CONV_qtd_l	1.101220942715d0
#define CONV_qtd_litero	1.10119010939194d0
#define CONV_qtd_m3	0.001101220942715d0
#define CONV_qtd_ml	1101.220942715d0
#define CONV_qtd_mm3	1101220.942715d0
#define CONV_qtd_acreft	8.92774347536816d-07
#define CONV_qtd_acrein	1.07132921704418d-05
#define CONV_qtd_bag	0.010093114290843d0
#define CONV_qtd_bbl	0.0069264713461142d0
#define CONV_qtd_bblbb	0.00672874286056199d0
#define CONV_qtd_bblbw	0.00768999184064227d0
#define CONV_qtd_bbluc	0.0115346077926536d0
#define CONV_qtd_bblud	0.00952389810090703d0
#define CONV_qtd_bblul	0.00923529512815227d0
#define CONV_qtd_board	0.466671006944445d0
#define CONV_qtd_boardf	0.466671006944445d0
#define CONV_qtd_bu	0.03125d0
#define CONV_qtd_bub	0.0302793428725289d0
#define CONV_qtd_buck	0.0605586857450579d0
#define CONV_qtd_cord	0.000303822270146123d0
#define CONV_qtd_cordft	0.00243057816116898d0
#define CONV_qtd_cup	8.400078125d0
#define CONV_qtd_dra	297.89367965368d0
#define CONV_qtd_drach	310.060471014696d0
#define CONV_qtd_firkb	0.0269149714422479d0
#define CONV_qtd_firku	0.0323235329485329d0
#define CONV_qtd_floz	67.200625d0
#define CONV_qtd_ft3	0.0388892505787037d0
#define CONV_qtd_gal	0.290911796536797d0
#define CONV_qtd_galb	0.242234742980231d0
#define CONV_qtd_gald	0.25d0
#define CONV_qtd_gill	9.30917748917749d0
#define CONV_qtd_gillb	7.75151177536741d0
#define CONV_qtd_in3	67.200625d0
#define CONV_qtd_mile3	2.64196954171643d-13
#define CONV_qtd_minim	17873.6207792208d0
#define CONV_qtd_minimb	18603.6282608818d0
#define CONV_qtd_ozbf	38.757558876837d0
#define CONV_qtd_peck	0.125d0
#define CONV_qtd_peckb	0.121117371490116d0
#define CONV_qtd_pt	2.32729437229437d0
#define CONV_qtd_ptb	1.93787794384185d0
#define CONV_qtd_ptd	2d0
#define CONV_qtd_qt	1.16364718614719d0
#define CONV_qtd_qtb	0.968938971920925d0
#define CONV_qtd_regton	0.000388892505787037d0
#define CONV_qtd_scrup	930.181413044089d0
#define CONV_qtd_seam	0.00378491785906612d0
#define CONV_qtd_yd3	0.00144034261402606d0
#define CONV_regton_cc	2831684.6592d0
#define CONV_regton_cl	283168.46592d0
#define CONV_regton_cm3	2831684.6592d0
#define CONV_regton_cupm	14158.423296d0
#define CONV_regton_dm3	2831.6846592d0
#define CONV_regton_km3	2.8316846592d-09
#define CONV_regton_l	2831.6846592d0
#define CONV_regton_litero	2831.60537424952d0
#define CONV_regton_m3	2.8316846592d0
#define CONV_regton_ml	2831684.6592d0
#define CONV_regton_mm3	2831684659.2d0
#define CONV_regton_acreft	0.00229568411386593d0
#define CONV_regton_acrein	0.0275482093663912d0
#define CONV_regton_bag	25.9534810793451d0
#define CONV_regton_bbl	17.8107606679035d0
#define CONV_regton_bblbb	17.3023207195634d0
#define CONV_regton_bblbw	19.7740808223582d0
#define CONV_regton_bbluc	29.6601441812564d0
#define CONV_regton_bblud	24.4897959183673d0
#define CONV_regton_bblul	23.747680890538d0
#define CONV_regton_board	1200d0
#define CONV_regton_boardf	1200d0
#define CONV_regton_bu	80.3563954948335d0
#define CONV_regton_bub	77.8604432380353d0
#define CONV_regton_buck	155.720886476071d0
#define CONV_regton_cord	0.78125d0
#define CONV_regton_cordft	6.25d0
#define CONV_regton_cup	21600d0
#define CONV_regton_dra	766005.194805195d0
#define CONV_regton_drach	797290.938757482d0
#define CONV_regton_firkb	69.2092828782536d0
#define CONV_regton_firku	83.1168831168831d0
#define CONV_regton_floz	172800d0
#define CONV_regton_ft3	100d0
#define CONV_regton_gal	748.051948051948d0
#define CONV_regton_galb	622.883545904283d0
#define CONV_regton_gald	642.851163958668d0
#define CONV_regton_gill	23937.6623376623d0
#define CONV_regton_gillb	19932.273468937d0
#define CONV_regton_in3	172800d0
#define CONV_regton_mile3	6.79357278014303d-10
#define CONV_regton_minim	45960311.6883117d0
#define CONV_regton_minimb	47837456.3254489d0
#define CONV_regton_ozbf	99661.3673446852d0
#define CONV_regton_peck	321.425581979334d0
#define CONV_regton_peckb	311.441772952141d0
#define CONV_regton_pt	5984.41558441558d0
#define CONV_regton_ptb	4983.06836723426d0
#define CONV_regton_ptd	5142.80931166935d0
#define CONV_regton_qt	2992.20779220779d0
#define CONV_regton_qtb	2491.53418361713d0
#define CONV_regton_qtd	2571.40465583467d0
#define CONV_regton_scrup	2391872.81627245d0
#define CONV_regton_seam	9.73255540475442d0
#define CONV_regton_yd3	3.7037037037037d0
#define CONV_scrup_cc	1.18387760416667d0
#define CONV_scrup_cl	0.118387760416667d0
#define CONV_scrup_cm3	1.18387760416667d0
#define CONV_scrup_cupm	0.00591938802083333d0
#define CONV_scrup_dm3	0.00118387760416667d0
#define CONV_scrup_km3	1.18387760416667d-15
#define CONV_scrup_l	0.00118387760416667d0
#define CONV_scrup_litero	0.00118384445652188d0
#define CONV_scrup_m3	1.18387760416667d-06
#define CONV_scrup_ml	1.18387760416667d0
#define CONV_scrup_mm3	1183.87760416667d0
#define CONV_scrup_acreft	9.59785193530308d-10
#define CONV_scrup_acrein	1.15174223223637d-08
#define CONV_scrup_bag	1.08506944444444d-05
#define CONV_scrup_bbl	7.44636610556085d-06
#define CONV_scrup_bblbb	7.2337962962963d-06
#define CONV_scrup_bblbw	8.26719576719577d-06
#define CONV_scrup_bbluc	1.24003851624015d-05
#define CONV_scrup_bblud	1.02387533951462d-05
#define CONV_scrup_bblul	9.92848814074781d-06
#define CONV_scrup_board	0.000501698916362163d0
#define CONV_scrup_boardf	0.000501698916362163d0
#define CONV_scrup_bu	3.35955971187728d-05
#define CONV_scrup_bub	3.25520833333333d-05
#define CONV_scrup_buck	6.51041666666667d-05
#define CONV_scrup_cord	3.26626898673283d-07
#define CONV_scrup_cordft	2.61301518938626d-06
#define CONV_scrup_cup	0.00903058049451893d0
#define CONV_scrup_dra	0.320253313467961d0
#define CONV_scrup_drach	0.333333333333333d0
#define CONV_scrup_firkb	2.89351851851852d-05
#define CONV_scrup_firku	3.47497084926173d-05
#define CONV_scrup_floz	0.0722446439561514d0
#define CONV_scrup_ft3	4.18082430301802d-05
#define CONV_scrup_gal	0.000312747376433556d0
#define CONV_scrup_galb	0.000260416666666667d0
#define CONV_scrup_gald	0.000268764776950182d0
#define CONV_scrup_gill	0.0100079160458738d0
#define CONV_scrup_gillb	0.00833333333333333d0
#define CONV_scrup_in3	0.0722446439561514d0
#define CONV_scrup_mile3	2.84027341835437d-16
#define CONV_scrup_minim	19.2151988080777d0
#define CONV_scrup_minimb	20d0
#define CONV_scrup_ozbf	0.0416666666666667d0
#define CONV_scrup_peck	0.000134382388475091d0
#define CONV_scrup_peckb	0.000130208333333333d0
#define CONV_scrup_pt	0.00250197901146845d0
#define CONV_scrup_ptb	0.00208333333333333d0
#define CONV_scrup_ptd	0.00215011821560146d0
#define CONV_scrup_qt	0.00125098950573422d0
#define CONV_scrup_qtb	0.00104166666666667d0
#define CONV_scrup_qtd	0.00107505910780073d0
#define CONV_scrup_regton	4.18082430301802d-07
#define CONV_scrup_seam	4.06901041666667d-06
#define CONV_scrup_yd3	1.54845344556223d-06
#define CONV_seam_cc	290949.76d0
#define CONV_seam_cl	29094.976d0
#define CONV_seam_cm3	290949.76d0
#define CONV_seam_cupm	1454.7488d0
#define CONV_seam_dm3	290.94976d0
#define CONV_seam_km3	2.9094976d-10
#define CONV_seam_l	290.94976d0
#define CONV_seam_litero	290.941613634818d0
#define CONV_seam_m3	0.29094976d0
#define CONV_seam_ml	290949.76d0
#define CONV_seam_mm3	290949760d0
#define CONV_seam_acreft	0.000235876809162008d0
#define CONV_seam_acrein	0.0028305217099441d0
#define CONV_seam_bag	2.66666666666667d0
#define CONV_seam_bbl	1.83001893410264d0
#define CONV_seam_bblbb	1.77777777777778d0
#define CONV_seam_bblbw	2.03174603174603d0
#define CONV_seam_bbluc	3.0475186575118d0
#define CONV_seam_bblud	2.51627603439112d0
#define CONV_seam_bblul	2.44002524547018d0
#define CONV_seam_board	123.297525685165d0
#define CONV_seam_boardf	123.297525685165d0
#define CONV_seam_bu	8.25645394790961d0
#define CONV_seam_bub	8d0
#define CONV_seam_buck	16d0
#define CONV_seam_cord	0.080271826617946d0
#define CONV_seam_cordft	0.642174612943568d0
#define CONV_seam_cup	2219.35546233297d0
#define CONV_seam_dra	78705.4543178862d0
#define CONV_seam_drach	81920d0
#define CONV_seam_firkb	7.11111111111111d0
#define CONV_seam_firku	8.54008835914563d0
#define CONV_seam_floz	17754.8436986638d0
#define CONV_seam_ft3	10.2747938070971d0
#define CONV_seam_gal	76.8607952323107d0
#define CONV_seam_galb	64d0
#define CONV_seam_gald	66.0516315832768d0
#define CONV_seam_gill	2459.54544743394d0
#define CONV_seam_gillb	2048d0
#define CONV_seam_in3	17754.8436986638d0
#define CONV_seam_mile3	6.98025595294769d-11
#define CONV_seam_minim	4722327.25907317d0
#define CONV_seam_minimb	4915200d0
#define CONV_seam_ozbf	10240d0
#define CONV_seam_peck	33.0258157916384d0
#define CONV_seam_peckb	32d0
#define CONV_seam_pt	614.886361858486d0
#define CONV_seam_ptb	512d0
#define CONV_seam_ptd	528.413052666215d0
#define CONV_seam_qt	307.443180929243d0
#define CONV_seam_qtb	256d0
#define CONV_seam_qtd	264.206526333107d0
#define CONV_seam_regton	0.102747938070971d0
#define CONV_seam_scrup	245760d0
#define CONV_seam_yd3	0.380547918781374d0
#define CONV_yd3_cc	764554.857984d0
#define CONV_yd3_cl	76455.4857984d0
#define CONV_yd3_cm3	764554.857984d0
#define CONV_yd3_cupm	3822.77428992d0
#define CONV_yd3_dm3	764.554857984d0
#define CONV_yd3_km3	7.64554857984d-10
#define CONV_yd3_l	764.554857984d0
#define CONV_yd3_litero	764.533451047371d0
#define CONV_yd3_m3	0.764554857984d0
#define CONV_yd3_ml	764554.857984d0
#define CONV_yd3_mm3	764554857.984d0
#define CONV_yd3_acreft	0.000619834710743802d0
#define CONV_yd3_acrein	0.00743801652892562d0
#define CONV_yd3_bag	7.00743989142318d0
#define CONV_yd3_bbl	4.80890538033395d0
#define CONV_yd3_bblbb	4.67162659428212d0
#define CONV_yd3_bblbw	5.33900182203671d0
#define CONV_yd3_bbluc	8.00823892893924d0
#define CONV_yd3_bblud	6.61224489795918d0
#define CONV_yd3_bblul	6.41187384044527d0
#define CONV_yd3_board	324d0
#define CONV_yd3_boardf	324d0
#define CONV_yd3_bu	21.6962267836051d0
#define CONV_yd3_bub	21.0223196742695d0
#define CONV_yd3_buck	42.0446393485391d0
#define CONV_yd3_cord	0.2109375d0
#define CONV_yd3_cordft	1.6875d0
#define CONV_yd3_cup	5832d0
#define CONV_yd3_dra	206821.402597403d0
#define CONV_yd3_drach	215268.55346452d0
#define CONV_yd3_firkb	18.6865063771285d0
#define CONV_yd3_firku	22.4415584415584d0
#define CONV_yd3_floz	46656d0
#define CONV_yd3_ft3	27d0
#define CONV_yd3_gal	201.974025974026d0
#define CONV_yd3_galb	168.178557394156d0
#define CONV_yd3_gald	173.569814268841d0
#define CONV_yd3_gill	6463.16883116883d0
#define CONV_yd3_gillb	5381.713836613d0
#define CONV_yd3_in3	46656d0
#define CONV_yd3_mile3	1.83426465063862d-10
#define CONV_yd3_minim	12409284.1558442d0
#define CONV_yd3_minimb	12916113.2078712d0
#define CONV_yd3_ozbf	26908.569183065d0
#define CONV_yd3_peck	86.7849071344203d0
#define CONV_yd3_peckb	84.0892786970782d0
#define CONV_yd3_pt	1615.79220779221d0
#define CONV_yd3_ptb	1345.42845915325d0
#define CONV_yd3_ptd	1388.55851415072d0
#define CONV_yd3_qt	807.896103896104d0
#define CONV_yd3_qtb	672.714229576625d0
#define CONV_yd3_qtd	694.279257075362d0
#define CONV_yd3_regton	0.27d0
#define CONV_yd3_scrup	645805.660393561d0
#define CONV_yd3_seam	2.62778995928369d0



c FREQUENCY (Hz)
c ====================
c 
c Hz     = hertz
c pS     = per seconds (s-1)



#define CONV_Hz_pS	1d0
#define CONV_pS_Hz	1d0



c FORCE (N)
c ====================
c 
c dyn    = dyne
c kgf    = kg-force
c N      = newton
c lbal   = poundal
c lbf    = pound-force
c mgf    = mg-force



#define CONV_dyn_kgf	1.01971621297793d-06
#define CONV_dyn_N	1d-05
#define CONV_dyn_lbal	7.233014d-05
#define CONV_dyn_lbf	2.248089d-06
#define CONV_dyn_mgf	1.01971621297793d0
#define CONV_kgf_dyn	980665d0
#define CONV_kgf_N	9.80665d0
#define CONV_kgf_lbal	70.9316367431d0
#define CONV_kgf_lbf	2.204622199185d0
#define CONV_kgf_mgf	1000000d0
#define CONV_N_dyn	100000d0
#define CONV_N_kgf	0.101971621297793d0
#define CONV_N_lbal	7.233014d0
#define CONV_N_lbf	0.2248089d0
#define CONV_N_mgf	101971.621297793d0
#define CONV_lbal_dyn	13825.4951531962d0
#define CONV_lbal_kgf	0.0140980815601619d0
#define CONV_lbal_N	0.138254951531962d0
#define CONV_lbal_lbf	0.0310809435734536d0
#define CONV_lbal_mgf	14098.0815601619d0
#define CONV_lbf_dyn	444822.246806065d0
#define CONV_lbf_kgf	0.453592456961414d0
#define CONV_lbf_N	4.44822246806065d0
#define CONV_lbf_lbal	32.1740553865972d0
#define CONV_lbf_mgf	453592.456961414d0
#define CONV_mgf_dyn	0.980665d0
#define CONV_mgf_kgf	1d-06
#define CONV_mgf_N	9.80665d-06
#define CONV_mgf_lbal	7.09316367431d-05
#define CONV_mgf_lbf	2.204622199185d-06



c PRESSURE (Pa)
c ====================
c 
c atm      = atmosphere
c atmt     = atmosphere (tech)
c bar      = bar
c barye    = barye
c cmh2o    = cm of water
c cmhg     = cm of mercury
c dynPcm2  = dyne per square cm
c fth2o    = foot of water
c gPcm2    = gram-force per square cm
c inh2o    = inch of water
c inhg     = inch of mercury
c kgPcm2   = kg-force per square cm
c kgPm2    = kg-force per square m
c kgPmm2   = kg-force per square mm
c kPa      = kilopascal
c lbalPft2 = poundal per square foot
c lbPft2   = pound-force per square foot
c lbPin2   = pound-force per square inch
c mbar     = millibar
c megaPa   = megapascal
c mh2o     = meter of water
c mmh2o    = mm of water
c mmhg     = mm of mercury
c NPcm2    = newton per square cm
c NPm2     = newton per square m
c NPmm2    = newton per square mm
c Pa       = pascal (N m-2) (SI)
c psf      = pound-force per square foot
c psi      = pound-force per square inche
c t        = torr
c tonlPft2 = ton-force (long) per square foot
c tonlPin2 = ton-force (long) per square inch
c tonmPin2 = ton-force (metric) per square inch
c tonmPm2  = ton-force (metric) per square meter
c tonsPft2 = ton-force (short) per square foot
c tonsPin2 = ton-force (short) per square inch



#define CONV_atm_atmt	1.03322745279989d0
#define CONV_atm_bar	1.01325d0
#define CONV_atm_barye	1013250d0
#define CONV_atm_cmh2o	1033.22745279989d0
#define CONV_atm_cmhg	75.9999732992034d0
#define CONV_atm_dynPcm2	1013250d0
#define CONV_atm_fth2o	33.8985384776865d0
#define CONV_atm_gPcm2	1033.227237d0
#define CONV_atm_inh2o	406.782461732238d0
#define CONV_atm_inhg	29.9278596929274d0
#define CONV_atm_kgPcm2	1.03322745279989d0
#define CONV_atm_kgPm2	10332.2745279989d0
#define CONV_atm_kgPmm2	0.0103322745279989d0
#define CONV_atm_kPa	101.325d0
#define CONV_atm_lbalPft2	68087.258925d0
#define CONV_atm_lbPft2	2116.2168d0
#define CONV_atm_lbPin2	14.69595d0
#define CONV_atm_mbar	1013.25d0
#define CONV_atm_megaPa	0.101325d0
#define CONV_atm_mh2o	10.3322745279989d0
#define CONV_atm_mmh2o	10332.27237d0
#define CONV_atm_mmhg	760d0
#define CONV_atm_NPcm2	10.1325d0
#define CONV_atm_NPm2	101325d0
#define CONV_atm_NPmm2	0.101325d0
#define CONV_atm_Pa	101325d0
#define CONV_atm_psf	2116.2168d0
#define CONV_atm_psi	14.69595d0
#define CONV_atm_t	760d0
#define CONV_atm_tonlPft2	0.94474d0
#define CONV_atm_tonlPin2	0.00656069d0
#define CONV_atm_tonmPin2	0.00656069196428571d0
#define CONV_atm_tonmPm2	10.3322745279989d0
#define CONV_atm_tonsPft2	1.0581084d0
#define CONV_atm_tonsPin2	0.007347975d0
#define CONV_atmt_atm	0.967841105354059d0
#define CONV_atmt_bar	0.980665d0
#define CONV_atmt_barye	980665d0
#define CONV_atmt_cmh2o	1000d0
#define CONV_atmt_cmhg	73.55589816478d0
#define CONV_atmt_dynPcm2	980665d0
#define CONV_atmt_fth2o	32.8083989501312d0
#define CONV_atmt_gPcm2	999.99979114d0
#define CONV_atmt_inh2o	393.700787401575d0
#define CONV_atmt_inhg	28.965412806084d0
#define CONV_atmt_kgPcm2	1d0
#define CONV_atmt_kgPm2	10000d0
#define CONV_atmt_kgPmm2	0.01d0
#define CONV_atmt_kPa	98.0665d0
#define CONV_atmt_lbalPft2	65897.6479385d0
#define CONV_atmt_lbPft2	2048.16160688083d0
#define CONV_atmt_lbPin2	14.223344492228d0
#define CONV_atmt_mbar	980.665d0
#define CONV_atmt_megaPa	0.0980665d0
#define CONV_atmt_mh2o	10d0
#define CONV_atmt_mmh2o	9999.9979114d0
#define CONV_atmt_mmhg	735.559240069085d0
#define CONV_atmt_NPcm2	9.80665d0
#define CONV_atmt_NPm2	98066.5d0
#define CONV_atmt_NPmm2	0.0980665d0
#define CONV_atmt_Pa	98066.5d0
#define CONV_atmt_psf	2048.16160688083d0
#define CONV_atmt_psi	14.223344492228d0
#define CONV_atmt_t	735.559240069085d0
#define CONV_atmt_tonlPft2	0.914358205872194d0
#define CONV_atmt_tonlPin2	0.00634970546148532d0
#define CONV_atmt_tonmPin2	0.00634970736260178d0
#define CONV_atmt_tonmPm2	10d0
#define CONV_atmt_tonsPft2	1.02408080344041d0
#define CONV_atmt_tonsPin2	0.00711167224611399d0
#define CONV_bar_atm	0.986923266716013d0
#define CONV_bar_atmt	1.01971621297793d0
#define CONV_bar_barye	1000000d0
#define CONV_bar_cmh2o	1019.71621297793d0
#define CONV_bar_cmhg	75.0061419187796d0
#define CONV_bar_dynPcm2	1000000d0
#define CONV_bar_fth2o	33.4552563312969d0
#define CONV_bar_gPcm2	1019.716d0
#define CONV_bar_inh2o	401.463075975562d0
#define CONV_bar_inhg	29.5365010539624d0
#define CONV_bar_kgPcm2	1.01971621297793d0
#define CONV_bar_kgPm2	10197.1621297793d0
#define CONV_bar_kgPmm2	0.0101971621297793d0
#define CONV_bar_kPa	100d0
#define CONV_bar_lbalPft2	67196.9d0
#define CONV_bar_lbPft2	2088.54359733531d0
#define CONV_bar_lbPin2	14.5037749814952d0
#define CONV_bar_mbar	1000d0
#define CONV_bar_megaPa	0.1d0
#define CONV_bar_mh2o	10.1971621297793d0
#define CONV_bar_mmh2o	10197.16d0
#define CONV_bar_mmhg	750.06168270417d0
#define CONV_bar_NPcm2	10d0
#define CONV_bar_NPm2	100000d0
#define CONV_bar_NPmm2	0.1d0
#define CONV_bar_Pa	100000d0
#define CONV_bar_psf	2088.54359733531d0
#define CONV_bar_psi	14.5037749814952d0
#define CONV_bar_t	750.06168270417d0
#define CONV_bar_tonlPft2	0.932385886997286d0
#define CONV_bar_tonlPin2	0.00647489760671108d0
#define CONV_bar_tonmPin2	0.00647489954531035d0
#define CONV_bar_tonmPm2	10.1971621297793d0
#define CONV_bar_tonsPft2	1.04427179866765d0
#define CONV_bar_tonsPin2	0.00725188749074759d0
#define CONV_barye_atm	9.86923266716013d-07
#define CONV_barye_atmt	1.01971621297793d-06
#define CONV_barye_bar	1d-06
#define CONV_barye_cmh2o	0.00101971621297793d0
#define CONV_barye_cmhg	7.50061419187796d-05
#define CONV_barye_dynPcm2	1d0
#define CONV_barye_fth2o	3.34552563312969d-05
#define CONV_barye_gPcm2	0.001019716d0
#define CONV_barye_inh2o	0.000401463075975562d0
#define CONV_barye_inhg	2.95365010539624d-05
#define CONV_barye_kgPcm2	1.01971621297793d-06
#define CONV_barye_kgPm2	0.0101971621297793d0
#define CONV_barye_kgPmm2	1.01971621297793d-08
#define CONV_barye_kPa	0.0001d0
#define CONV_barye_lbalPft2	0.0671969d0
#define CONV_barye_lbPft2	0.00208854359733531d0
#define CONV_barye_lbPin2	1.45037749814952d-05
#define CONV_barye_mbar	0.001d0
#define CONV_barye_megaPa	1d-07
#define CONV_barye_mh2o	1.01971621297793d-05
#define CONV_barye_mmh2o	0.01019716d0
#define CONV_barye_mmhg	0.00075006168270417d0
#define CONV_barye_NPcm2	1d-05
#define CONV_barye_NPm2	0.1d0
#define CONV_barye_NPmm2	1d-07
#define CONV_barye_Pa	0.1d0
#define CONV_barye_psf	0.00208854359733531d0
#define CONV_barye_psi	1.45037749814952d-05
#define CONV_barye_t	0.00075006168270417d0
#define CONV_barye_tonlPft2	9.32385886997286d-07
#define CONV_barye_tonlPin2	6.47489760671108d-09
#define CONV_barye_tonmPin2	6.47489954531035d-09
#define CONV_barye_tonmPm2	1.01971621297793d-05
#define CONV_barye_tonsPft2	1.04427179866765d-06
#define CONV_barye_tonsPin2	7.25188749074759d-09
#define CONV_cmh2o_atm	0.000967841105354059d0
#define CONV_cmh2o_atmt	0.001d0
#define CONV_cmh2o_bar	0.000980665d0
#define CONV_cmh2o_barye	980.665d0
#define CONV_cmh2o_cmhg	0.07355589816478d0
#define CONV_cmh2o_dynPcm2	980.665d0
#define CONV_cmh2o_fth2o	0.0328083989501312d0
#define CONV_cmh2o_gPcm2	0.99999979114d0
#define CONV_cmh2o_inh2o	0.393700787401575d0
#define CONV_cmh2o_inhg	0.028965412806084d0
#define CONV_cmh2o_kgPcm2	0.001d0
#define CONV_cmh2o_kgPm2	10d0
#define CONV_cmh2o_kgPmm2	1d-05
#define CONV_cmh2o_kPa	0.0980665d0
#define CONV_cmh2o_lbalPft2	65.8976479385d0
#define CONV_cmh2o_lbPft2	2.04816160688083d0
#define CONV_cmh2o_lbPin2	0.014223344492228d0
#define CONV_cmh2o_mbar	0.980665d0
#define CONV_cmh2o_megaPa	9.80665d-05
#define CONV_cmh2o_mh2o	0.01d0
#define CONV_cmh2o_mmh2o	9.9999979114d0
#define CONV_cmh2o_mmhg	0.735559240069085d0
#define CONV_cmh2o_NPcm2	0.00980665d0
#define CONV_cmh2o_NPm2	98.0665d0
#define CONV_cmh2o_NPmm2	9.80665d-05
#define CONV_cmh2o_Pa	98.0665d0
#define CONV_cmh2o_psf	2.04816160688083d0
#define CONV_cmh2o_psi	0.014223344492228d0
#define CONV_cmh2o_t	0.735559240069085d0
#define CONV_cmh2o_tonlPft2	0.000914358205872194d0
#define CONV_cmh2o_tonlPin2	6.34970546148532d-06
#define CONV_cmh2o_tonmPin2	6.34970736260178d-06
#define CONV_cmh2o_tonmPm2	0.01d0
#define CONV_cmh2o_tonsPft2	0.00102408080344041d0
#define CONV_cmh2o_tonsPin2	7.11167224611399d-06
#define CONV_cmhg_atm	0.0131578993595578d0
#define CONV_cmhg_atmt	0.0135951028394732d0
#define CONV_cmhg_bar	0.013332241526072d0
#define CONV_cmhg_barye	13332.241526072d0
#define CONV_cmhg_cmh2o	13.5951028394732d0
#define CONV_cmhg_dynPcm2	13332.241526072d0
#define CONV_cmhg_fth2o	0.446033557725498d0
#define CONV_cmhg_gPcm2	13.5951d0
#define CONV_cmhg_inh2o	5.35240269270597d0
#define CONV_cmhg_inhg	0.393787765886506d0
#define CONV_cmhg_kgPcm2	0.0135951028394732d0
#define CONV_cmhg_kgPm2	135.951028394732d0
#define CONV_cmhg_kgPmm2	0.000135951028394732d0
#define CONV_cmhg_kPa	1.3332241526072d0
#define CONV_cmhg_lbalPft2	895.885300603305d0
#define CONV_cmhg_lbPft2	27.8449676774055d0
#define CONV_cmhg_lbPin2	0.193367831093094d0
#define CONV_cmhg_mbar	13.332241526072d0
#define CONV_cmhg_megaPa	0.0013332241526072d0
#define CONV_cmhg_mh2o	0.135951028394732d0
#define CONV_cmhg_mmh2o	135.951d0
#define CONV_cmhg_mmhg	10.0000035132639d0
#define CONV_cmhg_NPcm2	0.13332241526072d0
#define CONV_cmhg_NPm2	1333.2241526072d0
#define CONV_cmhg_NPmm2	0.0013332241526072d0
#define CONV_cmhg_Pa	1333.2241526072d0
#define CONV_cmhg_psf	27.8449676774055d0
#define CONV_cmhg_psi	0.193367831093094d0
#define CONV_cmhg_t	10.0000035132639d0
#define CONV_cmhg_tonlPft2	0.0124307938409487d0
#define CONV_cmhg_tonlPin2	8.63248987492574d-05
#define CONV_cmhg_tonmPin2	8.63249245951312d-05
#define CONV_cmhg_tonmPm2	0.135951028394732d0
#define CONV_cmhg_tonsPft2	0.0139224838387028d0
#define CONV_cmhg_tonsPin2	9.66839155465469d-05
#define CONV_dynPcm2_atm	9.86923266716013d-07
#define CONV_dynPcm2_atmt	1.01971621297793d-06
#define CONV_dynPcm2_bar	1d-06
#define CONV_dynPcm2_barye	1d0
#define CONV_dynPcm2_cmh2o	0.00101971621297793d0
#define CONV_dynPcm2_cmhg	7.50061419187796d-05
#define CONV_dynPcm2_fth2o	3.34552563312969d-05
#define CONV_dynPcm2_gPcm2	0.001019716d0
#define CONV_dynPcm2_inh2o	0.000401463075975562d0
#define CONV_dynPcm2_inhg	2.95365010539624d-05
#define CONV_dynPcm2_kgPcm2	1.01971621297793d-06
#define CONV_dynPcm2_kgPm2	0.0101971621297793d0
#define CONV_dynPcm2_kgPmm2	1.01971621297793d-08
#define CONV_dynPcm2_kPa	0.0001d0
#define CONV_dynPcm2_lbalPft2	0.0671969d0
#define CONV_dynPcm2_lbPft2	0.00208854359733531d0
#define CONV_dynPcm2_lbPin2	1.45037749814952d-05
#define CONV_dynPcm2_mbar	0.001d0
#define CONV_dynPcm2_megaPa	1d-07
#define CONV_dynPcm2_mh2o	1.01971621297793d-05
#define CONV_dynPcm2_mmh2o	0.01019716d0
#define CONV_dynPcm2_mmhg	0.00075006168270417d0
#define CONV_dynPcm2_NPcm2	1d-05
#define CONV_dynPcm2_NPm2	0.1d0
#define CONV_dynPcm2_NPmm2	1d-07
#define CONV_dynPcm2_Pa	0.1d0
#define CONV_dynPcm2_psf	0.00208854359733531d0
#define CONV_dynPcm2_psi	1.45037749814952d-05
#define CONV_dynPcm2_t	0.00075006168270417d0
#define CONV_dynPcm2_tonlPft2	9.32385886997286d-07
#define CONV_dynPcm2_tonlPin2	6.47489760671108d-09
#define CONV_dynPcm2_tonmPin2	6.47489954531035d-09
#define CONV_dynPcm2_tonmPm2	1.01971621297793d-05
#define CONV_dynPcm2_tonsPft2	1.04427179866765d-06
#define CONV_dynPcm2_tonsPin2	7.25188749074759d-09
#define CONV_fth2o_atm	0.0294997968911917d0
#define CONV_fth2o_atmt	0.03048d0
#define CONV_fth2o_bar	0.0298906692d0
#define CONV_fth2o_barye	29890.6692d0
#define CONV_fth2o_cmh2o	30.48d0
#define CONV_fth2o_cmhg	2.24198377606249d0
#define CONV_fth2o_dynPcm2	29890.6692d0
#define CONV_fth2o_gPcm2	30.4799936339472d0
#define CONV_fth2o_inh2o	12d0
#define CONV_fth2o_inhg	0.882865782329441d0
#define CONV_fth2o_kgPcm2	0.03048d0
#define CONV_fth2o_kgPm2	304.8d0
#define CONV_fth2o_kgPmm2	0.0003048d0
#define CONV_fth2o_kPa	2.98906692d0
#define CONV_fth2o_lbalPft2	2008.56030916548d0
#define CONV_fth2o_lbPft2	62.4279657777277d0
#define CONV_fth2o_lbPin2	0.433527540123109d0
#define CONV_fth2o_mbar	29.8906692d0
#define CONV_fth2o_megaPa	0.00298906692d0
#define CONV_fth2o_mh2o	0.3048d0
#define CONV_fth2o_mmh2o	304.799936339472d0
#define CONV_fth2o_mmhg	22.4198456373057d0
#define CONV_fth2o_NPcm2	0.298906692d0
#define CONV_fth2o_NPm2	2989.06692d0
#define CONV_fth2o_NPmm2	0.00298906692d0
#define CONV_fth2o_Pa	2989.06692d0
#define CONV_fth2o_psf	62.4279657777277d0
#define CONV_fth2o_psi	0.433527540123109d0
#define CONV_fth2o_t	22.4198456373057d0
#define CONV_fth2o_tonlPft2	0.0278696381149845d0
#define CONV_fth2o_tonlPin2	0.000193539022466073d0
#define CONV_fth2o_tonmPin2	0.000193539080412102d0
#define CONV_fth2o_tonmPm2	0.3048d0
#define CONV_fth2o_tonsPft2	0.0312139828888638d0
#define CONV_fth2o_tonsPin2	0.000216763770061554d0
#define CONV_gPcm2_atm	0.000967841307497394d0
#define CONV_gPcm2_atmt	0.00100000020886004d0
#define CONV_gPcm2_bar	0.000980665204821735d0
#define CONV_gPcm2_barye	980.665204821735d0
#define CONV_gPcm2_cmh2o	1.00000020886004d0
#define CONV_gPcm2_cmhg	0.073555913527668d0
#define CONV_gPcm2_dynPcm2	980.665204821735d0
#define CONV_gPcm2_fth2o	0.0328084058024949d0
#define CONV_gPcm2_inh2o	0.393700869629938d0
#define CONV_gPcm2_inhg	0.0289654188558014d0
#define CONV_gPcm2_kgPcm2	0.00100000020886004d0
#define CONV_gPcm2_kgPm2	10.0000020886004d0
#define CONV_gPcm2_kgPmm2	1.00000020886004d-05
#define CONV_gPcm2_kPa	0.0980665204821735d0
#define CONV_gPcm2_lbalPft2	65.8976617018856d0
#define CONV_gPcm2_lbPft2	2.04816203465995d0
#define CONV_gPcm2_lbPin2	0.0142233474629163d0
#define CONV_gPcm2_mbar	0.980665204821735d0
#define CONV_gPcm2_megaPa	9.80665204821735d-05
#define CONV_gPcm2_mh2o	0.0100000020886004d0
#define CONV_gPcm2_mmh2o	10d0
#define CONV_gPcm2_mmhg	0.73555939369802d0
#define CONV_gPcm2_NPcm2	0.00980665204821735d0
#define CONV_gPcm2_NPm2	98.0665204821735d0
#define CONV_gPcm2_NPmm2	9.80665204821735d-05
#define CONV_gPcm2_Pa	98.0665204821735d0
#define CONV_gPcm2_psf	2.04816203465995d0
#define CONV_gPcm2_psi	0.0142233474629163d0
#define CONV_gPcm2_t	0.73555939369802d0
#define CONV_gPcm2_tonlPft2	0.000914358396845088d0
#define CONV_gPcm2_tonlPin2	6.34970678768508d-06
#define CONV_gPcm2_tonmPin2	6.34970868880193d-06
#define CONV_gPcm2_tonmPm2	0.0100000020886004d0
#define CONV_gPcm2_tonsPft2	0.00102408101732998d0
#define CONV_gPcm2_tonsPin2	7.11167373145816d-06
#define CONV_inh2o_atm	0.00245831640759931d0
#define CONV_inh2o_atmt	0.00254d0
#define CONV_inh2o_bar	0.0024908891d0
#define CONV_inh2o_barye	2490.8891d0
#define CONV_inh2o_cmh2o	2.54d0
#define CONV_inh2o_cmhg	0.186831981338541d0
#define CONV_inh2o_dynPcm2	2490.8891d0
#define CONV_inh2o_fth2o	0.0833333333333333d0
#define CONV_inh2o_gPcm2	2.5399994694956d0
#define CONV_inh2o_inhg	0.0735721485274534d0
#define CONV_inh2o_kgPcm2	0.00254d0
#define CONV_inh2o_kgPm2	25.4d0
#define CONV_inh2o_kgPmm2	2.54d-05
#define CONV_inh2o_kPa	0.24908891d0
#define CONV_inh2o_lbalPft2	167.38002576379d0
#define CONV_inh2o_lbPft2	5.20233048147731d0
#define CONV_inh2o_lbPin2	0.0361272950102591d0
#define CONV_inh2o_mbar	2.4908891d0
#define CONV_inh2o_megaPa	0.00024908891d0
#define CONV_inh2o_mh2o	0.0254d0
#define CONV_inh2o_mmh2o	25.399994694956d0
#define CONV_inh2o_mmhg	1.86832046977548d0
#define CONV_inh2o_NPcm2	0.024908891d0
#define CONV_inh2o_NPm2	249.08891d0
#define CONV_inh2o_NPmm2	0.00024908891d0
#define CONV_inh2o_Pa	249.08891d0
#define CONV_inh2o_psf	5.20233048147731d0
#define CONV_inh2o_psi	0.0361272950102591d0
#define CONV_inh2o_t	1.86832046977548d0
#define CONV_inh2o_tonlPft2	0.00232246984291537d0
#define CONV_inh2o_tonlPin2	1.61282518721727d-05
#define CONV_inh2o_tonmPin2	1.61282567010085d-05
#define CONV_inh2o_tonmPm2	0.0254d0
#define CONV_inh2o_tonsPft2	0.00260116524073865d0
#define CONV_inh2o_tonsPin2	1.80636475051295d-05
#define CONV_inhg_atm	0.0334136824437306d0
#define CONV_inhg_atmt	0.034523934d0
#define CONV_inhg_bar	0.03385641373611d0
#define CONV_inhg_barye	33856.41373611d0
#define CONV_inhg_cmh2o	34.523934d0
#define CONV_inhg_cmhg	2.53943897355159d0
#define CONV_inhg_dynPcm2	33856.41373611d0
#define CONV_inhg_fth2o	1.132675d0
#define CONV_inhg_gPcm2	34.5239267893312d0
#define CONV_inhg_inh2o	13.5921d0
#define CONV_inhg_kgPcm2	0.034523934d0
#define CONV_inhg_kgPm2	345.23934d0
#define CONV_inhg_kgPmm2	0.00034523934d0
#define CONV_inhg_kPa	3.385641373611d0
#define CONV_inhg_lbalPft2	2275.04604818401d0
#define CONV_inhg_lbPft2	70.7105961372877d0
#define CONV_inhg_lbPin2	0.491045806508942d0
#define CONV_inhg_mbar	33.85641373611d0
#define CONV_inhg_megaPa	0.003385641373611d0
#define CONV_inhg_mh2o	0.34523934d0
#define CONV_inhg_mmh2o	345.239267893312d0
#define CONV_inhg_mmhg	25.3943986572352d0
#define CONV_inhg_NPcm2	0.3385641373611d0
#define CONV_inhg_NPm2	3385.641373611d0
#define CONV_inhg_NPmm2	0.003385641373611d0
#define CONV_inhg_Pa	3385.641373611d0
#define CONV_inhg_psf	70.7105961372877d0
#define CONV_inhg_psi	0.491045806508942d0
#define CONV_inhg_t	25.3943986572352d0
#define CONV_inhg_tonlPft2	0.03156724235189d0
#define CONV_inhg_tonlPin2	0.000219216812271759d0
#define CONV_inhg_tonmPin2	0.000219216877905778d0
#define CONV_inhg_tonmPm2	0.34523934d0
#define CONV_inhg_tonsPft2	0.0353552980686438d0
#define CONV_inhg_tonsPin2	0.000245522903254471d0
#define CONV_kgPcm2_atm	0.967841105354059d0
#define CONV_kgPcm2_atmt	1d0
#define CONV_kgPcm2_bar	0.980665d0
#define CONV_kgPcm2_barye	980665d0
#define CONV_kgPcm2_cmh2o	1000d0
#define CONV_kgPcm2_cmhg	73.55589816478d0
#define CONV_kgPcm2_dynPcm2	980665d0
#define CONV_kgPcm2_fth2o	32.8083989501312d0
#define CONV_kgPcm2_gPcm2	999.99979114d0
#define CONV_kgPcm2_inh2o	393.700787401575d0
#define CONV_kgPcm2_inhg	28.965412806084d0
#define CONV_kgPcm2_kgPm2	10000d0
#define CONV_kgPcm2_kgPmm2	0.01d0
#define CONV_kgPcm2_kPa	98.0665d0
#define CONV_kgPcm2_lbalPft2	65897.6479385d0
#define CONV_kgPcm2_lbPft2	2048.16160688083d0
#define CONV_kgPcm2_lbPin2	14.223344492228d0
#define CONV_kgPcm2_mbar	980.665d0
#define CONV_kgPcm2_megaPa	0.0980665d0
#define CONV_kgPcm2_mh2o	10d0
#define CONV_kgPcm2_mmh2o	9999.9979114d0
#define CONV_kgPcm2_mmhg	735.559240069085d0
#define CONV_kgPcm2_NPcm2	9.80665d0
#define CONV_kgPcm2_NPm2	98066.5d0
#define CONV_kgPcm2_NPmm2	0.0980665d0
#define CONV_kgPcm2_Pa	98066.5d0
#define CONV_kgPcm2_psf	2048.16160688083d0
#define CONV_kgPcm2_psi	14.223344492228d0
#define CONV_kgPcm2_t	735.559240069085d0
#define CONV_kgPcm2_tonlPft2	0.914358205872194d0
#define CONV_kgPcm2_tonlPin2	0.00634970546148532d0
#define CONV_kgPcm2_tonmPin2	0.00634970736260178d0
#define CONV_kgPcm2_tonmPm2	10d0
#define CONV_kgPcm2_tonsPft2	1.02408080344041d0
#define CONV_kgPcm2_tonsPin2	0.00711167224611399d0
#define CONV_kgPm2_atm	9.67841105354059d-05
#define CONV_kgPm2_atmt	0.0001d0
#define CONV_kgPm2_bar	9.80665d-05
#define CONV_kgPm2_barye	98.0665d0
#define CONV_kgPm2_cmh2o	0.1d0
#define CONV_kgPm2_cmhg	0.007355589816478d0
#define CONV_kgPm2_dynPcm2	98.0665d0
#define CONV_kgPm2_fth2o	0.00328083989501312d0
#define CONV_kgPm2_gPcm2	0.099999979114d0
#define CONV_kgPm2_inh2o	0.0393700787401575d0
#define CONV_kgPm2_inhg	0.0028965412806084d0
#define CONV_kgPm2_kgPcm2	0.0001d0
#define CONV_kgPm2_kgPmm2	1d-06
#define CONV_kgPm2_kPa	0.00980665d0
#define CONV_kgPm2_lbalPft2	6.58976479385d0
#define CONV_kgPm2_lbPft2	0.204816160688083d0
#define CONV_kgPm2_lbPin2	0.0014223344492228d0
#define CONV_kgPm2_mbar	0.0980665d0
#define CONV_kgPm2_megaPa	9.80665d-06
#define CONV_kgPm2_mh2o	0.001d0
#define CONV_kgPm2_mmh2o	0.99999979114d0
#define CONV_kgPm2_mmhg	0.0735559240069085d0
#define CONV_kgPm2_NPcm2	0.000980665d0
#define CONV_kgPm2_NPm2	9.80665d0
#define CONV_kgPm2_NPmm2	9.80665d-06
#define CONV_kgPm2_Pa	9.80665d0
#define CONV_kgPm2_psf	0.204816160688083d0
#define CONV_kgPm2_psi	0.0014223344492228d0
#define CONV_kgPm2_t	0.0735559240069085d0
#define CONV_kgPm2_tonlPft2	9.14358205872193d-05
#define CONV_kgPm2_tonlPin2	6.34970546148532d-07
#define CONV_kgPm2_tonmPin2	6.34970736260178d-07
#define CONV_kgPm2_tonmPm2	0.001d0
#define CONV_kgPm2_tonsPft2	0.000102408080344041d0
#define CONV_kgPm2_tonsPin2	7.11167224611399d-07
#define CONV_kgPmm2_atm	96.7841105354059d0
#define CONV_kgPmm2_atmt	100d0
#define CONV_kgPmm2_bar	98.0665d0
#define CONV_kgPmm2_barye	98066500d0
#define CONV_kgPmm2_cmh2o	100000d0
#define CONV_kgPmm2_cmhg	7355.589816478d0
#define CONV_kgPmm2_dynPcm2	98066500d0
#define CONV_kgPmm2_fth2o	3280.83989501312d0
#define CONV_kgPmm2_gPcm2	99999.979114d0
#define CONV_kgPmm2_inh2o	39370.0787401575d0
#define CONV_kgPmm2_inhg	2896.5412806084d0
#define CONV_kgPmm2_kgPcm2	100d0
#define CONV_kgPmm2_kgPm2	1000000d0
#define CONV_kgPmm2_kPa	9806.65d0
#define CONV_kgPmm2_lbalPft2	6589764.79385d0
#define CONV_kgPmm2_lbPft2	204816.160688083d0
#define CONV_kgPmm2_lbPin2	1422.3344492228d0
#define CONV_kgPmm2_mbar	98066.5d0
#define CONV_kgPmm2_megaPa	9.80665d0
#define CONV_kgPmm2_mh2o	1000d0
#define CONV_kgPmm2_mmh2o	999999.79114d0
#define CONV_kgPmm2_mmhg	73555.9240069085d0
#define CONV_kgPmm2_NPcm2	980.665d0
#define CONV_kgPmm2_NPm2	9806650d0
#define CONV_kgPmm2_NPmm2	9.80665d0
#define CONV_kgPmm2_Pa	9806650d0
#define CONV_kgPmm2_psf	204816.160688083d0
#define CONV_kgPmm2_psi	1422.3344492228d0
#define CONV_kgPmm2_t	73555.9240069085d0
#define CONV_kgPmm2_tonlPft2	91.4358205872194d0
#define CONV_kgPmm2_tonlPin2	0.634970546148532d0
#define CONV_kgPmm2_tonmPin2	0.634970736260178d0
#define CONV_kgPmm2_tonmPm2	1000d0
#define CONV_kgPmm2_tonsPft2	102.408080344041d0
#define CONV_kgPmm2_tonsPin2	0.711167224611399d0
#define CONV_kPa_atm	0.00986923266716013d0
#define CONV_kPa_atmt	0.0101971621297793d0
#define CONV_kPa_bar	0.01d0
#define CONV_kPa_barye	10000d0
#define CONV_kPa_cmh2o	10.1971621297793d0
#define CONV_kPa_cmhg	0.750061419187796d0
#define CONV_kPa_dynPcm2	10000d0
#define CONV_kPa_fth2o	0.334552563312969d0
#define CONV_kPa_gPcm2	10.19716d0
#define CONV_kPa_inh2o	4.01463075975562d0
#define CONV_kPa_inhg	0.295365010539624d0
#define CONV_kPa_kgPcm2	0.0101971621297793d0
#define CONV_kPa_kgPm2	101.971621297793d0
#define CONV_kPa_kgPmm2	0.000101971621297793d0
#define CONV_kPa_lbalPft2	671.969d0
#define CONV_kPa_lbPft2	20.8854359733531d0
#define CONV_kPa_lbPin2	0.145037749814952d0
#define CONV_kPa_mbar	10d0
#define CONV_kPa_megaPa	0.001d0
#define CONV_kPa_mh2o	0.101971621297793d0
#define CONV_kPa_mmh2o	101.9716d0
#define CONV_kPa_mmhg	7.5006168270417d0
#define CONV_kPa_NPcm2	0.1d0
#define CONV_kPa_NPm2	1000d0
#define CONV_kPa_NPmm2	0.001d0
#define CONV_kPa_Pa	1000d0
#define CONV_kPa_psf	20.8854359733531d0
#define CONV_kPa_psi	0.145037749814952d0
#define CONV_kPa_t	7.5006168270417d0
#define CONV_kPa_tonlPft2	0.00932385886997286d0
#define CONV_kPa_tonlPin2	6.47489760671108d-05
#define CONV_kPa_tonmPin2	6.47489954531035d-05
#define CONV_kPa_tonmPm2	0.101971621297793d0
#define CONV_kPa_tonsPft2	0.0104427179866765d0
#define CONV_kPa_tonsPin2	7.25188749074759d-05
#define CONV_lbalPft2_atm	1.46870356625977d-05
#define CONV_lbalPft2_atmt	1.51750484468469d-05
#define CONV_lbalPft2_bar	1.48816388851271d-05
#define CONV_lbalPft2_barye	14.8816388851271d0
#define CONV_lbalPft2_cmh2o	0.0151750484468469d0
#define CONV_lbalPft2_cmhg	0.00111621431820187d0
#define CONV_lbalPft2_dynPcm2	14.8816388851271d0
#define CONV_lbalPft2_fth2o	0.000497869043531723d0
#define CONV_lbalPft2_gPcm2	0.0151750452773863d0
#define CONV_lbalPft2_inh2o	0.00597442852238068d0
#define CONV_lbalPft2_inhg	0.000439551542615246d0
#define CONV_lbalPft2_kgPcm2	1.51750484468469d-05
#define CONV_lbalPft2_kgPm2	0.151750484468469d0
#define CONV_lbalPft2_kgPmm2	1.51750484468469d-07
#define CONV_lbalPft2_kPa	0.00148816388851271d0
#define CONV_lbalPft2_lbPft2	0.0310809516113884d0
#define CONV_lbalPft2_lbPin2	0.000215839941745753d0
#define CONV_lbalPft2_mbar	0.0148816388851271d0
#define CONV_lbalPft2_megaPa	1.48816388851271d-06
#define CONV_lbalPft2_mh2o	0.000151750484468469d0
#define CONV_lbalPft2_mmh2o	0.151750452773863d0
#define CONV_lbalPft2_mmhg	0.0111621471035743d0
#define CONV_lbalPft2_NPcm2	0.000148816388851271d0
#define CONV_lbalPft2_NPm2	1.48816388851271d0
#define CONV_lbalPft2_NPmm2	1.48816388851271d-06
#define CONV_lbalPft2_Pa	1.48816388851271d0
#define CONV_lbalPft2_psf	0.0310809516113884d0
#define CONV_lbalPft2_psi	0.000215839941745753d0
#define CONV_lbalPft2_t	0.0111621471035743d0
#define CONV_lbalPft2_tonlPft2	1.38754300718826d-05
#define CONV_lbalPft2_tonlPin2	9.63570880012482d-08
#define CONV_lbalPft2_tonmPin2	9.63571168507826d-08
#define CONV_lbalPft2_tonmPm2	0.000151750484468469d0
#define CONV_lbalPft2_tonsPft2	1.55404758056942d-05
#define CONV_lbalPft2_tonsPin2	1.07919970872876d-07
#define CONV_lbPft2_atm	0.000472541376668024d0
#define CONV_lbPft2_atmt	0.000488242722957254d0
#define CONV_lbPft2_bar	0.000478802549908875d0
#define CONV_lbPft2_barye	478.802549908875d0
#define CONV_lbPft2_cmh2o	0.488242722957254d0
#define CONV_lbPft2_cmhg	0.0359131320095386d0
#define CONV_lbPft2_dynPcm2	478.802549908875d0
#define CONV_lbPft2_fth2o	0.01601846203928d0
#define CONV_lbPft2_gPcm2	0.488242620982879d0
#define CONV_lbPft2_inh2o	0.19222154447136d0
#define CONV_lbPft2_inhg	0.0141421520200234d0
#define CONV_lbPft2_kgPcm2	0.000488242722957254d0
#define CONV_lbPft2_kgPm2	4.88242722957254d0
#define CONV_lbPft2_kgPmm2	4.88242722957254d-06
#define CONV_lbPft2_kPa	0.0478802549908875d0
#define CONV_lbPft2_lbalPft2	32.1740470659717d0
#define CONV_lbPft2_lbPin2	0.00694444444444444d0
#define CONV_lbPft2_mbar	0.478802549908875d0
#define CONV_lbPft2_megaPa	4.78802549908875d-05
#define CONV_lbPft2_mh2o	0.00488242722957253d0
#define CONV_lbPft2_mmh2o	4.88242620982879d0
#define CONV_lbPft2_mmhg	0.359131446267698d0
#define CONV_lbPft2_NPcm2	0.00478802549908875d0
#define CONV_lbPft2_NPm2	47.8802549908875d0
#define CONV_lbPft2_NPmm2	4.78802549908875d-05
#define CONV_lbPft2_Pa	47.8802549908875d0
#define CONV_lbPft2_psf	1d0
#define CONV_lbPft2_psi	0.00694444444444444d0
#define CONV_lbPft2_t	0.359131446267698d0
#define CONV_lbPft2_tonlPft2	0.000446428740193349d0
#define CONV_lbPft2_tonlPin2	3.10019748449214d-06
#define CONV_lbPft2_tonmPin2	3.10019841269841d-06
#define CONV_lbPft2_tonmPm2	0.00488242722957254d0
#define CONV_lbPft2_tonsPft2	0.0005d0
#define CONV_lbPft2_tonsPin2	3.47222222222222d-06
#define CONV_lbPin2_atm	0.0680459582401954d0
#define CONV_lbPin2_atmt	0.0703069521058445d0
#define CONV_lbPin2_bar	0.068947567186878d0
#define CONV_lbPin2_barye	68947.567186878d0
#define CONV_lbPin2_cmh2o	70.3069521058445d0
#define CONV_lbPin2_cmhg	5.17149100937356d0
#define CONV_lbPin2_dynPcm2	68947.567186878d0
#define CONV_lbPin2_fth2o	2.30665853365632d0
#define CONV_lbPin2_gPcm2	70.3069374215345d0
#define CONV_lbPin2_inh2o	27.6799024038758d0
#define CONV_lbPin2_inhg	2.03646989088337d0
#define CONV_lbPin2_kgPcm2	0.0703069521058445d0
#define CONV_lbPin2_kgPm2	703.069521058445d0
#define CONV_lbPin2_kgPmm2	0.000703069521058445d0
#define CONV_lbPin2_kPa	6.8947567186878d0
#define CONV_lbPin2_lbalPft2	4633.06277749992d0
#define CONV_lbPin2_lbPft2	144d0
#define CONV_lbPin2_mbar	68.947567186878d0
#define CONV_lbPin2_megaPa	0.0068947567186878d0
#define CONV_lbPin2_mh2o	0.703069521058445d0
#define CONV_lbPin2_mmh2o	703.069374215345d0
#define CONV_lbPin2_mmhg	51.7149282625485d0
#define CONV_lbPin2_NPcm2	0.68947567186878d0
#define CONV_lbPin2_NPm2	6894.7567186878d0
#define CONV_lbPin2_NPmm2	0.0068947567186878d0
#define CONV_lbPin2_Pa	6894.7567186878d0
#define CONV_lbPin2_psf	144d0
#define CONV_lbPin2_psi	1d0
#define CONV_lbPin2_t	51.7149282625485d0
#define CONV_lbPin2_tonlPft2	0.0642857385878422d0
#define CONV_lbPin2_tonlPin2	0.000446428437766868d0
#define CONV_lbPin2_tonmPin2	0.000446428571428571d0
#define CONV_lbPin2_tonmPm2	0.703069521058445d0
#define CONV_lbPin2_tonsPft2	0.072d0
#define CONV_lbPin2_tonsPin2	0.0005d0
#define CONV_mbar_atm	0.000986923266716013d0
#define CONV_mbar_atmt	0.00101971621297793d0
#define CONV_mbar_bar	0.001d0
#define CONV_mbar_barye	1000d0
#define CONV_mbar_cmh2o	1.01971621297793d0
#define CONV_mbar_cmhg	0.0750061419187796d0
#define CONV_mbar_dynPcm2	1000d0
#define CONV_mbar_fth2o	0.0334552563312969d0
#define CONV_mbar_gPcm2	1.019716d0
#define CONV_mbar_inh2o	0.401463075975562d0
#define CONV_mbar_inhg	0.0295365010539624d0
#define CONV_mbar_kgPcm2	0.00101971621297793d0
#define CONV_mbar_kgPm2	10.1971621297793d0
#define CONV_mbar_kgPmm2	1.01971621297793d-05
#define CONV_mbar_kPa	0.1d0
#define CONV_mbar_lbalPft2	67.1969d0
#define CONV_mbar_lbPft2	2.08854359733531d0
#define CONV_mbar_lbPin2	0.0145037749814952d0
#define CONV_mbar_megaPa	0.0001d0
#define CONV_mbar_mh2o	0.0101971621297793d0
#define CONV_mbar_mmh2o	10.19716d0
#define CONV_mbar_mmhg	0.75006168270417d0
#define CONV_mbar_NPcm2	0.01d0
#define CONV_mbar_NPm2	100d0
#define CONV_mbar_NPmm2	0.0001d0
#define CONV_mbar_Pa	100d0
#define CONV_mbar_psf	2.08854359733531d0
#define CONV_mbar_psi	0.0145037749814952d0
#define CONV_mbar_t	0.75006168270417d0
#define CONV_mbar_tonlPft2	0.000932385886997286d0
#define CONV_mbar_tonlPin2	6.47489760671108d-06
#define CONV_mbar_tonmPin2	6.47489954531035d-06
#define CONV_mbar_tonmPm2	0.0101971621297793d0
#define CONV_mbar_tonsPft2	0.00104427179866765d0
#define CONV_mbar_tonsPin2	7.25188749074759d-06
#define CONV_megaPa_atm	9.86923266716013d0
#define CONV_megaPa_atmt	10.1971621297793d0
#define CONV_megaPa_bar	10d0
#define CONV_megaPa_barye	10000000d0
#define CONV_megaPa_cmh2o	10197.1621297793d0
#define CONV_megaPa_cmhg	750.061419187796d0
#define CONV_megaPa_dynPcm2	10000000d0
#define CONV_megaPa_fth2o	334.552563312969d0
#define CONV_megaPa_gPcm2	10197.16d0
#define CONV_megaPa_inh2o	4014.63075975562d0
#define CONV_megaPa_inhg	295.365010539624d0
#define CONV_megaPa_kgPcm2	10.1971621297793d0
#define CONV_megaPa_kgPm2	101971.621297793d0
#define CONV_megaPa_kgPmm2	0.101971621297793d0
#define CONV_megaPa_kPa	1000d0
#define CONV_megaPa_lbalPft2	671969d0
#define CONV_megaPa_lbPft2	20885.4359733531d0
#define CONV_megaPa_lbPin2	145.037749814952d0
#define CONV_megaPa_mbar	10000d0
#define CONV_megaPa_mh2o	101.971621297793d0
#define CONV_megaPa_mmh2o	101971.6d0
#define CONV_megaPa_mmhg	7500.6168270417d0
#define CONV_megaPa_NPcm2	100d0
#define CONV_megaPa_NPm2	1000000d0
#define CONV_megaPa_NPmm2	1d0
#define CONV_megaPa_Pa	1000000d0
#define CONV_megaPa_psf	20885.4359733531d0
#define CONV_megaPa_psi	145.037749814952d0
#define CONV_megaPa_t	7500.6168270417d0
#define CONV_megaPa_tonlPft2	9.32385886997286d0
#define CONV_megaPa_tonlPin2	0.0647489760671108d0
#define CONV_megaPa_tonmPin2	0.0647489954531035d0
#define CONV_megaPa_tonmPm2	101.971621297793d0
#define CONV_megaPa_tonsPft2	10.4427179866765d0
#define CONV_megaPa_tonsPin2	0.0725188749074759d0
#define CONV_mh2o_atm	0.0967841105354059d0
#define CONV_mh2o_atmt	0.1d0
#define CONV_mh2o_bar	0.0980665d0
#define CONV_mh2o_barye	98066.5d0
#define CONV_mh2o_cmh2o	100d0
#define CONV_mh2o_cmhg	7.355589816478d0
#define CONV_mh2o_dynPcm2	98066.5d0
#define CONV_mh2o_fth2o	3.28083989501312d0
#define CONV_mh2o_gPcm2	99.999979114d0
#define CONV_mh2o_inh2o	39.3700787401575d0
#define CONV_mh2o_inhg	2.8965412806084d0
#define CONV_mh2o_kgPcm2	0.1d0
#define CONV_mh2o_kgPm2	1000d0
#define CONV_mh2o_kgPmm2	0.001d0
#define CONV_mh2o_kPa	9.80665d0
#define CONV_mh2o_lbalPft2	6589.76479385d0
#define CONV_mh2o_lbPft2	204.816160688083d0
#define CONV_mh2o_lbPin2	1.4223344492228d0
#define CONV_mh2o_mbar	98.0665d0
#define CONV_mh2o_megaPa	0.00980665d0
#define CONV_mh2o_mmh2o	999.99979114d0
#define CONV_mh2o_mmhg	73.5559240069085d0
#define CONV_mh2o_NPcm2	0.980665d0
#define CONV_mh2o_NPm2	9806.65d0
#define CONV_mh2o_NPmm2	0.00980665d0
#define CONV_mh2o_Pa	9806.65d0
#define CONV_mh2o_psf	204.816160688083d0
#define CONV_mh2o_psi	1.4223344492228d0
#define CONV_mh2o_t	73.5559240069085d0
#define CONV_mh2o_tonlPft2	0.0914358205872194d0
#define CONV_mh2o_tonlPin2	0.000634970546148532d0
#define CONV_mh2o_tonmPin2	0.000634970736260178d0
#define CONV_mh2o_tonmPm2	1d0
#define CONV_mh2o_tonsPft2	0.102408080344041d0
#define CONV_mh2o_tonsPin2	0.000711167224611399d0
#define CONV_mmh2o_atm	9.67841307497394d-05
#define CONV_mmh2o_atmt	0.000100000020886004d0
#define CONV_mmh2o_bar	9.80665204821735d-05
#define CONV_mmh2o_barye	98.0665204821735d0
#define CONV_mmh2o_cmh2o	0.100000020886004d0
#define CONV_mmh2o_cmhg	0.00735559135276681d0
#define CONV_mmh2o_dynPcm2	98.0665204821735d0
#define CONV_mmh2o_fth2o	0.00328084058024949d0
#define CONV_mmh2o_gPcm2	0.1d0
#define CONV_mmh2o_inh2o	0.0393700869629938d0
#define CONV_mmh2o_inhg	0.00289654188558014d0
#define CONV_mmh2o_kgPcm2	0.000100000020886004d0
#define CONV_mmh2o_kgPm2	1.00000020886004d0
#define CONV_mmh2o_kgPmm2	1.00000020886004d-06
#define CONV_mmh2o_kPa	0.00980665204821735d0
#define CONV_mmh2o_lbalPft2	6.58976617018856d0
#define CONV_mmh2o_lbPft2	0.204816203465995d0
#define CONV_mmh2o_lbPin2	0.00142233474629163d0
#define CONV_mmh2o_mbar	0.0980665204821735d0
#define CONV_mmh2o_megaPa	9.80665204821735d-06
#define CONV_mmh2o_mh2o	0.00100000020886004d0
#define CONV_mmh2o_mmhg	0.073555939369802d0
#define CONV_mmh2o_NPcm2	0.000980665204821735d0
#define CONV_mmh2o_NPm2	9.80665204821735d0
#define CONV_mmh2o_NPmm2	9.80665204821735d-06
#define CONV_mmh2o_Pa	9.80665204821735d0
#define CONV_mmh2o_psf	0.204816203465995d0
#define CONV_mmh2o_psi	0.00142233474629163d0
#define CONV_mmh2o_t	0.073555939369802d0
#define CONV_mmh2o_tonlPft2	9.14358396845088d-05
#define CONV_mmh2o_tonlPin2	6.34970678768508d-07
#define CONV_mmh2o_tonmPin2	6.34970868880193d-07
#define CONV_mmh2o_tonmPm2	0.00100000020886004d0
#define CONV_mmh2o_tonsPft2	0.000102408101732998d0
#define CONV_mmh2o_tonsPin2	7.11167373145816d-07
#define CONV_mmhg_atm	0.00131578947368421d0
#define CONV_mmhg_atmt	0.00135950980631564d0
#define CONV_mmhg_bar	0.00133322368421053d0
#define CONV_mmhg_barye	1333.22368421053d0
#define CONV_mmhg_cmh2o	1.35950980631564d0
#define CONV_mmhg_cmhg	0.0999999648673729d0
#define CONV_mmhg_dynPcm2	1333.22368421053d0
#define CONV_mmhg_fth2o	0.0446033401022191d0
#define CONV_mmhg_gPcm2	1.35950952236842d0
#define CONV_mmhg_inh2o	0.53524008122663d0
#define CONV_mmhg_inhg	0.0393787627538518d0
#define CONV_mmhg_kgPcm2	0.00135950980631564d0
#define CONV_mmhg_kgPm2	13.5950980631564d0
#define CONV_mmhg_kgPmm2	1.35950980631564d-05
#define CONV_mmhg_kPa	0.133322368421053d0
#define CONV_mmhg_lbalPft2	89.5884985855263d0
#define CONV_mmhg_lbPft2	2.78449578947368d0
#define CONV_mmhg_lbPin2	0.0193367763157895d0
#define CONV_mmhg_mbar	1.33322368421053d0
#define CONV_mmhg_megaPa	0.000133322368421053d0
#define CONV_mmhg_mh2o	0.0135950980631564d0
#define CONV_mmhg_mmh2o	13.5950952236842d0
#define CONV_mmhg_NPcm2	0.0133322368421053d0
#define CONV_mmhg_NPm2	133.322368421053d0
#define CONV_mmhg_NPmm2	0.000133322368421053d0
#define CONV_mmhg_Pa	133.322368421053d0
#define CONV_mmhg_psf	2.78449578947368d0
#define CONV_mmhg_psi	0.0193367763157895d0
#define CONV_mmhg_t	1d0
#define CONV_mmhg_tonlPft2	0.00124307894736842d0
#define CONV_mmhg_tonlPin2	8.63248684210526d-06
#define CONV_mmhg_tonmPin2	8.63248942669173d-06
#define CONV_mmhg_tonmPm2	0.0135950980631564d0
#define CONV_mmhg_tonsPft2	0.00139224789473684d0
#define CONV_mmhg_tonsPin2	9.66838815789474d-06
#define CONV_NPcm2_atm	0.0986923266716013d0
#define CONV_NPcm2_atmt	0.101971621297793d0
#define CONV_NPcm2_bar	0.1d0
#define CONV_NPcm2_barye	100000d0
#define CONV_NPcm2_cmh2o	101.971621297793d0
#define CONV_NPcm2_cmhg	7.50061419187796d0
#define CONV_NPcm2_dynPcm2	100000d0
#define CONV_NPcm2_fth2o	3.34552563312969d0
#define CONV_NPcm2_gPcm2	101.9716d0
#define CONV_NPcm2_inh2o	40.1463075975562d0
#define CONV_NPcm2_inhg	2.95365010539624d0
#define CONV_NPcm2_kgPcm2	0.101971621297793d0
#define CONV_NPcm2_kgPm2	1019.71621297793d0
#define CONV_NPcm2_kgPmm2	0.00101971621297793d0
#define CONV_NPcm2_kPa	10d0
#define CONV_NPcm2_lbalPft2	6719.69d0
#define CONV_NPcm2_lbPft2	208.854359733531d0
#define CONV_NPcm2_lbPin2	1.45037749814952d0
#define CONV_NPcm2_mbar	100d0
#define CONV_NPcm2_megaPa	0.01d0
#define CONV_NPcm2_mh2o	1.01971621297793d0
#define CONV_NPcm2_mmh2o	1019.716d0
#define CONV_NPcm2_mmhg	75.006168270417d0
#define CONV_NPcm2_NPm2	10000d0
#define CONV_NPcm2_NPmm2	0.01d0
#define CONV_NPcm2_Pa	10000d0
#define CONV_NPcm2_psf	208.854359733531d0
#define CONV_NPcm2_psi	1.45037749814952d0
#define CONV_NPcm2_t	75.006168270417d0
#define CONV_NPcm2_tonlPft2	0.0932385886997286d0
#define CONV_NPcm2_tonlPin2	0.000647489760671108d0
#define CONV_NPcm2_tonmPin2	0.000647489954531035d0
#define CONV_NPcm2_tonmPm2	1.01971621297793d0
#define CONV_NPcm2_tonsPft2	0.104427179866765d0
#define CONV_NPcm2_tonsPin2	0.000725188749074759d0
#define CONV_NPm2_atm	9.86923266716013d-06
#define CONV_NPm2_atmt	1.01971621297793d-05
#define CONV_NPm2_bar	1d-05
#define CONV_NPm2_barye	10d0
#define CONV_NPm2_cmh2o	0.0101971621297793d0
#define CONV_NPm2_cmhg	0.000750061419187796d0
#define CONV_NPm2_dynPcm2	10d0
#define CONV_NPm2_fth2o	0.000334552563312969d0
#define CONV_NPm2_gPcm2	0.01019716d0
#define CONV_NPm2_inh2o	0.00401463075975562d0
#define CONV_NPm2_inhg	0.000295365010539624d0
#define CONV_NPm2_kgPcm2	1.01971621297793d-05
#define CONV_NPm2_kgPm2	0.101971621297793d0
#define CONV_NPm2_kgPmm2	1.01971621297793d-07
#define CONV_NPm2_kPa	0.001d0
#define CONV_NPm2_lbalPft2	0.671969d0
#define CONV_NPm2_lbPft2	0.0208854359733531d0
#define CONV_NPm2_lbPin2	0.000145037749814952d0
#define CONV_NPm2_mbar	0.01d0
#define CONV_NPm2_megaPa	1d-06
#define CONV_NPm2_mh2o	0.000101971621297793d0
#define CONV_NPm2_mmh2o	0.1019716d0
#define CONV_NPm2_mmhg	0.0075006168270417d0
#define CONV_NPm2_NPcm2	0.0001d0
#define CONV_NPm2_NPmm2	1d-06
#define CONV_NPm2_Pa	1d0
#define CONV_NPm2_psf	0.0208854359733531d0
#define CONV_NPm2_psi	0.000145037749814952d0
#define CONV_NPm2_t	0.0075006168270417d0
#define CONV_NPm2_tonlPft2	9.32385886997286d-06
#define CONV_NPm2_tonlPin2	6.47489760671108d-08
#define CONV_NPm2_tonmPin2	6.47489954531035d-08
#define CONV_NPm2_tonmPm2	0.000101971621297793d0
#define CONV_NPm2_tonsPft2	1.04427179866765d-05
#define CONV_NPm2_tonsPin2	7.25188749074759d-08
#define CONV_NPmm2_atm	9.86923266716013d0
#define CONV_NPmm2_atmt	10.1971621297793d0
#define CONV_NPmm2_bar	10d0
#define CONV_NPmm2_barye	10000000d0
#define CONV_NPmm2_cmh2o	10197.1621297793d0
#define CONV_NPmm2_cmhg	750.061419187796d0
#define CONV_NPmm2_dynPcm2	10000000d0
#define CONV_NPmm2_fth2o	334.552563312969d0
#define CONV_NPmm2_gPcm2	10197.16d0
#define CONV_NPmm2_inh2o	4014.63075975562d0
#define CONV_NPmm2_inhg	295.365010539624d0
#define CONV_NPmm2_kgPcm2	10.1971621297793d0
#define CONV_NPmm2_kgPm2	101971.621297793d0
#define CONV_NPmm2_kgPmm2	0.101971621297793d0
#define CONV_NPmm2_kPa	1000d0
#define CONV_NPmm2_lbalPft2	671969d0
#define CONV_NPmm2_lbPft2	20885.4359733531d0
#define CONV_NPmm2_lbPin2	145.037749814952d0
#define CONV_NPmm2_mbar	10000d0
#define CONV_NPmm2_megaPa	1d0
#define CONV_NPmm2_mh2o	101.971621297793d0
#define CONV_NPmm2_mmh2o	101971.6d0
#define CONV_NPmm2_mmhg	7500.6168270417d0
#define CONV_NPmm2_NPcm2	100d0
#define CONV_NPmm2_NPm2	1000000d0
#define CONV_NPmm2_Pa	1000000d0
#define CONV_NPmm2_psf	20885.4359733531d0
#define CONV_NPmm2_psi	145.037749814952d0
#define CONV_NPmm2_t	7500.6168270417d0
#define CONV_NPmm2_tonlPft2	9.32385886997286d0
#define CONV_NPmm2_tonlPin2	0.0647489760671108d0
#define CONV_NPmm2_tonmPin2	0.0647489954531035d0
#define CONV_NPmm2_tonmPm2	101.971621297793d0
#define CONV_NPmm2_tonsPft2	10.4427179866765d0
#define CONV_NPmm2_tonsPin2	0.0725188749074759d0
#define CONV_Pa_atm	9.86923266716013d-06
#define CONV_Pa_atmt	1.01971621297793d-05
#define CONV_Pa_bar	1d-05
#define CONV_Pa_barye	10d0
#define CONV_Pa_cmh2o	0.0101971621297793d0
#define CONV_Pa_cmhg	0.000750061419187796d0
#define CONV_Pa_dynPcm2	10d0
#define CONV_Pa_fth2o	0.000334552563312969d0
#define CONV_Pa_gPcm2	0.01019716d0
#define CONV_Pa_inh2o	0.00401463075975562d0
#define CONV_Pa_inhg	0.000295365010539624d0
#define CONV_Pa_kgPcm2	1.01971621297793d-05
#define CONV_Pa_kgPm2	0.101971621297793d0
#define CONV_Pa_kgPmm2	1.01971621297793d-07
#define CONV_Pa_kPa	0.001d0
#define CONV_Pa_lbalPft2	0.671969d0
#define CONV_Pa_lbPft2	0.0208854359733531d0
#define CONV_Pa_lbPin2	0.000145037749814952d0
#define CONV_Pa_mbar	0.01d0
#define CONV_Pa_megaPa	1d-06
#define CONV_Pa_mh2o	0.000101971621297793d0
#define CONV_Pa_mmh2o	0.1019716d0
#define CONV_Pa_mmhg	0.0075006168270417d0
#define CONV_Pa_NPcm2	0.0001d0
#define CONV_Pa_NPm2	1d0
#define CONV_Pa_NPmm2	1d-06
#define CONV_Pa_psf	0.0208854359733531d0
#define CONV_Pa_psi	0.000145037749814952d0
#define CONV_Pa_t	0.0075006168270417d0
#define CONV_Pa_tonlPft2	9.32385886997286d-06
#define CONV_Pa_tonlPin2	6.47489760671108d-08
#define CONV_Pa_tonmPin2	6.47489954531035d-08
#define CONV_Pa_tonmPm2	0.000101971621297793d0
#define CONV_Pa_tonsPft2	1.04427179866765d-05
#define CONV_Pa_tonsPin2	7.25188749074759d-08
#define CONV_psf_atm	0.000472541376668024d0
#define CONV_psf_atmt	0.000488242722957254d0
#define CONV_psf_bar	0.000478802549908875d0
#define CONV_psf_barye	478.802549908875d0
#define CONV_psf_cmh2o	0.488242722957254d0
#define CONV_psf_cmhg	0.0359131320095386d0
#define CONV_psf_dynPcm2	478.802549908875d0
#define CONV_psf_fth2o	0.01601846203928d0
#define CONV_psf_gPcm2	0.488242620982879d0
#define CONV_psf_inh2o	0.19222154447136d0
#define CONV_psf_inhg	0.0141421520200234d0
#define CONV_psf_kgPcm2	0.000488242722957254d0
#define CONV_psf_kgPm2	4.88242722957254d0
#define CONV_psf_kgPmm2	4.88242722957254d-06
#define CONV_psf_kPa	0.0478802549908875d0
#define CONV_psf_lbalPft2	32.1740470659717d0
#define CONV_psf_lbPft2	1d0
#define CONV_psf_lbPin2	0.00694444444444444d0
#define CONV_psf_mbar	0.478802549908875d0
#define CONV_psf_megaPa	4.78802549908875d-05
#define CONV_psf_mh2o	0.00488242722957254d0
#define CONV_psf_mmh2o	4.88242620982879d0
#define CONV_psf_mmhg	0.359131446267698d0
#define CONV_psf_NPcm2	0.00478802549908875d0
#define CONV_psf_NPm2	47.8802549908875d0
#define CONV_psf_NPmm2	4.78802549908875d-05
#define CONV_psf_Pa	47.8802549908875d0
#define CONV_psf_psi	0.00694444444444444d0
#define CONV_psf_t	0.359131446267698d0
#define CONV_psf_tonlPft2	0.000446428740193349d0
#define CONV_psf_tonlPin2	3.10019748449214d-06
#define CONV_psf_tonmPin2	3.10019841269841d-06
#define CONV_psf_tonmPm2	0.00488242722957254d0
#define CONV_psf_tonsPft2	0.0005d0
#define CONV_psf_tonsPin2	3.47222222222222d-06
#define CONV_psi_atm	0.0680459582401954d0
#define CONV_psi_atmt	0.0703069521058445d0
#define CONV_psi_bar	0.068947567186878d0
#define CONV_psi_barye	68947.567186878d0
#define CONV_psi_cmh2o	70.3069521058445d0
#define CONV_psi_cmhg	5.17149100937356d0
#define CONV_psi_dynPcm2	68947.567186878d0
#define CONV_psi_fth2o	2.30665853365632d0
#define CONV_psi_gPcm2	70.3069374215345d0
#define CONV_psi_inh2o	27.6799024038758d0
#define CONV_psi_inhg	2.03646989088337d0
#define CONV_psi_kgPcm2	0.0703069521058445d0
#define CONV_psi_kgPm2	703.069521058445d0
#define CONV_psi_kgPmm2	0.000703069521058445d0
#define CONV_psi_kPa	6.8947567186878d0
#define CONV_psi_lbalPft2	4633.06277749992d0
#define CONV_psi_lbPft2	144d0
#define CONV_psi_lbPin2	1d0
#define CONV_psi_mbar	68.947567186878d0
#define CONV_psi_megaPa	0.0068947567186878d0
#define CONV_psi_mh2o	0.703069521058445d0
#define CONV_psi_mmh2o	703.069374215345d0
#define CONV_psi_mmhg	51.7149282625485d0
#define CONV_psi_NPcm2	0.68947567186878d0
#define CONV_psi_NPm2	6894.7567186878d0
#define CONV_psi_NPmm2	0.0068947567186878d0
#define CONV_psi_Pa	6894.7567186878d0
#define CONV_psi_psf	144d0
#define CONV_psi_t	51.7149282625485d0
#define CONV_psi_tonlPft2	0.0642857385878422d0
#define CONV_psi_tonlPin2	0.000446428437766868d0
#define CONV_psi_tonmPin2	0.000446428571428571d0
#define CONV_psi_tonmPm2	0.703069521058445d0
#define CONV_psi_tonsPft2	0.072d0
#define CONV_psi_tonsPin2	0.0005d0
#define CONV_t_atm	0.00131578947368421d0
#define CONV_t_atmt	0.00135950980631564d0
#define CONV_t_bar	0.00133322368421053d0
#define CONV_t_barye	1333.22368421053d0
#define CONV_t_cmh2o	1.35950980631564d0
#define CONV_t_cmhg	0.0999999648673729d0
#define CONV_t_dynPcm2	1333.22368421053d0
#define CONV_t_fth2o	0.0446033401022191d0
#define CONV_t_gPcm2	1.35950952236842d0
#define CONV_t_inh2o	0.53524008122663d0
#define CONV_t_inhg	0.0393787627538518d0
#define CONV_t_kgPcm2	0.00135950980631564d0
#define CONV_t_kgPm2	13.5950980631564d0
#define CONV_t_kgPmm2	1.35950980631564d-05
#define CONV_t_kPa	0.133322368421053d0
#define CONV_t_lbalPft2	89.5884985855263d0
#define CONV_t_lbPft2	2.78449578947368d0
#define CONV_t_lbPin2	0.0193367763157895d0
#define CONV_t_mbar	1.33322368421053d0
#define CONV_t_megaPa	0.000133322368421053d0
#define CONV_t_mh2o	0.0135950980631564d0
#define CONV_t_mmh2o	13.5950952236842d0
#define CONV_t_mmhg	1d0
#define CONV_t_NPcm2	0.0133322368421053d0
#define CONV_t_NPm2	133.322368421053d0
#define CONV_t_NPmm2	0.000133322368421053d0
#define CONV_t_Pa	133.322368421053d0
#define CONV_t_psf	2.78449578947368d0
#define CONV_t_psi	0.0193367763157895d0
#define CONV_t_tonlPft2	0.00124307894736842d0
#define CONV_t_tonlPin2	8.63248684210526d-06
#define CONV_t_tonmPin2	8.63248942669173d-06
#define CONV_t_tonmPm2	0.0135950980631564d0
#define CONV_t_tonsPft2	0.00139224789473684d0
#define CONV_t_tonsPin2	9.66838815789474d-06
#define CONV_tonlPft2_atm	1.05849228359125d0
#define CONV_tonlPft2_atmt	1.09366328598332d0
#define CONV_tonlPft2_bar	1.07251730634884d0
#define CONV_tonlPft2_barye	1072517.30634884d0
#define CONV_tonlPft2_cmh2o	1093.66328598332d0
#define CONV_tonlPft2_cmhg	80.445385290348d0
#define CONV_tonlPft2_dynPcm2	1072517.30634884d0
#define CONV_tonlPft2_fth2o	35.8813414036524d0
#define CONV_tonlPft2_gPcm2	1093.66305756081d0
#define CONV_tonlPft2_inh2o	430.576096843828d0
#define CONV_tonlPft2_inhg	31.6784085493653d0
#define CONV_tonlPft2_kgPcm2	1.09366328598332d0
#define CONV_tonlPft2_kgPm2	10936.6328598332d0
#define CONV_tonlPft2_kgPmm2	0.0109366328598332d0
#define CONV_tonlPft2_kPa	107.251730634884d0
#define CONV_tonlPft2_lbalPft2	72069.8381829921d0
#define CONV_tonlPft2_lbPft2	2239.99915320617d0
#define CONV_tonlPft2_lbPin2	15.5555496750429d0
#define CONV_tonlPft2_mbar	1072.51730634884d0
#define CONV_tonlPft2_megaPa	0.107251730634884d0
#define CONV_tonlPft2_mh2o	10.9366328598332d0
#define CONV_tonlPft2_mmh2o	10936.6305756081d0
#define CONV_tonlPft2_mmhg	804.454135529352d0
#define CONV_tonlPft2_NPcm2	10.7251730634884d0
#define CONV_tonlPft2_NPm2	107251.730634884d0
#define CONV_tonlPft2_NPmm2	0.107251730634884d0
#define CONV_tonlPft2_Pa	107251.730634884d0
#define CONV_tonlPft2_psf	2239.99915320617d0
#define CONV_tonlPft2_psi	15.5555496750429d0
#define CONV_tonlPft2_t	804.454135529352d0
#define CONV_tonlPft2_tonlPin2	0.0069444397400343d0
#define CONV_tonlPft2_tonmPin2	0.00694444181921557d0
#define CONV_tonlPft2_tonmPm2	10.9366328598332d0
#define CONV_tonlPft2_tonsPft2	1.11999957660309d0
#define CONV_tonlPft2_tonsPin2	0.00777777483752143d0
#define CONV_tonlPin2_atm	152.422992093819d0
#define CONV_tonlPin2_atmt	157.487619869234d0
#define CONV_tonlPin2_bar	154.442596739063d0
#define CONV_tonlPin2_barye	154442596.739063d0
#define CONV_tonlPin2_cmh2o	157487.619869234d0
#define CONV_tonlPin2_cmhg	11584.143329315d0
#define CONV_tonlPin2_dynPcm2	154442596.739063d0
#define CONV_tonlPin2_fth2o	5166.91666237645d0
#define CONV_tonlPin2_gPcm2	157487.58697637d0
#define CONV_tonlPin2_inh2o	62002.9999485174d0
#define CONV_tonlPin2_inhg	4561.69392136001d0
#define CONV_tonlPin2_kgPcm2	157.487619869234d0
#define CONV_tonlPin2_kgPm2	1574876.19869234d0
#define CONV_tonlPin2_kgPmm2	1.57487619869234d0
#define CONV_tonlPin2_kPa	15444.2596739063d0
#define CONV_tonlPin2_lbalPft2	10378063.7288151d0
#define CONV_tonlPin2_lbPft2	322560.096575208d0
#define CONV_tonlPin2_lbPin2	2240.00067066117d0
#define CONV_tonlPin2_mbar	154442.596739063d0
#define CONV_tonlPin2_megaPa	15.4442596739062d0
#define CONV_tonlPin2_mh2o	1574.87619869234d0
#define CONV_tonlPin2_mmh2o	1574875.8697637d0
#define CONV_tonlPin2_mmhg	115841.473991303d0
#define CONV_tonlPin2_NPcm2	1544.42596739063d0
#define CONV_tonlPin2_NPm2	15444259.6739062d0
#define CONV_tonlPin2_NPmm2	15.4442596739062d0
#define CONV_tonlPin2_Pa	15444259.6739062d0
#define CONV_tonlPin2_psf	322560.096575208d0
#define CONV_tonlPin2_psi	2240.00067066117d0
#define CONV_tonlPin2_t	115841.473991303d0
#define CONV_tonlPin2_tonlPft2	144.000097550715d0
#define CONV_tonlPin2_tonmPin2	1.00000029940231d0
#define CONV_tonlPin2_tonmPm2	1574.87619869234d0
#define CONV_tonlPin2_tonsPft2	161.280048287604d0
#define CONV_tonlPin2_tonsPin2	1.12000033533058d0
#define CONV_tonmPin2_atm	152.422946458038d0
#define CONV_tonmPin2_atmt	157.487572717092d0
#define CONV_tonmPin2_bar	154.442550498607d0
#define CONV_tonmPin2_barye	154442550.498607d0
#define CONV_tonmPin2_cmh2o	157487.572717092d0
#define CONV_tonmPin2_cmhg	11584.1398609968d0
#define CONV_tonmPin2_dynPcm2	154442550.498607d0
#define CONV_tonmPin2_fth2o	5166.91511539015d0
#define CONV_tonmPin2_gPcm2	157487.539824237d0
#define CONV_tonmPin2_inh2o	62002.9813846818d0
#define CONV_tonmPin2_inhg	4561.69255557874d0
#define CONV_tonmPin2_kgPcm2	157.487572717092d0
#define CONV_tonmPin2_kgPm2	1574875.72717092d0
#define CONV_tonmPin2_kgPmm2	1.57487572717092d0
#define CONV_tonmPin2_kPa	15444.2550498607d0
#define CONV_tonmPin2_lbalPft2	10378060.6215998d0
#define CONV_tonmPin2_lbPft2	322560d0
#define CONV_tonmPin2_lbPin2	2240d0
#define CONV_tonmPin2_mbar	154442.550498607d0
#define CONV_tonmPin2_megaPa	15.4442550498607d0
#define CONV_tonmPin2_mh2o	1574.87572717092d0
#define CONV_tonmPin2_mmh2o	1574875.39824237d0
#define CONV_tonmPin2_mmhg	115841.439308109d0
#define CONV_tonmPin2_NPcm2	1544.42550498607d0
#define CONV_tonmPin2_NPm2	15444255.0498607d0
#define CONV_tonmPin2_NPmm2	15.4442550498607d0
#define CONV_tonmPin2_Pa	15444255.0498607d0
#define CONV_tonmPin2_psf	322560d0
#define CONV_tonmPin2_psi	2240d0
#define CONV_tonmPin2_t	115841.439308109d0
#define CONV_tonmPin2_tonlPft2	144.000054436767d0
#define CONV_tonmPin2_tonlPin2	0.999999700597784d0
#define CONV_tonmPin2_tonmPm2	1574.87572717092d0
#define CONV_tonmPin2_tonsPft2	161.28d0
#define CONV_tonmPin2_tonsPin2	1.12d0
#define CONV_tonmPm2_atm	0.0967841105354059d0
#define CONV_tonmPm2_atmt	0.1d0
#define CONV_tonmPm2_bar	0.0980665d0
#define CONV_tonmPm2_barye	98066.5d0
#define CONV_tonmPm2_cmh2o	100d0
#define CONV_tonmPm2_cmhg	7.355589816478d0
#define CONV_tonmPm2_dynPcm2	98066.5d0
#define CONV_tonmPm2_fth2o	3.28083989501312d0
#define CONV_tonmPm2_gPcm2	99.999979114d0
#define CONV_tonmPm2_inh2o	39.3700787401575d0
#define CONV_tonmPm2_inhg	2.8965412806084d0
#define CONV_tonmPm2_kgPcm2	0.1d0
#define CONV_tonmPm2_kgPm2	1000d0
#define CONV_tonmPm2_kgPmm2	0.001d0
#define CONV_tonmPm2_kPa	9.80665d0
#define CONV_tonmPm2_lbalPft2	6589.76479385d0
#define CONV_tonmPm2_lbPft2	204.816160688083d0
#define CONV_tonmPm2_lbPin2	1.4223344492228d0
#define CONV_tonmPm2_mbar	98.0665d0
#define CONV_tonmPm2_megaPa	0.00980665d0
#define CONV_tonmPm2_mh2o	1d0
#define CONV_tonmPm2_mmh2o	999.99979114d0
#define CONV_tonmPm2_mmhg	73.5559240069085d0
#define CONV_tonmPm2_NPcm2	0.980665d0
#define CONV_tonmPm2_NPm2	9806.65d0
#define CONV_tonmPm2_NPmm2	0.00980665d0
#define CONV_tonmPm2_Pa	9806.65d0
#define CONV_tonmPm2_psf	204.816160688083d0
#define CONV_tonmPm2_psi	1.4223344492228d0
#define CONV_tonmPm2_t	73.5559240069085d0
#define CONV_tonmPm2_tonlPft2	0.0914358205872193d0
#define CONV_tonmPm2_tonlPin2	0.000634970546148532d0
#define CONV_tonmPm2_tonmPin2	0.000634970736260178d0
#define CONV_tonmPm2_tonsPft2	0.102408080344041d0
#define CONV_tonmPm2_tonsPin2	0.000711167224611399d0
#define CONV_tonsPft2_atm	0.945082753336048d0
#define CONV_tonsPft2_atmt	0.976485445914507d0
#define CONV_tonsPft2_bar	0.95760509981775d0
#define CONV_tonsPft2_barye	957605.09981775d0
#define CONV_tonsPft2_cmh2o	976.485445914507d0
#define CONV_tonsPft2_cmhg	71.8262640190772d0
#define CONV_tonsPft2_dynPcm2	957605.09981775d0
#define CONV_tonsPft2_fth2o	32.0369240785599d0
#define CONV_tonsPft2_gPcm2	976.485241965757d0
#define CONV_tonsPft2_inh2o	384.443088942719d0
#define CONV_tonsPft2_inhg	28.2843040400467d0
#define CONV_tonsPft2_kgPcm2	0.976485445914507d0
#define CONV_tonsPft2_kgPm2	9764.85445914507d0
#define CONV_tonsPft2_kgPmm2	0.00976485445914507d0
#define CONV_tonsPft2_kPa	95.760509981775d0
#define CONV_tonsPft2_lbalPft2	64348.0941319434d0
#define CONV_tonsPft2_lbPft2	2000d0
#define CONV_tonsPft2_lbPin2	13.8888888888889d0
#define CONV_tonsPft2_mbar	957.60509981775d0
#define CONV_tonsPft2_megaPa	0.095760509981775d0
#define CONV_tonsPft2_mh2o	9.76485445914507d0
#define CONV_tonsPft2_mmh2o	9764.85241965757d0
#define CONV_tonsPft2_mmhg	718.262892535396d0
#define CONV_tonsPft2_NPcm2	9.5760509981775d0
#define CONV_tonsPft2_NPm2	95760.509981775d0
#define CONV_tonsPft2_NPmm2	0.095760509981775d0
#define CONV_tonsPft2_Pa	95760.509981775d0
#define CONV_tonsPft2_psf	2000d0
#define CONV_tonsPft2_psi	13.8888888888889d0
#define CONV_tonsPft2_t	718.262892535396d0
#define CONV_tonsPft2_tonlPft2	0.892857480386698d0
#define CONV_tonsPft2_tonlPin2	0.00620039496898428d0
#define CONV_tonsPft2_tonmPin2	0.00620039682539683d0
#define CONV_tonsPft2_tonmPm2	9.76485445914507d0
#define CONV_tonsPft2_tonsPin2	0.00694444444444444d0
#define CONV_tonsPin2_atm	136.091916480391d0
#define CONV_tonsPin2_atmt	140.613904211689d0
#define CONV_tonsPin2_bar	137.895134373756d0
#define CONV_tonsPin2_barye	137895134.373756d0
#define CONV_tonsPin2_cmh2o	140613.904211689d0
#define CONV_tonsPin2_cmhg	10342.9820187471d0
#define CONV_tonsPin2_dynPcm2	137895134.373756d0
#define CONV_tonsPin2_fth2o	4613.31706731263d0
#define CONV_tonsPin2_gPcm2	140613.874843069d0
#define CONV_tonsPin2_inh2o	55359.8048077516d0
#define CONV_tonsPin2_inhg	4072.93978176673d0
#define CONV_tonsPin2_kgPcm2	140.613904211689d0
#define CONV_tonsPin2_kgPm2	1406139.04211689d0
#define CONV_tonsPin2_kgPmm2	1.40613904211689d0
#define CONV_tonsPin2_kPa	13789.5134373756d0
#define CONV_tonsPin2_lbalPft2	9266125.55499985d0
#define CONV_tonsPin2_lbPft2	288000d0
#define CONV_tonsPin2_lbPin2	2000d0
#define CONV_tonsPin2_mbar	137895.134373756d0
#define CONV_tonsPin2_megaPa	13.7895134373756d0
#define CONV_tonsPin2_mh2o	1406.13904211689d0
#define CONV_tonsPin2_mmh2o	1406138.74843069d0
#define CONV_tonsPin2_mmhg	103429.856525097d0
#define CONV_tonsPin2_NPcm2	1378.95134373756d0
#define CONV_tonsPin2_NPm2	13789513.4373756d0
#define CONV_tonsPin2_NPmm2	13.7895134373756d0
#define CONV_tonsPin2_Pa	13789513.4373756d0
#define CONV_tonsPin2_psf	288000d0
#define CONV_tonsPin2_psi	2000d0
#define CONV_tonsPin2_t	103429.856525097d0
#define CONV_tonsPin2_tonlPft2	128.571477175684d0
#define CONV_tonsPin2_tonlPin2	0.892856875533736d0
#define CONV_tonsPin2_tonmPin2	0.892857142857143d0
#define CONV_tonsPin2_tonmPm2	1406.13904211689d0
#define CONV_tonsPin2_tonsPft2	144d0



c ENERGY, WORK, QUANTITY OF HEAT (J)
c ====================
c 
c cal      = calorie (thermochemical)
c kcal     = kilocalorie (thermochemical)
c ea       = hartree
c erg      = erg (g cm+2 s-2)
c ev       = electron volt
c hz       = energy measured as hertz
c J        = joule (N m) (SI)
c Nm       = newton-meter
c megaJ    = megajoule
c kcalPmol = kcal/mole
c kJPmol   = kjoule/mole
c wn       = cm-1
c ryd      = rydberg
c btu      = British thermal unit
c ft3atm   = cubic foot-atmosphere
c ft3lbPin2= cubic foot-pount-force/square inche
c ftlbal   = foot-poundal
c ftlb     = foot-pound-force
c hphr     = horsepower-hour
c hphrm    = horsepower-hour (metric)
c kgm      = kilogram-force-meter
c gcm      = gram-force-cm
c kWhr     = kilowatt-hour
c gWhr     = gigawatt-hour
c latm     = liter-atmosphere
c lbar     = liter-bar
c Whr      = watt-hour
c Ws       = watt-sec
c dyncm    = dyne-cm
c chu      = centigrade heat unit
c btu39    = btu (39 deg F, 4 deg C)
c but60    = btu (60 deg F, 15.6 deg C)
c btuave   = btu (mean)
c btuth    = btu (thermochemical)
c calor    = calorie
c kcalor   = kilocalorie
c cal15    = calorie (15 deg C)
c cal20    = calorie (20 deg C)
c calave   = calorie (mean)
c calth    = calorie (thermochemical)
c ccatm    = cubic centimeter-atmosphere



#define CONV_cal_kcal	0.001d0
#define CONV_cal_ea	9.59688469045039d+17
#define CONV_cal_erg	41840000d0
#define CONV_cal_ev	2.61144626231854d+19
#define CONV_cal_hz	6.31444661323283d+33
#define CONV_cal_J	4.184d0
#define CONV_cal_Nm	4.184d0
#define CONV_cal_megaJ	4.184d-06
#define CONV_cal_kcalPmol	6.0221367d+20
#define CONV_cal_kJPmol	2.51966199528d+21
#define CONV_cal_wn	2.10627267122004d+23
#define CONV_cal_ryd	1.91937693809008d+18
#define CONV_cal_btu	0.00396566611254419d0
#define CONV_cal_ft3atm	0.00145824284590641d0
#define CONV_cal_ft3lbPin2	0.02143028064d0
#define CONV_cal_ftlbal	99.2878549727716d0
#define CONV_cal_ftlb	3.08596262424764d0
#define CONV_cal_hphr	1.55856698194325d-06
#define CONV_cal_hphrm	1.58018251648037d-06
#define CONV_cal_kgm	0.426649279449699d0
#define CONV_cal_gcm	42664.9263509965d0
#define CONV_cal_kWhr	1.16222222222222d-06
#define CONV_cal_gWhr	1.16222222222222d-12
#define CONV_cal_latm	0.041292869479398d0
#define CONV_cal_lbar	0.04184d0
#define CONV_cal_Whr	0.00116222222222222d0
#define CONV_cal_Ws	4.184d0
#define CONV_cal_dyncm	41840000d0
#define CONV_cal_chu	0.00220314784030233d0
#define CONV_cal_btu39	0.00394839902988666d0
#define CONV_cal_but60	0.00396708006219896d0
#define CONV_cal_btuave	0.00396260903330903d0
#define CONV_cal_btuth	0.00396832171480059d0
#define CONV_cal_calor	0.999331231489443d0
#define CONV_cal_kcalor	0.000999331231489443d0
#define CONV_cal_cal15	0.999641619878151d0
#define CONV_cal_cal20	1.00050216408809d0
#define CONV_cal_calave	0.998563252681371d0
#define CONV_cal_calth	1d0
#define CONV_cal_ccatm	41.292869479398d0
#define CONV_kcal_cal	1000d0
#define CONV_kcal_ea	9.59688469045039d+20
#define CONV_kcal_erg	41840000000d0
#define CONV_kcal_ev	2.61144626231854d+22
#define CONV_kcal_hz	6.31444661323283d+36
#define CONV_kcal_J	4184d0
#define CONV_kcal_Nm	4184d0
#define CONV_kcal_megaJ	0.004184d0
#define CONV_kcal_kcalPmol	6.0221367d+23
#define CONV_kcal_kJPmol	2.51966199528d+24
#define CONV_kcal_wn	2.10627267122004d+26
#define CONV_kcal_ryd	1.91937693809008d+21
#define CONV_kcal_btu	3.96566611254419d0
#define CONV_kcal_ft3atm	1.45824284590641d0
#define CONV_kcal_ft3lbPin2	21.43028064d0
#define CONV_kcal_ftlbal	99287.8549727716d0
#define CONV_kcal_ftlb	3085.96262424764d0
#define CONV_kcal_hphr	0.00155856698194325d0
#define CONV_kcal_hphrm	0.00158018251648037d0
#define CONV_kcal_kgm	426.649279449699d0
#define CONV_kcal_gcm	42664926.3509965d0
#define CONV_kcal_kWhr	0.00116222222222222d0
#define CONV_kcal_gWhr	1.16222222222222d-09
#define CONV_kcal_latm	41.292869479398d0
#define CONV_kcal_lbar	41.84d0
#define CONV_kcal_Whr	1.16222222222222d0
#define CONV_kcal_Ws	4184d0
#define CONV_kcal_dyncm	41840000000d0
#define CONV_kcal_chu	2.20314784030233d0
#define CONV_kcal_btu39	3.94839902988666d0
#define CONV_kcal_but60	3.96708006219896d0
#define CONV_kcal_btuave	3.96260903330903d0
#define CONV_kcal_btuth	3.96832171480059d0
#define CONV_kcal_calor	999.331231489443d0
#define CONV_kcal_kcalor	0.999331231489443d0
#define CONV_kcal_cal15	999.641619878151d0
#define CONV_kcal_cal20	1000.50216408809d0
#define CONV_kcal_calave	998.563252681372d0
#define CONV_kcal_calth	1000d0
#define CONV_kcal_ccatm	41292.869479398d0
#define CONV_ea_cal	1.04200480911798d-18
#define CONV_ea_kcal	1.04200480911798d-21
#define CONV_ea_erg	4.35974812134962d-11
#define CONV_ea_ev	27.2113956408909d0
#define CONV_ea_hz	6.57968373790733d+15
#define CONV_ea_J	4.35974812134962d-18
#define CONV_ea_Nm	4.35974812134962d-18
#define CONV_ea_megaJ	4.35974812134962d-24
#define CONV_ea_kcalPmol	627.509540256587d0
#define CONV_ea_kJPmol	2625.49991643356d0
#define CONV_ea_wn	219474.625272505d0
#define CONV_ea_ryd	2d0
#define CONV_ea_btu	4.13224316062724d-21
#define CONV_ea_ft3atm	1.51949605829637d-21
#define CONV_ea_ft3lbPin2	2.23304554876279d-20
#define CONV_ea_ftlbal	1.03458422368636d-16
#define CONV_ea_ftlb	3.21558789522437d-18
#define CONV_ea_hphr	1.62403429051736d-24
#define CONV_ea_hphrm	1.64655778145669d-24
#define CONV_ea_kgm	4.44570600993306d-19
#define CONV_ea_gcm	4.44570584384027d-14
#define CONV_ea_kWhr	1.21104114481934d-24
#define CONV_ea_gWhr	1.21104114481934d-30
#define CONV_ea_latm	4.30273685798137d-20
#define CONV_ea_lbar	4.35974812134962d-20
#define CONV_ea_Whr	1.21104114481934d-21
#define CONV_ea_Ws	4.35974812134962d-18
#define CONV_ea_dyncm	4.35974812134962d-11
#define CONV_ea_chu	2.29569064479291d-21
#define CONV_ea_btu39	4.11425077745866d-21
#define CONV_ea_but60	4.13371650296736d-21
#define CONV_ea_btuave	4.12905766936235d-21
#define CONV_ea_btuth	4.13501031094951d-21
#define CONV_ea_calor	1.04130794911379d-18
#define CONV_ea_kcalor	1.04130794911379d-21
#define CONV_ea_cal15	1.04163137530752d-18
#define CONV_ea_cal20	1.04252806651274d-18
#define CONV_ea_calave	1.04050771150248d-18
#define CONV_ea_calth	1.04200480911798d-18
#define CONV_ea_ccatm	4.30273685798137d-17
#define CONV_erg_cal	2.39005736137667d-08
#define CONV_erg_kcal	2.39005736137667d-11
#define CONV_erg_ea	22937104900.694d0
#define CONV_erg_ev	624150636309.403d0
#define CONV_erg_hz	1.50918896109771d+26
#define CONV_erg_J	1d-07
#define CONV_erg_Nm	1d-07
#define CONV_erg_megaJ	1d-13
#define CONV_erg_kcalPmol	14393252151051.6d0
#define CONV_erg_kJPmol	60221367000000d0
#define CONV_erg_wn	5.03411250291597d+15
#define CONV_erg_ryd	45874209801.3881d0
#define CONV_erg_btu	9.47816948504824d-11
#define CONV_erg_ft3atm	3.48528404853349d-11
#define CONV_erg_ft3lbPin2	5.12196d-10
#define CONV_erg_ftlbal	2.37303668672972d-06
#define CONV_erg_ftlb	7.37562768701634d-08
#define CONV_erg_hphr	3.72506448839209d-14
#define CONV_erg_hphrm	3.77672685583262d-14
#define CONV_erg_kgm	1.01971625107481d-08
#define CONV_erg_gcm	0.00101971621297793d0
#define CONV_erg_kWhr	2.77777777777778d-14
#define CONV_erg_gWhr	2.77777777777778d-20
#define CONV_erg_latm	9.86923266716013d-10
#define CONV_erg_lbar	1d-09
#define CONV_erg_Whr	2.77777777777778d-11
#define CONV_erg_Ws	1d-07
#define CONV_erg_dyncm	1d0
#define CONV_erg_chu	5.26564971391569d-11
#define CONV_erg_btu39	9.43690016703313d-11
#define CONV_erg_but60	9.48154890582925d-11
#define CONV_erg_btuave	9.47086289031794d-11
#define CONV_erg_btuth	9.48451652677005d-11
#define CONV_erg_calor	2.38845896627496d-08
#define CONV_erg_kcalor	2.38845896627496d-11
#define CONV_erg_cal15	2.38920081232828d-08
#define CONV_erg_cal20	2.39125756235204d-08
#define CONV_erg_calave	2.38662345287135d-08
#define CONV_erg_calth	2.39005736137667d-08
#define CONV_erg_ccatm	9.86923266716013d-07
#define CONV_ev_cal	3.82929572179732d-20
#define CONV_ev_kcal	3.82929572179732d-23
#define CONV_ev_ea	0.0367493094877239d0
#define CONV_ev_erg	1.60217733d-12
#define CONV_ev_hz	241798834015701d0
#define CONV_ev_J	1.60217733d-19
#define CONV_ev_Nm	1.60217733d-19
#define CONV_ev_megaJ	1.60217733d-25
#define CONV_ev_kcalPmol	23.0605423013886d0
#define CONV_ev_kJPmol	96.4853089890101d0
#define CONV_ev_wn	8065.54092884153d0
#define CONV_ev_ryd	0.0734986189754478d0
#define CONV_ev_btu	1.51857082788421d-22
#define CONV_ev_ft3atm	5.58404309117097d-23
#define CONV_ev_ft3lbPin2	8.2062881971668d-22
#define CONV_ev_ftlbal	3.80202558273667d-18
#define CONV_ev_ftlb	1.18170634746579d-19
#define CONV_ev_hphr	5.96821387608985d-26
#define CONV_ev_hphrm	6.0509861500172d-26
#define CONV_ev_kgm	1.63376626050464d-20
#define CONV_ev_gcm	1.63376619946669d-15
#define CONV_ev_kWhr	4.45049258333333d-26
#define CONV_ev_gWhr	4.45049258333333d-32
#define CONV_ev_latm	1.58122608438194d-21
#define CONV_ev_lbar	1.60217733d-21
#define CONV_ev_Whr	4.45049258333333d-23
#define CONV_ev_Ws	1.60217733d-19
#define CONV_ev_dyncm	1.60217733d-12
#define CONV_ev_chu	8.43650459935671d-23
#define CONV_ev_btu39	1.51195875130937d-22
#define CONV_ev_but60	1.51911227102059d-22
#define CONV_ev_btuave	1.51740018184057d-22
#define CONV_ev_btuth	1.51958773652013d-22
#define CONV_ev_calor	3.82673480940097d-20
#define CONV_ev_kcalor	3.82673480940097d-23
#define CONV_ev_cal15	3.82792337832995d-20
#define CONV_ev_cal20	3.8312186565915d-20
#define CONV_ev_calave	3.82379399143679d-20
#define CONV_ev_calth	3.82929572179732d-20
#define CONV_ev_ccatm	1.58122608438194d-18
#define CONV_hz_cal	1.58367005258126d-34
#define CONV_hz_kcal	1.58367005258126d-37
#define CONV_hz_ea	1.51982988823419d-16
#define CONV_hz_erg	6.6260755d-27
#define CONV_hz_ev	4.13566923955914d-15
#define CONV_hz_J	6.6260755d-34
#define CONV_hz_Nm	6.6260755d-34
#define CONV_hz_megaJ	6.6260755d-40
#define CONV_hz_kcalPmol	9.53707754434055d-14
#define CONV_hz_kJPmol	3.99031324455208d-13
#define CONV_hz_wn	3.33564095198152d-11
#define CONV_hz_ryd	3.03965977646837d-16
#define CONV_hz_btu	6.28030666097258d-37
#define CONV_hz_ft3atm	2.30937552445285d-37
#define CONV_hz_ft3lbPin2	3.393849366798d-36
#define CONV_hz_ftlbal	1.5723920250541d-32
#define CONV_hz_ftlb	4.88714659140606d-34
#define CONV_hz_hphr	2.46825585424549d-40
#define CONV_hz_hphrm	2.50248772896245d-40
#define CONV_hz_kgm	6.75671686819862d-35
#define CONV_hz_gcm	6.75671661576583d-30
#define CONV_hz_kWhr	1.84057652777778d-40
#define CONV_hz_gWhr	1.84057652777778d-46
#define CONV_hz_latm	6.53942807796694d-36
#define CONV_hz_lbar	6.6260755d-36
#define CONV_hz_Whr	1.84057652777778d-37
#define CONV_hz_Ws	6.6260755d-34
#define CONV_hz_dyncm	6.6260755d-27
#define CONV_hz_chu	3.48905925609588d-37
#define CONV_hz_btu39	6.25296129927241d-37
#define CONV_hz_but60	6.2825458906967d-37
#define CONV_hz_btuave	6.27546525613949d-37
#define CONV_hz_btuth	6.28451225873761d-37
#define CONV_hz_calor	1.58261094391898d-34
#define CONV_hz_kcalor	1.58261094391898d-37
#define CONV_hz_cal15	1.58310249671485d-34
#define CONV_hz_cal20	1.58446531480906d-34
#define CONV_hz_calave	1.58139471887962d-34
#define CONV_hz_calth	1.58367005258126d-34
#define CONV_hz_ccatm	6.53942807796694d-33
#define CONV_J_cal	0.239005736137667d0
#define CONV_J_kcal	0.000239005736137667d0
#define CONV_J_ea	2.2937104900694d+17
#define CONV_J_erg	10000000d0
#define CONV_J_ev	6.24150636309403d+18
#define CONV_J_hz	1.50918896109771d+33
#define CONV_J_Nm	1d0
#define CONV_J_megaJ	1d-06
#define CONV_J_kcalPmol	1.43932521510516d+20
#define CONV_J_kJPmol	6.0221367d+20
#define CONV_J_wn	5.03411250291597d+22
#define CONV_J_ryd	4.58742098013881d+17
#define CONV_J_btu	0.000947816948504825d0
#define CONV_J_ft3atm	0.000348528404853349d0
#define CONV_J_ft3lbPin2	0.00512196d0
#define CONV_J_ftlbal	23.7303668672972d0
#define CONV_J_ftlb	0.737562768701634d0
#define CONV_J_hphr	3.72506448839209d-07
#define CONV_J_hphrm	3.77672685583262d-07
#define CONV_J_kgm	0.101971625107481d0
#define CONV_J_gcm	10197.1621297793d0
#define CONV_J_kWhr	2.77777777777778d-07
#define CONV_J_gWhr	2.77777777777778d-13
#define CONV_J_latm	0.00986923266716013d0
#define CONV_J_lbar	0.01d0
#define CONV_J_Whr	0.000277777777777778d0
#define CONV_J_Ws	1d0
#define CONV_J_dyncm	10000000d0
#define CONV_J_chu	0.000526564971391569d0
#define CONV_J_btu39	0.000943690016703313d0
#define CONV_J_but60	0.000948154890582926d0
#define CONV_J_btuave	0.000947086289031794d0
#define CONV_J_btuth	0.000948451652677005d0
#define CONV_J_calor	0.238845896627496d0
#define CONV_J_kcalor	0.000238845896627496d0
#define CONV_J_cal15	0.238920081232828d0
#define CONV_J_cal20	0.239125756235204d0
#define CONV_J_calave	0.238662345287135d0
#define CONV_J_calth	0.239005736137667d0
#define CONV_J_ccatm	9.86923266716013d0
#define CONV_Nm_cal	0.239005736137667d0
#define CONV_Nm_kcal	0.000239005736137667d0
#define CONV_Nm_ea	2.2937104900694d+17
#define CONV_Nm_erg	10000000d0
#define CONV_Nm_ev	6.24150636309403d+18
#define CONV_Nm_hz	1.50918896109771d+33
#define CONV_Nm_J	1d0
#define CONV_Nm_megaJ	1d-06
#define CONV_Nm_kcalPmol	1.43932521510516d+20
#define CONV_Nm_kJPmol	6.0221367d+20
#define CONV_Nm_wn	5.03411250291597d+22
#define CONV_Nm_ryd	4.58742098013881d+17
#define CONV_Nm_btu	0.000947816948504825d0
#define CONV_Nm_ft3atm	0.000348528404853349d0
#define CONV_Nm_ft3lbPin2	0.00512196d0
#define CONV_Nm_ftlbal	23.7303668672972d0
#define CONV_Nm_ftlb	0.737562768701634d0
#define CONV_Nm_hphr	3.72506448839209d-07
#define CONV_Nm_hphrm	3.77672685583262d-07
#define CONV_Nm_kgm	0.101971625107481d0
#define CONV_Nm_gcm	10197.1621297793d0
#define CONV_Nm_kWhr	2.77777777777778d-07
#define CONV_Nm_gWhr	2.77777777777778d-13
#define CONV_Nm_latm	0.00986923266716013d0
#define CONV_Nm_lbar	0.01d0
#define CONV_Nm_Whr	0.000277777777777778d0
#define CONV_Nm_Ws	1d0
#define CONV_Nm_dyncm	10000000d0
#define CONV_Nm_chu	0.000526564971391569d0
#define CONV_Nm_btu39	0.000943690016703313d0
#define CONV_Nm_but60	0.000948154890582926d0
#define CONV_Nm_btuave	0.000947086289031794d0
#define CONV_Nm_btuth	0.000948451652677005d0
#define CONV_Nm_calor	0.238845896627496d0
#define CONV_Nm_kcalor	0.000238845896627496d0
#define CONV_Nm_cal15	0.238920081232828d0
#define CONV_Nm_cal20	0.239125756235204d0
#define CONV_Nm_calave	0.238662345287135d0
#define CONV_Nm_calth	0.239005736137667d0
#define CONV_Nm_ccatm	9.86923266716013d0
#define CONV_megaJ_cal	239005.736137667d0
#define CONV_megaJ_kcal	239.005736137667d0
#define CONV_megaJ_ea	2.2937104900694d+23
#define CONV_megaJ_erg	10000000000000d0
#define CONV_megaJ_ev	6.24150636309403d+24
#define CONV_megaJ_hz	1.50918896109771d+39
#define CONV_megaJ_J	1000000d0
#define CONV_megaJ_Nm	1000000d0
#define CONV_megaJ_kcalPmol	1.43932521510516d+26
#define CONV_megaJ_kJPmol	6.0221367d+26
#define CONV_megaJ_wn	5.03411250291597d+28
#define CONV_megaJ_ryd	4.58742098013881d+23
#define CONV_megaJ_btu	947.816948504825d0
#define CONV_megaJ_ft3atm	348.528404853349d0
#define CONV_megaJ_ft3lbPin2	5121.96d0
#define CONV_megaJ_ftlbal	23730366.8672972d0
#define CONV_megaJ_ftlb	737562.768701634d0
#define CONV_megaJ_hphr	0.372506448839209d0
#define CONV_megaJ_hphrm	0.377672685583262d0
#define CONV_megaJ_kgm	101971.625107481d0
#define CONV_megaJ_gcm	10197162129.7793d0
#define CONV_megaJ_kWhr	0.277777777777778d0
#define CONV_megaJ_gWhr	2.77777777777778d-07
#define CONV_megaJ_latm	9869.23266716013d0
#define CONV_megaJ_lbar	10000d0
#define CONV_megaJ_Whr	277.777777777778d0
#define CONV_megaJ_Ws	1000000d0
#define CONV_megaJ_dyncm	10000000000000d0
#define CONV_megaJ_chu	526.564971391569d0
#define CONV_megaJ_btu39	943.690016703313d0
#define CONV_megaJ_but60	948.154890582926d0
#define CONV_megaJ_btuave	947.086289031794d0
#define CONV_megaJ_btuth	948.451652677005d0
#define CONV_megaJ_calor	238845.896627496d0
#define CONV_megaJ_kcalor	238.845896627496d0
#define CONV_megaJ_cal15	238920.081232828d0
#define CONV_megaJ_cal20	239125.756235204d0
#define CONV_megaJ_calave	238662.345287135d0
#define CONV_megaJ_calth	239005.736137667d0
#define CONV_megaJ_ccatm	9869232.66716013d0
#define CONV_kcalPmol_cal	1.66054018667494d-21
#define CONV_kcalPmol_kcal	1.66054018667494d-24
#define CONV_kcalPmol_ea	0.00159360126953783d0
#define CONV_kcalPmol_erg	6.94770014104795d-14
#define CONV_kcalPmol_ev	0.04336411463922d0
#define CONV_kcalPmol_hz	10485392357886.6d0
#define CONV_kcalPmol_J	6.94770014104794d-21
#define CONV_kcalPmol_Nm	6.94770014104794d-21
#define CONV_kcalPmol_megaJ	6.94770014104794d-27
#define CONV_kcalPmol_kJPmol	4.184d0
#define CONV_kcalPmol_wn	349.755041465605d0
#define CONV_kcalPmol_ryd	0.00318720253907567d0
#define CONV_kcalPmol_btu	6.5851479468146d-24
#define CONV_kcalPmol_ft3atm	2.42147084755883d-24
#define CONV_kcalPmol_ft3lbPin2	3.55858422144419d-23
#define CONV_kcalPmol_ftlbal	1.6487147323104d-19
#define CONV_kcalPmol_ftlb	5.12436495214005d-21
#define CONV_kcalPmol_hphr	2.58806310714144d-27
#define CONV_kcalPmol_hphrm	2.62395657089678d-27
#define CONV_kcalPmol_kgm	7.08468274142131d-22
#define CONV_kcalPmol_gcm	7.08468247673563d-17
#define CONV_kcalPmol_kWhr	1.92991670584665d-27
#define CONV_kcalPmol_gWhr	1.92991670584665d-33
#define CONV_kcalPmol_latm	6.85684691936634d-23
#define CONV_kcalPmol_lbar	6.94770014104794d-23
#define CONV_kcalPmol_Whr	1.92991670584665d-24
#define CONV_kcalPmol_Ws	6.94770014104794d-21
#define CONV_kcalPmol_dyncm	6.94770014104795d-14
#define CONV_kcalPmol_chu	3.65841552600811d-24
#define CONV_kcalPmol_btu39	6.55647526215515d-24
#define CONV_kcalPmol_but60	6.58749586703829d-24
#define CONV_kcalPmol_btuave	6.58007154389077d-24
#define CONV_kcalPmol_btuth	6.58955768108118d-24
#define CONV_kcalPmol_calor	1.65942966968758d-21
#define CONV_kcalPmol_kcalor	1.65942966968758d-24
#define CONV_kcalPmol_cal15	1.6599450820805d-21
#define CONV_kcalPmol_cal20	1.66137405032352d-21
#define CONV_kcalPmol_calave	1.65815441001426d-21
#define CONV_kcalPmol_calth	1.66054018667494d-21
#define CONV_kcalPmol_ccatm	6.85684691936634d-20
#define CONV_kJPmol_cal	3.96878629702423d-22
#define CONV_kJPmol_kcal	3.96878629702423d-25
#define CONV_kJPmol_ea	0.000380879844535811d0
#define CONV_kJPmol_erg	1.66054018667494d-14
#define CONV_kJPmol_ev	0.010364272141305d0
#define CONV_kJPmol_hz	2506068919188.95d0
#define CONV_kJPmol_J	1.66054018667494d-21
#define CONV_kJPmol_Nm	1.66054018667494d-21
#define CONV_kJPmol_megaJ	1.66054018667494d-27
#define CONV_kJPmol_kcalPmol	0.239005736137667d0
#define CONV_kJPmol_wn	83.5934611533473d0
#define CONV_kJPmol_ryd	0.000761759689071623d0
#define CONV_kJPmol_btu	1.57388813260387d-24
#define CONV_kJPmol_ft3atm	5.78745422456698d-25
#define CONV_kJPmol_ft3lbPin2	8.50522041454157d-24
#define CONV_kJPmol_ftlbal	3.94052278276865d-20
#define CONV_kJPmol_ftlb	1.2247526176243d-21
#define CONV_kJPmol_hphr	6.18561928093079d-28
#define CONV_kJPmol_hphrm	6.27140671820455d-28
#define CONV_kJPmol_kgm	1.69327981391523d-22
#define CONV_kJPmol_gcm	1.69327975065383d-17
#define CONV_kJPmol_kWhr	4.61261162965261d-28
#define CONV_kJPmol_gWhr	4.61261162965261d-34
#define CONV_kJPmol_latm	1.63882574554645d-23
#define CONV_kJPmol_lbar	1.66054018667494d-23
#define CONV_kJPmol_Whr	4.61261162965261d-25
#define CONV_kJPmol_Ws	1.66054018667494d-21
#define CONV_kJPmol_dyncm	1.66054018667494d-14
#define CONV_kJPmol_chu	8.7438229589104d-25
#define CONV_kJPmol_btu39	1.5670351964998d-24
#define CONV_kJPmol_but60	1.57444929900533d-24
#define CONV_kJPmol_btuave	1.57267484318613d-24
#define CONV_kJPmol_btuth	1.57494208438843d-24
#define CONV_kJPmol_calor	3.96613209772365d-22
#define CONV_kJPmol_kcalor	3.96613209772365d-25
#define CONV_kJPmol_cal15	3.96736396290751d-22
#define CONV_kJPmol_cal20	3.97077927897592d-22
#define CONV_kJPmol_calave	3.96308415395377d-22
#define CONV_kJPmol_calth	3.96878629702423d-22
#define CONV_kJPmol_ccatm	1.63882574554645d-20
#define CONV_wn_cal	4.74772337724326d-24
#define CONV_wn_kcal	4.74772337724326d-27
#define CONV_wn_ea	4.55633537935592d-06
#define CONV_wn_erg	1.98644746103858d-16
#define CONV_wn_ev	0.000123984244680243d0
#define CONV_wn_hz	29979245800d0
#define CONV_wn_J	1.98644746103858d-23
#define CONV_wn_Nm	1.98644746103858d-23
#define CONV_wn_megaJ	1.98644746103858d-29
#define CONV_wn_kcalPmol	0.00285914391915446d0
#define CONV_wn_kJPmol	0.0119626581577422d0
#define CONV_wn_ryd	9.11267075871184d-06
#define CONV_wn_btu	1.88278857088674d-26
#define CONV_wn_ft3atm	6.9233336492076d-27
#define CONV_wn_ft3lbPin2	1.01745044375412d-25
#define CONV_wn_ftlbal	4.71391270130566d-22
#define CONV_wn_ftlb	1.46512968924394d-23
#define CONV_wn_hphr	7.39964489517144d-30
#define CONV_wn_hphrm	7.50226947380492d-30
#define CONV_wn_kgm	2.02561275792733d-24
#define CONV_wn_gcm	2.02561268224988d-19
#define CONV_wn_kWhr	5.51790961399605d-30
#define CONV_wn_gWhr	5.51790961399605d-36
#define CONV_wn_latm	1.96047121740792d-25
#define CONV_wn_lbar	1.98644746103858d-25
#define CONV_wn_Whr	5.51790961399605d-27
#define CONV_wn_Ws	1.98644746103858d-23
#define CONV_wn_dyncm	1.98644746103858d-16
#define CONV_wn_chu	1.04599365049263d-26
#define CONV_wn_btu39	1.87459063768775d-26
#define CONV_wn_but60	1.88345987506976d-26
#define CONV_wn_btuave	1.88133715423166d-26
#define CONV_wn_btuth	1.88404937737808d-26
#define CONV_wn_calor	4.74454824935172d-24
#define CONV_wn_kcalor	4.74454824935172d-27
#define CONV_wn_cal15	4.74602188756081d-24
#define CONV_wn_cal20	4.75010751342351d-24
#define CONV_wn_calave	4.74090209841141d-24
#define CONV_wn_calth	4.74772337724326d-24
#define CONV_wn_ccatm	1.96047121740792d-22
#define CONV_ryd_cal	5.21002404558989d-19
#define CONV_ryd_kcal	5.21002404558989d-22
#define CONV_ryd_ea	0.5d0
#define CONV_ryd_erg	2.17987406067481d-11
#define CONV_ryd_ev	13.6056978204454d0
#define CONV_ryd_hz	3.28984186895367d+15
#define CONV_ryd_J	2.17987406067481d-18
#define CONV_ryd_Nm	2.17987406067481d-18
#define CONV_ryd_megaJ	2.17987406067481d-24
#define CONV_ryd_kcalPmol	313.754770128294d0
#define CONV_ryd_kJPmol	1312.74995821678d0
#define CONV_ryd_wn	109737.312636253d0
#define CONV_ryd_btu	2.06612158031362d-21
#define CONV_ryd_ft3atm	7.59748029148183d-22
#define CONV_ryd_ft3lbPin2	1.1165227743814d-20
#define CONV_ryd_ftlbal	5.17292111843182d-17
#define CONV_ryd_ftlb	1.60779394761219d-18
#define CONV_ryd_hphr	8.1201714525868d-25
#define CONV_ryd_hphrm	8.23278890728345d-25
#define CONV_ryd_kgm	2.22285300496653d-19
#define CONV_ryd_gcm	2.22285292192014d-14
#define CONV_ryd_kWhr	6.05520572409669d-25
#define CONV_ryd_gWhr	6.05520572409669d-31
#define CONV_ryd_latm	2.15136842899068d-20
#define CONV_ryd_lbar	2.17987406067481d-20
#define CONV_ryd_Whr	6.05520572409669d-22
#define CONV_ryd_Ws	2.17987406067481d-18
#define CONV_ryd_dyncm	2.17987406067481d-11
#define CONV_ryd_chu	1.14784532239646d-21
#define CONV_ryd_btu39	2.05712538872933d-21
#define CONV_ryd_but60	2.06685825148368d-21
#define CONV_ryd_btuave	2.06452883468117d-21
#define CONV_ryd_btuth	2.06750515547476d-21
#define CONV_ryd_calor	5.20653974556895d-19
#define CONV_ryd_kcalor	5.20653974556895d-22
#define CONV_ryd_cal15	5.20815687653759d-19
#define CONV_ryd_cal20	5.21264033256369d-19
#define CONV_ryd_calave	5.2025385575124d-19
#define CONV_ryd_calth	5.21002404558989d-19
#define CONV_ryd_ccatm	2.15136842899068d-17
#define CONV_btu_cal	252.16444643103d0
#define CONV_btu_kcal	0.25216444643103d0
#define CONV_btu_ea	2.41999311542985d+20
#define CONV_btu_erg	10550560438.6743d0
#define CONV_btu_ev	6.58513901121938d+21
#define CONV_btu_hz	1.59227893474415d+36
#define CONV_btu_J	1055.05604386743d0
#define CONV_btu_Nm	1055.05604386743d0
#define CONV_btu_megaJ	0.00105505604386743d0
#define CONV_btu_kcalPmol	1.51856876728749d+23
#define CONV_btu_kJPmol	6.35369172233086d+23
#define CONV_btu_wn	5.31127082171009d+25
#define CONV_btu_ryd	4.8399862308597d+20
#define CONV_btu_ft3atm	0.367717d0
#define CONV_btu_ft3lbPin2	5.40395485444722d0
#define CONV_btu_ftlbal	25036.8669865333d0
#define CONV_btu_ftlb	778.170056850254d0
#define CONV_btu_hphr	0.000393015180227401d0
#define CONV_btu_hphrm	0.000398465849528264d0
#define CONV_btu_kgm	107.585779372631d0
#define CONV_btu_gcm	10758577.5353197d0
#define CONV_btu_kWhr	0.000293071123296508d0
#define CONV_btu_gWhr	2.93071123296508d-10
#define CONV_btu_latm	10.4125935738212d0
#define CONV_btu_lbar	10.5505604386743d0
#define CONV_btu_Whr	0.293071123296508d0
#define CONV_btu_Ws	1055.05604386743d0
#define CONV_btu_dyncm	10550560438.6743d0
#define CONV_btu_chu	0.555555555555556d0
#define CONV_btu_btu39	0.995645855660187d0
#define CONV_btu_but60	1.00035654783198d0
#define CONV_btu_btuave	0.99922911330697d0
#define CONV_btu_btuth	1.00066964847293d0
#define CONV_btu_calor	251.995806789775d0
#define CONV_btu_kcalor	0.251995806789775d0
#define CONV_btu_cal15	252.074075705992d0
#define CONV_btu_cal20	252.291074360322d0
#define CONV_btu_calave	251.802149838767d0
#define CONV_btu_calth	252.16444643103d0
#define CONV_btu_ccatm	10412.5935738212d0
#define CONV_ft3atm_cal	685.756835911938d0
#define CONV_ft3atm_kcal	0.685756835911938d0
#define CONV_ft3atm_ea	6.58112927993498d+20
#define CONV_ft3atm_erg	28692066014.5555d0
#define CONV_ft3atm_ev	1.79081712600162d+22
#define CONV_ft3atm_hz	4.3301749300254d+36
#define CONV_ft3atm_J	2869.20660145555d0
#define CONV_ft3atm_Nm	2869.20660145555d0
#define CONV_ft3atm_megaJ	0.00286920660145555d0
#define CONV_ft3atm_kcalPmol	4.12972140882116d+23
#define CONV_ft3atm_kJPmol	1.72787543745077d+24
#define CONV_ft3atm_wn	1.44439088258364d+26
#define CONV_ft3atm_ryd	1.316225855987d+21
#define CONV_ft3atm_btu	2.7194826456215d0
#define CONV_ft3atm_ft3lbPin2	14.6959614443913d0
#define CONV_ft3atm_ftlbal	68087.3252706112d0
#define CONV_ft3atm_ftlb	2116.21996494656d0
#define CONV_ft3atm_hphr	0.00106879796209422d0
#define CONV_ft3atm_hphrm	0.00108362096266494d0
#define CONV_ft3atm_kgm	292.577659919534d0
#define CONV_ft3atm_gcm	29257764.8988752d0
#define CONV_ft3atm_kWhr	0.000797001833737652d0
#define CONV_ft3atm_gWhr	7.97001833737652d-10
#define CONV_ft3atm_latm	28.3168675199166d0
#define CONV_ft3atm_lbar	28.6920660145555d0
#define CONV_ft3atm_Whr	0.797001833737652d0
#define CONV_ft3atm_Ws	2869.20660145555d0
#define CONV_ft3atm_dyncm	28692066014.5555d0
#define CONV_ft3atm_chu	1.51082369201194d0
#define CONV_ft3atm_btu39	2.70764162565284d0
#define CONV_ft3atm_but60	2.72045227126289d0
#define CONV_ft3atm_btuave	2.71738623263806d0
#define CONV_ft3atm_btuth	2.72130374302229d0
#define CONV_ft3atm_calor	685.298223334181d0
#define CONV_ft3atm_kcalor	0.685298223334181d0
#define CONV_ft3atm_cal15	685.511074293525d0
#define CONV_ft3atm_cal20	686.101198368098d0
#define CONV_ft3atm_calave	684.77157661671d0
#define CONV_ft3atm_calth	685.756835911938d0
#define CONV_ft3atm_ccatm	28316.8675199166d0
#define CONV_ft3lbPin2_cal	46.6629446808775d0
#define CONV_ft3lbPin2_kcal	0.0466629446808775d0
#define CONV_ft3lbPin2_ea	4.47818899419247d+19
#define CONV_ft3lbPin2_erg	1952377605.44791d0
#define CONV_ft3lbPin2_ev	1.21857772475654d+21
#define CONV_ft3lbPin2_hz	2.94650673003638d+35
#define CONV_ft3lbPin2_J	195.237760544791d0
#define CONV_ft3lbPin2_Nm	195.237760544791d0
#define CONV_ft3lbPin2_megaJ	0.000195237760544791d0
#define CONV_ft3lbPin2_kcalPmol	2.81010631692782d+22
#define CONV_ft3lbPin2_kJPmol	1.1757484830026d+23
#define CONV_ft3lbPin2_wn	9.82848851399849d+24
#define CONV_ft3lbPin2_ryd	8.95637798838493d+19
#define CONV_ft3lbPin2_btu	0.18504965843248d0
#define CONV_ft3lbPin2_ft3atm	0.0680459052498162d0
#define CONV_ft3lbPin2_ftlbal	4633.06368407743d0
#define CONV_ft3lbPin2_ftlb	144.000103222523d0
#define CONV_ft3lbPin2_hphr	7.27273248598601d-05
#define CONV_ft3lbPin2_hphrm	7.37359693522131d-05
#define CONV_ft3lbPin2_kgm	19.9087117250976d0
#define CONV_ft3lbPin2_gcm	1990871.09813026d0
#define CONV_ft3lbPin2_kWhr	5.42327112624421d-05
#define CONV_ft3lbPin2_gWhr	5.42327112624421d-11
#define CONV_ft3lbPin2_latm	1.92684688423184d0
#define CONV_ft3lbPin2_lbar	1.95237760544791d0
#define CONV_ft3lbPin2_Whr	0.0542327112624421d0
#define CONV_ft3lbPin2_Ws	195.237760544791d0
#define CONV_ft3lbPin2_dyncm	1952377605.44791d0
#define CONV_ft3lbPin2_chu	0.102805365795822d0
#define CONV_ft3lbPin2_btu39	0.184243925509632d0
#define CONV_ft3lbPin2_but60	0.185115637487002d0
#define CONV_ft3lbPin2_btuave	0.184907006113245d0
#define CONV_ft3lbPin2_btuth	0.185173576653665d0
#define CONV_ft3lbPin2_calor	46.6317379728651d0
#define CONV_ft3lbPin2_kcalor	0.0466317379728651d0
#define CONV_ft3lbPin2_cal15	46.6462216090769d0
#define CONV_ft3lbPin2_cal20	46.686377135941d0
#define CONV_ft3lbPin2_calave	46.5959018202279d0
#define CONV_ft3lbPin2_calth	46.6629446808775d0
#define CONV_ft3lbPin2_ccatm	1926.84688423184d0
#define CONV_ftlbal_cal	0.0100717252908146d0
#define CONV_ftlbal_kcal	1.00717252908146d-05
#define CONV_ftlbal_ea	9.6657186249841d+15
#define CONV_ftlbal_erg	421400.986167685d0
#define CONV_ftlbal_ev	2.6301769365797d+17
#define CONV_ftlbal_hz	6.35973716519959d+31
#define CONV_ftlbal_J	0.0421400986167685d0
#define CONV_ftlbal_Nm	0.0421400986167685d0
#define CONV_ftlbal_megaJ	4.21400986167685d-08
#define CONV_ftlbal_kcalPmol	6.0653306506133d+18
#define CONV_ftlbal_kJPmol	2.53773434421661d+19
#define CONV_ftlbal_wn	2.12137997320786d+21
#define CONV_ftlbal_ryd	1.93314372499682d+16
#define CONV_ftlbal_btu	3.99410996806379d-05
#define CONV_ftlbal_ft3atm	1.46870213512651d-05
#define CONV_ftlbal_ft3lbPin2	0.000215839899511143d0
#define CONV_ftlbal_ftlb	0.0310809678091436d0
#define CONV_ftlbal_hphr	1.56974584894665d-08
#define CONV_ftlbal_hphrm	1.59151642153384d-08
#define CONV_ftlbal_kgm	0.00429709433814138d0
#define CONV_ftlbal_gcm	429.709417760076d0
#define CONV_ftlbal_kWhr	1.17055829491024d-08
#define CONV_ftlbal_gWhr	1.17055829491024d-14
#define CONV_ftlbal_latm	0.000415890437865961d0
#define CONV_ftlbal_lbar	0.000421400986167685d0
#define CONV_ftlbal_Whr	1.17055829491024d-05
#define CONV_ftlbal_Ws	0.0421400986167685d0
#define CONV_ftlbal_dyncm	421400.986167685d0
#define CONV_ftlbal_chu	2.21894998225766d-05
#define CONV_ftlbal_btu39	3.97671903675375d-05
#define CONV_ftlbal_but60	3.99553405931358d-05
#define CONV_ftlbal_btuave	3.99103096183891d-05
#define CONV_ftlbal_btuth	3.9967846177046d-05
#define CONV_ftlbal_calor	0.0100649896380932d0
#define CONV_ftlbal_kcalor	1.00649896380932d-05
#define CONV_ftlbal_cal15	0.0100681157846777d0
#define CONV_ftlbal_cal20	0.0100767829495608d0
#define CONV_ftlbal_calave	0.0100572547665091d0
#define CONV_ftlbal_calth	0.0100717252908146d0
#define CONV_ftlbal_ccatm	0.415890437865961d0
#define CONV_ftlb_cal	0.324047994665458d0
#define CONV_ftlb_kcal	0.000324047994665458d0
#define CONV_ftlb_ea	3.10985123897608d+17
#define CONV_ftlb_erg	13558168.0968028d0
#define CONV_ftlb_ev	8.46233924480929d+18
#define CONV_ftlb_hz	2.04618376244019d+33
#define CONV_ftlb_J	1.35581680968028d0
#define CONV_ftlb_Nm	1.35581680968028d0
#define CONV_ftlb_megaJ	1.35581680968028d-06
#define CONV_ftlb_kcalPmol	1.95146132123626d+20
#define CONV_ftlb_kJPmol	8.1649141680525d+20
#define CONV_ftlb_wn	6.82533435327512d+22
#define CONV_ftlb_ryd	6.21970247795216d+17
#define CONV_ftlb_btu	0.00128506615128271d0
#define CONV_ftlb_ft3atm	0.000472540669951223d0
#define CONV_ftlb_ft3lbPin2	0.00694443946650998d0
#define CONV_ftlb_ftlbal	32.1740302985614d0
#define CONV_ftlb_hphr	5.05050505050505d-07
#define CONV_ftlb_hphrm	5.1205497567088d-07
#define CONV_ftlb_kgm	0.138254843431138d0
#define CONV_ftlb_gcm	13825.4838265899d0
#define CONV_ftlb_kWhr	3.76615780466743d-07
#define CONV_ftlb_gWhr	3.76615780466743d-13
#define CONV_ftlb_latm	0.0133808715487814d0
#define CONV_ftlb_lbar	0.0135581680968028d0
#define CONV_ftlb_Whr	0.000376615780466743d0
#define CONV_ftlb_Ws	1.35581680968028d0
#define CONV_ftlb_dyncm	13558168.0968028d0
#define CONV_ftlb_chu	0.000713925639601503d0
#define CONV_ftlb_btu39	0.00127947078777381d0
#define CONV_ftlb_but60	0.00128552433883289d0
#define CONV_ftlb_btuave	0.00128407551088702d0
#define CONV_ftlb_btuth	0.00128592669386852d0
#define CONV_ftlb_calor	0.323831281570716d0
#define CONV_ftlb_kcalor	0.000323831281570717d0
#define CONV_ftlb_cal15	0.323931862305645d0
#define CONV_ftlb_cal20	0.324210719931198d0
#define CONV_ftlb_calave	0.323582419578015d0
#define CONV_ftlb_calth	0.324047994665458d0
#define CONV_ftlb_ccatm	13.3808715487814d0
#define CONV_hphr_cal	641615.029437607d0
#define CONV_hphr_kcal	641.615029437606d0
#define CONV_hphr_ea	6.15750545317264d+23
#define CONV_hphr_erg	26845172831669.5d0
#define CONV_hphr_ev	1.67554317047224d+25
#define CONV_hphr_hz	4.05144384963157d+39
#define CONV_hphr_J	2684517.28316695d0
#define CONV_hphr_Nm	2684517.28316695d0
#define CONV_hphr_megaJ	2.68451728316695d0
#define CONV_hphr_kcalPmol	3.86389341604779d+26
#define CONV_hphr_kJPmol	1.6166530052744d+27
#define CONV_hphr_wn	1.35141620194847d+29
#define CONV_hphr_ryd	1.23150109063453d+24
#define CONV_hphr_btu	2544.43097953976d0
#define CONV_hphr_ft3atm	935.630526503421d0
#define CONV_hphr_ft3lbPin2	13749.9901436898d0
#define CONV_hphr_ftlbal	63704579.9911516d0
#define CONV_hphr_ftlb	1980000d0
#define CONV_hphr_hphrm	1.01386885182834d0
#define CONV_hphr_kgm	273744.589993652d0
#define CONV_hphr_gcm	27374457976.6479d0
#define CONV_hphr_kWhr	0.745699245324152d0
#define CONV_hphr_gWhr	7.45699245324151d-07
#define CONV_hphr_latm	26494.1256665872d0
#define CONV_hphr_lbar	26845.1728316695d0
#define CONV_hphr_Whr	745.699245324152d0
#define CONV_hphr_Ws	2684517.28316695d0
#define CONV_hphr_dyncm	26845172831669.5d0
#define CONV_hphr_chu	1413.57276641098d0
#define CONV_hphr_btu39	2533.35215979215d0
#define CONV_hphr_but60	2545.33819088913d0
#define CONV_hphr_btuave	2542.4695115563d0
#define CONV_hphr_btuth	2546.13485385967d0
#define CONV_hphr_calor	641185.937510019d0
#define CONV_hphr_kcalor	641.185937510019d0
#define CONV_hphr_cal15	641385.087365176d0
#define CONV_hphr_cal20	641937.225463771d0
#define CONV_hphr_calave	640693.19076447d0
#define CONV_hphr_calth	641615.029437607d0
#define CONV_hphr_ccatm	26494125.6665872d0
#define CONV_hphrm_cal	632838.28897649d0
#define CONV_hphrm_kcal	632.83828897649d0
#define CONV_hphrm_ea	6.0732760870093d+23
#define CONV_hphrm_erg	26477954010776.4d0
#define CONV_hphrm_ev	1.65262318439972d+25
#define CONV_hphrm_hz	3.99602359055165d+39
#define CONV_hphrm_J	2647795.40107764d0
#define CONV_hphrm_Nm	2647795.40107764d0
#define CONV_hphrm_megaJ	2.64779540107764d0
#define CONV_hphrm_kcalPmol	3.81103868521053d+26
#define CONV_hphrm_kJPmol	1.59453858589208d+27
#define CONV_hphrm_wn	1.33292999337283d+29
#define CONV_hphrm_ryd	1.21465521740186d+24
#define CONV_hphrm_btu	2509.62535731451d0
#define CONV_hphrm_ft3atm	922.831907515621d0
#define CONV_hphrm_ft3lbPin2	13561.9021325036d0
#define CONV_hphrm_ftlbal	62833156.2571147d0
#define CONV_hphrm_ftlb	1952915.30697427d0
#define CONV_hphrm_hphr	0.986320862108219d0
#define CONV_hphrm_kgm	270000d0
#define CONV_hphrm_gcm	26999998991.2726d0
#define CONV_hphrm_kWhr	0.735498722521565d0
#define CONV_hphrm_gWhr	7.35498722521565d-07
#define CONV_hphrm_latm	26131.7088682718d0
#define CONV_hphrm_lbar	26477.9540107764d0
#define CONV_hphrm_Whr	735.498722521565d0
#define CONV_hphrm_Ws	2647795.40107764d0
#define CONV_hphrm_dyncm	26477954010776.4d0
#define CONV_hphrm_chu	1394.23630961917d0
#define CONV_hphrm_btu39	2498.69808626991d0
#define CONV_hphrm_but60	2510.52015879474d0
#define CONV_hphrm_btuave	2507.69072052207d0
#define CONV_hphrm_btuth	2511.30592410266d0
#define CONV_hphrm_calor	632415.066656548d0
#define CONV_hphrm_kcalor	632.415066656548d0
#define CONV_hphrm_cal15	632611.492313376d0
#define CONV_hphrm_cal20	633156.077638785d0
#define CONV_hphrm_calave	631929.060261678d0
#define CONV_hphrm_calth	632838.28897649d0
#define CONV_hphrm_ccatm	26131708.8682718d0
#define CONV_kgm_cal	2.34384551472774d0
#define CONV_kgm_kcal	0.00234384551472774d0
#define CONV_kgm_ea	2.24936151370715d+18
#define CONV_kgm_erg	98066496.3362087d0
#define CONV_kgm_ev	6.12082660888784d+19
#define CONV_kgm_hz	1.48000873724135d+34
#define CONV_kgm_J	9.80664963362087d0
#define CONV_kgm_Nm	9.80664963362087d0
#define CONV_kgm_megaJ	9.80664963362087d-06
#define CONV_kgm_kcalPmol	1.41149580933723d+21
#define CONV_kgm_kJPmol	5.90569846626698d+21
#define CONV_kgm_wn	4.93677775323272d+23
#define CONV_kgm_ryd	4.49872302741429d+18
#define CONV_kgm_btu	0.00929490873079449d0
#define CONV_kgm_ft3atm	0.00341789595376156d0
#define CONV_kgm_ft3lbPin2	0.0502292671574208d0
#define CONV_kgm_ftlbal	232.715393544869d0
#define CONV_kgm_ftlb	7.23301965546027d0
#define CONV_kgm_hphr	3.65304023003044d-06
#define CONV_kgm_hphrm	3.7037037037037d-06
#define CONV_kgm_gcm	99999.9962639726d0
#define CONV_kgm_kWhr	2.72406934267246d-06
#define CONV_kgm_gWhr	2.72406934267246d-12
#define CONV_kgm_latm	0.096784106919525d0
#define CONV_kgm_lbar	0.0980664963362087d0
#define CONV_kgm_Whr	0.00272406934267246d0
#define CONV_kgm_Ws	9.80664963362087d0
#define CONV_kgm_dyncm	98066496.3362087d0
#define CONV_kgm_chu	0.00516383818377472d0
#define CONV_kgm_btu39	0.00925443735655522d0
#define CONV_kgm_but60	0.00929822281035089d0
#define CONV_kgm_btuave	0.00928774340934099d0
#define CONV_kgm_btuth	0.00930113305223206d0
#define CONV_kgm_calor	2.34227802465388d0
#define CONV_kgm_kcalor	0.00234227802465388d0
#define CONV_kgm_cal15	2.34300552708658d0
#define CONV_kgm_cal20	2.34502250977328d0
#define CONV_kgm_calave	2.34047800096918d0
#define CONV_kgm_calth	2.34384551472774d0
#define CONV_kgm_ccatm	96.784106919525d0
#define CONV_gcm_cal	2.34384560229446d-05
#define CONV_gcm_kcal	2.34384560229446d-08
#define CONV_gcm_ea	22493615977439.1d0
#define CONV_gcm_erg	980.665d0
#define CONV_gcm_ev	612082683756360d0
#define CONV_gcm_hz	1.48000879253489d+29
#define CONV_gcm_J	9.80665d-05
#define CONV_gcm_Nm	9.80665d-05
#define CONV_gcm_megaJ	9.80665d-11
#define CONV_gcm_kcalPmol	1.4114958620711d+16
#define CONV_gcm_kJPmol	5.9056986869055d+16
#define CONV_gcm_wn	4.93677793767209d+18
#define CONV_gcm_ryd	44987231954878.2d0
#define CONV_gcm_btu	9.29490907805484d-08
#define CONV_gcm_ft3atm	3.41789608145509d-08
#define CONV_gcm_ft3lbPin2	5.0229269034d-07
#define CONV_gcm_ftlbal	0.0023271540223918d0
#define CONV_gcm_ftlb	7.23301992568788d-05
#define CONV_gcm_hphr	3.65304036650903d-11
#define CONV_gcm_hphrm	3.70370384207509d-11
#define CONV_gcm_kgm	1.00000003736028d-05
#define CONV_gcm_kWhr	2.72406944444444d-11
#define CONV_gcm_gWhr	2.72406944444444d-17
#define CONV_gcm_latm	9.67841105354059d-07
#define CONV_gcm_lbar	9.80665d-07
#define CONV_gcm_Whr	2.72406944444444d-08
#define CONV_gcm_Ws	9.80665d-05
#define CONV_gcm_dyncm	980.665d0
#define CONV_gcm_chu	5.16383837669713d-08
#define CONV_gcm_btu39	9.25443770230355d-08
#define CONV_gcm_but60	9.29822315773505d-08
#define CONV_gcm_btuave	9.28774375633364d-08
#define CONV_gcm_btuth	9.30113339972495d-08
#define CONV_gcm_calor	2.34227811216203d-05
#define CONV_gcm_kcalor	2.34227811216203d-08
#define CONV_gcm_cal15	2.34300561462191d-05
#define CONV_gcm_cal20	2.34502259738396d-05
#define CONV_gcm_calave	2.34047808841008d-05
#define CONV_gcm_calth	2.34384560229445d-05
#define CONV_gcm_ccatm	0.000967841105354059d0
#define CONV_kWhr_cal	860420.650095602d0
#define CONV_kWhr_kcal	860.420650095602d0
#define CONV_kWhr_ea	8.25735776424985d+23
#define CONV_kWhr_erg	36000000000000d0
#define CONV_kWhr_ev	2.24694229071385d+25
#define CONV_kWhr_hz	5.43308025995176d+39
#define CONV_kWhr_J	3600000d0
#define CONV_kWhr_Nm	3600000d0
#define CONV_kWhr_megaJ	3.6d0
#define CONV_kWhr_kcalPmol	5.18157077437858d+26
#define CONV_kWhr_kJPmol	2.167969212d+27
#define CONV_kWhr_wn	1.81228050104975d+29
#define CONV_kWhr_ryd	1.65147155284997d+24
#define CONV_kWhr_btu	3412.14101461737d0
#define CONV_kWhr_ft3atm	1254.70225747205d0
#define CONV_kWhr_ft3lbPin2	18439.056d0
#define CONV_kWhr_ftlbal	85429320.72227d0
#define CONV_kWhr_ftlb	2655225.96732588d0
#define CONV_kWhr_hphr	1.34102321582115d0
#define CONV_kWhr_hphrm	1.35962166809974d0
#define CONV_kWhr_kgm	367097.85038693d0
#define CONV_kWhr_gcm	36709783667.2054d0
#define CONV_kWhr_gWhr	1d-06
#define CONV_kWhr_latm	35529.2376017765d0
#define CONV_kWhr_lbar	36000d0
#define CONV_kWhr_Whr	1000d0
#define CONV_kWhr_Ws	3600000d0
#define CONV_kWhr_dyncm	36000000000000d0
#define CONV_kWhr_chu	1895.63389700965d0
#define CONV_kWhr_btu39	3397.28406013193d0
#define CONV_kWhr_but60	3413.35760609853d0
#define CONV_kWhr_btuave	3409.51064051446d0
#define CONV_kWhr_btuth	3414.42594963722d0
#define CONV_kWhr_calor	859845.227858985d0
#define CONV_kWhr_kcalor	859.845227858985d0
#define CONV_kWhr_cal15	860112.292438179d0
#define CONV_kWhr_cal20	860852.722446735d0
#define CONV_kWhr_calave	859184.443033685d0
#define CONV_kWhr_calth	860420.650095602d0
#define CONV_kWhr_ccatm	35529237.6017765d0
#define CONV_gWhr_cal	860420650095.602d0
#define CONV_gWhr_kcal	860420650.095602d0
#define CONV_gWhr_ea	8.25735776424985d+29
#define CONV_gWhr_erg	3.6d+19
#define CONV_gWhr_ev	2.24694229071385d+31
#define CONV_gWhr_hz	5.43308025995176d+45
#define CONV_gWhr_J	3600000000000d0
#define CONV_gWhr_Nm	3600000000000d0
#define CONV_gWhr_megaJ	3600000d0
#define CONV_gWhr_kcalPmol	5.18157077437858d+32
#define CONV_gWhr_kJPmol	2.167969212d+33
#define CONV_gWhr_wn	1.81228050104975d+35
#define CONV_gWhr_ryd	1.65147155284997d+30
#define CONV_gWhr_btu	3412141014.61737d0
#define CONV_gWhr_ft3atm	1254702257.47205d0
#define CONV_gWhr_ft3lbPin2	18439056000d0
#define CONV_gWhr_ftlbal	85429320722270d0
#define CONV_gWhr_ftlb	2655225967325.88d0
#define CONV_gWhr_hphr	1341023.21582115d0
#define CONV_gWhr_hphrm	1359621.66809974d0
#define CONV_gWhr_kgm	367097850386.93d0
#define CONV_gWhr_gcm	3.67097836672054d+16
#define CONV_gWhr_kWhr	1000000d0
#define CONV_gWhr_latm	35529237601.7765d0
#define CONV_gWhr_lbar	36000000000d0
#define CONV_gWhr_Whr	1000000000d0
#define CONV_gWhr_Ws	3600000000000d0
#define CONV_gWhr_dyncm	3.6d+19
#define CONV_gWhr_chu	1895633897.00965d0
#define CONV_gWhr_btu39	3397284060.13193d0
#define CONV_gWhr_but60	3413357606.09853d0
#define CONV_gWhr_btuave	3409510640.51446d0
#define CONV_gWhr_btuth	3414425949.63722d0
#define CONV_gWhr_calor	859845227858.985d0
#define CONV_gWhr_kcalor	859845227.858985d0
#define CONV_gWhr_cal15	860112292438.179d0
#define CONV_gWhr_cal20	860852722446.735d0
#define CONV_gWhr_calave	859184443033.685d0
#define CONV_gWhr_calth	860420650095.602d0
#define CONV_gWhr_ccatm	35529237601776.5d0
#define CONV_latm_cal	24.2172562141491d0
#define CONV_latm_kcal	0.0242172562141491d0
#define CONV_latm_ea	2.32410215406282d+19
#define CONV_latm_erg	1013250000d0
#define CONV_latm_ev	6.32420632240502d+20
#define CONV_latm_hz	1.52918571483226d+35
#define CONV_latm_J	101.325d0
#define CONV_latm_Nm	101.325d0
#define CONV_latm_megaJ	0.000101325d0
#define CONV_latm_kcalPmol	1.45839627420531d+22
#define CONV_latm_kJPmol	6.101930011275d+22
#define CONV_latm_wn	5.10081449357961d+24
#define CONV_latm_ryd	4.64820430812565d+19
#define CONV_latm_btu	0.0960375523072514d0
#define CONV_latm_ft3atm	0.0353146406217655d0
#define CONV_latm_ft3lbPin2	0.518982597d0
#define CONV_latm_ftlbal	2404.47942282889d0
#define CONV_latm_ftlb	74.733547538693d0
#define CONV_latm_hphr	3.77442159286328d-05
#define CONV_latm_hphrm	3.8267684866724d-05
#define CONV_latm_kgm	10.3322749140155d0
#define CONV_latm_gcm	1033227.45279989d0
#define CONV_latm_kWhr	2.81458333333333d-05
#define CONV_latm_gWhr	2.81458333333333d-11
#define CONV_latm_lbar	1.01325d0
#define CONV_latm_Whr	0.0281458333333333d0
#define CONV_latm_Ws	101.325d0
#define CONV_latm_dyncm	1013250000d0
#define CONV_latm_chu	0.0533541957262508d0
#define CONV_latm_btu39	0.0956193909424632d0
#define CONV_latm_but60	0.0960717942883149d0
#define CONV_latm_btuave	0.0959635182361465d0
#define CONV_latm_btuth	0.0961018637074975d0
#define CONV_latm_calor	24.201060475781d0
#define CONV_latm_kcalor	0.024201060475781d0
#define CONV_latm_cal15	24.2085772309163d0
#define CONV_latm_cal20	24.2294172505321d0
#define CONV_latm_calave	24.1824621362189d0
#define CONV_latm_calth	24.2172562141491d0
#define CONV_latm_ccatm	1000d0
#define CONV_lbar_cal	23.9005736137667d0
#define CONV_lbar_kcal	0.0239005736137667d0
#define CONV_lbar_ea	2.2937104900694d+19
#define CONV_lbar_erg	1000000000d0
#define CONV_lbar_ev	6.24150636309403d+20
#define CONV_lbar_hz	1.50918896109771d+35
#define CONV_lbar_J	100d0
#define CONV_lbar_Nm	100d0
#define CONV_lbar_megaJ	0.0001d0
#define CONV_lbar_kcalPmol	1.43932521510516d+22
#define CONV_lbar_kJPmol	6.0221367d+22
#define CONV_lbar_wn	5.03411250291597d+24
#define CONV_lbar_ryd	4.58742098013881d+19
#define CONV_lbar_btu	0.0947816948504825d0
#define CONV_lbar_ft3atm	0.0348528404853349d0
#define CONV_lbar_ft3lbPin2	0.512196d0
#define CONV_lbar_ftlbal	2373.03668672972d0
#define CONV_lbar_ftlb	73.7562768701634d0
#define CONV_lbar_hphr	3.72506448839209d-05
#define CONV_lbar_hphrm	3.77672685583262d-05
#define CONV_lbar_kgm	10.1971625107481d0
#define CONV_lbar_gcm	1019716.21297793d0
#define CONV_lbar_kWhr	2.77777777777778d-05
#define CONV_lbar_gWhr	2.77777777777778d-11
#define CONV_lbar_latm	0.986923266716013d0
#define CONV_lbar_Whr	0.0277777777777778d0
#define CONV_lbar_Ws	100d0
#define CONV_lbar_dyncm	1000000000d0
#define CONV_lbar_chu	0.0526564971391569d0
#define CONV_lbar_btu39	0.0943690016703313d0
#define CONV_lbar_but60	0.0948154890582926d0
#define CONV_lbar_btuave	0.0947086289031794d0
#define CONV_lbar_btuth	0.0948451652677005d0
#define CONV_lbar_calor	23.8845896627496d0
#define CONV_lbar_kcalor	0.0238845896627496d0
#define CONV_lbar_cal15	23.8920081232828d0
#define CONV_lbar_cal20	23.9125756235204d0
#define CONV_lbar_calave	23.8662345287135d0
#define CONV_lbar_calth	23.9005736137667d0
#define CONV_lbar_ccatm	986.923266716013d0
#define CONV_Whr_cal	860.420650095602d0
#define CONV_Whr_kcal	0.860420650095602d0
#define CONV_Whr_ea	8.25735776424985d+20
#define CONV_Whr_erg	36000000000d0
#define CONV_Whr_ev	2.24694229071385d+22
#define CONV_Whr_hz	5.43308025995176d+36
#define CONV_Whr_J	3600d0
#define CONV_Whr_Nm	3600d0
#define CONV_Whr_megaJ	0.0036d0
#define CONV_Whr_kcalPmol	5.18157077437858d+23
#define CONV_Whr_kJPmol	2.167969212d+24
#define CONV_Whr_wn	1.81228050104975d+26
#define CONV_Whr_ryd	1.65147155284997d+21
#define CONV_Whr_btu	3.41214101461737d0
#define CONV_Whr_ft3atm	1.25470225747205d0
#define CONV_Whr_ft3lbPin2	18.439056d0
#define CONV_Whr_ftlbal	85429.32072227d0
#define CONV_Whr_ftlb	2655.22596732588d0
#define CONV_Whr_hphr	0.00134102321582115d0
#define CONV_Whr_hphrm	0.00135962166809974d0
#define CONV_Whr_kgm	367.09785038693d0
#define CONV_Whr_gcm	36709783.6672054d0
#define CONV_Whr_kWhr	0.001d0
#define CONV_Whr_gWhr	1d-09
#define CONV_Whr_latm	35.5292376017765d0
#define CONV_Whr_lbar	36d0
#define CONV_Whr_Ws	3600d0
#define CONV_Whr_dyncm	36000000000d0
#define CONV_Whr_chu	1.89563389700965d0
#define CONV_Whr_btu39	3.39728406013193d0
#define CONV_Whr_but60	3.41335760609853d0
#define CONV_Whr_btuave	3.40951064051446d0
#define CONV_Whr_btuth	3.41442594963722d0
#define CONV_Whr_calor	859.845227858985d0
#define CONV_Whr_kcalor	0.859845227858985d0
#define CONV_Whr_cal15	860.112292438179d0
#define CONV_Whr_cal20	860.852722446735d0
#define CONV_Whr_calave	859.184443033685d0
#define CONV_Whr_calth	860.420650095602d0
#define CONV_Whr_ccatm	35529.2376017765d0
#define CONV_Ws_cal	0.239005736137667d0
#define CONV_Ws_kcal	0.000239005736137667d0
#define CONV_Ws_ea	2.2937104900694d+17
#define CONV_Ws_erg	10000000d0
#define CONV_Ws_ev	6.24150636309403d+18
#define CONV_Ws_hz	1.50918896109771d+33
#define CONV_Ws_J	1d0
#define CONV_Ws_Nm	1d0
#define CONV_Ws_megaJ	1d-06
#define CONV_Ws_kcalPmol	1.43932521510516d+20
#define CONV_Ws_kJPmol	6.0221367d+20
#define CONV_Ws_wn	5.03411250291597d+22
#define CONV_Ws_ryd	4.58742098013881d+17
#define CONV_Ws_btu	0.000947816948504825d0
#define CONV_Ws_ft3atm	0.000348528404853349d0
#define CONV_Ws_ft3lbPin2	0.00512196d0
#define CONV_Ws_ftlbal	23.7303668672972d0
#define CONV_Ws_ftlb	0.737562768701634d0
#define CONV_Ws_hphr	3.72506448839209d-07
#define CONV_Ws_hphrm	3.77672685583262d-07
#define CONV_Ws_kgm	0.101971625107481d0
#define CONV_Ws_gcm	10197.1621297793d0
#define CONV_Ws_kWhr	2.77777777777778d-07
#define CONV_Ws_gWhr	2.77777777777778d-13
#define CONV_Ws_latm	0.00986923266716013d0
#define CONV_Ws_lbar	0.01d0
#define CONV_Ws_Whr	0.000277777777777778d0
#define CONV_Ws_dyncm	10000000d0
#define CONV_Ws_chu	0.000526564971391569d0
#define CONV_Ws_btu39	0.000943690016703313d0
#define CONV_Ws_but60	0.000948154890582926d0
#define CONV_Ws_btuave	0.000947086289031794d0
#define CONV_Ws_btuth	0.000948451652677005d0
#define CONV_Ws_calor	0.238845896627496d0
#define CONV_Ws_kcalor	0.000238845896627496d0
#define CONV_Ws_cal15	0.238920081232828d0
#define CONV_Ws_cal20	0.239125756235204d0
#define CONV_Ws_calave	0.238662345287135d0
#define CONV_Ws_calth	0.239005736137667d0
#define CONV_Ws_ccatm	9.86923266716013d0
#define CONV_dyncm_cal	2.39005736137667d-08
#define CONV_dyncm_kcal	2.39005736137667d-11
#define CONV_dyncm_ea	22937104900.694d0
#define CONV_dyncm_erg	1d0
#define CONV_dyncm_ev	624150636309.403d0
#define CONV_dyncm_hz	1.50918896109771d+26
#define CONV_dyncm_J	1d-07
#define CONV_dyncm_Nm	1d-07
#define CONV_dyncm_megaJ	1d-13
#define CONV_dyncm_kcalPmol	14393252151051.6d0
#define CONV_dyncm_kJPmol	60221367000000d0
#define CONV_dyncm_wn	5.03411250291597d+15
#define CONV_dyncm_ryd	45874209801.3881d0
#define CONV_dyncm_btu	9.47816948504825d-11
#define CONV_dyncm_ft3atm	3.48528404853349d-11
#define CONV_dyncm_ft3lbPin2	5.12196d-10
#define CONV_dyncm_ftlbal	2.37303668672972d-06
#define CONV_dyncm_ftlb	7.37562768701634d-08
#define CONV_dyncm_hphr	3.72506448839209d-14
#define CONV_dyncm_hphrm	3.77672685583262d-14
#define CONV_dyncm_kgm	1.01971625107481d-08
#define CONV_dyncm_gcm	0.00101971621297793d0
#define CONV_dyncm_kWhr	2.77777777777778d-14
#define CONV_dyncm_gWhr	2.77777777777778d-20
#define CONV_dyncm_latm	9.86923266716013d-10
#define CONV_dyncm_lbar	1d-09
#define CONV_dyncm_Whr	2.77777777777778d-11
#define CONV_dyncm_Ws	1d-07
#define CONV_dyncm_chu	5.26564971391569d-11
#define CONV_dyncm_btu39	9.43690016703313d-11
#define CONV_dyncm_but60	9.48154890582925d-11
#define CONV_dyncm_btuave	9.47086289031794d-11
#define CONV_dyncm_btuth	9.48451652677005d-11
#define CONV_dyncm_calor	2.38845896627496d-08
#define CONV_dyncm_kcalor	2.38845896627496d-11
#define CONV_dyncm_cal15	2.38920081232828d-08
#define CONV_dyncm_cal20	2.39125756235204d-08
#define CONV_dyncm_calave	2.38662345287135d-08
#define CONV_dyncm_calth	2.39005736137667d-08
#define CONV_dyncm_ccatm	9.86923266716013d-07
#define CONV_chu_cal	453.896003575854d0
#define CONV_chu_kcal	0.453896003575854d0
#define CONV_chu_ea	4.35598760777373d+20
#define CONV_chu_erg	18991008789.6137d0
#define CONV_chu_ev	1.18532502201949d+22
#define CONV_chu_hz	2.86610208253947d+36
#define CONV_chu_J	1899.10087896137d0
#define CONV_chu_Nm	1899.10087896137d0
#define CONV_chu_megaJ	0.00189910087896137d0
#define CONV_chu_kcalPmol	2.73342378111748d+23
#define CONV_chu_kJPmol	1.14366451001955d+24
#define CONV_chu_wn	9.56028747907817d+25
#define CONV_chu_ryd	8.71197521554746d+20
#define CONV_chu_btu	1.8d0
#define CONV_chu_ft3atm	0.6618906d0
#define CONV_chu_ft3lbPin2	9.727118738005d0
#define CONV_chu_ftlbal	45066.36057576d0
#define CONV_chu_ftlb	1400.70610233046d0
#define CONV_chu_hphr	0.000707427324409322d0
#define CONV_chu_hphrm	0.000717238529150875d0
#define CONV_chu_kgm	193.654402870736d0
#define CONV_chu_gcm	19365439.5635755d0
#define CONV_chu_kWhr	0.000527528021933715d0
#define CONV_chu_gWhr	5.27528021933715d-10
#define CONV_chu_latm	18.7426684328781d0
#define CONV_chu_lbar	18.9910087896137d0
#define CONV_chu_Whr	0.527528021933715d0
#define CONV_chu_Ws	1899.10087896137d0
#define CONV_chu_dyncm	18991008789.6137d0
#define CONV_chu_btu39	1.79216254018834d0
#define CONV_chu_but60	1.80064178609756d0
#define CONV_chu_btuave	1.79861240395255d0
#define CONV_chu_btuth	1.80120536725127d0
#define CONV_chu_calor	453.592452221595d0
#define CONV_chu_kcalor	0.453592452221595d0
#define CONV_chu_cal15	453.733336270786d0
#define CONV_chu_cal20	454.123933848579d0
#define CONV_chu_calave	453.24386970978d0
#define CONV_chu_calth	453.896003575854d0
#define CONV_chu_ccatm	18742.6684328781d0
#define CONV_btu39_cal	253.267208413002d0
#define CONV_btu39_kcal	0.253267208413002d0
#define CONV_btu39_ea	2.43057619501185d+20
#define CONV_btu39_erg	10596700000d0
#define CONV_btu39_ev	6.61393704777985d+21
#define CONV_btu39_hz	1.59924226640641d+36
#define CONV_btu39_J	1059.67d0
#define CONV_btu39_Nm	1059.67d0
#define CONV_btu39_megaJ	0.00105967d0
#define CONV_btu39_kcalPmol	1.52520975069049d+23
#define CONV_btu39_kJPmol	6.381477596889d+23
#define CONV_btu39_wn	5.33449799596497d+25
#define CONV_btu39_ryd	4.86115239002369d+20
#define CONV_btu39_btu	1.00437318582211d0
#define CONV_btu39_ft3atm	0.369325094770948d0
#define CONV_btu39_ft3lbPin2	5.4275873532d0
#define CONV_btu39_ftlbal	25146.3578582688d0
#define CONV_btu39_ftlb	781.57313911006d0
#define CONV_btu39_hphr	0.000394733908641445d0
#define CONV_btu39_hphrm	0.000400208414732015d0
#define CONV_btu39_kgm	108.056271977644d0
#define CONV_btu39_gcm	10805626.7940632d0
#define CONV_btu39_kWhr	0.000294352777777778d0
#define CONV_btu39_gWhr	2.94352777777778d-10
#define CONV_btu39_latm	10.4581297804096d0
#define CONV_btu39_lbar	10.5967d0
#define CONV_btu39_Whr	0.294352777777778d0
#define CONV_btu39_Ws	1059.67d0
#define CONV_btu39_dyncm	10596700000d0
#define CONV_btu39_chu	0.557985103234504d0
#define CONV_btu39_but60	1.00473129290401d0
#define CONV_btu39_btuave	1.00359892789832d0
#define CONV_btu39_btuth	1.00504576279224d0
#define CONV_btu39_calor	253.097831279259d0
#define CONV_btu39_kcalor	0.253097831279259d0
#define CONV_btu39_cal15	253.17644247999d0
#define CONV_btu39_cal20	253.394390109759d0
#define CONV_btu39_calave	252.903327430418d0
#define CONV_btu39_calth	253.267208413002d0
#define CONV_btu39_ccatm	10458.1297804096d0
#define CONV_but60_cal	252.074569789675d0
#define CONV_but60_kcal	0.252074569789675d0
#define CONV_but60_ea	2.4191305796664d+20
#define CONV_but60_erg	10546800000d0
#define CONV_but60_ev	6.58279193102801d+21
#define CONV_but60_hz	1.59171141349053d+36
#define CONV_but60_J	1054.68d0
#define CONV_but60_Nm	1054.68d0
#define CONV_but60_megaJ	0.00105468d0
#define CONV_but60_kcalPmol	1.51802751786711d+23
#define CONV_but60_kJPmol	6.351427134756d+23
#define CONV_but60_wn	5.30937777457542d+25
#define CONV_but60_ryd	4.8382611593328d+20
#define CONV_but60_btu	0.999643579249068d0
#define CONV_but60_ft3atm	0.36758593803073d0
#define CONV_but60_ft3lbPin2	5.4020287728d0
#define CONV_but60_ftlbal	25027.943327601d0
#define CONV_but60_ftlb	777.892700894239d0
#define CONV_but60_hphr	0.000392875101461737d0
#define CONV_but60_hphrm	0.000398323828030954d0
#define CONV_but60_kgm	107.547433568358d0
#define CONV_but60_gcm	10754742.9550356d0
#define CONV_but60_kWhr	0.000292966666666667d0
#define CONV_but60_gWhr	2.92966666666667d-10
#define CONV_but60_latm	10.4088823094004d0
#define CONV_but60_lbar	10.5468d0
#define CONV_but60_Whr	0.292966666666667d0
#define CONV_but60_Ws	1054.68d0
#define CONV_but60_dyncm	10546800000d0
#define CONV_but60_chu	0.55535754402726d0
#define CONV_but60_btu39	0.99529098681665d0
#define CONV_but60_btuave	0.998872967316052d0
#define CONV_but60_btuth	1.00031298904538d0
#define CONV_but60_calor	251.905990255087d0
#define CONV_but60_kcalor	0.251905990255087d0
#define CONV_but60_cal15	251.984231274639d0
#define CONV_but60_cal20	252.201152586145d0
#define CONV_but60_calave	251.712402327435d0
#define CONV_but60_calth	252.074569789675d0
#define CONV_but60_ccatm	10408.8823094004d0
#define CONV_btuave_cal	252.358986615679d0
#define CONV_btuave_kcal	0.252358986615679d0
#define CONV_btuave_ea	2.42186009514958d+20
#define CONV_btuave_erg	10558700000d0
#define CONV_btuave_ev	6.59021932360009d+21
#define CONV_btuave_hz	1.59350734835424d+36
#define CONV_btuave_J	1055.87d0
#define CONV_btuave_Nm	1055.87d0
#define CONV_btuave_megaJ	0.00105587d0
#define CONV_btuave_kcalPmol	1.51974031487309d+23
#define CONV_btuave_kJPmol	6.358593477429d+23
#define CONV_btuave_wn	5.31536836845389d+25
#define CONV_btuave_ryd	4.84372019029916d+20
#define CONV_btuave_btu	1.00077148141779d0
#define CONV_btuave_ft3atm	0.368000686832505d0
#define CONV_btuave_ft3lbPin2	5.4081239052d0
#define CONV_btuave_ftlbal	25056.1824641731d0
#define CONV_btuave_ftlb	778.770400588994d0
#define CONV_btuave_hphr	0.000393318384135855d0
#define CONV_btuave_hphrm	0.000398773258526798d0
#define CONV_btuave_kgm	107.668779802236d0
#define CONV_btuave_gcm	10766877.5779701d0
#define CONV_btuave_kWhr	0.000293297222222222d0
#define CONV_btuave_gWhr	2.93297222222222d-10
#define CONV_btuave_latm	10.4206266962744d0
#define CONV_btuave_lbar	10.5587d0
#define CONV_btuave_Whr	0.293297222222222d0
#define CONV_btuave_Ws	1055.87d0
#define CONV_btuave_dyncm	10558700000d0
#define CONV_btuave_chu	0.555984156343216d0
#define CONV_btuave_btu39	0.996413977936527d0
#define CONV_btuave_but60	1.00112830431979d0
#define CONV_btuave_btuth	1.00144164651207d0
#define CONV_btuave_calor	252.190216872074d0
#define CONV_btuave_kcalor	0.252190216872074d0
#define CONV_btuave_cal15	252.268546171306d0
#define CONV_btuave_cal20	252.485712236065d0
#define CONV_btuave_calave	251.996410518327d0
#define CONV_btuave_calth	252.358986615679d0
#define CONV_btuave_ccatm	10420.6266962744d0
#define CONV_btuth_cal	251.995697896749d0
#define CONV_btuth_kcal	0.251995697896749d0
#define CONV_btuth_ea	2.41837365520468d+20
#define CONV_btuth_erg	10543500000d0
#define CONV_btuth_ev	6.58073223392819d+21
#define CONV_btuth_hz	1.59121338113337d+36
#define CONV_btuth_J	1054.35d0
#define CONV_btuth_Nm	1054.35d0
#define CONV_btuth_megaJ	0.00105435d0
#define CONV_btuth_kcalPmol	1.51755254054613d+23
#define CONV_btuth_kJPmol	6.349439829645d+23
#define CONV_btuth_wn	5.30771651744946d+25
#define CONV_btuth_ryd	4.83674731040935d+20
#define CONV_btuth_btu	0.999330799656062d0
#define CONV_btuth_ft3atm	0.367470923657128d0
#define CONV_btuth_ft3lbPin2	5.400338526d0
#define CONV_btuth_ftlbal	25020.1123065348d0
#define CONV_btuth_ftlb	777.649305180567d0
#define CONV_btuth_hphr	0.00039275217433362d0
#define CONV_btuth_hphrm	0.000398199196044712d0
#define CONV_btuth_kgm	107.513782932072d0
#define CONV_btuth_gcm	10751377.8915328d0
#define CONV_btuth_kWhr	0.000292875d0
#define CONV_btuth_gWhr	2.92875d-10
#define CONV_btuth_latm	10.4056254626203d0
#define CONV_btuth_lbar	10.5435d0
#define CONV_btuth_Whr	0.292875d0
#define CONV_btuth_Ws	1054.35d0
#define CONV_btuth_dyncm	10543500000d0
#define CONV_btuth_chu	0.555183777586701d0
#define CONV_btuth_btu39	0.994979569111138d0
#define CONV_btuth_but60	0.999687108886108d0
#define CONV_btuth_btuave	0.998560428840672d0
#define CONV_btuth_calor	251.8271711092d0
#define CONV_btuth_kcalor	0.2518271711092d0
#define CONV_btuth_cal15	251.905387647832d0
#define CONV_btuth_cal20	252.122241086587d0
#define CONV_btuth_calave	251.63364375349d0
#define CONV_btuth_calth	251.995697896749d0
#define CONV_btuth_ccatm	10405.6254626203d0
#define CONV_calor_cal	1.00066921606119d0
#define CONV_calor_kcal	0.00100066921606119d0
#define CONV_calor_ea	9.60330707982258d+17
#define CONV_calor_erg	41868000d0
#define CONV_calor_ev	2.61319388410021d+19
#define CONV_calor_hz	6.3186723423239d+33
#define CONV_calor_J	4.1868d0
#define CONV_calor_Nm	4.1868d0
#define CONV_calor_megaJ	4.1868d-06
#define CONV_calor_kcalPmol	6.02616681060229d+20
#define CONV_calor_kJPmol	2.521348193556d+21
#define CONV_calor_wn	2.10768222272086d+23
#define CONV_calor_ryd	1.92066141596452d+18
#define CONV_calor_btu	0.00396832d0
#define CONV_calor_ft3atm	0.00145921872544d0
#define CONV_calor_ft3lbPin2	0.021444622128d0
#define CONV_calor_ftlbal	99.3543d0
#define CONV_calor_ftlb	3.0880278d0
#define CONV_calor_hphr	1.55961d-06
#define CONV_calor_hphrm	1.58124d-06
#define CONV_calor_kgm	0.4269348d0
#define CONV_calor_gcm	42693.4784049599d0
#define CONV_calor_kWhr	1.163d-06
#define CONV_calor_gWhr	1.163d-12
#define CONV_calor_latm	0.041320503330866d0
#define CONV_calor_lbar	0.041868d0
#define CONV_calor_Whr	0.001163d0
#define CONV_calor_Ws	4.1868d0
#define CONV_calor_dyncm	41868000d0
#define CONV_calor_chu	0.00220462222222222d0
#define CONV_calor_btu39	0.00395104136193343d0
#define CONV_calor_but60	0.00396973489589259d0
#define CONV_calor_btuave	0.00396526087491831d0
#define CONV_calor_btuth	0.00397097737942808d0
#define CONV_calor_kcalor	0.001d0
#define CONV_calor_cal15	1.0003105961056d0
#define CONV_calor_cal20	1.00117171620555d0
#define CONV_calor_calave	0.999231507248175d0
#define CONV_calor_calth	1.00066921606119d0
#define CONV_calor_ccatm	41.320503330866d0
#define CONV_kcalor_cal	1000.66921606119d0
#define CONV_kcalor_kcal	1.00066921606119d0
#define CONV_kcalor_ea	9.60330707982258d+20
#define CONV_kcalor_erg	41868000000d0
#define CONV_kcalor_ev	2.61319388410021d+22
#define CONV_kcalor_hz	6.3186723423239d+36
#define CONV_kcalor_J	4186.8d0
#define CONV_kcalor_Nm	4186.8d0
#define CONV_kcalor_megaJ	0.0041868d0
#define CONV_kcalor_kcalPmol	6.02616681060229d+23
#define CONV_kcalor_kJPmol	2.521348193556d+24
#define CONV_kcalor_wn	2.10768222272086d+26
#define CONV_kcalor_ryd	1.92066141596452d+21
#define CONV_kcalor_btu	3.96832d0
#define CONV_kcalor_ft3atm	1.45921872544d0
#define CONV_kcalor_ft3lbPin2	21.444622128d0
#define CONV_kcalor_ftlbal	99354.3d0
#define CONV_kcalor_ftlb	3088.0278d0
#define CONV_kcalor_hphr	0.00155961d0
#define CONV_kcalor_hphrm	0.00158124d0
#define CONV_kcalor_kgm	426.9348d0
#define CONV_kcalor_gcm	42693478.4049599d0
#define CONV_kcalor_kWhr	0.001163d0
#define CONV_kcalor_gWhr	1.163d-09
#define CONV_kcalor_latm	41.320503330866d0
#define CONV_kcalor_lbar	41.868d0
#define CONV_kcalor_Whr	1.163d0
#define CONV_kcalor_Ws	4186.8d0
#define CONV_kcalor_dyncm	41868000000d0
#define CONV_kcalor_chu	2.20462222222222d0
#define CONV_kcalor_btu39	3.95104136193343d0
#define CONV_kcalor_but60	3.96973489589259d0
#define CONV_kcalor_btuave	3.96526087491831d0
#define CONV_kcalor_btuth	3.97097737942808d0
#define CONV_kcalor_calor	1000d0
#define CONV_kcalor_cal15	1000.3105961056d0
#define CONV_kcalor_cal20	1001.17171620555d0
#define CONV_kcalor_calave	999.231507248175d0
#define CONV_kcalor_calth	1000.66921606119d0
#define CONV_kcalor_ccatm	41320.503330866d0
#define CONV_cal15_cal	1.00035850860421d0
#define CONV_cal15_kcal	0.00100035850860421d0
#define CONV_cal15_ea	9.60032525618549d+17
#define CONV_cal15_erg	41855000d0
#define CONV_cal15_ev	2.61238248827301d+19
#define CONV_cal15_hz	6.31671039667447d+33
#define CONV_cal15_J	4.1855d0
#define CONV_cal15_Nm	4.1855d0
#define CONV_cal15_megaJ	4.1855d-06
#define CONV_cal15_kcalPmol	6.02429568782266d+20
#define CONV_cal15_kJPmol	2.520565315785d+21
#define CONV_cal15_wn	2.10702778809548d+23
#define CONV_cal15_ryd	1.9200650512371d+18
#define CONV_cal15_btu	0.00396708783796694d0
#define CONV_cal15_ft3atm	0.00145876563851369d0
#define CONV_cal15_ft3lbPin2	0.02143796358d0
#define CONV_cal15_ftlbal	99.3234505230725d0
#define CONV_cal15_ftlb	3.08706896840069d0
#define CONV_cal15_hphr	1.55912574161651d-06
#define CONV_cal15_hphrm	1.58074902550874d-06
#define CONV_cal15_kgm	0.42680223688736d0
#define CONV_cal15_gcm	42680.2220941912d0
#define CONV_cal15_kWhr	1.16263888888889d-06
#define CONV_cal15_gWhr	1.16263888888889d-12
#define CONV_cal15_latm	0.0413076733283987d0
#define CONV_cal15_lbar	0.041855d0
#define CONV_cal15_Whr	0.00116263888888889d0
#define CONV_cal15_Ws	4.1855d0
#define CONV_cal15_dyncm	41855000d0
#define CONV_cal15_chu	0.00220393768775941d0
#define CONV_cal15_btu39	0.00394981456491172d0
#define CONV_cal15_but60	0.00396850229453484d0
#define CONV_cal15_btuave	0.00396402966274257d0
#define CONV_cal15_btuth	0.0039697443922796d0
#define CONV_cal15_calor	0.999689500334384d0
#define CONV_cal15_kcalor	0.000999689500334384d0
#define CONV_cal15_cal20	1.00086085272245d0
#define CONV_cal15_calave	0.998921246199302d0
#define CONV_cal15_calth	1.00035850860421d0
#define CONV_cal15_ccatm	41.3076733283987d0
#define CONV_cal20_cal	0.999498087954111d0
#define CONV_cal20_kcal	0.000999498087954111d0
#define CONV_cal20_ea	9.59206789842124d+17
#define CONV_cal20_erg	41819000d0
#define CONV_cal20_ev	2.61013554598229d+19
#define CONV_cal20_hz	6.31127731641452d+33
#define CONV_cal20_J	4.1819d0
#define CONV_cal20_Nm	4.1819d0
#define CONV_cal20_megaJ	4.1819d-06
#define CONV_cal20_kcalPmol	6.01911411704828d+20
#define CONV_cal20_kJPmol	2.518397346573d+21
#define CONV_cal20_wn	2.10521550759443d+23
#define CONV_cal20_ryd	1.91841357968425d+18
#define CONV_cal20_btu	0.00396367569695233d0
#define CONV_cal20_ft3atm	0.00145751093625622d0
#define CONV_cal20_ft3lbPin2	0.021419524524d0
#define CONV_cal20_ftlbal	99.2380212023502d0
#define CONV_cal20_ftlb	3.08441374243336d0
#define CONV_cal20_hphr	1.55778471840069d-06
#define CONV_cal20_hphrm	1.57938940384064d-06
#define CONV_cal20_kgm	0.426435139036973d0
#define CONV_cal20_gcm	42643.512310524d0
#define CONV_cal20_kWhr	1.16163888888889d-06
#define CONV_cal20_gWhr	1.16163888888889d-12
#define CONV_cal20_latm	0.0412721440907969d0
#define CONV_cal20_lbar	0.041819d0
#define CONV_cal20_Whr	0.00116163888888889d0
#define CONV_cal20_Ws	4.1819d0
#define CONV_cal20_dyncm	41819000d0
#define CONV_cal20_chu	0.0022020420538624d0
#define CONV_cal20_btu39	0.00394641728085159d0
#define CONV_cal20_but60	0.00396508893692874d0
#define CONV_cal20_btuave	0.00396062015210206d0
#define CONV_cal20_btuth	0.00396632996632997d0
#define CONV_cal20_calor	0.998829655106525d0
#define CONV_cal20_kcalor	0.000998829655106525d0
#define CONV_cal20_cal15	0.999139887707562d0
#define CONV_cal20_calave	0.998062061756268d0
#define CONV_cal20_calth	0.999498087954111d0
#define CONV_cal20_ccatm	41.2721440907969d0
#define CONV_calave_cal	1.00143881453155d0
#define CONV_calave_kcal	0.00100143881453155d0
#define CONV_calave_ea	9.6106928276006d+17
#define CONV_calave_erg	41900200d0
#define CONV_calave_ev	2.61520364914912d+19
#define CONV_calave_hz	6.32353193077863d+33
#define CONV_calave_J	4.19002d0
#define CONV_calave_Nm	4.19002d0
#define CONV_calave_megaJ	4.19002d-06
#define CONV_calave_kcalPmol	6.03080143779493d+20
#define CONV_calave_kJPmol	2.5232873215734d+21
#define CONV_calave_wn	2.1093032069468d+23
#define CONV_calave_ryd	1.92213856552012d+18
#define CONV_calave_btu	0.00397137197057419d0
#define CONV_calave_ft3atm	0.00146034098690363d0
#define CONV_calave_ft3lbPin2	0.0214611148392d0
#define CONV_calave_ftlbal	99.4307117813127d0
#define CONV_calave_ftlb	3.09040275211522d0
#define CONV_calave_hphr	1.56080947076526d-06
#define CONV_calave_hphrm	1.58245610604758d-06
#define CONV_calave_kgm	0.427263148632846d0
#define CONV_calave_gcm	42726.3132670178d0
#define CONV_calave_kWhr	1.16389444444444d-06
#define CONV_calave_gWhr	1.16389444444444d-12
#define CONV_calave_latm	0.0413522822600543d0
#define CONV_calave_lbar	0.0419002d0
#define CONV_calave_Whr	0.00116389444444444d0
#define CONV_calave_Ws	4.19002d0
#define CONV_calave_dyncm	41900200d0
#define CONV_calave_chu	0.0022063177614301d0
#define CONV_calave_btu39	0.00395408004378722d0
#define CONV_calave_but60	0.00397278795464027d0
#define CONV_calave_btuave	0.003968310492769d0
#define CONV_calave_btuth	0.0039740313937497d0
#define CONV_calave_calor	1.00076908378714d0
#define CONV_calave_kcalor	0.00100076908378714d0
#define CONV_calave_cal15	1.00107991876717d0
#define CONV_calave_cal20	1.00194170114063d0
#define CONV_calave_calth	1.00143881453155d0
#define CONV_calave_ccatm	41.3522822600543d0
#define CONV_calth_cal	1d0
#define CONV_calth_kcal	0.001d0
#define CONV_calth_ea	9.59688469045039d+17
#define CONV_calth_erg	41840000d0
#define CONV_calth_ev	2.61144626231854d+19
#define CONV_calth_hz	6.31444661323283d+33
#define CONV_calth_J	4.184d0
#define CONV_calth_Nm	4.184d0
#define CONV_calth_megaJ	4.184d-06
#define CONV_calth_kcalPmol	6.0221367d+20
#define CONV_calth_kJPmol	2.51966199528d+21
#define CONV_calth_wn	2.10627267122004d+23
#define CONV_calth_ryd	1.91937693809008d+18
#define CONV_calth_btu	0.00396566611254419d0
#define CONV_calth_ft3atm	0.00145824284590641d0
#define CONV_calth_ft3lbPin2	0.02143028064d0
#define CONV_calth_ftlbal	99.2878549727716d0
#define CONV_calth_ftlb	3.08596262424764d0
#define CONV_calth_hphr	1.55856698194325d-06
#define CONV_calth_hphrm	1.58018251648037d-06
#define CONV_calth_kgm	0.426649279449699d0
#define CONV_calth_gcm	42664.9263509965d0
#define CONV_calth_kWhr	1.16222222222222d-06
#define CONV_calth_gWhr	1.16222222222222d-12
#define CONV_calth_latm	0.041292869479398d0
#define CONV_calth_lbar	0.04184d0
#define CONV_calth_Whr	0.00116222222222222d0
#define CONV_calth_Ws	4.184d0
#define CONV_calth_dyncm	41840000d0
#define CONV_calth_chu	0.00220314784030233d0
#define CONV_calth_btu39	0.00394839902988666d0
#define CONV_calth_but60	0.00396708006219896d0
#define CONV_calth_btuave	0.00396260903330903d0
#define CONV_calth_btuth	0.00396832171480059d0
#define CONV_calth_calor	0.999331231489443d0
#define CONV_calth_kcalor	0.000999331231489443d0
#define CONV_calth_cal15	0.999641619878151d0
#define CONV_calth_cal20	1.00050216408809d0
#define CONV_calth_calave	0.998563252681371d0
#define CONV_calth_ccatm	41.292869479398d0
#define CONV_ccatm_cal	0.0242172562141491d0
#define CONV_ccatm_kcal	2.42172562141491d-05
#define CONV_ccatm_ea	2.32410215406282d+16
#define CONV_ccatm_erg	1013250d0
#define CONV_ccatm_ev	6.32420632240502d+17
#define CONV_ccatm_hz	1.52918571483226d+32
#define CONV_ccatm_J	0.101325d0
#define CONV_ccatm_Nm	0.101325d0
#define CONV_ccatm_megaJ	1.01325d-07
#define CONV_ccatm_kcalPmol	1.45839627420531d+19
#define CONV_ccatm_kJPmol	6.101930011275d+19
#define CONV_ccatm_wn	5.10081449357961d+21
#define CONV_ccatm_ryd	4.64820430812565d+16
#define CONV_ccatm_btu	9.60375523072514d-05
#define CONV_ccatm_ft3atm	3.53146406217655d-05
#define CONV_ccatm_ft3lbPin2	0.000518982597d0
#define CONV_ccatm_ftlbal	2.40447942282889d0
#define CONV_ccatm_ftlb	0.074733547538693d0
#define CONV_ccatm_hphr	3.77442159286328d-08
#define CONV_ccatm_hphrm	3.8267684866724d-08
#define CONV_ccatm_kgm	0.0103322749140155d0
#define CONV_ccatm_gcm	1033.22745279989d0
#define CONV_ccatm_kWhr	2.81458333333333d-08
#define CONV_ccatm_gWhr	2.81458333333333d-14
#define CONV_ccatm_latm	0.001d0
#define CONV_ccatm_lbar	0.00101325d0
#define CONV_ccatm_Whr	2.81458333333333d-05
#define CONV_ccatm_Ws	0.101325d0
#define CONV_ccatm_dyncm	1013250d0
#define CONV_ccatm_chu	5.33541957262508d-05
#define CONV_ccatm_btu39	9.56193909424632d-05
#define CONV_ccatm_but60	9.60717942883149d-05
#define CONV_ccatm_btuave	9.59635182361465d-05
#define CONV_ccatm_btuth	9.61018637074975d-05
#define CONV_ccatm_calor	0.024201060475781d0
#define CONV_ccatm_kcalor	2.4201060475781d-05
#define CONV_ccatm_cal15	0.0242085772309163d0
#define CONV_ccatm_cal20	0.0242294172505321d0
#define CONV_ccatm_calave	0.0241824621362189d0
#define CONV_ccatm_calth	0.0242172562141491d0



c POWER, RADIANT FLUX (W)
c ====================
c 
c btuPhr  = btu per hour
c btuPmin = btu per minute
c btuPs   = btu per sec
c calPmin = calorie per minute
c calPs   = calorie per second
c ergPs   = erg per second
c ftlbPhr = foot-pound-force per hour
c ftlbPmin= foot-pound-force per minute
c ftlbPs  = foot-pound-force per second
c hp      = horsepower
c hpb     = horsepower (boiler)
c hpe     = horsepower (electric)
c hpm     = horsepower (metric)
c hpw     = horsepower (water)
c JPhr    = joule per hour
c JPmin   = joule per minute
c JPs     = joule per second
c kcalPhr = kilocalories per hour
c kcalPmin= kilocalories per minute
c kcalPs  = kilocalories per second
c kgmPhr  = kilogram-force-meter per hr
c kgmPmin = kilogram-force-meter per minute
c kgmPs   = kilogram-force-meter per second
c W       = watt
c kW      = kilowatt
c Wave    = watt (int. mean)
c Wu      = watt (int. US)



#define CONV_btuPhr_btuPmin	0.0166666666666667d0
#define CONV_btuPhr_btuPs	0.000277777777777778d0
#define CONV_btuPhr_calPmin	4.19993136203373d0
#define CONV_btuPhr_calPs	0.0699988560338954d0
#define CONV_btuPhr_ergPs	2930712.10442713d0
#define CONV_btuPhr_ftlbPhr	778.168422163217d0
#define CONV_btuPhr_ftlbPmin	12.9694737027203d0
#define CONV_btuPhr_ftlbPs	0.216157895045338d0
#define CONV_btuPhr_hp	0.000393014354627888d0
#define CONV_btuPhr_hpb	2.98762638710142d-05
#define CONV_btuPhr_hpe	0.000392856850459401d0
#define CONV_btuPhr_hpm	0.000398467432950192d0
#define CONV_btuPhr_hpw	0.000392834207200809d0
#define CONV_btuPhr_JPhr	1055.05635759377d0
#define CONV_btuPhr_JPmin	17.5842726265628d0
#define CONV_btuPhr_JPs	0.293071210442713d0
#define CONV_btuPhr_kcalPhr	0.251995881722024d0
#define CONV_btuPhr_kcalPmin	0.00419993136203373d0
#define CONV_btuPhr_kcalPs	6.99988560338954d-05
#define CONV_btuPhr_kgmPhr	107.586206896552d0
#define CONV_btuPhr_kgmPmin	1.79310344827586d0
#define CONV_btuPhr_kgmPs	0.0298850574712644d0
#define CONV_btuPhr_W	0.293071210442713d0
#define CONV_btuPhr_kW	0.000293071210442713d0
#define CONV_btuPhr_Wave	0.29301553749059d0
#define CONV_btuPhr_Wu	0.293022861670538d0
#define CONV_btuPmin_btuPhr	60d0
#define CONV_btuPmin_btuPs	0.0166666666666667d0
#define CONV_btuPmin_calPmin	251.995881722024d0
#define CONV_btuPmin_calPs	4.19993136203373d0
#define CONV_btuPmin_ergPs	175842726.265628d0
#define CONV_btuPmin_ftlbPhr	46690.105329793d0
#define CONV_btuPmin_ftlbPmin	778.168422163217d0
#define CONV_btuPmin_ftlbPs	12.9694737027203d0
#define CONV_btuPmin_hp	0.0235808612776733d0
#define CONV_btuPmin_hpb	0.00179257583226085d0
#define CONV_btuPmin_hpe	0.0235714110275641d0
#define CONV_btuPmin_hpm	0.0239080459770115d0
#define CONV_btuPmin_hpw	0.0235700524320486d0
#define CONV_btuPmin_JPhr	63303.3814556261d0
#define CONV_btuPmin_JPmin	1055.05635759377d0
#define CONV_btuPmin_JPs	17.5842726265628d0
#define CONV_btuPmin_kcalPhr	15.1197529033214d0
#define CONV_btuPmin_kcalPmin	0.251995881722024d0
#define CONV_btuPmin_kcalPs	0.00419993136203373d0
#define CONV_btuPmin_kgmPhr	6455.1724137931d0
#define CONV_btuPmin_kgmPmin	107.586206896552d0
#define CONV_btuPmin_kgmPs	1.79310344827586d0
#define CONV_btuPmin_W	17.5842726265628d0
#define CONV_btuPmin_kW	0.0175842726265628d0
#define CONV_btuPmin_Wave	17.5809322494354d0
#define CONV_btuPmin_Wu	17.5813717002323d0
#define CONV_btuPs_btuPhr	3600d0
#define CONV_btuPs_btuPmin	60d0
#define CONV_btuPs_calPmin	15119.7529033214d0
#define CONV_btuPs_calPs	251.995881722024d0
#define CONV_btuPs_ergPs	10550563575.9377d0
#define CONV_btuPs_ftlbPhr	2801406.31978758d0
#define CONV_btuPs_ftlbPmin	46690.105329793d0
#define CONV_btuPs_ftlbPs	778.168422163217d0
#define CONV_btuPs_hp	1.4148516766604d0
#define CONV_btuPs_hpb	0.107554549935651d0
#define CONV_btuPs_hpe	1.41428466165384d0
#define CONV_btuPs_hpm	1.43448275862069d0
#define CONV_btuPs_hpw	1.41420314592291d0
#define CONV_btuPs_JPhr	3798202.88733757d0
#define CONV_btuPs_JPmin	63303.3814556261d0
#define CONV_btuPs_JPs	1055.05635759377d0
#define CONV_btuPs_kcalPhr	907.185174199285d0
#define CONV_btuPs_kcalPmin	15.1197529033214d0
#define CONV_btuPs_kcalPs	0.251995881722024d0
#define CONV_btuPs_kgmPhr	387310.344827586d0
#define CONV_btuPs_kgmPmin	6455.1724137931d0
#define CONV_btuPs_kgmPs	107.586206896552d0
#define CONV_btuPs_W	1055.05635759377d0
#define CONV_btuPs_kW	1.05505635759377d0
#define CONV_btuPs_Wave	1054.85593496612d0
#define CONV_btuPs_Wu	1054.88230201394d0
#define CONV_calPmin_btuPhr	0.2380991292d0
#define CONV_calPmin_btuPmin	0.00396831882d0
#define CONV_calPmin_btuPs	6.6138647d-05
#define CONV_calPmin_calPs	0.0166666666666667d0
#define CONV_calPmin_ergPs	697800d0
#define CONV_calPmin_ftlbPhr	185.281223688d0
#define CONV_calPmin_ftlbPmin	3.0880203948d0
#define CONV_calPmin_ftlbPs	0.05146700658d0
#define CONV_calPmin_hp	9.35763756d-05
#define CONV_calPmin_hpb	7.11351241143789d-06
#define CONV_calPmin_hpe	9.35388739946381d-05
#define CONV_calPmin_hpm	9.48747488d-05
#define CONV_calPmin_hpw	9.35334826544851d-05
#define CONV_calPmin_JPhr	251.208d0
#define CONV_calPmin_JPmin	4.1868d0
#define CONV_calPmin_JPs	0.06978d0
#define CONV_calPmin_kcalPhr	0.06d0
#define CONV_calPmin_kcalPmin	0.001d0
#define CONV_calPmin_kcalPs	1.66666666666667d-05
#define CONV_calPmin_kgmPhr	25.616182176d0
#define CONV_calPmin_kgmPmin	0.4269363696d0
#define CONV_calPmin_kgmPs	0.00711560616d0
#define CONV_calPmin_W	0.06978d0
#define CONV_calPmin_kW	6.978d-05
#define CONV_calPmin_Wave	0.0697667443185795d0
#define CONV_calPmin_Wu	0.0697684881994471d0
#define CONV_calPs_btuPhr	14.285947752d0
#define CONV_calPs_btuPmin	0.2380991292d0
#define CONV_calPs_btuPs	0.00396831882d0
#define CONV_calPs_calPmin	60d0
#define CONV_calPs_ergPs	41868000d0
#define CONV_calPs_ftlbPhr	11116.87342128d0
#define CONV_calPs_ftlbPmin	185.281223688d0
#define CONV_calPs_ftlbPs	3.0880203948d0
#define CONV_calPs_hp	0.005614582536d0
#define CONV_calPs_hpb	0.000426810744686274d0
#define CONV_calPs_hpe	0.00561233243967828d0
#define CONV_calPs_hpm	0.005692484928d0
#define CONV_calPs_hpw	0.0056120089592691d0
#define CONV_calPs_JPhr	15072.48d0
#define CONV_calPs_JPmin	251.208d0
#define CONV_calPs_JPs	4.1868d0
#define CONV_calPs_kcalPhr	3.6d0
#define CONV_calPs_kcalPmin	0.06d0
#define CONV_calPs_kcalPs	0.001d0
#define CONV_calPs_kgmPhr	1536.97093056d0
#define CONV_calPs_kgmPmin	25.616182176d0
#define CONV_calPs_kgmPs	0.4269363696d0
#define CONV_calPs_W	4.1868d0
#define CONV_calPs_kW	0.0041868d0
#define CONV_calPs_Wave	4.18600465911477d0
#define CONV_calPs_Wu	4.18610929196683d0
#define CONV_ergPs_btuPhr	3.41214d-07
#define CONV_ergPs_btuPmin	5.6869d-09
#define CONV_ergPs_btuPs	9.47816666666667d-11
#define CONV_ergPs_calPmin	1.43307537976498d-06
#define CONV_ergPs_calPs	2.38845896627496d-08
#define CONV_ergPs_ftlbPhr	0.00026552196d0
#define CONV_ergPs_ftlbPmin	4.425366d-06
#define CONV_ergPs_ftlbPs	7.37561d-08
#define CONV_ergPs_hp	1.34102d-10
#define CONV_ergPs_hpb	1.01941995004842d-11
#define CONV_ergPs_hpe	1.34048257372654d-10
#define CONV_ergPs_hpm	1.35962666666667d-10
#define CONV_ergPs_hpw	1.34040531175817d-10
#define CONV_ergPs_JPhr	0.00036d0
#define CONV_ergPs_JPmin	6d-06
#define CONV_ergPs_JPs	1d-07
#define CONV_ergPs_kcalPhr	8.59845227858985d-08
#define CONV_ergPs_kcalPmin	1.43307537976498d-09
#define CONV_ergPs_kcalPs	2.38845896627496d-11
#define CONV_ergPs_kgmPhr	3.670992d-05
#define CONV_ergPs_kgmPmin	6.11832d-07
#define CONV_ergPs_kgmPs	1.01972d-08
#define CONV_ergPs_W	1d-07
#define CONV_ergPs_kW	1d-10
#define CONV_ergPs_Wave	9.99810036093142d-08
#define CONV_ergPs_Wu	9.99835027220509d-08
#define CONV_ftlbPhr_btuPhr	0.0012850688508024d0
#define CONV_ftlbPhr_btuPmin	2.14178141800399d-05
#define CONV_ftlbPhr_btuPs	3.56963569667332d-07
#define CONV_ftlbPhr_calPmin	0.00539720096885763d0
#define CONV_ftlbPhr_calPs	8.99533494809604d-05
#define CONV_ftlbPhr_ergPs	3766.16683606885d0
#define CONV_ftlbPhr_ftlbPmin	0.0166666666666667d0
#define CONV_ftlbPhr_ftlbPs	0.000277777777777778d0
#define CONV_ftlbPhr_hp	5.05050505050505d-07
#define CONV_ftlbPhr_hpb	3.83930560789933d-08
#define CONV_ftlbPhr_hpe	5.04848101349712d-07
#define CONV_ftlbPhr_hpm	5.12058086143484d-07
#define CONV_ftlbPhr_hpw	5.04819003203415d-07
#define CONV_ftlbPhr_JPhr	1.35582006098479d0
#define CONV_ftlbPhr_JPmin	0.0225970010164131d0
#define CONV_ftlbPhr_JPs	0.000376616683606885d0
#define CONV_ftlbPhr_kcalPhr	0.000323832058131457d0
#define CONV_ftlbPhr_kcalPmin	5.39720096885762d-06
#define CONV_ftlbPhr_kcalPs	8.99533494809604d-08
#define CONV_ftlbPhr_kgmPhr	0.138255683258741d0
#define CONV_ftlbPhr_kgmPmin	0.00230426138764568d0
#define CONV_ftlbPhr_kgmPs	3.84043564607613d-05
#define CONV_ftlbPhr_W	0.000376616683606885d0
#define CONV_ftlbPhr_kW	3.76616683606885d-07
#define CONV_ftlbPhr_Wave	0.000376545140030279d0
#define CONV_ftlbPhr_Wu	0.000376554552105788d0
#define CONV_ftlbPmin_btuPhr	0.0771041310481438d0
#define CONV_ftlbPmin_btuPmin	0.0012850688508024d0
#define CONV_ftlbPmin_btuPs	2.14178141800399d-05
#define CONV_ftlbPmin_calPmin	0.323832058131458d0
#define CONV_ftlbPmin_calPs	0.00539720096885762d0
#define CONV_ftlbPmin_ergPs	225970.010164131d0
#define CONV_ftlbPmin_ftlbPhr	60d0
#define CONV_ftlbPmin_ftlbPs	0.0166666666666667d0
#define CONV_ftlbPmin_hp	3.03030303030303d-05
#define CONV_ftlbPmin_hpb	2.3035833647396d-06
#define CONV_ftlbPmin_hpe	3.02908860809827d-05
#define CONV_ftlbPmin_hpm	3.0723485168609d-05
#define CONV_ftlbPmin_hpw	3.02891401922049d-05
#define CONV_ftlbPmin_JPhr	81.3492036590872d0
#define CONV_ftlbPmin_JPmin	1.35582006098479d0
#define CONV_ftlbPmin_JPs	0.0225970010164131d0
#define CONV_ftlbPmin_kcalPhr	0.0194299234878874d0
#define CONV_ftlbPmin_kcalPmin	0.000323832058131457d0
#define CONV_ftlbPmin_kcalPs	5.39720096885762d-06
#define CONV_ftlbPmin_kgmPhr	8.29534099552444d0
#define CONV_ftlbPmin_kgmPmin	0.138255683258741d0
#define CONV_ftlbPmin_kgmPs	0.00230426138764568d0
#define CONV_ftlbPmin_W	0.0225970010164131d0
#define CONV_ftlbPmin_kW	2.25970010164131d-05
#define CONV_ftlbPmin_Wave	0.0225927084018168d0
#define CONV_ftlbPmin_Wu	0.0225932731263473d0
#define CONV_ftlbPs_btuPhr	4.62624786288863d0
#define CONV_ftlbPs_btuPmin	0.0771041310481438d0
#define CONV_ftlbPs_btuPs	0.0012850688508024d0
#define CONV_ftlbPs_calPmin	19.4299234878875d0
#define CONV_ftlbPs_calPs	0.323832058131458d0
#define CONV_ftlbPs_ergPs	13558200.6098479d0
#define CONV_ftlbPs_ftlbPhr	3600d0
#define CONV_ftlbPs_ftlbPmin	60d0
#define CONV_ftlbPs_hp	0.00181818181818182d0
#define CONV_ftlbPs_hpb	0.000138215001884376d0
#define CONV_ftlbPs_hpe	0.00181745316485896d0
#define CONV_ftlbPs_hpm	0.00184340911011654d0
#define CONV_ftlbPs_hpw	0.00181734841153229d0
#define CONV_ftlbPs_JPhr	4880.95221954523d0
#define CONV_ftlbPs_JPmin	81.3492036590872d0
#define CONV_ftlbPs_JPs	1.35582006098479d0
#define CONV_ftlbPs_kcalPhr	1.16579540927325d0
#define CONV_ftlbPs_kcalPmin	0.0194299234878874d0
#define CONV_ftlbPs_kcalPs	0.000323832058131457d0
#define CONV_ftlbPs_kgmPhr	497.720459731466d0
#define CONV_ftlbPs_kgmPmin	8.29534099552444d0
#define CONV_ftlbPs_kgmPs	0.138255683258741d0
#define CONV_ftlbPs_W	1.35582006098479d0
#define CONV_ftlbPs_kW	0.00135582006098479d0
#define CONV_ftlbPs_Wave	1.35556250410901d0
#define CONV_ftlbPs_Wu	1.35559638758084d0
#define CONV_hp_btuPhr	2544.43632458875d0
#define CONV_hp_btuPmin	42.4072720764791d0
#define CONV_hp_btuPs	0.706787867941318d0
#define CONV_hp_calPmin	10686.4579183381d0
#define CONV_hp_calPs	178.107631972302d0
#define CONV_hp_ergPs	7457010335.41632d0
#define CONV_hp_ftlbPhr	1980000d0
#define CONV_hp_ftlbPmin	33000d0
#define CONV_hp_ftlbPs	550d0
#define CONV_hp_hpb	0.0760182510364068d0
#define CONV_hp_hpe	0.99959924067243d0
#define CONV_hp_hpm	1.0138750105641d0
#define CONV_hp_hpw	0.999541626342761d0
#define CONV_hp_JPhr	2684523.72074988d0
#define CONV_hp_JPmin	44742.0620124979d0
#define CONV_hp_JPs	745.701033541632d0
#define CONV_hp_kcalPhr	641.187475100286d0
#define CONV_hp_kcalPmin	10.6864579183381d0
#define CONV_hp_kcalPs	0.178107631972302d0
#define CONV_hp_kgmPhr	273746.252852306d0
#define CONV_hp_kgmPmin	4562.43754753844d0
#define CONV_hp_kgmPs	76.0406257923073d0
#define CONV_hp_W	745.701033541632d0
#define CONV_hp_kW	0.745701033541633d0
#define CONV_hp_Wave	745.559377259953d0
#define CONV_hp_Wu	745.578013169459d0
#define CONV_hpb_btuPhr	33471.38733d0
#define CONV_hpb_btuPmin	557.8564555d0
#define CONV_hpb_btuPs	9.29760759166667d0
#define CONV_hpb_calPmin	140577.529378045d0
#define CONV_hpb_calPs	2342.95882296742d0
#define CONV_hpb_ergPs	98095000000d0
#define CONV_hpb_ftlbPhr	26046376.6662d0
#define CONV_hpb_ftlbPmin	434106.27777d0
#define CONV_hpb_ftlbPs	7235.1046295d0
#define CONV_hpb_hp	13.15473569d0
#define CONV_hpb_hpe	13.1494638069705d0
#define CONV_hpb_hpm	13.3372577866667d0
#define CONV_hpb_hpw	13.1487059056918d0
#define CONV_hpb_JPhr	35314200d0
#define CONV_hpb_JPmin	588570d0
#define CONV_hpb_JPs	9809.5d0
#define CONV_hpb_kcalPhr	8434.65176268272d0
#define CONV_hpb_kcalPmin	140.577529378045d0
#define CONV_hpb_kcalPs	2.34295882296742d0
#define CONV_hpb_kgmPhr	3601059.6024d0
#define CONV_hpb_kgmPmin	60017.66004d0
#define CONV_hpb_kgmPs	1000.294334d0
#define CONV_hpb_W	9809.5d0
#define CONV_hpb_kW	9.8095d0
#define CONV_hpb_Wave	9807.63654905568d0
#define CONV_hpb_Wu	9807.88169951958d0
#define CONV_hpe_btuPhr	2545.45644d0
#define CONV_hpe_btuPmin	42.424274d0
#define CONV_hpe_btuPs	0.707071233333333d0
#define CONV_hpe_calPmin	10690.7423330467d0
#define CONV_hpe_calPs	178.179038884112d0
#define CONV_hpe_ergPs	7460000000d0
#define CONV_hpe_ftlbPhr	1980793.8216d0
#define CONV_hpe_ftlbPmin	33013.23036d0
#define CONV_hpe_ftlbPs	550.220506d0
#define CONV_hpe_hp	1.00040092d0
#define CONV_hpe_hpb	0.0760487282736123d0
#define CONV_hpe_hpm	1.01428149333333d0
#define CONV_hpe_hpw	0.999942362571594d0
#define CONV_hpe_JPhr	2685600d0
#define CONV_hpe_JPmin	44760d0
#define CONV_hpe_JPs	746d0
#define CONV_hpe_kcalPhr	641.444539982803d0
#define CONV_hpe_kcalPmin	10.6907423330467d0
#define CONV_hpe_kcalPs	0.178179038884112d0
#define CONV_hpe_kgmPhr	273856.0032d0
#define CONV_hpe_kgmPmin	4564.26672d0
#define CONV_hpe_kgmPs	76.071112d0
#define CONV_hpe_W	746d0
#define CONV_hpe_kW	0.746d0
#define CONV_hpe_Wave	745.858286925484d0
#define CONV_hpe_Wu	745.8769303065d0
#define CONV_hpm_btuPhr	2509.61538461538d0
#define CONV_hpm_btuPmin	41.8269230769231d0
#define CONV_hpm_btuPs	0.697115384615384d0
#define CONV_hpm_calPmin	10540.2123604885d0
#define CONV_hpm_calPs	175.670206008141d0
#define CONV_hpm_ergPs	7354960185.14886d0
#define CONV_hpm_ftlbPhr	1952903.44408269d0
#define CONV_hpm_ftlbPmin	32548.3907347115d0
#define CONV_hpm_ftlbPs	542.473178911858d0
#define CONV_hpm_hp	0.986314870748833d0
#define CONV_hpm_hpb	0.0749779314455259d0
#define CONV_hpm_hpe	0.985919595864459d0
#define CONV_hpm_hpw	0.985862769994339d0
#define CONV_hpm_JPhr	2647785.66665359d0
#define CONV_hpm_JPmin	44129.7611108932d0
#define CONV_hpm_JPs	735.496018514886d0
#define CONV_hpm_kcalPhr	632.412741629309d0
#define CONV_hpm_kcalPmin	10.5402123604885d0
#define CONV_hpm_kcalPs	0.175670206008141d0
#define CONV_hpm_kgmPhr	270000d0
#define CONV_hpm_kgmPmin	4500d0
#define CONV_hpm_kgmPs	75d0
#define CONV_hpm_W	735.496018514886d0
#define CONV_hpm_kW	0.735496018514887d0
#define CONV_hpm_Wave	735.356300817731d0
#define CONV_hpm_Wu	735.374681692407d0
#define CONV_hpw_btuPhr	2545.60316202d0
#define CONV_hpw_btuPmin	42.426719367d0
#define CONV_hpw_btuPs	0.70711198945d0
#define CONV_hpw_calPmin	10691.35855546d0
#define CONV_hpw_calPs	178.189309257667d0
#define CONV_hpw_ergPs	7460430000d0
#define CONV_hpw_ftlbPhr	1980907.9960428d0
#define CONV_hpw_ftlbPmin	33015.13326738d0
#define CONV_hpw_ftlbPs	550.252221123d0
#define CONV_hpw_hp	1.00045858386d0
#define CONV_hpw_hpb	0.0760531117793975d0
#define CONV_hpw_hpe	1.00005764075067d0
#define CONV_hpw_hpm	1.01433995728d0
#define CONV_hpw_JPhr	2685754.8d0
#define CONV_hpw_JPmin	44762.58d0
#define CONV_hpw_JPs	746.043d0
#define CONV_hpw_kcalPhr	641.481513327601d0
#define CONV_hpw_kcalPmin	10.69135855546d0
#define CONV_hpw_kcalPs	0.178189309257667d0
#define CONV_hpw_kgmPhr	273871.7884656d0
#define CONV_hpw_kgmPmin	4564.52980776d0
#define CONV_hpw_kgmPs	76.075496796d0
#define CONV_hpw_W	746.043d0
#define CONV_hpw_kW	0.746043d0
#define CONV_hpw_Wave	745.901278757036d0
#define CONV_hpw_Wu	745.91992321267d0
#define CONV_JPhr_btuPhr	0.000947816666666667d0
#define CONV_JPhr_btuPmin	1.57969444444444d-05
#define CONV_JPhr_btuPs	2.63282407407407d-07
#define CONV_JPhr_calPmin	0.0039807649437916d0
#define CONV_JPhr_calPs	6.63460823965266d-05
#define CONV_JPhr_ergPs	2777.77777777778d0
#define CONV_JPhr_ftlbPhr	0.737561d0
#define CONV_JPhr_ftlbPmin	0.0122926833333333d0
#define CONV_JPhr_ftlbPs	0.000204878055555556d0
#define CONV_JPhr_hp	3.72505555555556d-07
#define CONV_JPhr_hpb	2.83172208346784d-08
#define CONV_JPhr_hpe	3.72356270479595d-07
#define CONV_JPhr_hpm	3.77674074074074d-07
#define CONV_JPhr_hpw	3.72334808821714d-07
#define CONV_JPhr_JPmin	0.0166666666666667d0
#define CONV_JPhr_JPs	0.000277777777777778d0
#define CONV_JPhr_kcalPhr	0.000238845896627496d0
#define CONV_JPhr_kcalPmin	3.9807649437916d-06
#define CONV_JPhr_kcalPs	6.63460823965266d-08
#define CONV_JPhr_kgmPhr	0.101972d0
#define CONV_JPhr_kgmPmin	0.00169953333333333d0
#define CONV_JPhr_kgmPs	2.83255555555556d-05
#define CONV_JPhr_W	0.000277777777777778d0
#define CONV_JPhr_kW	2.77777777777778d-07
#define CONV_JPhr_Wave	0.000277725010025873d0
#define CONV_JPhr_Wu	0.000277731952005697d0
#define CONV_JPmin_btuPhr	0.056869d0
#define CONV_JPmin_btuPmin	0.000947816666666667d0
#define CONV_JPmin_btuPs	1.57969444444444d-05
#define CONV_JPmin_calPmin	0.238845896627496d0
#define CONV_JPmin_calPs	0.0039807649437916d0
#define CONV_JPmin_ergPs	166666.666666667d0
#define CONV_JPmin_ftlbPhr	44.25366d0
#define CONV_JPmin_ftlbPmin	0.737561d0
#define CONV_JPmin_ftlbPs	0.0122926833333333d0
#define CONV_JPmin_hp	2.23503333333333d-05
#define CONV_JPmin_hpb	1.6990332500807d-06
#define CONV_JPmin_hpe	2.23413762287757d-05
#define CONV_JPmin_hpm	2.26604444444444d-05
#define CONV_JPmin_hpw	2.23400885293028d-05
#define CONV_JPmin_JPhr	60d0
#define CONV_JPmin_JPs	0.0166666666666667d0
#define CONV_JPmin_kcalPhr	0.0143307537976498d0
#define CONV_JPmin_kcalPmin	0.000238845896627496d0
#define CONV_JPmin_kcalPs	3.9807649437916d-06
#define CONV_JPmin_kgmPhr	6.11832d0
#define CONV_JPmin_kgmPmin	0.101972d0
#define CONV_JPmin_kgmPs	0.00169953333333333d0
#define CONV_JPmin_W	0.0166666666666667d0
#define CONV_JPmin_kW	1.66666666666667d-05
#define CONV_JPmin_Wave	0.0166635006015524d0
#define CONV_JPmin_Wu	0.0166639171203418d0
#define CONV_JPs_btuPhr	3.41214d0
#define CONV_JPs_btuPmin	0.056869d0
#define CONV_JPs_btuPs	0.000947816666666667d0
#define CONV_JPs_calPmin	14.3307537976498d0
#define CONV_JPs_calPs	0.238845896627496d0
#define CONV_JPs_ergPs	10000000d0
#define CONV_JPs_ftlbPhr	2655.2196d0
#define CONV_JPs_ftlbPmin	44.25366d0
#define CONV_JPs_ftlbPs	0.737561d0
#define CONV_JPs_hp	0.00134102d0
#define CONV_JPs_hpb	0.000101941995004842d0
#define CONV_JPs_hpe	0.00134048257372654d0
#define CONV_JPs_hpm	0.00135962666666667d0
#define CONV_JPs_hpw	0.00134040531175817d0
#define CONV_JPs_JPhr	3600d0
#define CONV_JPs_JPmin	60d0
#define CONV_JPs_kcalPhr	0.859845227858985d0
#define CONV_JPs_kcalPmin	0.0143307537976498d0
#define CONV_JPs_kcalPs	0.000238845896627496d0
#define CONV_JPs_kgmPhr	367.0992d0
#define CONV_JPs_kgmPmin	6.11832d0
#define CONV_JPs_kgmPs	0.101972d0
#define CONV_JPs_W	1d0
#define CONV_JPs_kW	0.001d0
#define CONV_JPs_Wave	0.999810036093142d0
#define CONV_JPs_Wu	0.999835027220509d0
#define CONV_kcalPhr_btuPhr	3.96831882d0
#define CONV_kcalPhr_btuPmin	0.066138647d0
#define CONV_kcalPhr_btuPs	0.00110231078333333d0
#define CONV_kcalPhr_calPmin	16.6666666666667d0
#define CONV_kcalPhr_calPs	0.277777777777778d0
#define CONV_kcalPhr_ergPs	11630000d0
#define CONV_kcalPhr_ftlbPhr	3088.0203948d0
#define CONV_kcalPhr_ftlbPmin	51.46700658d0
#define CONV_kcalPhr_ftlbPs	0.857783443d0
#define CONV_kcalPhr_hp	0.00155960626d0
#define CONV_kcalPhr_hpb	0.000118558540190632d0
#define CONV_kcalPhr_hpe	0.00155898123324397d0
#define CONV_kcalPhr_hpm	0.00158124581333333d0
#define CONV_kcalPhr_hpw	0.00155889137757475d0
#define CONV_kcalPhr_JPhr	4186.8d0
#define CONV_kcalPhr_JPmin	69.78d0
#define CONV_kcalPhr_JPs	1.163d0
#define CONV_kcalPhr_kcalPmin	0.0166666666666667d0
#define CONV_kcalPhr_kcalPs	0.000277777777777778d0
#define CONV_kcalPhr_kgmPhr	426.9363696d0
#define CONV_kcalPhr_kgmPmin	7.11560616d0
#define CONV_kcalPhr_kgmPs	0.118593436d0
#define CONV_kcalPhr_W	1.163d0
#define CONV_kcalPhr_kW	0.001163d0
#define CONV_kcalPhr_Wave	1.16277907197632d0
#define CONV_kcalPhr_Wu	1.16280813665745d0
#define CONV_kcalPmin_btuPhr	238.0991292d0
#define CONV_kcalPmin_btuPmin	3.96831882d0
#define CONV_kcalPmin_btuPs	0.066138647d0
#define CONV_kcalPmin_calPmin	1000d0
#define CONV_kcalPmin_calPs	16.6666666666667d0
#define CONV_kcalPmin_ergPs	697800000d0
#define CONV_kcalPmin_ftlbPhr	185281.223688d0
#define CONV_kcalPmin_ftlbPmin	3088.0203948d0
#define CONV_kcalPmin_ftlbPs	51.46700658d0
#define CONV_kcalPmin_hp	0.0935763756d0
#define CONV_kcalPmin_hpb	0.00711351241143789d0
#define CONV_kcalPmin_hpe	0.0935388739946381d0
#define CONV_kcalPmin_hpm	0.0948747488d0
#define CONV_kcalPmin_hpw	0.0935334826544851d0
#define CONV_kcalPmin_JPhr	251208d0
#define CONV_kcalPmin_JPmin	4186.8d0
#define CONV_kcalPmin_JPs	69.78d0
#define CONV_kcalPmin_kcalPhr	60d0
#define CONV_kcalPmin_kcalPs	0.0166666666666667d0
#define CONV_kcalPmin_kgmPhr	25616.182176d0
#define CONV_kcalPmin_kgmPmin	426.9363696d0
#define CONV_kcalPmin_kgmPs	7.11560616d0
#define CONV_kcalPmin_W	69.78d0
#define CONV_kcalPmin_kW	0.06978d0
#define CONV_kcalPmin_Wave	69.7667443185795d0
#define CONV_kcalPmin_Wu	69.7684881994471d0
#define CONV_kcalPs_btuPhr	14285.947752d0
#define CONV_kcalPs_btuPmin	238.0991292d0
#define CONV_kcalPs_btuPs	3.96831882d0
#define CONV_kcalPs_calPmin	60000d0
#define CONV_kcalPs_calPs	1000d0
#define CONV_kcalPs_ergPs	41868000000d0
#define CONV_kcalPs_ftlbPhr	11116873.42128d0
#define CONV_kcalPs_ftlbPmin	185281.223688d0
#define CONV_kcalPs_ftlbPs	3088.0203948d0
#define CONV_kcalPs_hp	5.614582536d0
#define CONV_kcalPs_hpb	0.426810744686273d0
#define CONV_kcalPs_hpe	5.61233243967828d0
#define CONV_kcalPs_hpm	5.692484928d0
#define CONV_kcalPs_hpw	5.6120089592691d0
#define CONV_kcalPs_JPhr	15072480d0
#define CONV_kcalPs_JPmin	251208d0
#define CONV_kcalPs_JPs	4186.8d0
#define CONV_kcalPs_kcalPhr	3600d0
#define CONV_kcalPs_kcalPmin	60d0
#define CONV_kcalPs_kgmPhr	1536970.93056d0
#define CONV_kcalPs_kgmPmin	25616.182176d0
#define CONV_kcalPs_kgmPs	426.9363696d0
#define CONV_kcalPs_W	4186.8d0
#define CONV_kcalPs_kW	4.1868d0
#define CONV_kcalPs_Wave	4186.00465911477d0
#define CONV_kcalPs_Wu	4186.10929196683d0
#define CONV_kgmPhr_btuPhr	0.00929487179487179d0
#define CONV_kgmPhr_btuPmin	0.00015491452991453d0
#define CONV_kgmPhr_btuPs	2.58190883190883d-06
#define CONV_kgmPhr_calPmin	0.0390378235573648d0
#define CONV_kgmPhr_calPs	0.000650630392622746d0
#define CONV_kgmPhr_ergPs	27240.5932783291d0
#define CONV_kgmPhr_ftlbPhr	7.23297571882478d0
#define CONV_kgmPhr_ftlbPmin	0.120549595313746d0
#define CONV_kgmPhr_ftlbPs	0.00200915992189577d0
#define CONV_kgmPhr_hp	3.65301803981049d-06
#define CONV_kgmPhr_hpb	2.77696042390837d-07
#define CONV_kgmPhr_hpe	3.65155405875726d-06
#define CONV_kgmPhr_hpm	3.7037037037037d-06
#define CONV_kgmPhr_hpw	3.65134359257163d-06
#define CONV_kgmPhr_JPhr	9.80661358019849d0
#define CONV_kgmPhr_JPmin	0.163443559669975d0
#define CONV_kgmPhr_JPs	0.00272405932783291d0
#define CONV_kgmPhr_kcalPhr	0.00234226941344189d0
#define CONV_kgmPhr_kcalPmin	3.90378235573648d-05
#define CONV_kgmPhr_kcalPs	6.50630392622746d-07
#define CONV_kgmPhr_kgmPmin	0.0166666666666667d0
#define CONV_kgmPhr_kgmPs	0.000277777777777778d0
#define CONV_kgmPhr_W	0.00272405932783291d0
#define CONV_kgmPhr_kW	2.72405932783291d-06
#define CONV_kgmPhr_Wave	0.00272354185488049d0
#define CONV_kgmPhr_Wu	0.0027236099321941d0
#define CONV_kgmPmin_btuPhr	0.557692307692308d0
#define CONV_kgmPmin_btuPmin	0.00929487179487179d0
#define CONV_kgmPmin_btuPs	0.00015491452991453d0
#define CONV_kgmPmin_calPmin	2.34226941344189d0
#define CONV_kgmPmin_calPs	0.0390378235573648d0
#define CONV_kgmPmin_ergPs	1634435.59669975d0
#define CONV_kgmPmin_ftlbPhr	433.978543129487d0
#define CONV_kgmPmin_ftlbPmin	7.23297571882478d0
#define CONV_kgmPmin_ftlbPs	0.120549595313746d0
#define CONV_kgmPmin_hp	0.00021918108238863d0
#define CONV_kgmPmin_hpb	1.66617625434502d-05
#define CONV_kgmPmin_hpe	0.000219093243525435d0
#define CONV_kgmPmin_hpm	0.000222222222222222d0
#define CONV_kgmPmin_hpw	0.000219080615554298d0
#define CONV_kgmPmin_JPhr	588.396814811909d0
#define CONV_kgmPmin_JPmin	9.80661358019849d0
#define CONV_kgmPmin_JPs	0.163443559669975d0
#define CONV_kgmPmin_kcalPhr	0.140536164806513d0
#define CONV_kgmPmin_kcalPmin	0.00234226941344189d0
#define CONV_kgmPmin_kcalPs	3.90378235573648d-05
#define CONV_kgmPmin_kgmPhr	60d0
#define CONV_kgmPmin_kgmPs	0.0166666666666667d0
#define CONV_kgmPmin_W	0.163443559669975d0
#define CONV_kgmPmin_kW	0.000163443559669975d0
#define CONV_kgmPmin_Wave	0.163412511292829d0
#define CONV_kgmPmin_Wu	0.163416595931646d0
#define CONV_kgmPs_btuPhr	33.4615384615385d0
#define CONV_kgmPs_btuPmin	0.557692307692308d0
#define CONV_kgmPs_btuPs	0.00929487179487179d0
#define CONV_kgmPs_calPmin	140.536164806513d0
#define CONV_kgmPs_calPs	2.34226941344189d0
#define CONV_kgmPs_ergPs	98066135.8019849d0
#define CONV_kgmPs_ftlbPhr	26038.7125877692d0
#define CONV_kgmPs_ftlbPmin	433.978543129487d0
#define CONV_kgmPs_ftlbPs	7.23297571882478d0
#define CONV_kgmPs_hp	0.0131508649433178d0
#define CONV_kgmPs_hpb	0.000999705752607012d0
#define CONV_kgmPs_hpe	0.0131455946115261d0
#define CONV_kgmPs_hpm	0.0133333333333333d0
#define CONV_kgmPs_hpw	0.0131448369332578d0
#define CONV_kgmPs_JPhr	35303.8088887145d0
#define CONV_kgmPs_JPmin	588.396814811909d0
#define CONV_kgmPs_JPs	9.80661358019849d0
#define CONV_kgmPs_kcalPhr	8.43216988839079d0
#define CONV_kgmPs_kcalPmin	0.140536164806513d0
#define CONV_kgmPs_kcalPs	0.00234226941344189d0
#define CONV_kgmPs_kgmPhr	3600d0
#define CONV_kgmPs_kgmPmin	60d0
#define CONV_kgmPs_W	9.80661358019849d0
#define CONV_kgmPs_kW	0.00980661358019849d0
#define CONV_kgmPs_Wave	9.80475067756975d0
#define CONV_kgmPs_Wu	9.80499575589877d0
#define CONV_W_btuPhr	3.41214d0
#define CONV_W_btuPmin	0.056869d0
#define CONV_W_btuPs	0.000947816666666667d0
#define CONV_W_calPmin	14.3307537976498d0
#define CONV_W_calPs	0.238845896627496d0
#define CONV_W_ergPs	10000000d0
#define CONV_W_ftlbPhr	2655.2196d0
#define CONV_W_ftlbPmin	44.25366d0
#define CONV_W_ftlbPs	0.737561d0
#define CONV_W_hp	0.00134102d0
#define CONV_W_hpb	0.000101941995004842d0
#define CONV_W_hpe	0.00134048257372654d0
#define CONV_W_hpm	0.00135962666666667d0
#define CONV_W_hpw	0.00134040531175817d0
#define CONV_W_JPhr	3600d0
#define CONV_W_JPmin	60d0
#define CONV_W_JPs	1d0
#define CONV_W_kcalPhr	0.859845227858985d0
#define CONV_W_kcalPmin	0.0143307537976498d0
#define CONV_W_kcalPs	0.000238845896627496d0
#define CONV_W_kgmPhr	367.0992d0
#define CONV_W_kgmPmin	6.11832d0
#define CONV_W_kgmPs	0.101972d0
#define CONV_W_kW	0.001d0
#define CONV_W_Wave	0.999810036093142d0
#define CONV_W_Wu	0.999835027220509d0
#define CONV_kW_btuPhr	3412.14d0
#define CONV_kW_btuPmin	56.869d0
#define CONV_kW_btuPs	0.947816666666667d0
#define CONV_kW_calPmin	14330.7537976498d0
#define CONV_kW_calPs	238.845896627496d0
#define CONV_kW_ergPs	10000000000d0
#define CONV_kW_ftlbPhr	2655219.6d0
#define CONV_kW_ftlbPmin	44253.66d0
#define CONV_kW_ftlbPs	737.561d0
#define CONV_kW_hp	1.34102d0
#define CONV_kW_hpb	0.101941995004842d0
#define CONV_kW_hpe	1.34048257372654d0
#define CONV_kW_hpm	1.35962666666667d0
#define CONV_kW_hpw	1.34040531175817d0
#define CONV_kW_JPhr	3600000d0
#define CONV_kW_JPmin	60000d0
#define CONV_kW_JPs	1000d0
#define CONV_kW_kcalPhr	859.845227858985d0
#define CONV_kW_kcalPmin	14.3307537976498d0
#define CONV_kW_kcalPs	0.238845896627496d0
#define CONV_kW_kgmPhr	367099.2d0
#define CONV_kW_kgmPmin	6118.32d0
#define CONV_kW_kgmPs	101.972d0
#define CONV_kW_W	1000d0
#define CONV_kW_Wave	999.810036093142d0
#define CONV_kW_Wu	999.835027220509d0
#define CONV_Wave_btuPhr	3.4127883066d0
#define CONV_Wave_btuPmin	0.05687980511d0
#define CONV_Wave_btuPs	0.000947996751833333d0
#define CONV_Wave_calPmin	14.3334766408713d0
#define CONV_Wave_calPs	0.238891277347855d0
#define CONV_Wave_ergPs	10001900d0
#define CONV_Wave_ftlbPhr	2655.724091724d0
#define CONV_Wave_ftlbPmin	44.2620681954d0
#define CONV_Wave_ftlbPs	0.73770113659d0
#define CONV_Wave_hp	0.0013412747938d0
#define CONV_Wave_hpb	0.000101961363983893d0
#define CONV_Wave_hpe	0.00134073726541555d0
#define CONV_Wave_hpm	0.00135988499573333d0
#define CONV_Wave_hpw	0.0013406599887674d0
#define CONV_Wave_JPhr	3600.684d0
#define CONV_Wave_JPmin	60.0114d0
#define CONV_Wave_JPs	1.00019d0
#define CONV_Wave_kcalPhr	0.860008598452279d0
#define CONV_Wave_kcalPmin	0.0143334766408713d0
#define CONV_Wave_kcalPs	0.000238891277347855d0
#define CONV_Wave_kgmPhr	367.168948848d0
#define CONV_Wave_kgmPmin	6.1194824808d0
#define CONV_Wave_kgmPs	0.10199137468d0
#define CONV_Wave_W	1.00019d0
#define CONV_Wave_kW	0.00100019d0
#define CONV_Wave_Wu	1.00002499587568d0
#define CONV_Wu_btuPhr	3.4127030031d0
#define CONV_Wu_btuPmin	0.056878383385d0
#define CONV_Wu_btuPs	0.000947973056416667d0
#define CONV_Wu_calPmin	14.3331183720264d0
#define CONV_Wu_calPs	0.238885306200439d0
#define CONV_Wu_ergPs	10001650d0
#define CONV_Wu_ftlbPhr	2655.657711234d0
#define CONV_Wu_ftlbPmin	44.2609618539d0
#define CONV_Wu_ftlbPs	0.737682697565d0
#define CONV_Wu_hp	0.0013412412683d0
#define CONV_Wu_hpb	0.000101958815434018d0
#define CONV_Wu_hpe	0.00134070375335121d0
#define CONV_Wu_hpm	0.00135985100506667d0
#define CONV_Wu_hpw	0.00134062647863461d0
#define CONV_Wu_JPhr	3600.594d0
#define CONV_Wu_JPmin	60.0099d0
#define CONV_Wu_JPs	1.000165d0
#define CONV_Wu_kcalPhr	0.859987102321582d0
#define CONV_Wu_kcalPmin	0.0143331183720264d0
#define CONV_Wu_kcalPs	0.000238885306200439d0
#define CONV_Wu_kgmPhr	367.159771368d0
#define CONV_Wu_kgmPmin	6.1193295228d0
#define CONV_Wu_kgmPs	0.10198882538d0
#define CONV_Wu_W	1.000165d0
#define CONV_Wu_kW	0.001000165d0
#define CONV_Wu_Wave	0.999975004749098d0



c QUANTITY OF ELECTRICITY, ELECTRIC CHARGE (C)
c ====================
c 
c abC    = abcoulomb
c As     = ampere-second
c Ahr    = ampere-hour
c C      = coulomb
c frank  = franklin



#define CONV_abC_As	10d0
#define CONV_abC_Ahr	0.00277777777777778d0
#define CONV_abC_C	10d0
#define CONV_abC_frank	29979245368.4314d0
#define CONV_As_abC	0.1d0
#define CONV_As_Ahr	0.000277777777777778d0
#define CONV_As_C	1d0
#define CONV_As_frank	2997924536.84314d0
#define CONV_Ahr_abC	360d0
#define CONV_Ahr_As	3600d0
#define CONV_Ahr_C	3600d0
#define CONV_Ahr_frank	10792528332635.3d0
#define CONV_C_abC	0.1d0
#define CONV_C_As	1d0
#define CONV_C_Ahr	0.000277777777777778d0
#define CONV_C_frank	2997924536.84314d0
#define CONV_frank_abC	3.335641d-11
#define CONV_frank_As	3.335641d-10
#define CONV_frank_Ahr	9.26566944444444d-14
#define CONV_frank_C	3.335641d-10



c ELECTRIC POTENTIAL, POTENTIAL DIFFERENCE, ELECTROMOTIVE FORCE (V)
c ====================
c 
c abV    = abvolt
c kV     = kilovolt
c V      = volt
c Vave   = volt (int. mean)
c Vus    = volt (int. US)



#define CONV_abV_kV	1d-11
#define CONV_abV_V	1d-08
#define CONV_abV_Vave	9.99660115560709d-09
#define CONV_abV_Vus	9.99670108864075d-09
#define CONV_kV_abV	100000000000d0
#define CONV_kV_V	1000d0
#define CONV_kV_Vave	999.660115560709d0
#define CONV_kV_Vus	999.670108864075d0
#define CONV_V_abV	100000000d0
#define CONV_V_kV	0.001d0
#define CONV_V_Vave	0.999660115560709d0
#define CONV_V_Vus	0.999670108864075d0
#define CONV_Vave_abV	100034000d0
#define CONV_Vave_kV	0.00100034d0
#define CONV_Vave_V	1.00034d0
#define CONV_Vave_Vus	1.00000999670109d0
#define CONV_Vus_abV	100033000d0
#define CONV_Vus_kV	0.00100033d0
#define CONV_Vus_V	1.00033d0
#define CONV_Vus_Vave	0.999990003398844d0



c CAPACITANCE (F)
c ====================
c 
c abF    = abfarad
c F      = farad
c Fave   = farad (int. mean)
c Fus    = farad (int. US)
c uF     = microfarad



#define CONV_abF_F	1000000000d0
#define CONV_abF_Fave	1000490240.21771d0
#define CONV_abF_Fus	1000495245.14635d0
#define CONV_abF_uF	1d+15
#define CONV_F_abF	1d-09
#define CONV_F_Fave	1.00049024021771d0
#define CONV_F_Fus	1.00049524514635d0
#define CONV_F_uF	1000000d0
#define CONV_Fave_abF	9.9951d-10
#define CONV_Fave_F	0.99951d0
#define CONV_Fave_Fus	1.00000500247623d0
#define CONV_Fave_uF	999510d0
#define CONV_Fus_abF	9.99505d-10
#define CONV_Fus_F	0.999505d0
#define CONV_Fus_Fave	0.999994997548799d0
#define CONV_Fus_uF	999505d0
#define CONV_uF_abF	1d-15
#define CONV_uF_F	1d-06
#define CONV_uF_Fave	1.00049024021771d-06
#define CONV_uF_Fus	1.00049524514635d-06



c ELECTRICAL RESISTANCE
c ====================
c 
c abO    = abohm
c O      = ohm
c Oave   = ohm (int. mean)
c Ous    = ohm (int. US)



#define CONV_abO_O	1d-09
#define CONV_abO_Oave	9.9951d-10
#define CONV_abO_Ous	9.99505d-10
#define CONV_O_abO	1000000000d0
#define CONV_O_Oave	0.99951d0
#define CONV_O_Ous	0.999505d0
#define CONV_Oave_abO	1000490240.21771d0
#define CONV_Oave_O	1.00049024021771d0
#define CONV_Oave_Ous	0.999994997548799d0
#define CONV_Ous_abO	1000495245.14635d0
#define CONV_Ous_O	1.00049524514635d0
#define CONV_Ous_Oave	1.00000500247623d0



c CAPACITANCE (S)
c ====================
c 
c S      = siemens
c mhO    = mho (omh-1)
c abmhO  = abmho



#define CONV_S_mhO	1d0
#define CONV_S_abmhO	1d-09
#define CONV_mhO_S	1d0
#define CONV_mhO_abmhO	1d-09
#define CONV_abmhO_S	1000000000d0
#define CONV_abmhO_mhO	1000000000d0



c MAGNETIC FLUX (Wb)
c ====================
c 
c max   = maxwell
c pole  = unit pole
c Vs    = volt-sond
c Wb    = weber



#define CONV_max_pole	0.0795774754364228d0
#define CONV_max_Vs	1d-08
#define CONV_max_Wb	1d-08
#define CONV_pole_max	12.56637d0
#define CONV_pole_Vs	1.256637d-07
#define CONV_pole_Wb	1.256637d-07
#define CONV_Vs_max	100000000d0
#define CONV_Vs_pole	7957747.54364228d0
#define CONV_Vs_Wb	1d0
#define CONV_Wb_max	100000000d0
#define CONV_Wb_pole	7957747.54364228d0
#define CONV_Wb_Vs	1d0



c MAGNETIC FLUX DENSITY (T)
c ====================
c 
c T        = tesla
c WbPm2    = weber per square meter



#define CONV_T_WbPm2	1d0
#define CONV_WbPm2_T	1d0



c INDUCTANCE (H)
c ====================
c 
c abH    = abhenry
c H      = henry
c Have   = henry (int. mean)
c Hus    = henry (int. US)



#define CONV_abH_H	1d-09
#define CONV_abH_Have	9.9951d-10
#define CONV_abH_Hus	9.99505d-10
#define CONV_H_abH	1000000000d0
#define CONV_H_Have	0.99951d0
#define CONV_H_Hus	0.999505d0
#define CONV_Have_abH	1000490240.21771d0
#define CONV_Have_H	1.00049024021771d0
#define CONV_Have_Hus	0.999994997548799d0
#define CONV_Hus_abH	1000495245.14635d0
#define CONV_Hus_H	1.00049524514635d0
#define CONV_Hus_Have	1.00000500247623d0



c ILLUMINANCE (lx)
c ====================
c 
c lx     = lux
c lmPcm2 = lumen per square cm
c lmPm2  = lumen per square meter
c lmPft2 = lumen per square foot
c ph     = phot



#define CONV_lx_lmPcm2	0.0001d0
#define CONV_lx_lmPm2	1d0
#define CONV_lx_lmPft2	0.09290304d0
#define CONV_lx_ph	0.0001d0
#define CONV_lmPcm2_lx	10000d0
#define CONV_lmPcm2_lmPm2	10000d0
#define CONV_lmPcm2_lmPft2	929.0304d0
#define CONV_lmPcm2_ph	1d0
#define CONV_lmPm2_lx	1d0
#define CONV_lmPm2_lmPcm2	0.0001d0
#define CONV_lmPm2_lmPft2	0.09290304d0
#define CONV_lmPm2_ph	0.0001d0
#define CONV_lmPft2_lx	10.7639104167097d0
#define CONV_lmPft2_lmPcm2	0.00107639104167097d0
#define CONV_lmPft2_lmPm2	10.7639104167097d0
#define CONV_lmPft2_ph	0.00107639104167097d0
#define CONV_ph_lx	10000d0
#define CONV_ph_lmPcm2	1d0
#define CONV_ph_lmPm2	10000d0
#define CONV_ph_lmPft2	929.0304d0



c ACTIVITY (Bq)
c ====================
c 
c Bq     = becquerel
c cur    = curie



#define CONV_Bq_cur	2.7027027027027d-11
#define CONV_cur_Bq	37000000000d0



c ABSORBED DOSE (Gy)
c ====================
c 
c Gy     = gray
c JPkg   = joule per kg



#define CONV_Gy_JPkg	1d0
#define CONV_JPkg_Gy	1d0



c SOUND INTENSITY
c ====================
c 
c db     = decibel
c neper  = neper



#define CONV_db_neper	0.115129255d0
#define CONV_neper_db	8.68588961163694d0

#endif /* _CONST_H_ */

