// -*- C++ -*-
// Iterator_Factory_i.h,v 1.8 2003/11/01 11:15:08 dhinton Exp

// ============================================================================
//
// = LIBRARY
//     AMI_Iterator
//
// = FILENAME
//     Iterator_Factory_i.h
//
// = DESCRIPTION
//     Header file for the Web_Server::Iterator_Factory implementation.
//
// = AUTHOR
//     Ossama Othman <ossama@uci.edu>
//
// ============================================================================

#ifndef ITERATOR_FACTORY_I_H
#define ITERATOR_FACTORY_I_H

#include "Web_ServerS.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/OS_NS_sys_stat.h"

// Forward declarations
class Content_Iterator_i;

class Iterator_Factory_i : virtual public POA_Web_Server::Iterator_Factory
{
  // = TITLE
  //    Factory that creates a Content_Iterator that retrieves fixed
  //    size chunks of data from Content server.
  //
  // = DESCRIPTION
  //    This class creates a Content_Iterator that is set up to
  //    iteratively download a specific file.  This same factory can
  //    be used to create Content_Iterators for other files.
public:

  virtual void get_iterator (const char *pathname,
                             Web_Server::Content_Iterator_out contents,
                             Web_Server::Metadata_Type_out metadata
                             ACE_ENV_ARG_DECL)
    ACE_THROW_SPEC ((CORBA::SystemException,
                     Web_Server::Error_Result));
  // This factory method returns a <Content_Iterator> that can be used
  // to read the <contents> associated with <pathname> one ``chunk''
  // at a time.  The <metadata> reports information about the
  // <contents>.

  int modification_date (ACE_stat *file_status,
                         Web_Server::Metadata_Type_out metadata);
  // Set the file modification date in the metadata structure.

  int content_type (const char *filename,
                    Web_Server::Metadata_Type_out metadata);
  // Set the type of file content in the metadata structure.
};

#endif  /* ITERATOR_FACTORY_I_H */
