/*
 * Copyright (C) 2012 Chris Wayne <cwayne@ubuntu.com>
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
  
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU General Public License for more details.
  
 * You should have received a copy of the GNU General Public License along 
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

public class FitbitPlugin : Ap.OAuthPlugin {
    public FitbitPlugin (Ag.Account account) {
        Object (account: account);
    }

    construct
    {
        var oauth_params = new HashTable<string, GLib.Value?> (str_hash, null);       
        oauth_params.insert ("RequestEndpoint",
                            "https://api.fitbit.com/oauth/request_token");
        oauth_params.insert ("TokenEndpoint",
                            "https://api.fitbit.com/oauth/access_token");
        oauth_params.insert ("AuthorizationEndpoint",
                            "https://www.fitbit.com/oauth/authorize");
        oauth_params.insert ("ConsumerKey", Config.FITBIT_CONSUMER_KEY);
        oauth_params.insert ("ConsumerSecret", Config.FITBIT_CONSUMER_SECRET);
        oauth_params.insert ("Callback", "https://www.fitbit.com/");
        string[] schemes = {
            "https",
            "http"
        };
        oauth_params.insert ("AllowedSchemes", schemes);
        set_oauth_parameters (oauth_params);

        set_mechanism(Ap.OAuthMechanism.HMAC_SHA1);
    }
}

public GLib.Type ap_module_get_object_type ()
{
    return typeof (FitbitPlugin);
}
