
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: file_view.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>
#include <string.h>

#include "aca.h"
#include "aca_dlg.h"
#include "aca_widget.h"

#define Y(a)	(a+y)
#define X(a)	(a+x)

   void Dlg_FileViewer(char *filename, char *header, char *descript, int xn)
   {
      char	*str = chN;
      int	fd, flag = 0,
      		y, x, yn;
      Wmenu	m = { " View: ", 0, M_TITLE|M_COLORIN|M_BORDER|M_SHTMENU|M_OPEN,
   	   0,0,0,8,0,0,0,10,0,0, alistN, (void *) str, mpr_view, mpr_descript, descript };	
      Widget	w[] = {
   	   { TRUE, 0,0,0,0,  menu_fn,   (void *) &m, Wf_DEFAULT, _aca_text_domain },
   	   { TRUE, 0,9,0,0,  button_fn, (void *) &def_button[_BUTT_QUIT], Wf_DEFAULT, _aca_text_domain },
   	   W_NULL
      };
      SessW	s;

      if (!filename) 
         return;   
      if ((fd	= open(filename, O_RDONLY)) == -1) {
         ErrorOpen_no(filename);
         return;			
      }
      if ((str = aca_loadfile(fd, &flag)) == NULL) 
         return;
      m.list	= (void *) str;
      
      init_view(&m);
      
      yn = m.item_max > LINES-9 ? LINES-4 : m.item_max+5; 
      m.scr_max = yn-5;

#define _SET_VIEWFILE_POZ {				\
      y = LINES/2 - yn/2;				\
      x = COLS/2 - xn/2-1;				\
      w[0].y = Y(1);    w[1].y = Y(yn-1);		\
      w[0].x = X(2);    w[1].x = X(xn-astrlen(def_button[_BUTT_CANCEL].astr)-2);\
      aca_border(Y(0),X(0), yn, xn, TplC->dlg_bgr);  	\
      clean_box(Y(1),X(1), yn-2, xn-2, TplC->dlg_bgr);  \
      bold;  aca_c(TplC->dlg_header);  			\
      mvaddstr(Y(0), COLS/2 - strlen(header)/2, header);\
      ubold;						\
}

      w[0].lines = m.scr_max;			
      w[0].cols  = xn-4;
      _SET_VIEWFILE_POZ;
      
      if (descript) {
      		m.flag |= M_DESCRIPT; 
      		m.item_act = (m.scr_act = m.scr_max ) -1;
      } else 
      		m.item_act = m.scr_act = m.scr_max;
      
      init_sessw(&s, 0, TRUE, w, NULL, Sf_NOT_BGR);

      W_redraw_session(&s);
      do {
         if (s.key == K_SCREEN_RESIZED) {
         	_SET_VIEWFILE_POZ;
         	W_redraw_session(&s);
         	continue;
         }	
         if (run_act_widget(&s) & Wr_BUTTON_PRESS) 
            break;							
         W_key_to_widgets(&s);		
         W_default_go(&s);
      } while((s.key = get_k()) != KEY_F(10));  
   
      aca_unloadfile(str, flag);
      close(fd);	
   
      return;
   }
