!{\src2tex{textfont=tt}}
!!****f* ABINIT/sizefft
!! NAME
!! sizefft
!!
!! FUNCTION
!! Calculate N, the size of the smallest allowed FFT that will encompass
!! the 2M+1 points-M..+M.  (Ideally, N=2M+1, but this may not be
!! an allowable FFT.)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  m=input M value
!!
!! OUTPUT
!!  n=output N value
!!
!! NOTES
!! This routine is written for the GOEDECKER routine, in which the
!! allowable sizes of FFT are those whose prime factors are 2,3 and 5.
!!
!! PARENTS
!!      setmesh
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine sizefft(m,n)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: m
 integer,intent(out) :: n

!Local variables-------------------------------
!scalars
 integer,parameter :: nn=105
 integer :: i,nbest
!arrays
 integer :: nallwd(nn)
!no_abirules
 data nallwd/&
&   2, 3, 4, 5, 6, 8, 9,10,12,15,&
&  16,18,20,24,25,27,30,32,36,40,&
&  45,48,50,54,60,64,72,75,80,81,&
&  90,96,100,108,120,125,128,135,144,150,&
& 160,162,180,192,200,216,225,240,243,250,&
& 256,270,288,300,320,324,360,375,384,400,&
& 405,432,450,480,486,500,512,540,576,600,&
& 625,640,648,675,720,729,750,768,800,810,&
& 864,900,960,972,1000,1024,1080,1152,1200,1250,&
& 1280,1296,1350,1440,1458,1500,1536,1600,1620,1728,&
& 1800,1920,1944,2000,2048/

! *************************************************************************

 nbest=2*m+1
 if(nbest>nallwd(nn)) then
   write(6,*) '**error sizefft 1: '
   stop
 end if
 if(nbest<2) then
   write(6,*) '**error sizefft 2: '
   stop
 end if
 do i=nn,1,-1
   if(nallwd(i)>=nbest) n=nallwd(i)
 end do

end subroutine sizefft
!!***
