!{\src2tex{textfont=tt}}
!!****f* ABINIT/cigfft
!! NAME
!! cigfft
!!
!! FUNCTION
!! For each of the 125 vectors G0 around the origin, calculate G-G0
!! and its FFT index no. for all NPWVEC vectors G
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  gvec(3,npwvec)=coordinates of G vectors
!!  npwvec=number of plane waves
!!  n1d,n1,n2,n3=FFT grid dimensions
!!
!! OUTPUT
!!  igfft(npwvec,5,5,5)=for each PW G , and each G0 vector, gives the
!!   FFT grid index of the G-G0 vector
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cigfft(npwvec,n1d,n1,n2,n3,gvec,igfft)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => cigfft
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: n1,n1d,n2,n3,npwvec
!arrays
 integer,intent(in) :: gvec(3,npwvec)
 integer,intent(out) :: igfft(npwvec,5,5,5)

!Local variables ------------------------------
!scalars
 integer :: gmg01,gmg02,gmg03,ig,ig01,ig02,ig03,nr
 character(len=500) :: message

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 integer :: modx
#endif
!End of the abilint section

 do ig01=-2,2
   do ig02=-2,2
     do ig03=-2,2
       do ig=1,npwvec
         gmg01=modx(gvec(1,ig)-ig01,n1)
         gmg02=modx(gvec(2,ig)-ig02,n2)
         gmg03=modx(gvec(3,ig)-ig03,n3)
         igfft(ig,ig01+3,ig02+3,ig03+3)=1+gmg01+gmg02*n1d+gmg03*n1d*n2
       end do
     end do
   end do
 end do

 write(message,'(2a)')' G-table set up',ch10
 call wrtout(6,message,'COLL')

end subroutine cigfft
!!***
