# Part of the A-A-P recipe executive: Setup using BCC

# Copyright (c) 2002-2003 stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This module sets up variables and actions for using the Borland C++
# compiler tools.
#

from RecPython import *
import Global
from Action import action_add
from Dictlist import str2dictlist
from RecPos import RecPos


def exists():
    """
    Return TRUE when the BCC toolchain can be found.
    """
    return program_path("bcc32")


def define_actions():
    """
    Define the actions that BCC can accomplish.
    """
    rd = Global.globals

    # TODO: use DEBUG and OPTIMIZE
    rpstack = [ RecPos  ("compile_bcc action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_bcc object c"),
            "defi = $?DEFINE\n"
            "incl = $?INCLUDE\n"
            ":sys $BCC $CPPFLAGS $defi $incl $CFLAGS -c -WE -o$target $source")
    if not rd.get("BCC"):
        rd["BCC"] = "bcc32"

    rpstack = [ RecPos("build_bcc action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "build_bcc object"),
            ":sys $BCCLINK $LINKFLAGS $source c0x32.obj, $target, , import32.lib cw32.lib")
    if not rd.get("BCCLINK"):
        rd["BCCLINK"] = "ilink32"
    if not rd.get("LINKFLAGS"):
        rd["LINKFLAGS"] = "-q"


def use_actions(scope):
    """
    Setup variables so that the default actions use the BCC actions.
    """
    scope["C_COMPILE_ACTION"] = "compile_bcc"
    scope["CXX_COMPILE_ACTION"] = "compile_bcc"
    scope["C_BUILD_ACTION"] = "build_bcc"
    scope["CXX_BUILD_ACTION"] = "build_bcc"

    # Avoid using gcc for dependency checks.  It may exist but won't work with
    # the BCC compiler flags.
    scope["HASGCC"] = "no"
    scope["HASGCCXX"] = "no"

# vim: set sw=4 et sts=4 tw=79 fo+=l:
