/* ------------------------------------------------------------------------
 * Nobel.cc
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-11-09 by Niklas Elmqvist.
 *
 * Copyright (c) 2000, 2001 Niklas Elmqvist <elm@3dwm.org>. 
 * Copyright (c) 2000, 2001 Steve Houston <shouston@programmer.net>. 
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Nobel++/Nobel.hh"

using namespace Nobel;

// -- Code Segment

Nobelxx::Client::Client(const char *name, int &argc, char **argv,
			const char *ior)
    : _orb(CORBA::ORB_init(argc, argv, "omniORB3")),
      _client(new ClientHandleImpl)
{
    // Create the portable object adapter and activate the client servant
    // @@@ Maybe we don't need to do this explicitly?
    PortableServer::POA_var poa = resolve_init<PortableServer::POA>
	(_orb, "RootPOA");
    PortableServer::ObjectId_var oid = poa->activate_object(_client);
    
    // @@@Handle stringified IORs!
    
    // Connect to the name service
    CosNaming::NamingContext_var context =
	resolve_init<CosNaming::NamingContext>(_orb, "NameService");
    
    // Retrieve the super context and connect to it
    Server_var s = resolve_name<Server>(context, Server::_PD_repoId);
    _server = s->connect(name, _client->_this());
}

Nobelxx::Client::~Client()
{
    _server->shutdown();
    deactivate(_client);
    delete _client;
}
