/* ------------------------------------------------------------------------ 
 * $Id: VolumeImpl.cc,v 1.4 2001/06/27 12:48:57 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-05-29 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes
#include <algorithm>
#include <cmath>

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Celsius/Guard.hh"
#include "Celsius/Logger.hh"
#include "Polhem/VolumeImpl.hh"

using namespace Nobel;

// -- Code Segment

VolumeImpl::VolumeImpl()
{
    Vertex3D min = { HUGE_VAL, HUGE_VAL, HUGE_VAL }; 
    Vertex3D max = { -HUGE_VAL, -HUGE_VAL, -HUGE_VAL }; 
    _min = min;
    _max = max;
}

VolumeImpl::VolumeImpl(const VolumeImpl &v)
{
    *this = v;
}

VolumeImpl::~VolumeImpl()
{
    // empty
}
    
CORBA::Boolean VolumeImpl::inside(const Nobel::Vertex3D &v)
{
    // Simple containment test
    return (v.x > _min.x && v.y > _min.y && v.z > _min.z &&
	    v.x < _max.x && v.y < _max.y && v.z < _max.z);
}

void VolumeImpl::getBounds(Nobel::Vertex3D &min, Nobel::Vertex3D &max)
{
    // Return vertex bounds
    min = _min; max = _max;
}

void VolumeImpl::merge(Nobel::Volume_ptr v)
{
    // Retrieve bounds of the given volume
    Vertex3D vmax, vmin;
    v->getBounds(vmin, vmax);

    // Now, update the bounds
    _min.x = std::min(_min.x, vmin.x);
    _min.y = std::min(_min.y, vmin.y);
    _min.z = std::min(_min.z, vmin.z);
    _max.x = std::max(_max.x, vmax.x);
    _max.y = std::max(_max.y, vmax.y);
    _max.z = std::max(_max.z, vmax.z);
}

void VolumeImpl::setBounds(Nobel::Vertex3D &min, Nobel::Vertex3D &max)
{
    // Update vertex bounds
    _min = min; _max = max;
}

VolumeImpl &VolumeImpl::operator = (const VolumeImpl &v)
{
    // Retrieve bounds from template volume
    _min = v._min; _max = v._max;
    
    return *this;
}

bool VolumeImpl::operator == (const VolumeImpl &v)
{
    // Do an element-wise comparison
    return (_min.x == v._min.x && _min.y == v._min.y && _min.z == v._min.z &&
	    _max.x == v._max.x && _max.y == v._max.y && _max.z == v._max.z);
}
    
bool VolumeImpl::operator != (const VolumeImpl &v)
{
    return !(*this == v);
}
