/* -*- c++ -*- ------------------------------------------------------------
 * $Id: SDLInputListener.inl,v 1.2 2001/07/18 07:48:37 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-04-28 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Antony Suter <antony@mira.net>.
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2001 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// NOTE that this class is #include:d by both SDLPlatform.cc and
// SDLfbconPlatform.cc!

class SDLInputListener : public InputDevice {
public:
    
    /**
     * Constructor. No initialization necessary, that is already done
     * in the SDLPlatform constructor.
     **/
    SDLInputListener(InputEventQueue *eventQueue)
	: InputDevice(eventQueue) { }

    /**
     * Retrieve the device name.
     **/
    std::string getDeviceName() const {
	return "SDL Event Listener"; 
    }

    /**
     * Main thread loop. Should never exit (this thread is killed on
     * termination).
     **/
    void run() {
	
	// Loop indefinitely
	while (true) {

	    SDL_Event event;
	    InputEvent ie;
	    
	    // Wait for an event
	    if (SDL_WaitEvent(&event) == 0)
		throw Exception("SDLPlatform: event error");
	    
	    // Keyboard events
	    if (event.type == SDL_KEYDOWN || event.type == SDL_KEYUP) {
		
		ie.add("keyboard");
		ie.add("keyboard.pressed", event.type == SDL_KEYDOWN);
		
		// Handle the 'a' to 'z' keys
		if (event.key.keysym.sym >= SDLK_a &&
		    event.key.keysym.sym <= SDLK_z)
		    ie.add("keyboard.key", event.key.keysym.sym - SDLK_a+'a');
		// These are the "normal" SDL keys
		else
		    ie.add("keyboard.key", event.key.keysym.sym);
	    }
	    // Mouse click events
	    else if (event.type == SDL_MOUSEBUTTONDOWN ||
		     event.type == SDL_MOUSEBUTTONUP) {
		
		ie.add("mouse");
		ie.add("mouse.pressed",  event.type == SDL_MOUSEBUTTONDOWN);
		ie.add("mouse.button", event.button.button);
		ie.add("mouse.x", event.button.x);
		ie.add("mouse.y", event.button.y);
	    }
	    // Mouse motion events
	    else if (event.type == SDL_MOUSEMOTION) {
		
		ie.add("mouse");
		ie.add("mouse.motion");
		ie.add("mouse.x", event.button.x);
		ie.add("mouse.y", event.button.y);
	    }
	    else {
		continue;
	    }
	    
	    // Add the event to the event queue
	    addInputEvent(ie);
	}
    }
};
