/* ------------------------------------------------------------------------
 * $Id: Config.hh,v 1.1 2001/08/16 11:32:23 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-15 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _Config_hh_
#define _Config_hh_

// -- System Includes
#include <string>
#include <vector>

// -- Local Includes
#include "Celsius/SAX/Exception.hh"
#include "Celsius/SAX/HandlerBase.hh"
#include "Celsius/SAX/AttributeList.hh"

// -- Class Declarations

/**
 * Configuration file event handler. Derives from the SAX document
 * handler class so that it can be used by the configuration settings
 * database to parse input from XML config files. This class is a
 * friend of the Config class to make it easy to maintain
 * encapsulation while still allowing the handler to easily manipulate
 * the state in the configuration.
 **/
class ConfigHandler : public SAX::HandlerBase {
public:

    /**
     * Handle a starting XML element.
     *
     * @param name element name.
     * @param atts element attribute list.
     **/
    virtual void startElement(const std::string &name,
			      const SAX::AttributeList &atts);

    /**
     * Handle an ending XML element.
     *
     * @param name element name.
     **/
    virtual void endElement(const std::string &name);
};

/**
 * Configuration settings database.
 **/ 
class Config {
public:

    /**
     * Parse a config file and store the settings into the
     * configuration. 
     *
     * @param filename resolved name of file to load and parse. 
     **/
    static void parse(const std::string &filename);

    /*
     * Config querying methods.
     */
    static int getScreenWidth() { return _screenWidth; }
    static int getScreenHeight() { return _screenHeight; }
    static int getScreenDepth() { return _screenDepth; }
    static const std::vector<std::string> &getRuleFiles() {
	return _ruleFiles; 
    }
    static const std::vector<std::string> &getLogGroups() {
	return _logGroups; 
    }
    
private:
    friend class ConfigHandler;
    static int _screenWidth, _screenHeight, _screenDepth;
    static std::vector<std::string> _ruleFiles;
    static std::vector<std::string> _logGroups;
};

#endif /* Config.hh */
