/* ------------------------------------------------------------------------
 * $Id: EvalVisitor.hh,v 1.1 2001/06/19 22:48:00 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-12 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _EvalVisitor_hh_
#define _EvalVisitor_hh_

// -- System Includes
#include <map>
#include <string>
#include <vector>
#include <iostream>

// -- Zorn Includes
#include "Value.hh"
#include "ASTVisitor.hh"

namespace Zorn {

    // -- Forward Declarations
    class Store;

    // -- Class Declarations

    /**
     * Evaluation traversal class. 
     **/
    class EvalVisitor : public ASTVisitor {
    public:

	EvalVisitor(Store *store);
	virtual ~EvalVisitor();
    
	void beginVisit();
	void endVisit();

	void visitRule(ASTRule *node);
	void visitAssign(ASTAssign *node);
	void visitCall(ASTCall *node);
	void visitActionCall(ASTActionCall *node);
	void visitParam(ASTParam *node);
	void visitBinOp(ASTBinOp *node);
	void visitUnOp(ASTUnOp *node);
	void visitAnd(ASTAnd *node);
	void visitIf(ASTIf *node);
	void visitInt(ASTInt *node);
	void visitDouble(ASTDouble *node);
	void visitString(ASTString *node);
	void visitBool(ASTBool *node);
	void visitId(ASTId *node);
	void visitExists(ASTExists *node);

	/**
	 * Unary function object.
	 **/
	class UnaryFunctor {
	public:
	    virtual Value execute(const Value &operand) = 0;
	};
    
	/**
	 * Binary function object.
	 **/
	class BinaryFunctor {
	public:
	    virtual Value execute(const Value &left, const Value &right) = 0;
	};
    
    private:
        
	void pushState(const Value &state) {
	    _evalStack.push_back(state);
	}

	Value popState() {
	    Value state = _evalStack.back();
	    _evalStack.pop_back();
	    return state;
	}

	void incrementParamCount() {
	    _paramCountStack.back()++;
	}
    
	void beginParams() {
	    _paramCountStack.push_back(0);
	}
    
	int endParams() {
	    int count = _paramCountStack.back();
	    _paramCountStack.pop_back();
	    return count;
	}
    
	Store *_store;
	std::map<std::string, UnaryFunctor *> _unary;
	std::map<std::string, BinaryFunctor *> _binary;
	std::vector<Value> _evalStack;
	std::vector<int> _paramCountStack;
    };

};

#endif /* EvalVisitor.hh */
