/* ------------------------------------------------------------------------
 * $Id: ASTVisitor.hh,v 1.1 2001/06/19 22:48:00 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-12 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _ASTVisitor_hh_
#define _ASTVisitor_hh_

namespace Zorn {
    
    // -- Forward Declarations
    class AST;
    class ASTRule;
    class ASTAssign;
    class ASTBinOp;
    class ASTUnOp;
    class ASTIf;
    class ASTInt;
    class ASTDouble;
    class ASTString;
    class ASTBool;
    class ASTId;
    class ASTAnd;
    class ASTCall;
    class ASTActionCall;
    class ASTParam;
    class ASTExists;

    // -- Class Declarations

    /**
     * Abstract syntax tree traversal class. 
     **/
    class ASTVisitor {
    public:

	/**
	 * Initialization method. Called just before traversal begins.
	 **/
	virtual void beginVisit() { }

	/**
	 * Cleanup method. Called just after traversal has ended.
	 **/
	virtual void endVisit() { }
    
	virtual void visitRule(ASTRule *node) = 0;
	virtual void visitAssign(ASTAssign *node) = 0;
	virtual void visitCall(ASTCall *node) = 0;
	virtual void visitActionCall(ASTActionCall *node) = 0;
	virtual void visitParam(ASTParam *node) = 0;
	virtual void visitBinOp(ASTBinOp *node) = 0;
	virtual void visitUnOp(ASTUnOp *node) = 0;
	virtual void visitAnd(ASTAnd *node) = 0;
	virtual void visitIf(ASTIf *node) = 0;
	virtual void visitInt(ASTInt *node) = 0;
	virtual void visitDouble(ASTDouble *node) = 0;
	virtual void visitString(ASTString *node) = 0;
	virtual void visitBool(ASTBool *node) = 0;
	virtual void visitId(ASTId *node) = 0;
	virtual void visitExists(ASTExists *node) = 0;
    };

};

#endif /* ASTVisitor.hh */
