/* ------------------------------------------------------------------------
 * $Id: Event.hh,v 1.1 2000/12/03 23:26:42 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-12-01 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Event_hh_
#define _Event_hh_

// -- Class Declarations

/**
 * Basic event class. Events are polymorphic, ranging from the normal
 * input events (which are quite diverse due to the differing nature
 * of all the different input devices) to client communication events.
 * 
 * @@@ HACK! Make this into a "real" class!!!
 **/
struct Event {
    enum { key_press, key_release,
	   button_up, button_down } type;
    int x, y, z;
    int button;
    int key;
    int status;
};

#endif /* Event.hh */
