/* ------------------------------------------------------------------------
 * $Id: User.hh,v 1.1 2001/08/16 11:32:20 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-15 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _User_hh_
#define _User_hh_

// -- System Includes
#include <string>
#include <pwd.h>

// -- Class Declarations

/**
 * User representation class.
 **/
class User {
public:

    /**
     * Constructor.
     *
     * @param uid user identifier (-1 for the current user).
     **/
    User(int uid = -1);

    /**
     * Constructor.
     *
     * @param name user name.
     **/
    User(const std::string &name);

    /**
     * Destructor. Note that we should not attempt to delete the
     * "_pwd" member variable, it is taken care of by the OS!
     **/ 
    ~User() { }

    /**
     * Return the user identifier.
     *
     * @return user identifier.
     **/
    uid_t getUid() const { return _pwd->pw_uid; }

    /**
     * Return the user group identifier.
     * 
     * @return user group identifier.
     **/
    gid_t getGid() const { return _pwd->pw_gid; }

    /**
     * Retrieve the user name.
     * 
     * @return user name.
     **/
    std::string getName() const { return _pwd->pw_name; }

    /**
     * Retrieve the real name of the user.
     * 
     * @return user name.
     **/
    std::string getRealName() const { return _pwd->pw_gecos; }

    /**
     * Retrieve the home directory.
     *
     * @return user home directory.
     **/
    std::string getHome() const { return _pwd->pw_dir; }
    
private:
    passwd *_pwd;
};

#endif /* User.hh */
