/* ------------------------------------------------------------------------
 * $Id: Locator.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXLocator_hh_
#define _SAXLocator_hh_

// -- System Includes
#include <string>

namespace SAX {

    // -- Class Declarations

    /**
     * Interface for associating a SAX event with a document location.
     **/
    class Locator {
    public:
	
	/**
	 * Constructor.
	 **/
	Locator() { }

	/**
	 * Destructor.
	 **/
	virtual ~Locator() { }

	/**
	 * Return the public identifier for the current document event.
	 *
	 * @return string containing the public identifier, empty if
	 *         none is available.
	 **/
	virtual const std::string &getPublicId() const = 0;
	
	/**
	 * Return the system identifier for the current document event. 
	 *
	 * @return string containing the system identifier, empty if
	 *         none is available.
	 **/
	virtual const std::string &getSystemId() const = 0;

	/**
	 * Return the line number where the current document event ends. 
	 *
	 * @return line number, or -1 if none is available.
	 **/
	virtual int getLineNumber() const = 0;

	/**
	 * Return the column number where the current document event ends.
	 * 
	 * @return column number, or -1 if none is available.
	 **/
	virtual int getColumnNumber() const = 0; 
    };

};

#endif /* Locator.hh */
