/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/


/*
 * hgfsUtil.h --
 * 
 *    Utility functions used by hgfs.
 */


#ifndef _HGFSUTIL_H_
#   define _HGFSUTIL_H_


#   ifdef __KERNEL__
#      include "driver-config.h"
#      include <linux/time.h> // for time_t and timespec
#   else
#      include <time.h>
#   endif
#   include "vm_basic_types.h"
#   if !defined(_STRUCT_TIMESPEC) &&   \
       !defined(_TIMESPEC_DECLARED) && \
       !defined(__timespec_defined) && \
       !defined(sun) && \
       !defined(__FreeBSD__)
struct timespec {
   time_t tv_sec;
   long   tv_nsec;
};
#   endif


/*
 * Routines for converting between Win NT and unix time formats. The
 * hgfs attributes use the NT time formats, so the linux driver and
 * server have to convert back and forth. [bac]
 */

uint64 HgfsConvertToNtTime(time_t unixTime, // IN
			   long   nsec);    // IN
int HgfsConvertFromNtTime(time_t * unixTime, // OUT
			  uint64 ntTime);    // IN
int HgfsConvertFromNtTimeNsec(struct timespec *unixTime, // OUT
                              uint64 ntTime);            // IN


#endif /* _HGFSUTIL_H_ */
