/*
 * util.c
 *
 * Copyright (C) 1997,98 Rasca, Berlin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../config.h"  /* autoconf output */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>		/* PATH_MAX */
#include <ctype.h>		/* isdigit() */
#include "util.h"
#ifdef HAVE_LIBZ
#include <zlib.h>
#ifdef HAVE_LIBPNG
#include <png.h>
#endif
#endif
#ifdef HAVE_LIBJPEG
#include <jpeglib.h>
#endif

/*
 * swap the byte order of a 16 bit word;
 */
void
swap_2byte (unsigned short *i)
{
    unsigned char t;
	unsigned char *p = (unsigned char *) i;
    t = p[0];
    p[0] = p[1];
    p[1] = t;
}

/*
 * swap the byte order of a long integer (32 byte)
 */
void
swap_4byte (unsigned long *i)
{
    unsigned char t;
	unsigned char *p = (unsigned char *) i;

	t = p[0];
	p[0] = p[3];
	p[3] = t;
	t = p[1];
	p[1] = p[2];
	p[2] = t;
}

/*
 * swap the byte order of a 32 bit word;
 */
void
swap_n_4byte (unsigned char *p, unsigned long n)
{
    register unsigned char t;
	register unsigned long i;
	for (i = 0; i < n; i++) {
		t = p[0];
		p[0] = p[3];
		p[3] = t;
		t = p[1];
		p[1] = p[2];
		p[2] = t;
		p += 4;
	}
}

/*
 * swap n bytes in a char array
 */
void
swap_n_bytes (unsigned char *p, unsigned long n)
{
	unsigned char t;
	unsigned int i, h;

	h = n--/2;
	for (i = 0; i < h; i++) {
		t = *(p+i);
		*(p+i) = *(p+(n-i));
		*(p+(n-i)) = t;
	}
}

/*
 *
 */

/*
 * wrapper for gzwrite
 */
int
zwrite (void *buffer, unsigned int size, unsigned int memb, void *fp)
{
#ifdef HAVE_LIBZ
	return (gzwrite (fp, buffer, size * memb));
#else
	return (fwrite (buffer, size, memb, fp));
#endif
}

/*
 * wrapper for jpeg lib
 */
int
jwrite (void *buffer, unsigned int size, unsigned int memb, void *gp)
{
#ifdef HAVE_LIBJPEG
	static JSAMPROW row_ptr[1];
	row_ptr[0] = buffer;
	return (jpeg_write_scanlines(gp, row_ptr, 1));
#else
	return (fwrite (buffer, size, memb, (FILE *)gp));
#endif
}

/*
 * wrapper for png lib
 */
int
xv_pwrite (void *buffer, unsigned int size, unsigned int memb, void *gp)
{
#ifdef HAVE_LIBPNG
	png_write_row (gp, buffer);
	return (1);
#else
	return (fwrite (buffer, size, memb, (FILE *)gp));
#endif
}

