/*
 * sound.h
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HasOSS
#ifdef linux
#include <linux/soundcard.h>
#else
#include <sys/soundcard.h>
#endif
#endif

#define SND_MONO	1
#define SND_STEREO	2
#define SND_16TO8	4
#define SND_8BIT	8
#define SND_16BIT	16
#define SND_32BIT	32

#define SNDBUFFER	4096

int snd_init (char *sound_device);
int snd_open_play (void);
int snd_close_play (void);
int snd_open_rec (void);
int snd_close_rec (void);
int snd_play_data(unsigned char *buf, int size, int offset);
int snd_rec_data(unsigned char *buf, int max_size);
int snd_set_samplesize (int samplesize);
int snd_set_speed (int speed);
int snd_set_stereo (int boolval);
int snd_set_channels (int);
int snd_get_blksize (void);
int snd_get_fmts (void);
int snd_set_fmt (int);
int snd_set_trigger_out (void);
int snd_sync (void);
int snd_post (void);
int snd_reset (void);
int snd_wave_length (unsigned char *header);
int snd_wave_info (unsigned char *header, int *mode);
int snd_wave_prepare (int *speed, int *mode);
int snd_wave_prepare_header (int speed, int mode, char **dst);
int snd_get_interval (int blksize, int speed, int mode);
unsigned int snd_get_caps (void);
int snd_has_feature(unsigned int feature);
#define snd_has_duplex()	snd_has_feature(DSP_CAP_DUPLEX)
#define snd_has_realtime()	snd_has_feature(DSP_CAP_REALTIME)
#define snd_has_batch()		snd_has_feature(DSP_CAP_BATCH)
#define snd_has_trigger()	snd_has_feature(DSP_CAP_TRIGGER)
#define snd_has_mmap()		snd_has_feature(DSP_CAP_MMAP)

