/*
 * parse_gt.c
 * gnutime test program
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "gnutime.h"

void
usage (char *pname)
{
	fprintf (stderr, "Usage: %s <file>\n", pname);
	exit(1);
}

int
main (int argc, char *argv[])
{
	char *file, *p;
	FILE *fp;
	gt_atom *moov, *gt;
	int type, size, i, j;

	if (argc < 2) {
		usage (argv[0]);
	}
	file = argv[1];
	fp = fopen (file, "rb");
	if (!fp) {
		perror (file);
		exit(2);
	}
		p = (char *) &type;
	while (1) {
		if (gt_read4byte (&size, fp) < 4)
			break;
		if (gt_read4byte (&type, fp) < 4)
			break;
		printf ("position: %08d, atom type: %c%c%c%c, size: %d bytes\n",
				ftell(fp)-8, *(p+3), *(p+2), *(p+1), *(p), size);
		if (type == ATOM_movie) {
			fseek (fp, -8, SEEK_CUR);
			moov = gt_get_movie (fp);
			if (moov) {
				for (i = 0; i < moov->memb; i++) {
					if (moov->suba[i]->type == ATOM_track) {
						printf (" -> track\n");
						gt = moov->suba[i];
						for (j = 0; j < gt->memb; j++) {
							if (gt->suba[j]->type == ATOM_media) {
								printf ("  -> media\n");
							}
						}
					}
				}
			}
		} else
			fseek (fp, size-8, SEEK_CUR);
	}
	fclose (fp);
	return (0);
}

