/*
 * gttypes.h
 * GnuTime module
 *
 * Copyright (C) 1998,99 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTTYPES_H__
#define __GTTYPES_H__

#include <gt/gtatoms.h>

#define ui32 unsigned int
#define si32 signed int
#define ui16 unsigned short
#define si16 signed short
#define byte unsigned char

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define MAX_SUBATOMS	16	/* max subatoms in a container atom */
#define MAX_USERDATA	16	/* */

enum {
	GT_MOVIE,
	GT_IMAGE,
	GT_QTVR,
};

/* 32 bit fixed point number, <16bit>.<16bit>
 */
typedef struct {
	unsigned short high;
	unsigned short low;
} fp32;

/* 16 bit fixed point number, <8bit>.<8bit>
 */
typedef struct {
	unsigned char high;
	unsigned char low;
} fp16;

typedef struct c_atom {
	ui32 size;
	ui32 type;
	void *data;
	/* for private state */
	ui32 memb;				/* number of subatoms */
	struct c_atom **suba;	/* subatoms */
} gt_atom;

typedef gt_atom
	gt_moov_atom, gt_trak_atom, gt_mdia_atom, gt_dinf_atom, gt_stbl_atom,
	gt_minf_atom, gt_gmhd_atom;

#define GT_IS_CONTAINER(c) (\
	c->type == GTA_movie		||\
	c->type == GTA_track		||\
	c->type == GTA_media		||\
	c->type == GTA_media_info	||\
	c->type == GTA_data_info	||\
	c->type == GTA_sample_table ||\
	c->type == GTA_edit			||\
	c->type == GTA_base_media_header)

/*
 * movie data atom
 */
typedef struct {
	ui32 size;
	ui32 type;			/* 'mdat' */
	byte *data;
} mdat_atom, free_atom, skip_atom;

/*
 * movie header atom
 */
typedef struct {
	ui32 size;			/* size of atom in bytes: 108 */
	ui32 type;			/* type of atom 'mvhd' */
	byte version;		/* version of atom */
	byte flags[3];		/* not used */
	ui32 ctime;			/* in sec. form 1. Jan 1904 */
	ui32 mtime;			/* -"- */
	ui32 time_scale;	/* number of time units that passes per second */
	ui32 duration;		/* time of the movie in time scale units */
	fp32 pref_rate;	/* fmt:2.2 rate at which to play the movie */
	fp16 pref_volume;	/* fmt:2.2 preferred volume, 1.0 */
	byte reserved[10];	/* */
	byte matrix[36];	/* */
	ui32 preview_time;	/* */
	ui32 preview_duration;	/* */
	ui32 poster_time;	/* */
	ui32 sel_time;		/* */
	ui32 sel_duration;	/* selection duration */
	ui32 current_time;	/* */
	ui32 next_track_id; /* */
} gt_mvhd_atom;

/*
 * media header leaf atom
 */
typedef struct {
	ui32 size;			/* size: 32 */
	ui32 type;			/* mdhd */
	byte version;		/* 0 */
	byte flags[3];		/* 0 */
	ui32 ctime;
	ui32 mtime;
	ui32 time_scale;	/* number of time units per second */
	ui32 duration;		/* duration in time units */
	ui16 language;
	ui16 quality;
} gt_mdhd_atom;

/*
 * handler reference atom
 */
typedef struct {	
	ui32 size;			/* size: 32 + 1 + n */
	ui32 type;			/* 'hdlr' */
	byte version;		/* 0 */
	byte flags[3];		/* 0 */
	ui32 comp_type;		/* 'mhlr' or 'dhlr' */
	ui32 comp_subtype;	/* 'vide' or 'soun' for mhlr-atoms */
	ui32 comp_man;		/* manufacurere */
	ui32 comp_flags;
	ui32 comp_flags_mask;
	byte *comp_name;	/* variable length, pascal string */
} gt_hdlr_atom;

/*
 * video media information header leaf atom
 */
typedef struct {
	ui32 size;			/* size: 20 */
	ui32 type;			/* 'vmhd' */
	byte version;		/* */
	byte flags[3];		/* */
	ui16 grmode;
	ui16 opcolor[3];
} gt_vmhd_atom, gt_smhd_atom;

/*
 * base media info atom
 */
typedef struct {
	ui32 size;			/* */
	ui32 type;			/* gmin */
	byte version;
	byte flags[3];
	ui16 grmode;
	ui16 opcolor[3];
	ui16 balance;
	ui16 reserved;
} gt_gmin_atom;

/*
 * dref entry
 */
typedef struct {
	ui32 size;				/* size */
	ui32 type;				/* eg. alis */
	byte version;
	byte flags[3];			/* only 0x0001 defined */
	byte *data;
} gt_dref_entry;

/*
 * data reference atom
 */
typedef struct {
	ui32 size;			/* size: 16 + n * sizeof(dref_entry) */
	ui32 type;			/* 'dref' */
	byte version;		/* version of data reference */
	byte flags[3];		/* 0 */
	ui32 count;			/* number of table entries */
	gt_dref_entry *tab;	/* data reference information */
} gt_dref_atom;

/*
 * is this used only for movies?
 */
typedef struct {
	ui32 size;			/* len: 86 */
	ui32 format;		/* 'cvid', 'jpeg', 'raw ', 'YUV2', .. */
	byte reserved[6];	/* set to '0' */
	ui16 index;			/* data reference index for data ref atom */
	ui16 version;		/* */
	ui16 rev_level;
	ui32 vendor;		/* !4 chars */
	ui32 temp_qual;		/* temporal quality 0..1023 */
	ui32 spat_qual;		/* spacial quality 0..1023 */
	ui16 width;
	ui16 height;
	fp32 hres;			/* horizontal resolution in pixels per inch */
	fp32 vres;			/* vertical - " - */
	ui32 data_size;		/* must be set to 0 */
	ui16 frame_count;
	byte comp_name[32];	/* compress name, e.g. jpeg */
	ui16 depth;			/* color depth, 1, 2, 4, 8, 16, 24 or 32, or 34,36,40 */
	si16 ctab_id;		/* if -1 use default color table */
} gt_stsd_entry;

/*
 * sample description table entry for panoramas
 */
typedef struct {
	ui32 size;			/* length: 152 */
	ui32 format;		/* 'pano' */
	byte reserved1[6];	/* 0 */
	ui16 index;			/* data reference index for data ref atom */
	ui32 version;		/* major/minor version */
	ui32 track_id;		/* !scene track id */
	ui32 lowres_id;		/* low res scene track id */
	byte reserved2[24];	/* 0 */
	ui32 hotspot_id;	/* hot spot track id */
	byte reserved3[36];	/* 0 */
	fp32 hpan_start;	/* hPan start */
	fp32 hpan_end;		/* hPan end */
	fp32 vpan_top;		/* vertical pan top (tilt) */
	fp32 vpan_bottom;	/* vertical pan bottom (tilt) */
	fp32 min_zoom;		/* */
	fp32 max_zoom;		/* */
	ui32 size_x;		/* scene size x */
	ui32 size_y;		/* scene size y */
	ui32 no_frames;		/* number of frames */
	ui16 reserved4;		/* 0 */
	ui16 no_frames_x;	/* scene number of frames x */
	ui16 no_frames_y;	/* scene number of frames y */
	ui16 color_depth;	/* scene color depth */
	ui32 hs_size_x;		/* hotspot size x */
	ui32 hs_size_y;		/* hotspot size y */
	ui16 reserved5;		/* 0 */
	ui16 hs_no_frames_x;/* hotspot number of frames x */
	ui16 hs_no_frames_y;/* hotspot number of frames y */
	ui16 hs_color_depth;/* hotspot color depth */
} gt_stsd_pano_entry;

/*
 * sample description leaf atom
 */
typedef struct {
	ui32 size;			/* 16 + n * 86 */
	ui32 type;			/* stsd */
	byte version;		/* version of sample */
	byte flags[3];		/* not used */
	ui32 count;			/* number of sample descriptions that follow */
	gt_stsd_entry *tab;	/* sample description table */
} gt_stsd_atom;

typedef struct {
	ui32 num_samples;	/* num. of consecutive samples that have the same dur.*/
	ui32 duration;		/* dureation of the sample */
} gt_stts_entry;

/*
 * time to sample leaf atom
 */
typedef struct {
	ui32 size;
	ui32 type;
	byte version;
	byte flags[3];
	ui32 count;			/* number of entries */
	gt_stts_entry *tab;	/* */
} gt_stts_atom;

/*
 */
typedef struct {
	ui32 size;
	ui32 type;
	byte version;
	byte flags[3];
} gt_stss_atom;

/*
 * stsc table entry
 */
typedef struct {
	ui32 first_chunk;
	ui32 samples_per_chunk;	/**/
	ui32 sample_id;			/* id num of the stsd */
} gt_stsc_entry;

/*
 * sample to chunk leaf atom
 */
typedef struct {
	ui32 size;			/* size: 16 + n * 12 */
	ui32 type;			/* stsc */
	byte version;		/* */
	byte flags[3];		/* set to 0 */
	ui32 count;			/* number of entries */
	gt_stsc_entry *tab;	/* table entries */
} gt_stsc_atom;

/*
 */
typedef struct {
	ui32 size;
} gt_stsz_entry;

/*
 * sample size atom
 */
typedef struct {
	ui32 size;			/* size: 20 + n * 4 */
	ui32 type;
	byte version;
	byte flags[3];
	ui32 sample_size;
	ui32 count;
	gt_stsz_entry *tab;	/* sample size table */
} gt_stsz_atom;

/*
 */
typedef struct {
	ui32 offset;		/* chunk offset */
} gt_stco_entry;

/*
 * sample chunk offset atom
 */
typedef struct {
	ui32 size;		/* size: 16 + n * stco_entry */
	ui32 type;		/* stco */
	byte version;
	byte flags[3];
	ui32 count;		/* number of table entries */
	gt_stco_entry *tab;
} gt_stco_atom;

/*
 */
typedef struct {
	ui32 size;
	ui32 type;
	byte version;
	byte flags[3];
} gt_stsh_atom;

/*
 * track header atom
 */
typedef struct {
	ui32 size;			/* size of atom in bytes: 92 */
	ui32 type;			/* "tkhd" */
	byte version;		/* zero */
	byte flags[3];		/* enable:0x0001, in movie:0x0002, in prev:0x0004 */
	ui32 ctime;
	ui32 mtime;
	ui32 track_id;
	ui32 reserved1;
	ui32 duration;
	ui32 reserved2[2];
	ui16 layer;
	ui16 alternate_group;
	fp16 volume;		/* fixed point number, 1.0 default */
	ui16 reserved3;
	byte matrix[36];
	fp32 width;
	fp32 height;
} gt_tkhd_atom;

/*
 */
typedef struct {
	ui32 size;
	ui32 type;
	/* todo */
} clip_atom;

/*
 */
typedef struct {
	ui32 size;	/* size */
	ui32 type;	/* type, eg. LOOP */
	ui16 tlen;	/* text length */
	ui16 lang;	/* language */
	byte *text;	/* string */
} gt_udta_entry;

/*
 * user data atom, todo
 */
typedef struct {
	ui32 size;			/* */
	ui32 type;			/* udta */
	ui32 count;			/* internal counter, not written to file!*/
	gt_udta_entry *tab[MAX_USERDATA];	/* list of user data entries */
} gt_udta_atom;

/*
 * todo
 */
typedef struct {
} ctab_atom;

/*
 * movie types
 */
typedef enum {
	GT_MOVIE_SIMPLE = 1,
	GT_MOVIE_PANO,
} gtMovieType;

/*
 */
typedef struct {
	gtMovieType type;	/* type */
	int max_subs;
	gt_mvhd_atom *mvhd;
	gt_atom *moov;
	gt_atom *mdat;
	char *file;			/* file name */
} gt_movie;

/*
 * general purpose image structure
 */
typedef struct {
	int width;
	int height;
	int depth;	/* bytes per pixel */
	int bpp;	/* bits per pixel */
	int type;	/* YUV, RGB, .. */
	int size;
	char *img;
} gt_image;
#endif

