/*
 * gtatoms.h
 * GnuTime module
 *
 * Copyright (C) 1998,99 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTATOMS_H__
#define __GTATOMS_H__

/* gnutime atom types
 */
#define GTA_free			0x66726565	/* free */
#define GTA_skip			0x736B6970	/* skip */
#define GTA_movie			0x6D6F6F76	/* moov */
#define GTA_movie_header	0x6D766864	/* mvhd */
#define GTA_movie_data		0x6D646174	/* mdat */
#define GTA_track			0x7472616B	/* trak */
#define GTA_track_header	0x746b6864	/* tkhd */
#define GTA_edit			0x65647473	/* edts */
#define GTA_edit_list		0x656C7374	/* elst */
#define GTA_media			0x6D646961	/* mdia */
#define GTA_media_header	0x6D646864	/* mdhd */
#define GTA_handler_ref		0x68646C72	/* hdlr */
#define GTA_color_table		0x63746162	/* */
#define GTA_user_data		0x75647461	/* udta */
#define GTA_media_info		0x6D696E66	/* minf */
#define GTA_video_media_header	0x766D6864	/* vmhd */
#define GTA_sound_media_header	0x736D6864	/* smhd */
#define GTA_base_media_header	0x676D6864	/* gmhd */
#define GTA_base_media_info 	0x676D696E	/* gmin */
#define GTA_data_info		0x64696E66	/* dinf */
#define GTA_data_ref		0x64726566	/* dref */
#define GTA_sample_table	0x7374626C	/* stbl */
#define GTA_sample_desc		0x73747364	/* stsd */
#define GTA_time_to_sample	0x73747473	/* stts */
#define GTA_sample_size		0x7374737A	/* stsz */
#define GTA_chunk_offset	0x7374636F	/* stco */
#define GTA_sample_to_chunk 0x73747363	/* stsc */
#define GTA_sync_sample		0x73747373	/* stss */

#define GTA_world_header    0x76727363  /* vrsc */
#define GTA_imaging_parent  0x696D6770  /* imgp */

#define GT_MEDIA_REF	0x6D686C72	/* mhlr */
#define GT_DATA_REF		0x64686C72	/* dhlr */
/* media types
 */
#define GT_VIDEO		0x76696465	/* vide */
#define GT_SOUND		0x736F756E	/* soun */
#define GT_PANORAMA		0x70616E6F	/* pano */
#define GT_N_PANO		0x5354706E	/* STpn */
#define GT_N_QTVR		0x71747672	/* qtvr */
#define GT_ALIAS		0x616C6973	/* alis */
#define GT_COMP_MAN		0x40676E75	/* @gnu */
#define GT_MID_HDLR_NAME "GNU Media Handler"
/* video track data format */
#define GT_COMP_RAW		"Uncompressed"
#define GT_COMP_JPEG	"Joint Picture Expert Group"
#define GT_COMP_PNG		"Portable Network Graphics"

#define GT_VID_FMT_CVID	0x63766964	/* 'cvid' */
#define GT_VID_FMT_RAW	0x72617720	/* 'raw ' */
#define GT_VID_FMT_JPEG	0x6A706567	/* 'jpeg' */
#define GT_VID_FMT_YUV2	0x59555632	/* 'YUV2' */
#define GT_VID_FMT_PNG	0x706E6720	/* 'png ' */
#define GT_VID_FMT_PANO	0x70616E6F	/* 'pano' */

#define GT_SND_FMT_RAW	0x72617720	/* 'raw ' */
#define GT_SND_FMT_TWOS	0x74776F73	/* 'twos' */
#define GT_SND_FMT_yLAW	0xB56C6177	/* 'law' */

#define GT_UD_COPYRIGHT		0xA9637079	/* 'cpy' */
#define GT_UD_DAY			0xA9646179	/* 'day' */
#define GT_UD_DIRECTOR		0xA9646972	/* 'dir' */
#define GT_UD_INFO			0xA9696E66	/* 'inf' */
#define GT_UD_PRODUCER		0xA9707264	/* '@prd' */
#define GT_UD_LOOP			0x4C4F4F50	/* 'LOOP' */
#define GT_UD_CONTR_TYPE	0x63747970	/* 'ctyp' */
#define GT_UD_CONTR_DATA	0x5354706E	/* 'STpn' */

#endif
