/*
	 xslideshow.h

	 Author:	 Susumu Shiohara (shiohara@tpp.epson.co.jp)

			Copyright 1993-1997 by Susumu Shiohara

					 All Rights Reserved

*/

/* include files */
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include <X11/extensions/shape.h>

#if defined _EDIT
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Command.h>
#endif

#if defined ( _X11R4 )
typedef char *XPointer;
#endif

#define MIN(A,B) ((A)<(B)?(A):(B))
#define MAX(A,B) ((A)<(B)?(B):(A))
#define ABS(A,B) ((A)<(B)?(B)-(A):(A)-(B))

#define MAX_TEXT_LEN 512
#define MAX_WINDOW_NUM 50

typedef unsigned char	byte;
typedef unsigned short	word;
typedef unsigned long	dword;

typedef enum {
	IS_NONE=0,
	IS_GIF,
	IS_JPG
} FileType;

typedef enum {
	ERR_NO_ERR=0,
	ERR_FILE_RW,
	ERR_GIF_DATA,
	ERR_JPG_DATA,
	ERR_NO_FILE,
	ERR_SCREEN,
	ERR_IMAGE,
	ERR_COLOR,
} ErrStatus;

typedef enum {
/* Thank you for giving idea 
	by grina@fai.com (Peter Grina) and Dr Eberhard W Lisse <el@lisse.na> */
	ACTION_NOTHING    =0x0000,
	ACTION_SLEEP      =0x0001,	/* Sleep flag (Picture displaying time) */
								/* Cleared by HEAD,TAIL,NEXT,PREV actions */
	ACTION_HEAD_FRAME =0x0002,	/* Go to head of the file list flag */
								/* One time action */
	ACTION_TAIL_FRAME =0x0004,	/* Go to tail of the file list flag */
								/* One time action */
	ACTION_NEXT_FRAME =0x0008,	/* Go to next picture flag */
								/* Continuous action */
	ACTION_PREV_FRAME =0x0010,	/* Go to prev picture flag */
								/* Continuous action */
	ACTION_PAUSE_FRAME=0x0020	/* Pause action */
								/* Toggled */
} ActionStatus;

#if defined (IS_MAIN)
# define WHERE
static char *errstrs[] = {
	"No errs",				/* Never use */
	"Can't open file",		/* File open error */
	"Corrupt GIF file",		/* GIF data error */
	"Corrupt JPEG file",	/* JPEG data error */
	"No valid files",		/* No files */
	"Sorry, xslidehsow support only Pseudo and True color display",
	"Can't create XImage",	/* Reduce or XImage error */
	"Too small color entries < 8",
	"",
	"",
	"",
	"",
	"",
};
# if defined(SYSV) || defined(SVR4)	/* For Solaris2.x or other System V OS */

#   if defined(__STDC__) || defined(__cplusplus)
static void usleep (unsigned long usecs)
#   else
static void usleep (usecs)
unsigned long usecs;
#   endif
{
  struct timeval tv;
  tv.tv_sec  = usecs / 1000000L;
  tv.tv_usec = usecs % 1000000L;
  (void)select(0, 0, 0, 0, &tv);
}

# endif
#else
# define WHERE extern
#endif



#define IS_BIG_ENDEAN 0
#define IS_LITTLE_ENDEAN 1
WHERE dword			Endean;

WHERE ActionStatus	click;
WHERE Boolean		gotSomeAction;
WHERE Display		 *theDisp;
WHERE int			theScreenNumber;
WHERE Colormap		theCmap;
WHERE Colormap		defCmap;
WHERE Window		theWindow;
WHERE GC			fontGC;
WHERE dword			bcol, wcol;
WHERE dword			dbcol, dwcol;
WHERE Visual		*theVisual;
WHERE int			theDepth;
WHERE XImage		*theImage;
WHERE XColor		xcolors[256];
WHERE XColor		fcolors[256];
WHERE Pixel			pixels[256];
WHERE int			windowWidth,windowHeight;
WHERE int			newWindowWidth,newWindowHeight;
WHERE int			prevWindowWidth,prevWindowHeight;
WHERE int			movep;
WHERE int			allocatedColorNum;
WHERE int			allocatedSysColorNum;
WHERE FileType		fileType;
WHERE FILE			*fp;
WHERE int			pauseToggle;
WHERE Boolean		useGlobalCmap;

typedef struct {
		char	*geometry;
		Boolean help;
		Boolean debug;
		Boolean verbose;
		Boolean root;
		Boolean full;
		Boolean override;
		Boolean fit;
		Boolean maxfit;
		Boolean resize;
		Boolean privateCmap;
		Boolean forceChange;
		Boolean doGifAnim;
		Boolean perfect;
		Boolean showFileName;
		Boolean showFilePath;
		Boolean clock;
		Boolean clockMilitary;
		Boolean clockSeconds;
		Boolean biff;
		XFontStruct *font;
		char	*translations;
		int		color;						/* Color num */
		char	*reduce;
		char	*zoom;
		dword	intervalTime;				/* Display time */
		char	*mail_spool;				/* mail spool directory */
		char	*fileSelectionMode;			/* random or sequent */
		char	*animate;				 	/* Animation mode */
		char	*animateList;
		int		gifAnimTicks;
		Boolean	gifAnimFade;
		int		mosaicTicks;
		int	 	fadeSteps, fadeTicks;		/* Animate Fade */
		int	 	wipeSteps, wipeTicks;		/* Animate Wipe */
		int	 	moveSteps, moveTicks;		/* Animate Move */
		int		float24Steps, float24Ticks;
		int		floatImageSize, floatImageLifeTime;
		int	 	blockSteps;					/* Animate Block */
		int	 	reverseSteps, reverseTicks;	/* Animate reverse */
		int	 	flushSteps, flushTicks;		/* Animate flush */
		int		flushCount;
		int		monotoneSteps, monotoneTicks;	 /* Animate monotone */
		char	*colorAnimSort;				/* Animate color */
		int		colorAnimTicks;
		char	*shuffleSort;				/* Animate shuffle */
		int		shuffleSteps,shuffleTicks;
		Boolean	shuffleFade;
		int		puzzleSteps,puzzleTicks;	/* Animate puzzle */
		Boolean	puzzleFade;
		char	*slitSort;					/* Animate slit */
		int		slitSteps,slitTicks;
		Boolean	slitFade;
		char	*transparentMode;
		int		moveOnTheLineTicks;			/* move on the bresenham line */
		int		borderWidth;				/* Puzzle and Shuffle block border width */
		char	*pathDir;					/* Display file dir */
		char	*destDir;					/* Destination dir */
		Boolean confirm;
}ApplicationData, *ApplicationDataPtr;

WHERE ApplicationData app_data;

typedef struct _SUBGIMAGE{
	struct _SUBGIMAGE *next;
	Boolean isTop;
	int	bits_per_pixel;	/* Bits per pixel */
	int	width;			/* image width */
	int	height;			/* image height */
	int	mapsize;		/* used color map size */
	word red[256];		/* red color map */
	word green[256];	/* green color map */
	word blue[256];		/* blue color map */
	byte *image;		/* image data */
} SUBGIMAGE;			/* General Image Format */

typedef struct {
	SUBGIMAGE *subImageList;
	dword *pTrueColor;
	short *pTrueColorIdx;
	Visual visual;
	XPixmapFormatValues pmf;
} GIMAGE;

WHERE GIMAGE gim;

#define MAX_COLOR_24     32768  /* 5x5x5 */
#define R_MASK   0x7c00
#define G_MASK   0x03e0
#define B_MASK   0x001f
#define GET_R(c) (byte)((int)((c) & R_MASK) >> 10)
#define GET_G(c) (byte)((int)((c) & G_MASK) >> 5)
#define GET_B(c) (byte)((c) & B_MASK)
#define PUT_RGB(r,g,b) (word)((((int)r << 7) & R_MASK) + (((int)g << 2) & G_MASK) + (((int)b >> 3) & B_MASK))
#define GET_RGB(c) (int)(((c)))
#define GET_GBR(c) (int)((int)((c) & R_MASK) >> 10 | (int)((c) & G_MASK) << 5 | (int)((c) & B_MASK) << 5)
#define GET_GRB(c) (int)((int)((c) & R_MASK) >> 5 | (int)((c) & G_MASK) << 5 | (int)((c) & B_MASK))
#define GET_BRG(c) (int)((int)((c) & R_MASK) >> 5 | (int)((c) & G_MASK) >> 5 | (int)((c) & B_MASK) << 10)
#define GET_BGR(c) (int)((int)((c) & R_MASK) >> 10 | (int)((c) & G_MASK) | (int)((c) & B_MASK) << 10)

#define MAX_COLOR_24_565 65536  /* 5x6x5 */
#define R_MASK565   0xf800
#define G_MASK565   0x07e0
#define B_MASK565   0x001f
#define GET_R565(c) (byte)((int)((c) & R_MASK565) >> 11)
#define GET_G565(c) (byte)((int)((c) & G_MASK565) >> 5)
#define GET_B565(c) (byte)((c) & B_MASK565)
#define PUT_RGB565(r,g,b) (word)((((int)r << 8) & R_MASK565) + (((int)g << 3) & G_MASK565) + (((int)b >> 3) & B_MASK565))
#define GET_RGB565(c) (int)(((c)))
#define GET_GBR565(c) (int)((int)((c) & R_MASK565) >> 11 | (int)((c) & G_MASK565) << 6 | (int)((c) & B_MASK565) << 6)
#define GET_BRG565(c) (int)((int)((c) & R_MASK565) >> 6 | (int)((c) & G_MASK565) >> 6 | (int)((c) & B_MASK565) << 11)


#define ACT_PAUSE_ON(act)  ((act) |=  ACTION_PAUSE_FRAME)
#define ACT_PAUSE_OFF(act) ((act) &= ~ACTION_PAUSE_FRAME)
#define ACT_SLEEP_ON(act)  ((act) |=  ACTION_SLEEP)
#define ACT_SLEEP_OFF(act) ((act) &= ~ACTION_SLEEP)
#define ACT_TAIL_ON(act)   ((act) |=  ACTION_TAIL_FRAME)
#define ACT_TAIL_OFF(act)  ((act) &= ~ACTION_TAIL_FRAME)
#define ACT_HEAD_ON(act)   ((act) |=  ACTION_HEAD_FRAME)
#define ACT_HEAD_OFF(act)  ((act) &= ~ACTION_HEAD_FRAME)
#define ACT_NEXT_ON(act)   ((act) |=  ACTION_NEXT_FRAME)
#define ACT_NEXT_OFF(act)  ((act) &= ~ACTION_NEXT_FRAME)
#define ACT_PREV_ON(act)   ((act) |=  ACTION_PREV_FRAME)
#define ACT_PREV_OFF(act)  ((act) &= ~ACTION_PREV_FRAME)

#define IS_SLEEP_ON(act)   ((act) & ACTION_SLEEP)
#define IS_SLEEP_OFF(act)  (!((act) & ACTION_SLEEP))
#define IS_PAUSE_ON(act)   ((act) & ACTION_PAUSE_FRAME)
#define IS_PAUSE_OFF(act)  (!((act) & ACTION_PAUSE_FRAME))
#define IS_HEAD_ON(act)    ((act) & ACTION_HEAD_FRAME)
#define IS_PREV_ON(act)    ((act) & ACTION_PREV_FRAME)
#define IS_NEXT_ON(act)    ((act) & ACTION_NEXT_FRAME)
#define IS_TAIL_ON(act)    ((act) & ACTION_TAIL_FRAME)

#if !defined(SEEK_SET)
# define SEEK_SET 0 /* set position equal to offset bytes */
#endif

#if !defined(SEEK_CUR)
# define SEEK_CUR 2 /* set position to current location plus offset */
#endif

#if !defined(SEEK_END)
# define SEEK_END 2 /* set position to EOF plus offset */
#endif


