/***************************** gif2gimage *******************************

			Copyright 1993-1997 by Susumu Shiohara

					 All Rights Reserved

	All the code for reading and converting the GIF image is 
	Ryuuji Oomoto's gif2map (oomoto@tpp.epson.co.jp).

	"The Graphics Interchange Format(c) is the Copyright property of
	CompuServe Incorporated. GIF(sm) is a Service Mark property of
	CompuServe Incorporated."

************************************************************************/

#include "xslideshow.h"

extern void goodbyekiss();
extern void myevent();

#define IEND1	 4096
static int count,c,c2,code,cdm,bt0,cd2,cd3,msk,head,ap,pixel;
static int reset_dic,data_end;
static int nd0[IEND1],nd1[IEND1];
static int sft[13],dat[10];
static byte aa0,cc[IEND1],hd[IEND1],h[IEND1];
static long dbyte;
static SUBGIMAGE globalImage, *subImageList;
static int frame;

/*
*
*/
static void putsk()
{
	if(code >= IEND1)
		return;

	h[code]     = 1;
	hd[code]    = head;
	nd0[code]   = cd3;
	nd1[code++] = cd2;

	if (code >= cdm) {
		if(bt0 != 12)
			bt0++;
		cdm = cdm << 1;
	}
}

/*
*
*/
static int getc12()
{
	while(msk < bt0) {
		if(count == 0) {
			if((count = getc(fp)) == 0 || feof(fp)) {
				c2 = EOF;
				return(ERR_NO_ERR);
			}
		}
		count--;

		if((c2 = getc(fp)) == EOF)
			return(ERR_NO_ERR);

		dbyte = dbyte + ((long)c2 << msk);
		msk += 8;
	}

	c     = dbyte & sft[bt0];
	dbyte = dbyte >> bt0;
	msk  -= bt0;

	return(ERR_NO_ERR);
}

/*
*
*/
ErrStatus Do_gif2gimage()
{
int i,j,x,y,xmax,ymax;
int position,interlace,pass,xposi,yposi,yaddr;
int gifversion=0, done=False;
int status;
byte *dst=NULL;
char sign[7];

	/* Create shift table */
	for(j = 1,i = 0; i < 13; i++) {
		sft[i] = j-1;
		j = (j << 1);
	}


	/* Read GIF SIGNATURE */
	for(i = 0; i < 6; i++) sign[i] = getc(fp);
	sign[i] = (char)NULL;
	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"xslideshow: gif2gimage() %s\n",sign);
	if(feof(fp)) return(ERR_GIF_DATA);

	if((strncmp(sign, "GIF87a", 6)) == 0)
		gifversion = 87;
	else if((strncmp(sign, "GIF89a", 6)) == 0)
		gifversion = 89;

	if( gifversion == 0 ){
		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"xslideshow: gif2gimage() Error: not support version %s\n",sign);
		return(ERR_GIF_DATA);
	}


	/* Read SCREEN DESCRIPTOR */
	for(i = 0; i < 7; i++) {
		c = getc(fp);
		if(i == 4) j = c; /* Read Global colormap field */
	}
	if(feof(fp)) return(ERR_GIF_DATA);

	/* Check Global colormap */
	if((j & 0x80) == 0) {
		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"xslideshow: gif2gimage() Error: no color table\n");
		return(ERR_GIF_DATA);
	}


	/* Check bits per pixel in image */
	pixel = (j & 0x7) + 1;
	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"xslideshow: gif2gimage() bits per pixel = %d\n",pixel);


	/* Read the global colormap */
	globalImage.mapsize = 1 << pixel;
	for(i = 0; i < globalImage.mapsize; i++) {
		globalImage.red[i]   = getc(fp);
		globalImage.green[i] = getc(fp);
		globalImage.blue[i]  = getc(fp);
	}
	if(feof(fp)) return(ERR_GIF_DATA);


anim:

	if(gifversion == 87){
		while(!done){
			dat[0] = getc(fp);
			dat[1] = getc(fp);
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"xslideshow: gif2gimage() %02x %02x ",dat[0],dat[1]);
			if(feof(fp)) return(ERR_GIF_DATA);

			if(dat[0] == 0x21 && dat[1] == 0xfe){
				int comment_len, tmp_char;

				/* Skip Comment Extension */
				do {
					comment_len = getc(fp);
					if(app_data.verbose && app_data.debug)
						fprintf(stderr,"skip comment extension (%d byte)\n",comment_len);
					if(feof(fp)) return(ERR_GIF_DATA);

					for(i = 0; i < comment_len; i++){
						tmp_char = getc(fp);
						if(app_data.verbose)
							fprintf(stderr,"%c",tmp_char);
					}
					if(app_data.verbose) fprintf(stderr,"\n");
				} while (comment_len);

				if(app_data.verbose) fprintf(stderr,"\n");
			}

			else if(dat[0] == 0x2c){

				/* Read IMAGE DESCRIPTOR
					dat[0]	= Image Separator (0x2c)
					dat[1],dat[2] = left position
					dat[3],dat[4] = right position
					dat[5],dat[6] = width
					dat[7],dat[8] = height
					dat[9]	= misc, bits
				*/
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"read image descriptor\n");
				for(i = 2;i < 10;i++) dat[i] = getc(fp);
				if(feof(fp)) return(ERR_GIF_DATA);
				done = True;
			}
		}

		/* Read Image Width and Image Height */
		xmax = (dat[6] << 8) | dat[5];
		ymax = (dat[8] << 8) | dat[7];
	}

	else if(gifversion == 89){
		while(!done){
			dat[0] = getc(fp);
			dat[1] = getc(fp);
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"xslideshow: gif2gimage() %02x %02x ",dat[0],dat[1]);
			if(feof(fp)) return(ERR_GIF_DATA);

			if(dat[0] == 0x21 && dat[1] == 0xf9){

				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"skip graphic control extension\n");
				/* Skip Graphic Control Extension */
				for(i = 0; i < 6; i++) (void)getc(fp);
				if(feof(fp)) return(ERR_GIF_DATA);
			}

			else if(dat[0] == 0x21 && dat[1] == 0xfe){
				int comment_len, tmp_char;

				/* Skip Comment Extension */
				do {
					comment_len = getc(fp);
					if(app_data.verbose && app_data.debug)
						fprintf(stderr,"skip comment extension (%d byte)\n",comment_len);
					if(feof(fp)) return(ERR_GIF_DATA);

					for(i = 0; i < comment_len; i++){
						tmp_char = getc(fp);
						if(app_data.verbose) fprintf(stderr,"%c",tmp_char);
					}
					if(app_data.verbose) fprintf(stderr,"\n");
				} while (comment_len);

				if(app_data.verbose) fprintf(stderr,"\n");
			}

			else if(dat[0] == 0x21 && dat[1] == 0xff){
				int tmp_char;

				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"skip application extension\n");
				/* Skip Application Extension */
				while(1){
					tmp_char = getc(fp); if(feof(fp)) return(ERR_GIF_DATA);
					if(tmp_char == 0x00) break;
				}
			}

			else if(dat[0] == 0x21 && dat[1] == 0x01){
				int text_len, tmp_char;

				/* Skip Plain Text Extension */
				do {
					text_len = getc(fp);
					if(app_data.verbose && app_data.debug)
						fprintf(stderr,"skip plain text extension (%d byte)\n",text_len);
					if(feof(fp)) return(ERR_GIF_DATA);

					for(i = 0; i < text_len; i++){
						tmp_char = getc(fp);
						if(app_data.verbose) fprintf(stderr,"%c",tmp_char);
					}
				} while (text_len);
			}

			else{

				/* Read IMAGE DESCRIPTOR */
				if(dat[0]!=0x2c){
					while(dat[0] != 0x2c){
						dat[0] = getc(fp);
						if(feof(fp)) {
							if(dst == NULL) return(ERR_GIF_DATA);
							else goto allend;
						}
					}
					dat[1] = getc(fp); if(feof(fp)) return(ERR_GIF_DATA);
				}

				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"read image descriptor\n");

				/* Read IMAGE DESCRIPTOR
					dat[0]	= Image Separator (0x2c)
					dat[1],dat[2] = left position
					dat[3],dat[4] = right position
					dat[5],dat[6] = width
					dat[7],dat[8] = height
					dat[9]	= misc, bits
				*/
				for(i = 2; i < 10; i++) dat[i] = getc(fp);
				if(feof(fp)) return(ERR_GIF_DATA);
				done = True;
			}
		}

		/* Read Image Width and Image Height */
		xmax = (dat[6] << 8) | dat[5];
		ymax = (dat[8] << 8) | dat[7];
	}

	if(xmax == 0 || ymax == 0)
		return(ERR_GIF_DATA);

	if(gim.subImageList->image == (byte *)NULL){
		/* If this is the first frame */
		frame = 1;
		subImageList          = gim.subImageList;
		subImageList->next    = (SUBGIMAGE *)NULL;
		subImageList->isTop   = True;
		subImageList->mapsize = 1 << pixel;
		subImageList->width   = 0;
		subImageList->height  = 0;
	}
	else {
		/* This is not the first frame */
		frame++;
		subImageList->next    = (SUBGIMAGE *)XtMalloc(sizeof(SUBGIMAGE));
		subImageList          = subImageList->next;
		subImageList->next    = (SUBGIMAGE *)NULL;
		subImageList->isTop   = False;
		subImageList->image   = (byte *)NULL;
		subImageList->mapsize = 0;
		subImageList->width   = 0;
		subImageList->height  = 0;
	}

	if(app_data.verbose)
		fprintf(stderr,
				"xslideshow: gif2gimage() (%d x %d) frame (%d)\n",
				xmax, ymax, frame);

	/* If the image has local colormap, then use it. */
	if (dat[9] & 0x80) {
		subImageList->mapsize = 1 << ( (dat[9] & 0x7) + 1 );
		if(app_data.verbose)
			fprintf(stderr,
				"xslideshow: gif2gimage() use local colormap : mapsize = %d\n",
				subImageList->mapsize);

		for (i = 0; i< subImageList->mapsize;  i++) {
			subImageList->red[i] = getc(fp);
			subImageList->green[i] = getc(fp);
			subImageList->blue[i] = getc(fp);
		}
		if(feof(fp)) return(ERR_GIF_DATA);
	}

	/* Use previous image's colormap */
	else {
		subImageList->mapsize = globalImage.mapsize;
		if(app_data.verbose)
			fprintf(stderr,
				"xslideshow: gif2gimage() use global colormap : mapsize = %d\n",
				subImageList->mapsize);

		for(i = 0; i < subImageList->mapsize; i++) {
			subImageList->red[i]   = globalImage.red[i];
			subImageList->green[i] = globalImage.green[i];
			subImageList->blue[i]  = globalImage.blue[i];
		}
	}

	/* Check if Interlace or Sequential order */
	interlace = ((dat[9] & 0x40) ? True : False);
	if(app_data.verbose && app_data.debug)
		if(interlace)
			fprintf(stderr,"xslideshow: gif2gimage() interlace\n");


	/* Read pixel flag field */
	pixel = getc(fp); if(feof(fp)) return(ERR_GIF_DATA);

	reset_dic = (1 << pixel);
	data_end = (1 << pixel) + 1;

	if((dst = (byte *)XtCalloc(xmax * ymax, sizeof(byte))) == NULL){
		fprintf(stderr,"xslideshow: gif2gimage() memory allocation error\n");
		goodbyekiss();
	}
	subImageList->image          = dst;
	subImageList->width          = xmax;
	subImageList->height         = ymax;
	subImageList->bits_per_pixel = 8;
	
	/* Read RASTER DATA */
	count = 0;
	dbyte = 0;
	msk   = 0;
	code  = (1 << pixel) + 1;
	bt0   = pixel + 1;
	cdm   = (1 << bt0);
	cd2   = 0;
	x     = 0;
	y     = 0;

	for(i = 0; i < IEND1; i++) h[i]=0;

	if(interlace){
		xposi = 0;
 		yposi = yaddr = 0;
		pass  = 1;
	}
	else{
		position = 0;
	}

	while(1) {

loop:

		myevent();

		if((status = getc12()) != ERR_NO_ERR) return(status);
		if((c2 == EOF) || (c == data_end)) break;

		if (c == reset_dic) {
			code = (1 << pixel) + 1;
			bt0 = pixel + 1;
			cdm = (1 << bt0);
			for(i = 0; i < IEND1; i++) h[i]=0;
			cd2 = 0;
			goto loop;
		}

		if (c <	reset_dic) {
			aa0 = c;
			if(interlace){
				if(xposi >= xmax){
					switch(pass){
					case 1:
						xposi = 0;
						yposi += 8;
						if(yposi >= ymax){
							yposi = 4;
							pass++;
						}
						yaddr = yposi * xmax;
						break;
					case 2:
						xposi = 0;
						yposi += 8;
						if(yposi >= ymax){
							yposi = 2;
							pass++;
						}
						yaddr = yposi * xmax;
						break;
					case 3:
						xposi = 0;
						yposi += 4;
						if(yposi >= ymax){
							yposi = 1;
							pass++;
						}
						yaddr = yposi * xmax;
						break;
					case 4:
						xposi = 0;
						yposi += 2;
						yaddr = yposi * xmax;
						break;
					}
				}

				dst[yaddr + xposi] = c;
				xposi++;
			}
			else{
				dst[position++] = c;
			}

			x++;
			if(x == xmax) {
				x = 0;
				y++;
				if(y == ymax) goto allend;
			}
			cd3 = c;
			putsk();
			cd2 = head = cd3;
			goto loop;
		}

		if(c > code) {
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"xslideshow: gif2gimage() Error: data error <<%x>>.\n",code);
			return(ERR_NO_ERR);
		}

		if (h[c] == 0) cd3 = aa0;
		else cd3 = hd[c];
		putsk();
		head = cd3;
		i = c;
		ap = 0;

		while(i >= reset_dic) {
			cc[ap++] = nd0[i];
			i = nd1[i];
		}
		aa0 = cc[ap] = i;
		for(i = ap; i >= 0; i--) {
			if(interlace){
				if(xposi >= xmax){
					switch(pass){
					case 1:
						xposi = 0;
						yposi += 8;
						if(yposi >= ymax){
							yposi = 4;
							pass++;
						}
						yaddr = yposi * xmax;
						break;
					case 2:
						xposi = 0;
						yposi += 8;
						if(yposi >= ymax){
							yposi = 2;
							pass++;
						}
						yaddr = yposi * xmax;
						break;
					case 3:
						xposi = 0;
						yposi += 4;
						if(yposi >= ymax){
							yposi = 1;
							pass++;
						}
						yaddr = yposi * xmax;
						break;
					case 4:
						xposi = 0;
						yposi += 2;
						yaddr = yposi * xmax;
						break;
					}
				}
				dst[yaddr + xposi] = cc[i];
				xposi++;
			}
			else{
				dst[position++] = cc[i];
			}

			x++;
			if(x == xmax) {
				x = 0;
				y++;
				if(y == ymax) goto allend;
			}
		}

		cd2 = c;
		/* goto loop; */
	}

	if(x != 0 && y != ymax){
 		for(; y < ymax; y++){
			for(; x < xmax; x++){
				if(interlace){
					if(xposi >= xmax){
						switch(pass){
						case 1:
							xposi = 0;
							yposi += 8;
							if(yposi >= ymax){
								yposi = 4;
								pass++;
							}
							yaddr = yposi * xmax;
							break;
						case 2:
							xposi = 0;
							yposi += 8;
							if(yposi >= ymax){
								yposi = 2;
								pass++;
							}
							yaddr = yposi * xmax;
							break;
						case 3:
							xposi = 0;
							yposi += 4;
							if(yposi >= ymax){
								yposi = 1;
								pass++;
							}
							yaddr = yposi * xmax;
							break;
						case 4:
							xposi = 0;
							yposi += 2;
							yaddr = yposi * xmax;
							break;
						}
					}
					dst[yaddr + xposi] = 0x00;
					xposi++;
				}
				else{
					dst[position++] = 0x00;
				}
			}
			x = 0;
		}
	}

allend:

#if True
	/* support gif-anim */
	if(!feof(fp)) {
		if(app_data.verbose && app_data.debug)
			fprintf(stderr,
				"\rxslideshow: gif2gimage() subimage offset = 0x%x ",(int)ftell(fp));

		/* Find top of the next subimage */
		dat[0] = getc(fp); if(feof(fp)) return(ERR_NO_ERR);
		while(dat[0] != 0x21) {
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"(%02x) ",dat[0]);
			dat[0] = getc(fp);
			if(feof(fp)) {
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"\n");
				return(ERR_NO_ERR);
			}
		}
		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"\n");

		ungetc((byte)dat[0],fp);
		done = False;

		goto anim;
	}
#endif

	if(app_data.verbose)
		fprintf(stderr,"\rxslideshow: gif2gimage() gifdone.\n");

	return(ERR_NO_ERR);
}

#if defined(__STDC__) || defined(__cplusplus)
ErrStatus gif2gimage(char *fname)
#else
ErrStatus gif2gimage(fname)
char *fname;
#endif
{
ErrStatus status;

	/* Open a GIF file */
	if((fp = fopen(fname,"r")) == NULL) {
		if(app_data.verbose)
			fprintf(stderr,"xslideshow: Error: can't open %s\n",fname);
		return(ERR_FILE_RW);
	}

	if(app_data.verbose)
		fprintf(stderr,"xslideshow: gif2gimage() reading %s\n",fname);

	status = Do_gif2gimage();

	fclose(fp);

	if(status != ERR_NO_ERR){
		if(gim.subImageList->image != (byte *)NULL)
			status = ERR_NO_ERR;
	}
	return(status);
}

