/*
	biff.c - mail biff

	Author:   Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

				All Rights Reserved

*/

#include "xslideshow.h"
#include <sys/stat.h>

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern void XSlideshowRemoveWorkProc P_((int));
extern int XSlideshowAddWorkProc P_((void (*)(), dword, caddr_t));

static Window biffWindow;
static off_t fsize=0;
static int biffWxd,biffWw,biffWx,biffWy;
static int biffProcId;
static int scrollBiffProcId = -1;
static int do_biff=False;
static int textwidth,textheight;
static char biffMessage[] = {"You have new mail .... "};
static char cbuf[MAX_TEXT_LEN];

/* Biff window */
void removeBiffWindow()
{
	if(biffWindow != (Window)0){
		XSlideshowRemoveWorkProc(scrollBiffProcId);
		scrollBiffProcId = -1;
		XUnmapWindow(theDisp,biffWindow);
	}
}

void replaceBiffWindow()
{
    if(biffWindow != (Window)0){
		biffWx  = windowWidth;
		biffWxd = windowWidth;	/* default x axis position */
		biffWy  = (windowHeight-textheight)/2;
    }
}

#if defined(__STDC__) || defined(__cplusplus)
void scrollBiff(caddr_t client_data)
#else
void scrollBiff(client_data)
caddr_t client_data;
#endif
{
	biffWx -= 2;			/* update x axis position */
	if(biffWx < -biffWw)
		biffWx = biffWxd;	/* reset x axis position */

	XRaiseWindow(theDisp,biffWindow);
	XMoveWindow(theDisp, biffWindow, biffWx, biffWy);
}

#if defined(__STDC__) || defined(__cplusplus)
void updateBiff(caddr_t client_data)
#else
void updateBiff(client_data)
caddr_t client_data;
#endif
{
struct stat fstatus;

	fstatus.st_size = 0;

	if((stat(cbuf,&fstatus))== -1) {
		removeBiffWindow();
		do_biff = False;
		return;
	}

	/* You have new mail */
	if(fstatus.st_size > fsize){

		fsize = fstatus.st_size;

		if(!do_biff){
    		if(app_data.verbose)
				fprintf(stderr,"xslideshow: You have new mail .... \n");

			biffWx = biffWxd;	/* reset xaxis position */
			XMoveWindow(theDisp, biffWindow, biffWx, biffWy);
			XMapWindow(theDisp,biffWindow);
			XRaiseWindow(theDisp,biffWindow);

			/* Scroll eatch 100 msec */
   			scrollBiffProcId = XSlideshowAddWorkProc(scrollBiff, 100000, 0);
			do_biff = True;
		}

	/* You have read the mail and remove it from the mail spool */
	}else if(fstatus.st_size < fsize){

		fsize = fstatus.st_size;
		if(do_biff){
    		removeBiffWindow();
			do_biff = False;
		}

	/* You have mail */
	}else if(fstatus.st_size == fsize && fsize > 0){

		if(!do_biff){
    		if(app_data.verbose) fprintf(stderr,"xslideshow: You have mail .... \n");
			biffWx = biffWxd;
			XMoveWindow(theDisp, biffWindow, biffWx, biffWy);
			XMapWindow(theDisp,biffWindow);
			XRaiseWindow(theDisp,biffWindow);

			/* Scroll eatch 100 msec */
   			scrollBiffProcId = XSlideshowAddWorkProc(scrollBiff, 100000, 0);
			do_biff = True;
		}

	}
}

void initBiff()
{
Pixmap pic;
int d_h,f_a,f_d,len;
XCharStruct overall;
XGCValues gcv;
GC gc;
XSetWindowAttributes xswa;
struct stat fstatus;
char *user;

	/* Get user login name */
	if((user = (char *)getlogin()) == NULL)
		if((user = (char *)getenv("USER")) == NULL)
			return;

	/* Get mail spool path */
	strcpy(cbuf,app_data.mail_spool);
	if((len = strlen(cbuf)) == 0)
		return;	/* You have no mail spool */

	if(cbuf[len-1] != '/')
		strcat(cbuf,"/");
	strcat(cbuf,user);

	if(app_data.verbose)
		fprintf(stderr,"xslideshow: mail spool is %s\n",cbuf);
	
	/* Check if mail is exist */
	if((stat(cbuf,&fstatus)) == 0)
	    fsize=fstatus.st_size;
	
	/* Get text and font information */
	XTextExtents(
				app_data.font,
				biffMessage, strlen(biffMessage),
				&d_h, &f_a, &f_d, &overall );

	textwidth = (overall.lbearing<0 ? -overall.lbearing : overall.lbearing) + overall.rbearing;
	textheight = overall.descent+overall.ascent;

	/* Create the biff message window */
	biffWindow = XCreateSimpleWindow(
								theDisp,
								theWindow,
								windowWidth,
								(windowHeight + textheight) / 2,
								textwidth,
								textheight,
								0, dbcol,dbcol );

	biffWw  = textwidth;
	biffWx  = windowWidth;
	biffWxd = windowWidth;	/* default x axis position */
	biffWy  = (windowHeight - textheight) / 2;

	xswa.override_redirect = True;
	XChangeWindowAttributes(theDisp,biffWindow,CWOverrideRedirect,&xswa);

	pic = XCreatePixmap(
					theDisp,
					biffWindow,
					textwidth,
					textheight,
					DefaultDepth(theDisp,theScreenNumber) );

	gcv.function=GXcopy;
	gcv.foreground=dbcol;
	gc = XCreateGC(theDisp,pic,GCForeground | GCFunction,&gcv);
	XFillRectangle(theDisp,pic,gc,0,0,textwidth,textheight);
	XFreeGC(theDisp,gc);

	/* Draw biff message string */
	XDrawImageString(
					theDisp,
					pic,
					fontGC,
					(overall.lbearing < 0 ? -overall.lbearing : overall.lbearing),
					overall.ascent,
					biffMessage, strlen(biffMessage) );

	XSetWindowBackgroundPixmap(theDisp,biffWindow,pic);
	XClearWindow(theDisp,biffWindow);

	XFreePixmap(theDisp,pic);
	XLowerWindow(theDisp,biffWindow);

	/* Exec updateBiff() after 1 sec */
	biffProcId = XSlideshowAddWorkProc(updateBiff, 1000000, 0);
}

