/* Based on s3virge xv code from XFree86 */
/* $XFree86: xc/programs/Xserver/hw/xfree86/drivers/s3virge/s3v_xv.c,v 1.7 2003/02/04 02:20:50 dawes Exp $ */
/*
Copyright (C) 2000 The XFree86 Project, Inc.  All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FIT-
NESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
XFREE86 PROJECT BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the XFree86 Project shall not
be used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the XFree86 Project.
*/

/*
 * s3v_xv.c
 * X Video Extension support
 *
 * S3 ViRGE driver
 *
 * 7/2000 Kevin Brosius
 *
 * Useful references:
 * X Video extension support -> xc/programs/hw/xfree86/common/xf86xv.c
 *
 */

/*
 * I N C L U D E S
 */
#include "config.h"
#include "ivtvhw.h"
#include "ivtvdev.h"

#include "xf86.h"
#include "xf86xv.h"
#include <X11/extensions/Xv.h>
#include "fourcc.h"
#include "regionstr.h"
typedef struct ivtv_xv_portData
{
    unsigned int colorKey;
    RegionRec    clip;
    int		 autopaintColorKey;
}Ivtv_Xv_PortData;


#define IVTV_MAX_PORTS 1
#define MAKE_ATOM(a) MakeAtom(a, sizeof(a) - 1, TRUE)

#if !defined(XvExtension) || !defined(IVTV_IOC_PREP_FRAME_YUV)
void IvtvInitVideo(ScreenPtr pScreen)
{
    ErrorF("XVDriver disabled at compilation time\n");
}
#else

static XF86VideoAdaptorPtr IVTVSetupImageVideoOverlay(ScreenPtr);
static int IVTVSetPortAttributeOverlay(ScrnInfoPtr, Atom, INT32, pointer);
static int IVTVGetPortAttributeOverlay(ScrnInfoPtr, Atom, INT32 *, pointer);

static void IVTVStopVideo(ScrnInfoPtr, pointer, Bool);

static void IVTVQueryBestSize(ScrnInfoPtr, Bool, short, short, short, short,
			      unsigned int *, unsigned int *, pointer);
static int IVTVPutImage(ScrnInfoPtr, short, short, short, short, short,
			short, short, short, int, unsigned char *, short,
			short, Bool, RegionPtr, pointer);
static int IVTVQueryImageAttributes(ScrnInfoPtr, int, unsigned short *,
				    unsigned short *, int *, int *);

void IvtvInitVideo(ScreenPtr pScreen)
{
	ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
	XF86VideoAdaptorPtr *adaptors, *newAdaptors = NULL;
	XF86VideoAdaptorPtr newAdaptor = NULL;
	int num_adaptors;
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	if (!fPtr->yuvDevName)
		return;

	xf86DrvMsg(pScrn->scrnIndex, X_INFO,
		   "Enabling Xv support for PVR350\n");
	newAdaptor = IVTVSetupImageVideoOverlay(pScreen);

	num_adaptors = xf86XVListGenericAdaptors(pScrn, &adaptors);

	if (newAdaptor) {
		if (!num_adaptors) {
			num_adaptors = 1;
			adaptors = &newAdaptor;
		} else {
			newAdaptors =	/* need to free this someplace */
			    xalloc((num_adaptors +
				    1) * sizeof(XF86VideoAdaptorPtr *));
			if (newAdaptors) {
				memcpy(newAdaptors, adaptors, num_adaptors *
				       sizeof(XF86VideoAdaptorPtr));
				newAdaptors[num_adaptors] = newAdaptor;
				adaptors = newAdaptors;
				num_adaptors++;
			}
		}
	}

	if (num_adaptors)
		xf86XVScreenInit(pScreen, adaptors, num_adaptors);

	if (newAdaptors)
		xfree(newAdaptors);
}

/* client libraries expect an encoding */
static XF86VideoEncodingRec DummyEncoding[1] = {
	{			/* overlay limit */
	 0,
	 "XV_IMAGE",
	 768, 576,
	 {1, 1}
	 }
};

#define NUM_FORMATS_OVERLAY 4
#define NUM_FORMATS_TEXTURE 4

static XF86VideoFormatRec Formats[NUM_FORMATS_TEXTURE] = {
	/*{15, TrueColor}, */ {16, TrueColor}, {24, TrueColor}
	/* ,
	   {15, DirectColor} */ , {16, DirectColor}, {24, DirectColor}
};

#define NUM_IMAGES 1

static XF86ImageRec Images[NUM_IMAGES] = {
	XVIMAGE_YV12
	    /* XVIMAGE_UYVY */
};

#define NUM_ATTRIBUTES_OVERLAY 2

static XF86AttributeRec Attributes[NUM_ATTRIBUTES_OVERLAY] =
{
   {XvSettable | XvGettable, 0, (1 << 24) - 1, "XV_COLORKEY"},
   {XvSettable | XvGettable, 0, 1, "XV_AUTOPAINT_COLORKEY"},

#if 0
   {XvSettable | XvGettable, -128, 127, "XV_BRIGHTNESS"},
   {XvSettable | XvGettable, 0, 255, "XV_CONTRAST"}
#endif
};
static Atom  xvColorKey, xvAutopaintColorKey;

static int
IVTVSetPortAttributeOverlay(ScrnInfoPtr pScrn,
			    Atom attribute, INT32 value, pointer data)
{
	IVTVDevPtr devPtr = IVTVDEVPTR(pScrn);
        Ivtv_Xv_PortData *pPriv = (Ivtv_Xv_PortData *)data;
#ifdef JOHN
	if (attribute == xvBrightness) {
		if ((value < -128) || (value > 127))
			return BadValue;
		pPriv->brightness = value;
		OUTREG(MGAREG_BESLUMACTL, ((pPriv->brightness & 0xff) << 16) |
		       (pPriv->contrast & 0xff));
	} else if (attribute == xvContrast) {
		if ((value < 0) || (value > 255))
			return BadValue;
		pPriv->contrast = value;
		OUTREG(MGAREG_BESLUMACTL, ((pPriv->brightness & 0xff) << 16) |
		       (pPriv->contrast & 0xff));
	} else 
#endif
            if (attribute == xvColorKey) {
		pPriv->colorKey = value;
#ifdef JOHN
		outMGAdac(0x55, (pPriv->colorKey & pScrn->mask.red) >>
			  pScrn->offset.red);
		outMGAdac(0x56, (pPriv->colorKey & pScrn->mask.green) >>
			  pScrn->offset.green);
		outMGAdac(0x57, (pPriv->colorKey & pScrn->mask.blue) >>
			  pScrn->offset.blue);
#endif
		REGION_EMPTY(pScrn->pScreen, &pPriv->clip);
	}else if (attribute == xvAutopaintColorKey) {
		pPriv->autopaintColorKey = value;
        } else
        {
            ErrorF("IvtvSetPortAttributeOverlay bad attribute\n");

		return BadMatch;
        }

	return Success;
}

static int
IVTVGetPortAttributeOverlay(ScrnInfoPtr pScrn,
			    Atom attribute, INT32 * value, pointer data)
{
	IVTVDevPtr devPtr = IVTVDEVPTR(pScrn);
        Ivtv_Xv_PortData *pPriv = (Ivtv_Xv_PortData *)data;

#ifdef JOHN
	if (attribute == xvBrightness) {
		*value = pPriv->brightness;
	} else if (attribute == xvContrast) {
		*value = pPriv->contrast;
	} else
#endif
            if (attribute == xvColorKey) {
		*value = pPriv->colorKey;
	} else if (attribute == xvAutopaintColorKey) {
		*value = pPriv->autopaintColorKey;
	} else
        {
            ErrorF("IvtvGetPortAttributeOverlay bad attribute\n");
		return BadMatch;
        }

	return Success;
}

static void
IVTVQueryBestSize(ScrnInfoPtr pScrn,
		  Bool motion,
		  short vid_w, short vid_h,
		  short drw_w, short drw_h,
		  unsigned int *p_w, unsigned int *p_h, pointer data)
{
    ErrorF("Query best vid_w %d vid_h %d drw_w %d drw_h %d\n",
           vid_w, vid_h, drw_w, drw_h);
	*p_w = drw_w;
	*p_h = drw_h;
}

static XF86VideoAdaptorPtr IVTVAllocAdaptor(ScreenPtr pScreen)
{
	ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
	XF86VideoAdaptorPtr adapt;
	DevUnion *pPriv;
	IVTVDevPtr devPtr = IVTVDEVPTR(pScrn);
	int i;

	if (!(adapt = xf86XVAllocateVideoAdaptorRec(pScrn)))
		return NULL;

	if (!(pPriv = xcalloc(1, sizeof(DevUnion) * IVTV_MAX_PORTS))) {
		xfree(adapt);
		return NULL;
	}

	adapt->pPortPrivates = pPriv;

	for (i = 0; i < IVTV_MAX_PORTS; i++)
        {
            Ivtv_Xv_PortData *portData =  (Ivtv_Xv_PortData *)xcalloc(1,sizeof(Ivtv_Xv_PortData));
            portData->colorKey = 101;
            portData->autopaintColorKey = 0;
#ifdef X_USE_REGION_NULL
            REGION_NULL(pScreen, &portData->clip);
#else
            REGION_INIT(pScreen, &portData->clip, NullBox, 0); 
#endif
            adapt->pPortPrivates[i].ptr =portData;
        }
            

#if 0
	xvBrightness = MAKE_ATOM("XV_BRIGHTNESS");
	xvContrast = MAKE_ATOM("XV_CONTRAST");
#endif
	xvColorKey 		= MAKE_ATOM("XV_COLORKEY");
        xvAutopaintColorKey 	= MAKE_ATOM("XV_AUTOPAINT_COLORKEY");

	return adapt;
}

static XF86VideoAdaptorPtr IVTVSetupImageVideoOverlay(ScreenPtr pScreen)
{
	ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
#ifdef JOHN
	IVTVPtr ps3v = IVTVPTR(pScrn);
#endif
	XF86VideoAdaptorPtr adapt;
	adapt = IVTVAllocAdaptor(pScreen);

	adapt->type = XvWindowMask | XvInputMask | XvImageMask;
	adapt->flags = VIDEO_OVERLAID_IMAGES | VIDEO_CLIP_TO_VIEWPORT;
	adapt->name = "PVR350";
	adapt->nEncodings = 1;
	adapt->pEncodings = &DummyEncoding[0];
	adapt->nFormats = NUM_FORMATS_OVERLAY;
	adapt->pFormats = Formats;
	adapt->nPorts = 1;
	adapt->pAttributes = Attributes /*Attributes */ ;
	adapt->nImages = 1;
	adapt->nAttributes = NUM_ATTRIBUTES_OVERLAY;
	adapt->pImages = Images;
	adapt->PutVideo = NULL;
	adapt->PutStill = NULL;
	adapt->GetVideo = NULL;
	adapt->GetStill = NULL;
	adapt->StopVideo = IVTVStopVideo;
	/* Empty Attrib functions - required anyway */
	adapt->SetPortAttribute = IVTVSetPortAttributeOverlay;
	adapt->GetPortAttribute = IVTVGetPortAttributeOverlay;
	adapt->QueryBestSize = IVTVQueryBestSize;
	adapt->PutImage = IVTVPutImage;
	adapt->QueryImageAttributes = IVTVQueryImageAttributes;

	return adapt;
}

static Bool RegionsEqual(RegionPtr A, RegionPtr B)
{
	int *dataA, *dataB;
	int num;

	num = REGION_NUM_RECTS(A);
	if (num != REGION_NUM_RECTS(B))
		return FALSE;

	if ((A->extents.x1 != B->extents.x1) ||
	    (A->extents.x2 != B->extents.x2) ||
	    (A->extents.y1 != B->extents.y1) ||
	    (A->extents.y2 != B->extents.y2))
		return FALSE;

	dataA = (int *)REGION_RECTS(A);
	dataB = (int *)REGION_RECTS(B);

	while (num--) {
		if ((dataA[0] != dataB[0]) || (dataA[1] != dataB[1]))
			return FALSE;
		dataA += 2;
		dataB += 2;
	}

	return TRUE;
}

#ifdef JOHN
/* Not using this at the moment */
/* IVTVClipVideo - copied from MGAClipVideo -  

   Takes the dst box in standard X BoxRec form (top and left
   edges inclusive, bottom and right exclusive).  The new dst
   box is returned.  The source boundaries are given (x1, y1 
   inclusive, x2, y2 exclusive) and returned are the new source 
   boundaries in 16.16 fixed point. 
*/

#define DummyScreen screenInfo.screens[0]

static Bool
IVTVClipVideo(BoxPtr dst,
	      INT32 * x1,
	      INT32 * x2,
	      INT32 * y1, INT32 * y2, RegionPtr reg, INT32 width, INT32 height)
{
	INT32 vscale, hscale, delta;
	BoxPtr extents = REGION_EXTENTS(DummyScreen, reg);
	int diff;

	hscale = ((*x2 - *x1) << 16) / (dst->x2 - dst->x1);
	vscale = ((*y2 - *y1) << 16) / (dst->y2 - dst->y1);

	*x1 <<= 16;
	*x2 <<= 16;
	*y1 <<= 16;
	*y2 <<= 16;

	diff = extents->x1 - dst->x1;
	if (diff > 0) {
		dst->x1 = extents->x1;
		*x1 += diff * hscale;
	}
	diff = dst->x2 - extents->x2;
	if (diff > 0) {
		dst->x2 = extents->x2;
		*x2 -= diff * hscale;
	}
	diff = extents->y1 - dst->y1;
	if (diff > 0) {
		dst->y1 = extents->y1;
		*y1 += diff * vscale;
	}
	diff = dst->y2 - extents->y2;
	if (diff > 0) {
		dst->y2 = extents->y2;
		*y2 -= diff * vscale;
	}

	if (*x1 < 0) {
		diff = (-*x1 + hscale - 1) / hscale;
		dst->x1 += diff;
		*x1 += diff * hscale;
	}
	delta = *x2 - (width << 16);
	if (delta > 0) {
		diff = (delta + hscale - 1) / hscale;
		dst->x2 -= diff;
		*x2 -= diff * hscale;
	}
	if (*x1 >= *x2)
		return FALSE;

	if (*y1 < 0) {
		diff = (-*y1 + vscale - 1) / vscale;
		dst->y1 += diff;
		*y1 += diff * vscale;
	}
	delta = *y2 - (height << 16);
	if (delta > 0) {
		diff = (delta + vscale - 1) / vscale;
		dst->y2 -= diff;
		*y2 -= diff * vscale;
	}
	if (*y1 >= *y2)
		return FALSE;

	if ((dst->x1 != extents->x1) || (dst->x2 != extents->x2) ||
	    (dst->y1 != extents->y1) || (dst->y2 != extents->y2)) {
		RegionRec clipReg;
		REGION_INIT(DummyScreen, &clipReg, dst, 1);
		REGION_INTERSECT(DummyScreen, reg, reg, &clipReg);
		REGION_UNINIT(DummyScreen, &clipReg);
	}
	return TRUE;
}
#endif

static void IVTVStopVideo(ScrnInfoPtr pScrn, pointer data, Bool shutdown)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
        Ivtv_Xv_PortData *pPriv = (Ivtv_Xv_PortData *)data;

	REGION_EMPTY(pScrn->pScreen, &pPriv->clip);

	if (shutdown) {
		if (fPtr->fd_yuv != -1) {
                        IVTVDevPtr devPtr = IVTVDEVPTR(pScrn);
			struct ivtvfb_ioctl_state_info state;
			close(fPtr->fd_yuv);
			fPtr->fd_yuv = -1;
                        struct ivtvfb_ioctl_colorkey colorKey;
                        colorKey.state = 0;
                        colorKey.colorKey = pPriv->colorKey;
                        if (ioctl(fPtr->fd,IVTVFB_IOCTL_SET_COLORKEY, &colorKey) < 0) {
                            ErrorF
                                ("IVTVFB_IOCTL_SET_COLORKEY failed (error: %s)\n",
                                 strerror(errno));
                        }
		}
	}

}

static void de_macro_y(unsigned char *src, unsigned char *dst,
		       int w, int h, int src_x, int src_y, int height, int width)
{
	unsigned int x, y, i;
	unsigned char *dst_2;
	unsigned int h_tail, w_tail;
	unsigned int h_size, w_size;
	unsigned int h_lead, w_lead;

	// Always round the origin, but compensate by increasing the size
	if (src_x & 15) {
		w += src_x & 15;
		src_x &= ~15;
	}

	if (src_y & 15) {
		h += src_y & 15;
		src_y &= ~15;
	}

	// The right / bottom edge might not be a multiple of 16
	h_tail = h & 15;
	w_tail = w & 15;

	// One block is 16 pixels high
	h_size = 16;

	// descramble Y plane
	for (y = 0; y < h; y += 16) {

		// Clip if we've reached the bottom & the size isn't a multiple of 16
		if (y + 16 > h) h_size = h_tail;

		for (x = 0; x < w; x += 16) {
			if (x + 16 > w)
				w_size = w_tail;
			else
				w_size = 16;

			dst_2 = dst + (720 * y) + (720 * src_y) + (256 * (src_x>>4)) + (x * 16);

			for (i = 0; i < h_size; i++) {
				memcpy(dst_2, src + src_x + x + (y + i) * width + (src_y * width), w_size);
				dst_2 += 16;
			}
		}
	}
}

static void de_macro_uv(unsigned char *srcu, unsigned char *srcv,
			unsigned char *dst, int w, int h, int src_x, int src_y,
		       int height, int width)
{
	unsigned int x, y, i, f;
	unsigned char *dst_2;
	unsigned int h_tail, w_tail;
	unsigned int h_size, w_size;
	unsigned int h_lead, w_lead;

	// The uv plane is half the size of the y plane, so 'correct' all dimensions.
	w /= 2;
	h /= 2;
	src_x /= 2;
	src_y /= 2;
	height /= 2;
	width /= 2;

	// Always round the origin, but compensate by increasing the size
	if (src_x & 7) {
		w += src_x & 7;
		src_x &= ~7;
	}

	if (src_y & 15) {
		h += src_y & 15;
		src_y &= ~15;
	}

	// The right / bottom edge may not be a multiple of 16
	h_tail = h & 15;
	w_tail = w & 7;

	h_size = 16;

	// descramble U/V plane
	for (y = 0; y < h; y += 16) {
		if ( y + 16 > h ) h_size = h_tail;
		for (x = 0; x < w; x += 8) {
			dst_2 = dst + (720 * y) + (720 * src_y) + (256 * (src_x>>3)) + (x * 32);
			if (x + 8 <= w) {
				for (i = 0; i < h_size; i++) {
					int idx = src_x + x + ((y + i) * width) + (src_y * width);
					dst_2[0] = srcu[idx + 0];
					dst_2[1] = srcv[idx + 0];
					dst_2[2] = srcu[idx + 1];
					dst_2[3] = srcv[idx + 1];
					dst_2[4] = srcu[idx + 2];
					dst_2[5] = srcv[idx + 2];
					dst_2[6] = srcu[idx + 3];
					dst_2[7] = srcv[idx + 3];
					dst_2[8] = srcu[idx + 4];
					dst_2[9] = srcv[idx + 4];
					dst_2[10] = srcu[idx + 5];
					dst_2[11] = srcv[idx + 5];
					dst_2[12] = srcu[idx + 6];
					dst_2[13] = srcv[idx + 6];
					dst_2[14] = srcu[idx + 7];
					dst_2[15] = srcv[idx + 7];
					dst_2 += 16;
				}
			}
			else {
				for (i = 0; i < h_size; i ++) {
					int idx = src_x + x + ((y + i) * width) + (src_y * width);
					for (f = 0; f < w_tail; f++) {
						dst_2[0] = srcu[idx + f];
						dst_2[1] = srcv[idx + f];
						dst_2 += 2;
					}
/*
					// Used for testing edge cutoff. Sets colour to Green
					for (f = w_tail;f < 8;f ++) {
						dst_2[0] = 0;
						dst_2[1] = 0;
						dst_2 += 2;
					}
*/
					dst_2 += 16 - (w_tail << 1);
				}
			}
		}
	}
}

static char outbuf[622080];

static int
IVTVPutImage(ScrnInfoPtr pScrn,
	     short src_x, short src_y,
	     short drw_x, short drw_y,
	     short src_w, short src_h,
	     short drw_w, short drw_h,
	     int id, unsigned char *buf,
	     short width, short height,
	     Bool sync, RegionPtr clipBoxes, pointer data)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
        Ivtv_Xv_PortData *pPriv = (Ivtv_Xv_PortData *)data;

	struct ivtvyuv_ioctl_dma_host_to_ivtv_args args;
#ifdef JOHN
        ErrorF("src_w %d src_h %d drw_w %d drw_h %d width %d height %d\n",
               src_w, src_h, drw_w, drw_h, width, height);
        ErrorF("src_x %d src_y %d drw_x %d drw_y %d width %d height %d\n",
               src_x, src_y, drw_x, drw_y, width, height);
#endif

	// FIXME - Is this the correct place for this ?

	// Source coordinates must be even
	// For origin, round down
	src_x &= ~1;
	src_y &= ~1;

	// For size, round up
	src_w += src_w & 1;
	src_h += src_h & 1;

#ifdef JOHN
	INT32 x1, x2, y1, y2;
	unsigned char *dst_start;
	int top, left, npixels, nlines;

	BoxRec dstBox;
	CARD32 tmp;
	static int once = 1;
	static int once2 = 1;

	/* Clip */
	x1 = src_x;
	x2 = src_x + src_w;
	y1 = src_y;
	y2 = src_y + src_h;

	dstBox.x1 = drw_x;
	dstBox.x2 = drw_x + drw_w;
	dstBox.y1 = drw_y;
	dstBox.y2 = drw_y + drw_h;

#ifdef JOHN
	if (!IVTVClipVideo
	    (&dstBox, &x1, &x2, &y1, &y2, clipBoxes, width, height))
		return Success;
#endif

	dstBox.x1 -= pScrn->frameX0;
	dstBox.x2 -= pScrn->frameX0;
	dstBox.y1 -= pScrn->frameY0;
	dstBox.y2 -= pScrn->frameY0;

	pitch = pScrn->bitsPerPixel * pScrn->displayWidth >> 3;

	dstPitch = ((width << 1) + 15) & ~15;
	new_h = ((dstPitch * height) + pitch - 1) / pitch;
#endif

	switch (id) {

	case FOURCC_YV12:
		{
			de_macro_y(buf, outbuf, src_w, src_h, src_x, src_y, height, width);
			de_macro_uv(buf + (width * height) + width * height/ 4,
				    buf + (width * height), outbuf + 720 * 576,
				    src_w,  src_h, src_x, src_y, height, width);

			args.y_source = outbuf;
			args.uv_source = outbuf + (720 * 576);
			args.src_x = src_x;
                        args.src_y = src_y;
                        args.dst_x = drw_x;
                        args.dst_y = drw_y;
			args.src_w = src_w;
                        args.dst_w = drw_w;
                        args.srcBuf_width = width;
			args.src_h = src_h;
                        args.dst_h = drw_h;
                        args.srcBuf_height = height;
			args.yuv_type = IVTV_YUV_TYPE_HME12;
		}
		break;
	default:
		return BadMatch;
	}
	if (fPtr->fd_yuv == -1) {
		if ((fPtr->fd_yuv = open(fPtr->yuvDevName, O_RDWR)) == -1) {
			if (errno == ENODEV)
				ErrorF
				    ("Failed to open \"%s\". Need to initialize the mpeg decoder before the YUV output can be used\n",
				     fPtr->yuvDevName);
			else
				ErrorF("Failed to open \"%s\" Error %s\n",
				       fPtr->yuvDevName, strerror(errno));
			return BadAccess;
		}
                struct ivtvfb_ioctl_colorkey colorKey;
                colorKey.state = 1;
                colorKey.colorKey = pPriv->colorKey;
                if (ioctl(fPtr->fd,IVTVFB_IOCTL_SET_COLORKEY, &colorKey) < 0) {
                    ErrorF
                        ("IVTVFB_IOCTL_SET_COLORKEY failed (error: %s)\n",
                         strerror(errno));
                }
	}
	int ret = ioctl(fPtr->fd_yuv, IVTV_IOC_PREP_FRAME_YUV, &args);
	if (ret == -1) {
		ErrorF
		    ("Ioctl IVTV_IOC_PREP_FRAME_YUV returned failed Error %s\n",
		     strerror(errno));
		return BadImplementation;
	}
                                                                          
        if(pPriv->autopaintColorKey && 
           !RegionsEqual( &pPriv->clip, clipBoxes))
        {
            /* we always paint V4L's color key */
            REGION_COPY(pScrn->pScreen, &pPriv->clip, clipBoxes);
            xf86XVFillKeyHelper(pScrn->pScreen, pPriv->colorKey, clipBoxes);
        }
	return Success;
}

static int
IVTVQueryImageAttributes(ScrnInfoPtr pScrn,
			 int id,
			 unsigned short *w, unsigned short *h,
			 int *pitches, int *offsets)
{
	int size = 0, tmp;

	if (*w > 768)
		*w = 768;
	if (*h > pScrn->virtualY)
		*h = pScrn->virtualY;

	*w = (*w + 1) & ~1;
	if (offsets)
		offsets[0] = 0;

	switch (id) {
	case FOURCC_YV12:
		*h = (*h + 1) & ~1;
		size = (*w + 3) & ~3;
		if (pitches)
			pitches[0] = size;
		size *= *h;
		if (offsets)
			offsets[1] = size;
		tmp = ((*w >> 1) + 3) & ~3;
		if (pitches)
			pitches[1] = pitches[2] = tmp;
		tmp *= (*h >> 1);
		size += tmp;
		if (offsets)
			offsets[2] = size;
		size += tmp;
		break;
	default:
		break;
	}

	return size;
}

#endif				/* !XvExtension */
