/* xoreos-tools - Tools to help with xoreos development
 *
 * xoreos-tools is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos-tools is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos-tools. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Unit tests for our KEY resource index reader.
 */

#include "gtest/gtest.h"

#include "src/common/error.h"
#include "src/common/memreadstream.h"

#include "src/aurora/keyfile.h"

// --- KEY V1.0 ---

static const byte kKEY10File[] = {
	0x4B,0x45,0x59,0x20,0x56,0x31,0x20,0x20,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x40,0x00,0x00,0x00,0x5B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x4C,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x64,0x61,0x74,0x61,
	0x5C,0x78,0x6F,0x72,0x65,0x6F,0x73,0x2E,0x62,0x69,0x66,0x6F,0x7A,0x79,0x6D,0x61,
	0x6E,0x64,0x69,0x61,0x73,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x01,0x00,0x00,
	0x00
};

GTEST_TEST(KEYFile10, getBIFs) {
	Common::MemoryReadStream stream(kKEY10File);
	Aurora::KEYFile key(stream);

	const Aurora::KEYFile::BIFList &bifs = key.getBIFs();
	ASSERT_EQ(bifs.size(), 1);

	EXPECT_STREQ(bifs[0].c_str(), "data/xoreos.bif");
}

GTEST_TEST(KEYFile10, getResources) {
	Common::MemoryReadStream stream(kKEY10File);
	Aurora::KEYFile key(stream);

	const Aurora::KEYFile::ResourceList &res = key.getResources();
	ASSERT_EQ(res.size(), 1);

	EXPECT_STREQ(res[0].name.c_str(), "ozymandias");
	EXPECT_EQ(res[0].type, Aurora::kFileTypeTXT);
	EXPECT_EQ(res[0].bifIndex, 0);
	EXPECT_EQ(res[0].resIndex, 1);
}

// --- KEY V1.1 ---

static const byte kKEY11File[] = {
	0x4B,0x45,0x59,0x20,0x56,0x31,0x2E,0x31,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x00,0x5F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x64,0x61,0x74,0x61,0x5C,0x78,0x6F,0x72,0x65,0x6F,0x73,0x2E,0x62,0x69,0x66,0x6F,
	0x7A,0x79,0x6D,0x61,0x6E,0x64,0x69,0x61,0x73,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,
	0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

GTEST_TEST(KEYFile11, getBIFs) {
	Common::MemoryReadStream stream(kKEY11File);
	Aurora::KEYFile key(stream);

	const Aurora::KEYFile::BIFList &bifs = key.getBIFs();
	ASSERT_EQ(bifs.size(), 1);

	EXPECT_STREQ(bifs[0].c_str(), "data/xoreos.bif");
}

GTEST_TEST(KEYFile11, getResources) {
	Common::MemoryReadStream stream(kKEY11File);
	Aurora::KEYFile key(stream);

	const Aurora::KEYFile::ResourceList &res = key.getResources();
	ASSERT_EQ(res.size(), 1);

	EXPECT_STREQ(res[0].name.c_str(), "ozymandias");
	EXPECT_EQ(res[0].type, Aurora::kFileTypeTXT);
	EXPECT_EQ(res[0].bifIndex, 0);
	EXPECT_EQ(res[0].resIndex, 1);
}
