/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util.event;

import java.util.*;

public class ListEvent extends EventObject { 

    //--- Constant(s) ---

    public static final int ELEMENT_ADDED = 1;
    public static final int ELEMENT_REMOVED = 2;
    public static final int LIST_CLEARED = 3;

    //--- Data Field(s) ---
    
    Object element;
    int id;
    int index;

    //--- Constructor(s) ---

    public ListEvent(Object source, int id, Object element, int index)
    {
	super(source);
	this.id = id;
	this.element = element;
	this.index = index;
    }

    public ListEvent(Object source, int id)
    {
	this(source, id, null, -1);
    }

    //--- Method(s) ---

    public Object getElement()
    {
	return element;
    }

    public int getID()
    {
	return id;
    }

    public int getIndex()
    {
	return index;
    }

}
