/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * This file was originally written by Mike Perham. 
 * Modifications were made to fit it into XNap.
 *
 */
package xnap.util.audio;

import java.lang.reflect.*;
import java.net.*;
import java.io.*;

/**
 * JMF 2.1-based MP3 audio player.  Note that this class
 * uses nothing but reflection to run the JMF code so that
 * this class can be loaded without dependencies on the
 * JMF jar being installed on the user's system.
 *
 * @see <A HREF="http://java.sun.com/products/java-media/jmf/index.html">JMF</A>
 */
public class JMFPlayer extends AudioPlayer
{
    private Object player = null;

    public static boolean isAvailable()
    {
	try {
	    Class m = Class.forName("javax.media.Manager");
	}
	catch (Throwable t) {
	    return false;
	}

	return true;
    }

    public boolean play(File f)
    {
	URL url;

	if (!isAvailable())
	    return false;

	try {
	    url = f.toURL();
	} 
	catch (MalformedURLException ex) {
	    return false;
	}
	System.out.println("play " + url);
	stop();

	try {
	    Class m = Class.forName("javax.media.Manager");
	    Method meth = m.getMethod("createRealizedPlayer", 
				      new Class[] { url.getClass() });

	    // Player player = Manager.createRealizedPlayer(...);
	    Object o = meth.invoke(null, new Object[] {url});

	    // player.start();
	    o.getClass().getMethod("start", null).invoke(o, null); 		

	    player = o;
	}
	catch (Exception e) {
	    return false;
	}

	return true;
    }

    public boolean stop()
    {
	if (player != null) 
	    {
		try {
		    // just a shortcut
		    Object o = player;
		    o.getClass().getMethod("stop", null).invoke(o, null);
		    o.getClass().getMethod("close", null).invoke(o, null);
		    o.getClass().getMethod("deallocate", null).invoke(o, null);
		}
		catch (Exception ex) {
		    return false;
		}

		player = null;
	    }

	return true;
    }
}
