/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/**
 * If you hack around, make sure all pathes are returned with a trailing
 * file separator and all values are initialized to something other than
 * null.
 *
 * Most important, keep all preferences sorted alphabetically everywhere.
 */
package xnap.util;

import java.beans.PropertyChangeListener;
import java.util.Collection;

public interface TablePreferencesSupport {

    //--- Constant(s) ---

    //--- Method(s) ---
    
    void addTableListener(String table, PropertyChangeListener l);

    boolean getTableMaintainSortOrder(String table);

    /**
     * Returns an array of visible columns as their model index.
     */
    int[] getTableColumnsArray(String table);

    void setTableColumns(String table, int[] columns);

    int[] getTableColumnWidths(String table);

    void setTableColumnWidths(String table, int[] widths);

    void setTableMaintainSortOrder(String table, boolean enable);

    /**
     * Returns 0, if no column is sorted, otherwise the model index 
     * of the column + 1. If the return value is < 0 the column is sorted 
     * descending .
     */
    int getTableSortedColumn(String table);

    void setTableSortedColumn(String table, int column);

}
