/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.util.event.*;

import java.util.*;

public class EventList {

    //--- Constant(s) ---

    //--- Data field(s) ---

    private HashSet listListeners = new HashSet();
    private List queue;

    //--- Constructor(s) ---

    public EventList(List queue)
    {
	this.queue = queue;
    }

    public EventList()
    {
	this(new ArrayList());
    }

    //--- Method(s) ---

    protected void add(Object object)
    {
	add(queue.size(), object);
    }

    protected void add(int index, Object object)
    {
	queue.add(index, object);
	fireElementAdded(object, index);
    }

    public void clear()
    {
	int lastIndex = queue.size() - 1;
	queue.clear();
	fireListCleared(lastIndex);
    }

    public boolean contains(Object object)
    {
	return queue.contains(object);
    }

    public void ensureCapacity(int c)
    {
	if (queue instanceof ArrayList) {
	    ((ArrayList)queue).ensureCapacity(c);
	}
    }

    public Object get(int index)
    {
	return queue.get(index);
    }

    public int indexOf(Object item)
    {
	return queue.indexOf(item);
    }

    public Iterator iterator()
    {
	return queue.iterator();
    }

    public ListIterator listIterator()
    {
	return queue.listIterator();
    }

    protected void remove(int index)
    {
	Object object = queue.remove(index);
	fireElementRemoved(object, index);
    }

    protected boolean remove(Object o) 
    {
	int index = queue.indexOf(o);
	if (index != -1) {
	    remove(index);
	    return true;
	}
	else {
	    return false;
	}
    }

    protected void remove(Iterator i, Object o)
    {
	int index = queue.indexOf(o);
	if (index != -1) {
	    i.remove();
	    fireElementRemoved(o, index);
	}
    }

    protected Object set(int index, Object element)
    {
	return queue.set(index, element);
    }

    public int size()
    {
	return queue.size();
    }

    public Object[] toArray()
    {
	return queue.toArray();
    }

    public void addListListener(ListListener l) {
	synchronized (listListeners) {
	    listListeners.add(l);
	}
    }

    public void removeListListener(ListListener l) 
    {
	synchronized (listListeners) {
	    listListeners.remove(l);
	}
    }
        
    protected Object[] getListListeners()
    {
	synchronized(listListeners) {
	    return listListeners.toArray();
	}
    }
    
    protected void fireElementAdded(Object element, int index)
    {
	Object[] listeners = getListListeners();
	if (listeners != null) {
	    ListEvent event = new ListEvent(this, ListEvent.ELEMENT_ADDED, 
					    element, index);
	    
	    for (int i = listeners.length - 1; i >= 0; i--) {
		((ListListener)listeners[i]).elementAdded(event);
	    }
	}
    }   

    protected void fireElementRemoved(Object element, int index)
    {
	Object[] listeners = getListListeners();
	if (listeners != null) {
	    ListEvent event = new ListEvent(this, ListEvent.ELEMENT_REMOVED, 
					    element, index);

	    for (int i = listeners.length - 1; i >= 0; i--) {
		((ListListener)listeners[i]).elementRemoved(event);
	    }
	}
    }   

    protected void fireListCleared(int lastIndex)
    {
	Object[] listeners = getListListeners();
	if (listeners != null) {
	    ListEvent event = new ListEvent(this, ListEvent.LIST_CLEARED,
					    null, lastIndex);

	    for (int i = listeners.length - 1; i >= 0; i--) {
		((ListListener)listeners[i]).elementRemoved(event);
	    }
	}
    }   

}
