/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.util;

import xnap.util.event.*;

import java.io.*;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.varia.LevelMatchFilter;

public class Debug {

    //--- Constant(s) ---

    //--- Data Field(s) ---

    private static Logger logger = Logger.getLogger("xnap");
    private static File errorFile;

    //--- Method(s) ---

    public static File getErrorFile()
    {
	return errorFile;
    }

    public static long getErrorFileSize()
    {
	// this might fail on some systems because the length of open
	// files might always be 0
	return (errorFile != null) ? errorFile.length() : 0;
    }

    /**
     * Initializes the debug environment. Should be called as early as
     * possible.
     */
    public static void init(File prefsFile, Level level)
    {
	if (level != Level.OFF && prefsFile.canRead()) {
	    FileInputStream in = null;
	    try {
		in = new FileInputStream(prefsFile);
		Properties p = new Properties();
		p.load(in);
		PropertyConfigurator.configure(p);
	    } 
	    catch (FileNotFoundException e) {
	    } 
	    catch (IOException e) {
	    }
	    finally {
		try {
		    if (in != null) {
			in.close();
		    }
		}
		catch (IOException e) {
		}
	    }
	}
	else {
	    // ConsoleAppender seems broken as of log4j 1.3beta3
	    //ConsoleAppender ca = new ConsoleAppender();
	    //ca.setTarget("System.out");
	    //ca.setLayout(new PatternLayout("%-5p [%t] %m%n"));
	    WriterAppender ca = new WriterAppender
	    	(new PatternLayout("%-5p [%t] %m%n"), System.out);
	    ca.setName("Default");
	    Logger.getRootLogger().addAppender(ca);
	    Logger.getRootLogger().setLevel(level);
	}
    }

    public static void setErrorFile(File f)
    {
	errorFile = f;

	try {
	    System.setErr(new PrintStream(new FileOutputStream(f)));
	} 
	catch (IOException e) {
	}
    }

    public static void log(Object o)
    {
	logger.info(o); 
    }

    public static void warn(Object o)
    {
	logger.warn(o); 
    }

}


