/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.net.*;
import xnap.net.event.*;
import xnap.plugin.*;
import xnap.util.*;

import java.util.*;

public class Browser extends Searcher
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    //--- Constructor(s) ---

    public Browser(IBrowse browse)
    {
	super(new ISearch[] { browse }, null);
    }

    //--- Method(s) ---

    public Grouper getDefaultGrouper()
    {
	return new Grouper();
    }

    public void updateStatus()
    {
	if (searches.size() > 0) {
	    if (!connected) {
		setStatus("Connecting...");
	    }
	    else {
		setStatus("Receiving list of files...");
	    }
	}
	else if (errStatus.length() > 0) {
	    setStatus("Failed (" + errStatus + ")");
	}
	else {
	    setStatus("Finished");
	}
    }

    public String toString()
    {
	return searches.get(0).toString();
    }

}

