/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.user;

import xnap.XNap;
import xnap.net.IUser;
import xnap.util.EventVector;
import xnap.util.FileHelper;

import java.io.*;
import java.lang.reflect.*;
import java.util.*;
import org.apache.log4j.Logger;

public class UserManager extends EventVector
{

    //--- Constant(s) ---

    public static final String USER_REPOSITORY_FILENAME = "users";

    public static final String[] CATEGORIES = { "",
						XNap.tr("Hotlist"), 
						XNap.tr("Banned") };

    //--- Data field(s) ---

    private static Logger logger = Logger.getLogger(UserManager.class);
    private static UserManager singleton = new UserManager();

    private Hashtable usersByName = new Hashtable();

    //--- Constructor(s) ---

    protected UserManager()
    {
	try {
	    read();
	}
	catch (IOException e) {
	    logger.debug("error reading hotlist", e);
	}
    }

    //--- Method(s) ---

    public boolean add(UserData d) 
    {
	if (d.parentClass != null) {
	    try {
		d = convert(d);

		Class c = Class.forName(d.parentClass);
		Constructor ct = c.getConstructor(new Class[] { d.getClass() });
		Object o = ct.newInstance(new Object[] {d});
		if (o instanceof IUser) {
		    add((IUser)o);
		    return true;
		}
	    }
	    catch (Exception e) {
		logger.warn("error creating " + d.parentClass);
	    }
	}

	return false;
    }

    public void add(IUser o) 
    {
	super.add(o);
	usersByName.put(o.getName(), o);
    }

    public static UserManager getInstance()
    {
	return singleton;
    }

    public IUser get(String name)
    {
	return (IUser)usersByName.get(name);
    }

    public void read() throws IOException
    {
	LinkedList list = new LinkedList();
	File f = new File(FileHelper.getHomeDir() + USER_REPOSITORY_FILENAME);
	FileHelper.readBinary(f, list);

	for (Iterator i = list.iterator(); i.hasNext();) {
	    Object o = i.next();
	    if (o instanceof UserData) {
		add((UserData)o);
	    }
	}
    }

    public void write()
    {
	LinkedList list = new LinkedList();
	for (Iterator i = iterator(); i.hasNext();) {
	    IUser u = (IUser)i.next();
	    if (!u.isTemporary()) {
		list.add(u.getData());
	    }
	}

	File f = new File(FileHelper.getHomeDir() + USER_REPOSITORY_FILENAME);
	try {
	    FileHelper.writeBinary(f, list);
	}
	catch (IOException e) {
	    logger.debug("error writing hotlist", e);
	}
    }

    /**
     * Converts d.
     */
    protected UserData2 convert(UserData d)
    {
	// convert UserData
	if (d instanceof UserData2) {
	    return (UserData2)d;
	}
	else {
	    return new UserData2(d);
	}
    }

    public static void reset(IUser u)
    {
	u.setChatIgnored(false);
	u.setCategory("");
	u.setMaxDownloads(IUser.TRANSFER_DEFAULT);
	u.setMaxUploads(IUser.TRANSFER_DEFAULT);
	u.setTemporary(true);
    }

}

