/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.viewer.image;

import xnap.gui.*;
import xnap.plugin.*;
import xnap.util.*;

import java.io.*;
import javax.swing.*;

public class Plugin extends AbstractViewerPlugin
{
    
    //--- Constant(s) ---

    public static final String VERSION = "2.1";

    //--- Data Field(s) ---

    //--- Constructor(s) ---

    public Plugin()
    {
    }

    //--- Method(s) ---

    public String getDescription()
    {
	return "Image preview support.";
    }

    public String[] getExtensions()
    {
	return new String[] { "gif", "jpg", "png", "jpeg" };
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("image.png");
    }
    
    public String getName()
    {
	return "Image";
    }

    public String getVersion()
    {
	return VERSION;
    }

    public void start()
    {
	vp = new ImagePanel();
	super.start();
    }

}
