/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.util.PrivateChannel;
import xnap.util.QuotedStringTokenizer;

public class ServerStatisticsMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 10115;

    //--- Data Field(s) ---

    public int clientCount;
    public int serverCount;
    public int userCount;
    public int fileCount;
    public int fileSize;
    public int channelCount;
    public long startTime;
    public long uptime;
    public int memorySize;
    public int registeredUserCount;

    //--- Constructor(s) ---

    public ServerStatisticsMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 10);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	clientCount = Integer.parseInt(t.nextToken());
	serverCount = Integer.parseInt(t.nextToken());
	userCount = Integer.parseInt(t.nextToken());
	fileCount = Integer.parseInt(t.nextToken());
	fileSize = Integer.parseInt(t.nextToken());
	channelCount = Integer.parseInt(t.nextToken());
	startTime = Long.parseLong(t.nextToken());
	uptime = Long.parseLong(t.nextToken());
	memorySize = Integer.parseInt(t.nextToken());
	registeredUserCount = Integer.parseInt(t.nextToken());
    }

    public void received()
    {
    }

}
