/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.cmdl.Console;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.util.PrivateChannel;
import xnap.util.QuotedStringTokenizer;

public class ServerLinksMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 10112;

    //--- Data Field(s) ---

    public String host1;
    public String host2;
    public int hops;

    //--- Constructor(s) ---

    public ServerLinksMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 0);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	host1 = (t.hasMoreTokens()) ? t.nextToken() : null;
	host2 = (t.hasMoreTokens()) ? t.nextToken() : null;
	hops = (t.hasMoreTokens()) ? Integer.parseInt(t.nextToken()) : 0;
    }

    public void received()
    {
	StringBuffer sb = new StringBuffer();
	sb.append(server.getHost());
	sb.append(": linked ");
	sb.append(host1);
	sb.append(", ");
	sb.append(host2);
	sb.append(", ");
	sb.append(hops);
	sb.append(" hops");
	Console.getInstance().println(sb.toString());
    }

}
