/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.util.QuotedStringTokenizer;

public class MotdMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 621;

    //--- Data Field(s) ---

    public String message;
    public String version;

    //--- Constructor(s) ---

    public MotdMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 0);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	message = data;

	if (t.countTokens() > 1 && t.nextToken().equals("VERSION")) {
	    version = t.allNextTokens();
	}
    }

    public void received()
    {
	if (version != null) {
	    server.setVersion(version);
	}
    }

}

