/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.AltDirectBrowseUpload;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.DirectBrowseAckMessage;
import xnap.util.QuotedStringTokenizer;
import xnap.util.StringHelper;

public class DirectBrowseRequestMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 640;

    //--- Data Field(s) ---

    public String nick;
    public String ip;
    public int port;

    //--- Constructor(s) ---

    public DirectBrowseRequestMessage(String data)
	throws InvalidMessageException 
    {
	super(TYPE, data, 1);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	nick = t.nextToken();
	ip = (t.hasMoreTokens()) ? StringHelper.parseIP(t.nextToken()) : null;
	port = (t.hasMoreTokens()) ? Integer.parseInt(t.nextToken()) : 0;
    }

    public void received()
    {
	if (ip != null && port > 0) {
	    MessageHandler.send(server, new DirectBrowseAckMessage(nick));

	    AltDirectBrowseUpload b 
		= new AltDirectBrowseUpload(server, ip, port);
	    b.start();
	}		       
	else if (server.getLocalPort() != 0) {
	    MessageHandler.addBrowseRequest(server);
	    MessageHandler.send(server, new DirectBrowseAckMessage(nick));
	}
    }

}
