/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.client;

import xnap.util.Preferences;

import java.io.File;
import java.util.StringTokenizer;

public class UnshareFileMessage extends ClientMessage {

    //--- Constant(s) ---

    public static final int TYPE = 102;

    //--- Constructor(s) ---

    public UnshareFileMessage(int index, File file)
    {
	super(TYPE);

	StringBuffer sb = new StringBuffer();
	if (Preferences.getInstance().getShareFullPath()){
	    StringBuffer path = new StringBuffer();
	    StringTokenizer st = new StringTokenizer(file.getPath(), 
						     file.separator);
	    while (st.countTokens() > 1) {
		path.append("\\");
		path.append(st.nextToken());
	    }
	    sb.append(path);
	}
	else  {
	    sb.append(index);
	}
	sb.append("\\\\");
	sb.append(file.getName());

	data = sb.toString();
    }

}

