/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.client;

import xnap.plugin.nap.net.ServerVersion;
import xnap.plugin.nap.net.msg.ExceptionListener;
import xnap.plugin.nap.net.msg.Message;

import java.util.Hashtable;

public class ClientMessage extends Message {
    
    //--- Data Field(s) ---

    public String data;
    public Hashtable ht;
    public ExceptionListener listener;

    //--- Constructor(s) ---

    protected ClientMessage(int type, String data) 
    {
	super(type);

	this.data = data;
    }

    protected ClientMessage(int type) 
    {
	this(type, "");
    }

    //--- Method(s) ---

    public void add(ServerVersion sv, String d)
    {
	if (ht == null) {
	    ht = new Hashtable();
	}
	ht.put(sv, d);
    }

    public ExceptionListener getExceptionListener()
    {
	return listener;
    }

    public void setExceptionListener(ExceptionListener newValue)
    {
	listener = newValue;
    }


    public String getData(ServerVersion version)
    {
	if (ht != null) {
	    ServerVersion sv = version.getNextVersion();
	    while (sv != null) {
		Object d = ht.get(sv);
		if (d != null) {
		    return (String)d;
		}
		else {
		    sv = sv.getNextVersion();
		}
	    }
	}

	return data;
    }

    public String getData()
    {
	return data;
    }
    
    public int getType()
    {
	return type;
    }

}
