/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net;

import xnap.io.ThrottledOutputStream;
import xnap.plugin.nap.util.NapFileHelper;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.QuotedStringTokenizer;

import java.io.*;
import java.net.Socket;

public class UploadSocket extends IncomingSocket {

    //--- Data Field(s) ---
    
    public String requestFilename;
    public String nick;
    public long offset;

    //--- Constructor(s) ---

    /**
     * This is a bit ugly since we have to read in the file offset too and
     * pass it on to the actual upload.
     */
    public UploadSocket(Socket socket, InputStream in) throws IOException
    {
	super(socket, in);

	byte data[] = new byte[2048];
	int j = in.read(data);
	if (j < 0) {
	    throw new IOException("Invalid request");
	}
	String response = new String(data, 0, j);
	    
	QuotedStringTokenizer t = new QuotedStringTokenizer(response);

	if (t.countTokens() < 3) {
	    throw new IOException("Invalid request: " + response);
	}

	nick = t.nextToken();
	requestFilename = t.nextToken();

	try {
	    offset = Long.parseLong(t.nextToken());
	}
	catch (NumberFormatException e) {
	    throw new IOException("Invalid request");
	}		
    }

    public UploadSocket(String nick, String filename)
    {
	this.nick = nick;
	requestFilename = filename;
    }

    //--- Method(s) ---

    public boolean equals(Object obj)
    {
	if (obj != null) {
	    if (obj instanceof UploadSocket) {
		UploadSocket u = (UploadSocket)obj;
		return ((nick == null ||  nick.equals(u.nick))
			&& requestFilename.equals(u.requestFilename));
	    }
	}
	return false;
    }
}


