/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net;

import java.util.*;

public class SearchResultCache {

    //--- Constant(s) ---

    public static final int PURGE_INTERVAL = 10 * 60 * 1000;

    //--- Data field(s) ---

    protected static Timer timer;

    /**
     * Contains last n searchesTexts an their and their collectors.
     */
    protected Hashtable cache = new Hashtable();
    protected Object lock = new Object();

    //--- Constructor(s) ---

    public SearchResultCache()
    {
    }

    //--- Method(s) ---

    public void put(String search, LinkedList list)
    {
	SearchContainer c = new SearchContainer(list);
	synchronized (lock) {
	    cache.put(search, c);
	}
    }

    public void clear()
    {
	synchronized (lock) {
	    cache.clear();
	}
    }

    public LinkedList get(String search)
    {
	Object o;
	synchronized (lock) {
	    o = cache.get(search);
	}

	return (o != null) ? ((SearchContainer)o).results : null;
    }

    public void purge()
    {
	LinkedList toRemove = new LinkedList();

	synchronized (lock) {
	    // we need to use two loops, because we can only 
	    // enumerate through the keys which can't be modified 
	    // during enumerating
	    for (Enumeration e = cache.keys(); e.hasMoreElements();) {
		String s = (String)e.nextElement();
		SearchContainer c = (SearchContainer)cache.get(s);
		if (System.currentTimeMillis() - c.time > PURGE_INTERVAL) {
		    toRemove.add(s);
		}
	    }

	    for (Iterator i = toRemove.iterator(); i.hasNext();) {
		cache.remove(i.next());
	    }
	}
    }

    public void remove(String search)
    {
	synchronized (lock) {
	    cache.remove(search);
	}
    }

    protected class SearchContainer 
    {
	public LinkedList results;
	public long time;

	public SearchContainer(LinkedList results)
	{
	    this.results = results;
	    this.time = System.currentTimeMillis();
	}

    }

}
