/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net;

import xnap.util.QuotedStringTokenizer;

import java.io.InputStream;
import java.io.IOException;
import java.net.Socket;

public class DownloadSocket extends IncomingSocket {

    //--- Data Field(s) ---
    
    public String filename;
    public long filesize;
    public String nick;

    //--- Constructor(s) ---

    public DownloadSocket(Socket socket, InputStream in) throws IOException
    {
	super(socket, in);

	byte data[] = new byte[2048];
	int i = in.read(data);
	if (i > 0) {
	    String response = new String(data, 0, i);
		    
	    QuotedStringTokenizer t = new QuotedStringTokenizer(response);
		    
	    if (t.countTokens() < 3) {
		throw new IOException("invalid request: " + response);
	    }

	    nick = t.nextToken();
	    filename = t.nextToken();
	    try {
		filesize = Long.parseLong(t.nextToken());
	    }
	    catch (NumberFormatException e) {
		throw new IOException("invalid request: " + response);
	    }

	    logger.info("download response from " + nick + " for " + filename);
	}
	else {
	    throw new IOException("empty request");
	}
    }

    public DownloadSocket(String nick, String filename, long filesize)
    {
	this.nick = nick;
	this.filename = filename;
	this.filesize = filesize;
    }

    //--- Method(s) ---

    public boolean equals(Object obj)
    {
	if (obj != null) {
	    if (obj instanceof DownloadSocket) {
		DownloadSocket d = (DownloadSocket)obj;
		return (nick.equals(d.nick) && filename.equals(d.filename)
			&& filesize == d.filesize);
	    }
	}

	return false;
    }
}


