/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.plugin.nap.net;

import xnap.net.*;
import xnap.plugin.nap.net.GlobalUser;
import xnap.plugin.nap.net.msg.ExceptionListener;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.BrowseRequestMessage;
import xnap.plugin.nap.net.msg.server.BrowseResponseMessage;
import xnap.util.*;

import java.io.IOException;
import java.util.*;

public class Browse extends AbstractBrowse implements ExceptionListener {
    
    //--- Constant(s) ---

    //--- Data field(s) ---

    protected Server server;
    protected String failedMsg = null;

    //--- Constructor(s) ---

    public Browse(User user)
    {
	super(user);

	server = user.getServer();
    }

    //--- Method(s) ---

    public void add(BrowseResponseMessage msg)
    {
	User user = server.getUser(msg.nick);

	SearchResult result 
	    = new SearchResult(msg.filesize, msg.bitrate, msg.frequency, 
			       msg.length, user, msg.filename, msg.md5);

	add(result);
    }

    public synchronized int available() throws IOException
    {
	if (failedMsg != null) {
	    throw new IOException(failedMsg);
	}
	
	return super.available();
    }

    public void close()
    {
	if (!finished) {
	    server.removeBrowse(this);
	}
	finished = true;
    }

    public void connect() throws IOException
    {
	server.addBrowse(this);
    }

    public void exceptionThrown(Exception e)
    {
	failed(e.getMessage());
    }

    public void failed(String msg)
    {
	failedMsg = msg;
    }

    public void finished()
    {
	finished = true;
    }

    public void start()
    {
	BrowseRequestMessage msg = new BrowseRequestMessage(user.getName());
	msg.setExceptionListener(this);
	MessageHandler.send(server, msg);
    }

}
