/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net;

import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.util.NapPreferences;
import xnap.io.ThrottledOutputStream;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class AltDirectBrowseUpload extends DirectBrowseUpload {
    
    //--- Constant(s) ---
    
    //--- Data field(s) ---

    protected static Logger logger 
	= Logger.getLogger(AltDirectBrowseUpload.class);

    protected String host;
    protected int port;
    protected Server server;

    //--- Constructor(s) ---

    public AltDirectBrowseUpload(Server server, String host, int port)
    {
	this.server = server;
	this.host = host;
	this.port = port;
    }

    //--- Method(s) ---

    public void run() 
    {
	try {
	    logger.info("connecting to " + host + ":" + port 
			+ " for direct browse push");
	    socket = new Socket(host, port);
	    out = new ThrottledOutputStream(socket.getOutputStream());

	    write("SENDLIST " + server.getUsername() + "\n");

		if (NapPreferences.getInstance().getSendWholeRepository()) {
		    sendWholeRepository();
		}
		else {
		    sendList(server.getShared());
		}
        } 
	catch (IOException e) {
	    logger.warn("direct browse failed", e);
        }
	finally {
		close();
	}
    }

}

