/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.gui.table;

import xnap.XNap;
import xnap.gui.table.*;
import xnap.net.*;
import xnap.plugin.nap.*;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.server.MessageListener;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.net.msg.server.WhoisResponseMessage;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.*;
import xnap.util.event.*;

import java.util.*;
import javax.swing.event.*;
import javax.swing.table.*;

public class WhoisTableModel extends AbstractDynamicTableModel 
    implements MessageListener {

    //--- Constant(s) ---

    public static final int NAME = 0;
    public static final int SERVER = 1;
    public static final int FILE_COUNT = 2;
    public static final int LINK_SPEED = 3;
    public static final int LEVEL = 4;
    public static final int STATUS = 5;
    public static final int DOWNLOAD_COUNT = 6;
    public static final int UPLOAD_COUNT = 7;
    public static final int CLIENT_INFO = 8;
    public static final int LAST_SEEN = 9;
    public static final int CONNECT_DURATION = 10;

    //--- Data field(s) ---

    protected Column columns[] = new Column[] {
	new Column(Plugin.tr("User"), String.class),
	new Column(Plugin.tr("Server"), String.class),
	new Column(Plugin.tr("File Count"), Integer.class,
		   new NumberCellRenderer()),
	new Column(Plugin.tr("Link Speed"), String.class,
		   new LinkSpeedCellRenderer()),
	new Column(Plugin.tr("Level"), String.class),
	new Column(Plugin.tr("Status"), String.class),
	new Column(Plugin.tr("Downloads"), Integer.class,
		   new NumberCellRenderer()),
	new Column(Plugin.tr("Upload"), Integer.class,
		   new NumberCellRenderer()),
	new Column(Plugin.tr("Client"), String.class),
	new Column(Plugin.tr("Last Seen"), Long.class, new TimeCellRenderer()),
	new Column(Plugin.tr("Online"), Long.class, new TimeCellRenderer()),
    };

    private ArrayList rows = new ArrayList();

    //--- Constructor(s) ---

    public WhoisTableModel() 
    {
	super("whois", NapPreferences.getInstance());

	setColumns(columns);

	MessageHandler.subscribe(WhoisResponseMessage.TYPE, this);
    }

    //--- Method(s) ---

    public void add(User u)
    {
	int i = rows.indexOf(new MyUser(u));
	if (i == -1) {
	    rows.add(u);
	    fireTableRowsInserted(rows.size() - 1, rows.size() - 1);
	}
	else {
	    fireTableRowsUpdated(i, i);
	}
    }

    public void clear()
    {
	int i = rows.size() - 1;
	rows.clear();
	fireTableRowsDeleted(0, i);
    }

    public User get(int i)
    {
	return (User)rows.get(mapToIndex(i));
    }
    
    public Object get(int i, int j) 
    {
        if (i >= rows.size()) 
	    return null;

        User u = (User)rows.get(i);

        if (u == null) 
	    return null;

        switch (j) {
	case NAME:
	    return u.getName();
	case SERVER:
	    return u.getServer().getHost() + ":" + u.getServer().getPort();
	case FILE_COUNT:
	    return new Integer(u.getFileCount());
	case LINK_SPEED:
	    return (new LinkSpeed(u.getLinkSpeed())).toString();
	case LEVEL:
	    return u.getLevel();
	case STATUS:
	    return IUser.STATUS_MSGS[u.getStatus()];
	case DOWNLOAD_COUNT:
	    return new Integer(u.getDownloadCount());
	case UPLOAD_COUNT:
	    return new Integer(u.getUploadCount());
	case CLIENT_INFO:
	    return u.getClientInfo();
	case LAST_SEEN:
	    long l = u.getLastSeen();
	    return new Long((l > 0) ? l : -1);
	case CONNECT_DURATION:
	    return new Integer(u.getConnectDuration());
	default:
	    return "";
        }
    }

    public int getRowCount() 
    {
        return rows.size();
    }

    public String getTableName()
    {
	return XNap.tr("Whois Table");
    }

    public void messageReceived(ServerMessage msg)
    {
	WhoisResponseMessage m = (WhoisResponseMessage)msg;
	add(m.getServer().getUser(m.nick));
    }

    public void reload()
    {
	fireTableDataChanged();
    }

    public void remove(User u)
    {
	int i = rows.indexOf(u);
	if (i != -1) {
	    rows.remove(u);
	    fireTableRowsDeleted(i, i);
	}
    }

    public void set(Object o, int i, int j)
    {
    }

    class MyUser extends User {

	public MyUser(User u) 
	{
	    super(u.getName(), u.getServer());
	}

	public boolean equals(Object obj) 
	{
	    if (obj != null) {
		if (obj instanceof User) {
		    User user = (User)obj;
		    return (getName().equals(user.getName())
			    && getServer().equals(user.getServer()));

		}
	    }
	    
	    return false;
	}	

    }

}


