/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.gui;

import xnap.*;
import xnap.gui.*;
import xnap.plugin.nap.*;
import xnap.plugin.nap.util.*;

import java.awt.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;

public class NapAdvancedPreferencesPanel extends AbstractPreferencesPanel {

    //--- Data Field(s) ----

    private NapPreferences napPrefs = NapPreferences.getInstance();

    private JCheckBox jcbCustomizeClientInfo;
    private JTextField jteClient;

    private JCheckBox jcbLimitSharesPerServer;
    private ValidatedTextField jteMaxSharesPerServer;
    private JCheckBox jcSendWholeRepository;

    private ValidatedTextField jteMinimumShares;
    private JCheckBox jcbMininumShares;
    private ValidatedTextField jteMinimumSharesMessage;
    private JCheckBox jcbMininumSharesMessage;
    
    //--- Constructor(s) ---

    public NapAdvancedPreferencesPanel()
    {
	setLayout(new GridBagLayout());

	// client info
	JPanel jpClientInfo = new JPanel(new GridBagLayout());
	jpClientInfo.setBorder(new TitledBorder(Plugin.tr("Client Info", 1)));
	GridBagHelper.add(this, jpClientInfo);
        jteClient = new JTextField(napPrefs.getClientInfo(), 20);
	EnableAction ac 
	    = new EnableAction(Plugin.tr("Customize"), new Component[] 
		{ jteClient }, napPrefs.getCustomizeClientInfo());
	jcbCustomizeClientInfo = ac.getCheckBox();
	GridBagHelper.addComponent(jpClientInfo, jcbCustomizeClientInfo);
	GridBagHelper.add(jpClientInfo, jteClient);

	// limit number of shared files per server
	JPanel jpLimitShares = new JPanel(new GridBagLayout());
	jpLimitShares.setBorder
	    (new TitledBorder(Plugin.tr("Shares Per Server", 1)));
	GridBagHelper.add(this, jpLimitShares);

        jteMaxSharesPerServer = new ValidatedTextField
	    (napPrefs.getMaxSharesPerServer() + "", 5,
	     ValidatedTextField.NUMBERS_INT);
	ac = new EnableAction(Plugin.tr("Limit"), 
			      new Component[] { jteMaxSharesPerServer }, 
			      napPrefs.getLimitSharesPerServer());
	jcbLimitSharesPerServer = ac.getCheckBox();

	GridBagHelper.addComponent(jpLimitShares, jcbLimitSharesPerServer);
	GridBagHelper.add(jpLimitShares, jteMaxSharesPerServer, false);

	jcSendWholeRepository = new JCheckBox
	    (Plugin.tr("Send whole repository on direct browse.", 1), 
	     napPrefs.getSendWholeRepository());
	GridBagHelper.add(jpLimitShares, jcSendWholeRepository);

	// minimum shares of peer to be allowed to download
	JPanel jpMinimumShares = new JPanel(new GridBagLayout());
	jpMinimumShares.setBorder(new TitledBorder
	    (Plugin.tr("Minimum Shares to be allowed to download", 1)));
	GridBagHelper.add(this, jpMinimumShares);

	jteMinimumShares = 
	    new ValidatedTextField(napPrefs.getMinimumShares() + "", 5, 
				   ValidatedTextField.NUMBERS_INT);
	ac = new EnableAction(Plugin.tr("Minimum"),
			      new Component[] { jteMinimumShares },
			      napPrefs.getUseMinimumShares());
	jcbMininumShares = ac.getCheckBox();
	jcbMininumShares.setSelected(napPrefs.getUseMinimumShares());
	GridBagHelper.addComponent(jpMinimumShares, jcbMininumShares);
	GridBagHelper.add(jpMinimumShares, jteMinimumShares, false);

	// minimum shares message
	jteMinimumSharesMessage =
	    new ValidatedTextField(napPrefs.getMinimumSharesMessage(), 20,
				   ValidatedTextField.ANYTHING);
	ac = new EnableAction(Plugin.tr("Message"), 
			      new Component[] { jteMinimumSharesMessage },
			      napPrefs.getSendMinimumSharesMessage());
	jcbMininumSharesMessage = ac.getCheckBox();
	jcbMininumSharesMessage.setSelected
	    (napPrefs.getSendMinimumSharesMessage());
	
  	GridBagHelper.addComponent(jpMinimumShares, jcbMininumSharesMessage);
  	GridBagHelper.add(jpMinimumShares, jteMinimumSharesMessage);
			
	GridBagHelper.addVerticalSpacer(this);
    }

    //--- Method(s) ---

    public void apply()
    {
	napPrefs.setCustomizeClientInfo(jcbCustomizeClientInfo.isSelected());
	napPrefs.setClientInfo(jteClient.getText().trim());


	napPrefs.setLimitSharesPerServer(jcbLimitSharesPerServer.isSelected());
	napPrefs.setMaxSharesPerServer(jteMaxSharesPerServer.getIntValue());
	napPrefs.setSendWholeRepository(jcSendWholeRepository.isSelected());

	napPrefs.setUseMinimumShares(jcbMininumShares.isSelected());
	napPrefs.setMinimumShares(jteMinimumShares.getIntValue());
	napPrefs.setSendMinimumSharesMessage
	    (jcbMininumSharesMessage.isSelected());
	napPrefs.setMinimumSharesMessage(jteMinimumSharesMessage.getText());
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("network_local.png");
    }

    public String getTitle()
    {
	return XNap.tr("Advanced");
    }


}
