/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella.util;

import xnap.util.*;
import xnap.plugin.gnutella.net.Servent;

import java.util.*;

/**
 * Higher priorities are popped first. This class is thread safe.
 */
public class SendQueue extends PriorityQueue
{

    //--- Constant(s) ---
    
    public static final int MAX_ELEMENTS = 500;

    //--- Data field(s) ---
    
    //--- Constructor(s) ---

    public SendQueue()
    {
    }
    
    //--- Method(s) ---

    public synchronized void add(Object o, int priority)
    {
	if (size() > MAX_ELEMENTS) {
	    Debug.log("SendQueue overflow, removing elements");
	    int j = 0;
	    int size = size();
	    for (Iterator i = queue.iterator(); i.hasNext() && j < size / 2; 
		 j++) {
		Element e = (Element) i.next();
		/* only remove routed messages */
		if (e.priority != Servent.PRIORITY_NORMAL) {
		    i.remove();
		}
	    }
	}
	super.add(o, priority);
	//  Debug.log("sendQueue add " + size());
	notify();
    }
    
    public synchronized Object pop()
    {
	while (size() == 0) {
	    try {
		wait();
	    }
	    catch (InterruptedException ie) {
	    }
	}
	//  Debug.log("sendQueue pop " + size());
	return super.pop();
    }
}
