/*
 * 07/24/2001
 *
 * WriterThread.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import java.io.IOException;

import xnap.util.*;
import xnap.plugin.gnutella.io.*;
import xnap.plugin.gnutella.util.*;

/**
 *
 * @version 0.1 07/24/2001
 * @author Frederik Zimmer
 */

public class WriterThread implements Runnable 
{
    protected static final int MAX_TIME_BETWEEN_FLUSHS = 500;
    protected static final int MAX_MESSAGES_BETWEEN_FLUSHES = 10;
    
    protected Servent servent;
    
    protected DataOutputStream out;
    protected SendQueue sendQueue;
    
    protected boolean alive;
    protected Thread thread;
    
    protected final Object lock = new Object();

    private long lastFlushTime;
    private int messagesSent;

    public WriterThread(Servent con) 
    {
	servent = con;
	sendQueue = servent.getSendQueue();
    } 
	
    public void setOutputStream(DataOutputStream out) 
    {
	this.out = out;
    }
	
    public void start() 
    {
	if (!alive && out != null) {
	    alive = true;
	    thread = new Thread(this);
	    thread.start();
	}
    }
	
    public void run() 
    {
	lastFlushTime = System.currentTimeMillis();
	long currentTime;
	long waittime;
	int sendcounter = 0;
	Message msg;
		
	while (alive) {
	    msg = null;
	    
	    /* this blocks until a new message is available */
	    msg = (Message) sendQueue.pop();
		
	    try {
		msg.write(out);
		sendcounter++;
		messagesSent++;
		if (sendcounter >= MAX_MESSAGES_BETWEEN_FLUSHES 
		    || timeToFlush()) {
		    //  Debug.log("WriterThread: messages flushed");
		    sendcounter = 0;
		    lastFlushTime = System.currentTimeMillis();
		    out.flush();
		}
	    }
	    catch(IOException e) {
		servent.stop();
		return;
	    }
	}
    }
	
    public void stop()
    {
	if (alive) {
	    synchronized(lock) {
		alive = false;
		thread.interrupt();
	    }
	}
    }
    
    public void close() 
    {
	if (out != null) {
	    try {
		out.close();
	    }
	    catch(IOException e) {
	    }
	}
    }

    public int getMessagesSent()
    {
	return messagesSent;
    }

    private boolean timeToFlush()
    {
	return (System.currentTimeMillis() - lastFlushTime) 
	    > MAX_TIME_BETWEEN_FLUSHS;
    }
}
